/*     */ package oracle.jdbc.proxy;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ 
/*     */ class GeneratedProxiesRegistry
/*     */ {
/* 211 */   private Map<Key, Value> registry = Collections.synchronizedMap(new HashMap());
/*     */ 
/*     */   void put(Class paramClass1, Class paramClass2, Value paramValue)
/*     */   {
/* 221 */     this.registry.put(new Key(paramClass1, paramClass2), paramValue);
/*     */   }
/*     */ 
/*     */   Value get(Class paramClass1, Class paramClass2)
/*     */   {
/* 232 */     return (Value)this.registry.get(new Key(paramClass1, paramClass2));
/*     */   }
/*     */ 
/*     */   int size()
/*     */   {
/* 241 */     return this.registry.size();
/*     */   }
/*     */ 
/*     */   Set<Key> keySet()
/*     */   {
/* 250 */     return this.registry.keySet();
/*     */   }
/*     */ 
/*     */   Collection<Value> values()
/*     */   {
/* 259 */     return this.registry.values();
/*     */   }
/*     */ 
/*     */   static class Value
/*     */   {
/*     */     private final String name;
/*     */     private final String source;
/*     */     private final Class clazz;
/*     */     private final Constructor constructor;
/*     */ 
/*     */     Value(String paramString1, String paramString2, Class paramClass, Constructor paramConstructor)
/*     */     {
/* 168 */       this.name = paramString1;
/* 169 */       this.source = paramString2;
/* 170 */       this.clazz = paramClass;
/* 171 */       this.constructor = paramConstructor;
/*     */     }
/*     */ 
/*     */     String getName()
/*     */     {
/* 180 */       return this.name;
/*     */     }
/*     */ 
/*     */     String getSource()
/*     */     {
/* 189 */       return this.source;
/*     */     }
/*     */ 
/*     */     Class getClazz()
/*     */     {
/* 198 */       return this.clazz;
/*     */     }
/*     */ 
/*     */     Constructor getConstructor()
/*     */     {
/* 207 */       return this.constructor;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class Key
/*     */   {
/*  33 */     private final String PREFIX = "oracle.jdbc.proxy.";
/*  34 */     private final String SUFFIX = "$$$Proxy";
/*     */     private final Class iface;
/*     */     private final Class superclass;
/*  69 */     private Integer hashCode = null;
/*     */ 
/*     */     Key(Class paramClass1, Class paramClass2)
/*     */     {
/*  44 */       this.iface = paramClass1;
/*  45 */       this.superclass = paramClass2;
/*     */     }
/*     */ 
/*     */     Key(String paramString)
/*     */     {
/*  50 */       this.iface = parseIface(paramString);
/*  51 */       this.superclass = parseSuperclass(paramString);
/*     */     }
/*     */ 
/*     */     public boolean equals(Object paramObject)
/*     */     {
/*  56 */       if (null == paramObject) {
/*  57 */         return false;
/*     */       }
/*     */       try
/*     */       {
/*  61 */         Key localKey = (Key)paramObject;
/*  62 */         return (this.iface.equals(localKey.iface)) && (this.superclass.equals(localKey.superclass));
/*     */       }
/*     */       catch (ClassCastException localClassCastException) {
/*     */       }
/*  66 */       return false;
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/*  73 */       if (null == this.hashCode)
/*     */       {
/*  75 */         this.hashCode = Integer.valueOf(23);
/*  76 */         this.hashCode = Integer.valueOf(HashUtil.hash(this.hashCode.intValue(), this.iface));
/*  77 */         this.hashCode = Integer.valueOf(HashUtil.hash(this.hashCode.intValue(), this.superclass));
/*     */       }
/*     */ 
/*  80 */       return this.hashCode.intValue();
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/*  85 */       return "oracle.jdbc.proxy." + this.superclass.getName().replace(".", "$1") + "$2" + this.iface.getName().replace(".", "$1") + "$$$Proxy";
/*     */     }
/*     */ 
/*     */     private Class parseSuperclass(String paramString)
/*     */     {
/*     */       try
/*     */       {
/*  96 */         String str1 = paramString.substring("oracle.jdbc.proxy.".length());
/*  97 */         String str2 = str1.replaceAll("\\$1", ".");
/*  98 */         String str3 = str2.substring(0, str2.indexOf("$2"));
/*  99 */         return Class.forName(str3);
/*     */       }
/*     */       catch (ClassNotFoundException localClassNotFoundException)
/*     */       {
/* 103 */         throw new RuntimeException(localClassNotFoundException);
/*     */       }
/*     */     }
/*     */ 
/*     */     private Class parseIface(String paramString)
/*     */     {
/*     */       try
/*     */       {
/* 111 */         String str1 = paramString.substring("oracle.jdbc.proxy.".length());
/* 112 */         String str2 = str1.replaceAll("\\$1", ".");
/* 113 */         String str3 = str2.substring(str2.indexOf("$2") + 2, str2.indexOf("$$$Proxy"));
/* 114 */         return Class.forName(str3);
/*     */       }
/*     */       catch (ClassNotFoundException localClassNotFoundException)
/*     */       {
/* 118 */         throw new RuntimeException(localClassNotFoundException);
/*     */       }
/*     */     }
/*     */ 
/*     */     public Class getIface()
/*     */     {
/* 127 */       return this.iface;
/*     */     }
/*     */ 
/*     */     public Class getSuperclass()
/*     */     {
/* 135 */       return this.superclass;
/*     */     }
/*     */ 
/*     */     public String makePathname()
/*     */     {
/* 140 */       return toString().replace(".", "/") + ".class";
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.proxy.GeneratedProxiesRegistry
 * JD-Core Version:    0.6.2
 */