/*     */ package oracle.jdbc.proxy;
/*     */ 
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.io.PrintWriter;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ import org.objectweb.asm.ClassReader;
/*     */ import org.objectweb.asm.ClassWriter;
/*     */ import org.objectweb.asm.FieldVisitor;
/*     */ import org.objectweb.asm.Label;
/*     */ import org.objectweb.asm.MethodVisitor;
/*     */ 
/*     */ class ClassGenerator
/*     */ {
/*     */   private final AnnotationsForIface annotationsForIface;
/*     */   private final String proxyName;
/*     */   private final String superclassName;
/*     */   private final String ifaceName;
/*     */   private final String proxyType;
/*     */   private final String ifaceType;
/*     */   final Map<MethodSignature, MethodGenerator> members;
/*     */ 
/*     */   private ClassGenerator(AnnotationsForIface paramAnnotationsForIface, String paramString1, String paramString2, String paramString3, Map<MethodSignature, MethodGenerator> paramMap)
/*     */   {
/* 119 */     this.annotationsForIface = paramAnnotationsForIface;
/* 120 */     this.proxyName = Utils.makeSlashed(paramString1);
/* 121 */     this.proxyType = Utils.makeType(paramString1);
/* 122 */     this.superclassName = Utils.makeSlashed(paramString2);
/* 123 */     this.ifaceName = Utils.makeSlashed(paramString3);
/* 124 */     this.ifaceType = Utils.makeType(paramString3);
/* 125 */     this.members = paramMap;
/*     */   }
/*     */ 
/*     */   String getProxyName()
/*     */   {
/* 133 */     return this.proxyName;
/*     */   }
/*     */ 
/*     */   String getSuperclassName()
/*     */   {
/* 141 */     return this.superclassName;
/*     */   }
/*     */ 
/*     */   String getIfaceName()
/*     */   {
/* 149 */     return this.ifaceName;
/*     */   }
/*     */ 
/*     */   String getProxyType()
/*     */   {
/* 157 */     return this.proxyType;
/*     */   }
/*     */ 
/*     */   String getIfaceType()
/*     */   {
/* 165 */     return this.ifaceType;
/*     */   }
/*     */ 
/*     */   static <T> byte[] generateBytecode(GeneratedProxiesRegistry.Key paramKey, AnnotationsRegistry paramAnnotationsRegistry)
/*     */   {
/* 172 */     Class localClass1 = paramKey.getIface();
/* 173 */     Class localClass2 = paramKey.getSuperclass();
/*     */ 
/* 175 */     if (!localClass1.isInterface()) {
/* 176 */       new RuntimeException("iface must be interface");
/*     */     }
/* 178 */     if (localClass2.isInterface()) {
/* 179 */       new RuntimeException("sclass must not be interface");
/*     */     }
/* 181 */     HashMap localHashMap1 = new HashMap();
/*     */ 
/* 184 */     final HashMap localHashMap2 = new HashMap();
/*     */ 
/* 187 */     final HashMap localHashMap3 = new HashMap();
/*     */ 
/* 190 */     AnnotationsForIface localAnnotationsForIface = new AnnotationsForIface(paramAnnotationsRegistry, localClass1, paramAnnotationsRegistry.get(localClass1));
/*     */ 
/* 196 */     ClassGenerator localClassGenerator = new ClassGenerator(localAnnotationsForIface, paramKey.toString(), localClass2.getName(), localClass1.getName(), localHashMap1);
/*     */ 
/* 204 */     new Runnable() {
/*     */       public void run() {
/* 206 */         traverse(this.val$superclass, this.val$superclass.isAnnotationPresent(ProxyFor.class));
/*     */       }
/*     */ 
/*     */       void traverse(Class paramAnonymousClass, boolean paramAnonymousBoolean)
/*     */       {
/* 213 */         if (null == paramAnonymousClass) {
/* 214 */           return;
/*     */         }
/* 216 */         for (Method localMethod : paramAnonymousClass.getDeclaredMethods()) {
/* 217 */           MethodSignature localMethodSignature = new MethodSignature(localMethod);
/*     */ 
/* 220 */           if (paramAnonymousBoolean)
/* 221 */             localHashMap2.put(localMethodSignature, localMethod);
/* 222 */           else if (!Modifier.isAbstract(localMethod.getModifiers()))
/* 223 */             localHashMap3.put(localMethodSignature, localMethod);
/*     */         }
/* 225 */         ??? = paramAnonymousClass.getSuperclass();
/*     */ 
/* 227 */         traverse((Class)???, (paramAnonymousBoolean) && (((Class)???).isAnnotationPresent(ProxyFor.class)));
/*     */       }
/*     */     }
/* 204 */     .run();
/*     */ 
/* 234 */     for (Method localMethod1 : localClass1.getMethods()) {
/* 235 */       MethodSignature localMethodSignature = new MethodSignature(localMethod1);
/*     */ 
/* 238 */       Method localMethod2 = (Method)localHashMap2.get(localMethodSignature);
/*     */ 
/* 241 */       if ((null != localMethod2) || (!localHashMap3.containsKey(localMethodSignature)))
/*     */       {
/* 244 */         localHashMap1.put(localMethodSignature, new MethodGenerator(localClassGenerator, localMethod1, (null == localMethod2) || (Modifier.isAbstract(localMethod2.getModifiers()))));
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 252 */     ??? = new ClassWriter(3);
/*     */ 
/* 255 */     localClassGenerator.generate((ClassWriter)???);
/* 256 */     return ((ClassWriter)???).toByteArray();
/*     */   }
/*     */ 
/*     */   static <T> Class generate(Class<T> paramClass, Class paramClass1, AnnotationsRegistry paramAnnotationsRegistry)
/*     */   {
/* 264 */     GeneratedProxiesRegistry.Key localKey = new GeneratedProxiesRegistry.Key(paramClass, paramClass1);
/*     */ 
/* 267 */     byte[] arrayOfByte = generateBytecode(localKey, paramAnnotationsRegistry);
/*     */ 
/* 271 */     String str = System.getProperty("oracle.jdbc.proxy.asm.verify");
/* 272 */     if ((null != str) && (0 == "true".compareToIgnoreCase(str)))
/*     */       try
/*     */       {
/* 275 */         Class localClass = Class.forName("org.objectweb.asm.util.CheckClassAdapter");
/*     */ 
/* 278 */         Method localMethod = localClass.getMethod("verify", new Class[] { ClassReader.class, Boolean.TYPE, PrintWriter.class });
/*     */ 
/* 285 */         localMethod.invoke(null, new Object[] { new ClassReader(arrayOfByte), Boolean.valueOf(true), new PrintWriter(new OutputStreamWriter(System.out)) });
/*     */       }
/*     */       catch (ClassNotFoundException localClassNotFoundException1)
/*     */       {
/*     */       }
/*     */       catch (NoSuchMethodException localNoSuchMethodException)
/*     */       {
/*     */       }
/*     */       catch (IllegalAccessException localIllegalAccessException)
/*     */       {
/*     */       }
/*     */       catch (InvocationTargetException localInvocationTargetException)
/*     */       {
/*     */       }
/*     */     try
/*     */     {
/* 301 */       return Class.forName(localKey.toString(), false, new ClassLoader()
/*     */       {
/*     */         protected Class findClass(String paramAnonymousString)
/*     */         {
/* 308 */           return defineClass(paramAnonymousString, this.val$bytecode, 0, this.val$bytecode.length);
/*     */         }
/*     */       });
/*     */     }
/*     */     catch (ClassNotFoundException localClassNotFoundException2)
/*     */     {
/* 314 */       throw new RuntimeException(localClassNotFoundException2);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void generate(ClassWriter paramClassWriter)
/*     */   {
/* 320 */     paramClassWriter.visit(50, 33, this.proxyName, null, this.superclassName, new String[] { this.ifaceName, Utils.makeSlashed(_Proxy_.class.getName()) });
/*     */ 
/* 329 */     for (Object localObject1 = this.members.values().iterator(); ((Iterator)localObject1).hasNext(); ) { localObject2 = (MethodGenerator)((Iterator)localObject1).next();
/* 330 */       if (null != localObject2) {
/* 331 */         ((MethodGenerator)localObject2).generate(paramClassWriter);
/*     */       }
/*     */     }
/*     */ 
/* 335 */     localObject1 = paramClassWriter.visitMethod(1, "_getDelegate_", "()" + this.ifaceType, null, null);
/*     */ 
/* 343 */     ((MethodVisitor)localObject1).visitCode();
/* 344 */     ((MethodVisitor)localObject1).visitVarInsn(25, 0);
/* 345 */     ((MethodVisitor)localObject1).visitFieldInsn(180, this.proxyName, "delegate", this.ifaceType);
/*     */ 
/* 351 */     ((MethodVisitor)localObject1).visitInsn(176);
/* 352 */     ((MethodVisitor)localObject1).visitMaxs(0, 0);
/* 353 */     ((MethodVisitor)localObject1).visitEnd();
/*     */ 
/* 356 */     localObject1 = paramClassWriter.visitMethod(4161, "_getDelegate_", "()Ljava/lang/Object;", null, null);
/*     */ 
/* 364 */     ((MethodVisitor)localObject1).visitCode();
/* 365 */     ((MethodVisitor)localObject1).visitVarInsn(25, 0);
/* 366 */     ((MethodVisitor)localObject1).visitMethodInsn(182, this.proxyName, "_getDelegate_", "()" + this.ifaceType);
/*     */ 
/* 372 */     ((MethodVisitor)localObject1).visitInsn(176);
/* 373 */     ((MethodVisitor)localObject1).visitMaxs(0, 0);
/* 374 */     ((MethodVisitor)localObject1).visitEnd();
/*     */ 
/* 379 */     localObject1 = this.annotationsForIface.getValue();
/*     */     Object localObject4;
/*     */     Object localObject5;
/*     */     Object localObject6;
/*     */     Object localObject7;
/*     */     Object localObject8;
/* 382 */     if (null != localObject1)
/*     */     {
/* 385 */       localObject2 = ((AnnotationsRegistry.Value)localObject1).getMethodGetDelegate();
/*     */ 
/* 388 */       if (null != localObject2)
/*     */       {
/* 390 */         localObject3 = paramClassWriter.visitMethod(1, ((Method)localObject2).getName(), "()" + Utils.makeType(((Method)localObject2).getReturnType()), null, null);
/*     */ 
/* 397 */         ((MethodVisitor)localObject3).visitCode();
/* 398 */         localObject4 = new Label();
/* 399 */         ((MethodVisitor)localObject3).visitLabel((Label)localObject4);
/* 400 */         ((MethodVisitor)localObject3).visitVarInsn(25, 0);
/* 401 */         ((MethodVisitor)localObject3).visitFieldInsn(180, this.proxyName, "delegate", this.ifaceType);
/* 402 */         ((MethodVisitor)localObject3).visitInsn(176);
/* 403 */         localObject5 = new Label();
/* 404 */         ((MethodVisitor)localObject3).visitLabel((Label)localObject5);
/* 405 */         ((MethodVisitor)localObject3).visitLocalVariable("this", this.proxyType, null, (Label)localObject4, (Label)localObject5, 0);
/* 406 */         ((MethodVisitor)localObject3).visitMaxs(0, 0);
/* 407 */         ((MethodVisitor)localObject3).visitEnd();
/*     */       }
/*     */ 
/* 411 */       localObject3 = ((AnnotationsRegistry.Value)localObject1).getMethodSetDelegate();
/*     */ 
/* 414 */       if (null != localObject3)
/*     */       {
/* 416 */         localObject4 = ((Method)localObject3).getParameterTypes();
/*     */ 
/* 418 */         if (1 != localObject4.length) {
/* 419 */           throw new RuntimeException("wrong delegate setter signature");
/*     */         }
/* 421 */         localObject5 = paramClassWriter.visitMethod(1, ((Method)localObject3).getName(), "(" + Utils.makeType(localObject4[0]) + ")V", null, null);
/*     */ 
/* 429 */         ((MethodVisitor)localObject5).visitCode();
/*     */ 
/* 431 */         ((MethodVisitor)localObject5).visitLabel(localObject6 = new Label());
/*     */ 
/* 433 */         ((MethodVisitor)localObject5).visitVarInsn(25, 0);
/*     */ 
/* 435 */         ((MethodVisitor)localObject5).visitFieldInsn(180, this.proxyName, "proxyFactory", Utils.makeType(ProxyFactory.class));
/*     */ 
/* 441 */         ((MethodVisitor)localObject5).visitVarInsn(25, 0);
/* 442 */         ((MethodVisitor)localObject5).visitVarInsn(25, 0);
/*     */ 
/* 444 */         ((MethodVisitor)localObject5).visitFieldInsn(180, this.proxyName, "delegate", this.ifaceType);
/*     */ 
/* 450 */         ((MethodVisitor)localObject5).visitVarInsn(25, 1);
/*     */ 
/* 452 */         ((MethodVisitor)localObject5).visitMethodInsn(182, Utils.makeSlashed(ProxyFactory.class), "updateDelegate", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V");
/*     */ 
/* 458 */         ((MethodVisitor)localObject5).visitVarInsn(25, 0);
/* 459 */         ((MethodVisitor)localObject5).visitVarInsn(25, 1);
/*     */ 
/* 461 */         ((MethodVisitor)localObject5).visitFieldInsn(181, this.proxyName, "delegate", this.ifaceType);
/*     */ 
/* 467 */         ((MethodVisitor)localObject5).visitInsn(177);
/*     */ 
/* 469 */         ((MethodVisitor)localObject5).visitLabel(localObject7 = new Label());
/*     */ 
/* 471 */         ((MethodVisitor)localObject5).visitLocalVariable("this", this.proxyType, null, (Label)localObject6, (Label)localObject7, 0);
/*     */ 
/* 479 */         ((MethodVisitor)localObject5).visitLocalVariable("delegate", this.ifaceType, null, (Label)localObject6, (Label)localObject7, 1);
/*     */ 
/* 487 */         ((MethodVisitor)localObject5).visitMaxs(0, 0);
/* 488 */         ((MethodVisitor)localObject5).visitEnd();
/*     */       }
/*     */ 
/* 492 */       localObject4 = ((AnnotationsRegistry.Value)localObject1).getMethodGetCreator();
/*     */ 
/* 495 */       if (null != localObject4)
/*     */       {
/* 497 */         localObject5 = paramClassWriter.visitMethod(1, ((Method)localObject4).getName(), "()" + Utils.makeType(((Method)localObject4).getReturnType()), null, null);
/*     */ 
/* 505 */         ((MethodVisitor)localObject5).visitCode();
/* 506 */         localObject6 = new Label();
/* 507 */         ((MethodVisitor)localObject5).visitLabel((Label)localObject6);
/* 508 */         ((MethodVisitor)localObject5).visitVarInsn(25, 0);
/* 509 */         ((MethodVisitor)localObject5).visitFieldInsn(180, this.proxyName, "creator", "Ljava/lang/Object;");
/* 510 */         ((MethodVisitor)localObject5).visitInsn(176);
/* 511 */         localObject7 = new Label();
/* 512 */         ((MethodVisitor)localObject5).visitLabel((Label)localObject7);
/* 513 */         ((MethodVisitor)localObject5).visitLocalVariable("this", this.proxyType, null, (Label)localObject6, (Label)localObject7, 0);
/* 514 */         ((MethodVisitor)localObject5).visitMaxs(1, 1);
/* 515 */         ((MethodVisitor)localObject5).visitEnd();
/*     */       }
/*     */ 
/* 519 */       localObject5 = ((AnnotationsRegistry.Value)localObject1).getMethodGetProxy();
/*     */ 
/* 522 */       if (null != localObject5)
/*     */       {
/* 524 */         localObject6 = ((Method)localObject5).getParameterTypes();
/*     */ 
/* 527 */         localObject7 = ((Method)localObject5).getReturnType();
/*     */ 
/* 530 */         if ((!Arrays.deepEquals(new Class[] { Object.class, Object.class }, (Object[])localObject6)) || (!Object.class.equals(localObject7)))
/*     */         {
/* 532 */           throw new RuntimeException("internal error: wrong @GetProxy method");
/*     */         }
/* 534 */         localObject8 = paramClassWriter.visitMethod(1, ((Method)localObject5).getName(), "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "<T:Ljava/lang/Object;>(TT;Ljava/lang/Object;)TT;", null);
/*     */ 
/* 542 */         ((MethodVisitor)localObject8).visitCode();
/* 543 */         ((MethodVisitor)localObject8).visitVarInsn(25, 0);
/*     */ 
/* 545 */         ((MethodVisitor)localObject8).visitFieldInsn(180, this.proxyName, "proxyFactory", Utils.makeType(ProxyFactory.class));
/*     */ 
/* 551 */         ((MethodVisitor)localObject8).visitVarInsn(25, 1);
/* 552 */         ((MethodVisitor)localObject8).visitVarInsn(25, 2);
/*     */ 
/* 554 */         ((MethodVisitor)localObject8).visitMethodInsn(182, Utils.makeSlashed(ProxyFactory.class), "proxyFor", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
/*     */ 
/* 560 */         ((MethodVisitor)localObject8).visitInsn(176);
/* 561 */         ((MethodVisitor)localObject8).visitMaxs(3, 3);
/* 562 */         ((MethodVisitor)localObject8).visitEnd();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 568 */     paramClassWriter.visitField(2, "delegate", this.ifaceType, null, null).visitEnd();
/*     */ 
/* 576 */     paramClassWriter.visitField(18, "creator", "Ljava/lang/Object;", null, null).visitEnd();
/*     */ 
/* 584 */     paramClassWriter.visitField(18, "proxyFactory", Utils.makeType(ProxyFactory.class.getName()), null, null).visitEnd();
/*     */ 
/* 592 */     paramClassWriter.visitField(18, "proxyCache", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/Object;Ljava/lang/Object;>;", null).visitEnd();
/*     */ 
/* 600 */     paramClassWriter.visitField(10, "zeroLengthObjectArray", "[Ljava/lang/Object;", null, null).visitEnd();
/*     */ 
/* 608 */     int i = 0;
/* 609 */     for (Object localObject2 = this.members.values().iterator(); ((Iterator)localObject2).hasNext(); ) { localObject3 = (MethodGenerator)((Iterator)localObject2).next();
/*     */ 
/* 611 */       paramClassWriter.visitField(10, ((MethodGenerator)localObject3).getMethodObject(), "Ljava/lang/reflect/Method;", null, null).visitEnd();
/*     */ 
/* 618 */       i = 1;
/*     */     }
/*     */ 
/* 623 */     localObject2 = paramClassWriter.visitMethod(8, "<clinit>", "()V", null, null);
/*     */ 
/* 631 */     ((MethodVisitor)localObject2).visitCode();
/*     */ 
/* 634 */     Utils.loadConst((MethodVisitor)localObject2, 0);
/* 635 */     ((MethodVisitor)localObject2).visitTypeInsn(189, "java/lang/Object");
/* 636 */     ((MethodVisitor)localObject2).visitFieldInsn(179, this.proxyName, "zeroLengthObjectArray", "[Ljava/lang/Object;");
/*     */ 
/* 642 */     if (i != 0)
/*     */     {
/* 649 */       ((MethodVisitor)localObject2).visitTryCatchBlock(localObject3 = new Label(), localObject4 = new Label(), localObject5 = new Label(), "java/lang/Throwable");
/*     */ 
/* 655 */       ((MethodVisitor)localObject2).visitLabel((Label)localObject3);
/*     */ 
/* 657 */       for (localObject7 = this.members.values().iterator(); ((Iterator)localObject7).hasNext(); ) { localObject8 = (MethodGenerator)((Iterator)localObject7).next();
/* 658 */         ((MethodGenerator)localObject8).initializeMethodObject((MethodVisitor)localObject2);
/*     */       }
/* 660 */       ((MethodVisitor)localObject2).visitLabel((Label)localObject4);
/* 661 */       ((MethodVisitor)localObject2).visitJumpInsn(167, localObject6 = new Label());
/* 662 */       ((MethodVisitor)localObject2).visitLabel((Label)localObject5);
/*     */ 
/* 664 */       ((MethodVisitor)localObject2).visitFrame(4, 0, null, 1, new Object[] { "java/lang/Throwable" });
/*     */ 
/* 671 */       ((MethodVisitor)localObject2).visitVarInsn(58, 0);
/*     */ 
/* 673 */       ((MethodVisitor)localObject2).visitTypeInsn(187, "java/lang/RuntimeException");
/* 674 */       ((MethodVisitor)localObject2).visitInsn(89);
/* 675 */       ((MethodVisitor)localObject2).visitVarInsn(25, 0);
/*     */ 
/* 677 */       ((MethodVisitor)localObject2).visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/Throwable;)V");
/*     */ 
/* 683 */       ((MethodVisitor)localObject2).visitInsn(191);
/*     */ 
/* 685 */       ((MethodVisitor)localObject2).visitLabel((Label)localObject6);
/* 686 */       ((MethodVisitor)localObject2).visitFrame(3, 0, null, 0, null);
/*     */     }
/*     */ 
/* 689 */     ((MethodVisitor)localObject2).visitInsn(177);
/* 690 */     ((MethodVisitor)localObject2).visitMaxs(0, 0);
/* 691 */     ((MethodVisitor)localObject2).visitEnd();
/*     */ 
/* 696 */     localObject2 = "(" + this.ifaceType + "Ljava/lang/Object;" + Utils.makeType(ProxyFactory.class.getName()) + "Ljava/util/Map;" + ")V";
/*     */ 
/* 704 */     Object localObject3 = paramClassWriter.visitMethod(1, "<init>", (String)localObject2, null, null);
/*     */ 
/* 712 */     ((MethodVisitor)localObject3).visitCode();
/* 713 */     ((MethodVisitor)localObject3).visitVarInsn(25, 0);
/*     */ 
/* 715 */     ((MethodVisitor)localObject3).visitMethodInsn(183, this.superclassName, "<init>", "()V");
/*     */ 
/* 721 */     ((MethodVisitor)localObject3).visitVarInsn(25, 0);
/* 722 */     ((MethodVisitor)localObject3).visitVarInsn(25, 1);
/*     */ 
/* 724 */     ((MethodVisitor)localObject3).visitFieldInsn(181, this.proxyName, "delegate", this.ifaceType);
/*     */ 
/* 730 */     ((MethodVisitor)localObject3).visitVarInsn(25, 0);
/* 731 */     ((MethodVisitor)localObject3).visitVarInsn(25, 2);
/*     */ 
/* 733 */     ((MethodVisitor)localObject3).visitFieldInsn(181, this.proxyName, "creator", "Ljava/lang/Object;");
/*     */ 
/* 739 */     ((MethodVisitor)localObject3).visitVarInsn(25, 0);
/* 740 */     ((MethodVisitor)localObject3).visitVarInsn(25, 3);
/*     */ 
/* 742 */     ((MethodVisitor)localObject3).visitFieldInsn(181, this.proxyName, "proxyFactory", Utils.makeType(ProxyFactory.class.getName()));
/*     */ 
/* 748 */     ((MethodVisitor)localObject3).visitVarInsn(25, 0);
/* 749 */     ((MethodVisitor)localObject3).visitVarInsn(25, 4);
/*     */ 
/* 751 */     ((MethodVisitor)localObject3).visitFieldInsn(181, this.proxyName, "proxyCache", "Ljava/util/Map;");
/*     */ 
/* 757 */     ((MethodVisitor)localObject3).visitInsn(177);
/* 758 */     ((MethodVisitor)localObject3).visitMaxs(0, 0);
/* 759 */     ((MethodVisitor)localObject3).visitEnd();
/*     */ 
/* 762 */     paramClassWriter.visitEnd();
/*     */   }
/*     */ 
/*     */   AnnotationsForIface getAnnotationsForIface()
/*     */   {
/* 770 */     return this.annotationsForIface;
/*     */   }
/*     */ 
/*     */   static class AnnotationsForIface
/*     */   {
/*     */     private final AnnotationsRegistry registry;
/*     */     private final Class iface;
/*     */     private final AnnotationsRegistry.Value value;
/*     */ 
/*     */     AnnotationsForIface(AnnotationsRegistry paramAnnotationsRegistry, Class paramClass, AnnotationsRegistry.Value paramValue)
/*     */     {
/*  77 */       this.registry = paramAnnotationsRegistry;
/*  78 */       this.iface = paramClass;
/*  79 */       this.value = paramValue;
/*     */     }
/*     */ 
/*     */     AnnotationsRegistry getRegistry()
/*     */     {
/*  87 */       return this.registry;
/*     */     }
/*     */ 
/*     */     Class getIface()
/*     */     {
/*  95 */       return this.iface;
/*     */     }
/*     */ 
/*     */     AnnotationsRegistry.Value getValue()
/*     */     {
/* 103 */       return this.value;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.proxy.ClassGenerator
 * JD-Core Version:    0.6.2
 */