/*      */ package oracle.jdbc.proxy;
/*      */ 
/*      */ import java.lang.reflect.Method;
/*      */ import java.lang.reflect.Modifier;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Arrays;
/*      */ import java.util.Collection;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import oracle.jdbc.proxy.annotation.GetCreator;
/*      */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*      */ import oracle.jdbc.proxy.annotation.GetProxy;
/*      */ import oracle.jdbc.proxy.annotation.Methods;
/*      */ import oracle.jdbc.proxy.annotation.OnError;
/*      */ import oracle.jdbc.proxy.annotation.Post;
/*      */ import oracle.jdbc.proxy.annotation.Pre;
/*      */ import oracle.jdbc.proxy.annotation.ProxyAccess;
/*      */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*      */ import oracle.jdbc.proxy.annotation.ProxyLocale;
/*      */ import oracle.jdbc.proxy.annotation.ProxyResult;
/*      */ import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
/*      */ import oracle.jdbc.proxy.annotation.SetDelegate;
/*      */ import oracle.jdbc.proxy.annotation.Signature;
/*      */ 
/*      */ class AnnotationsRegistry
/*      */ {
/*  167 */   private Map<Class, Value> ifacesToAnnotatedSuperclasses = new HashMap();
/*      */ 
/*      */   void register(Class[] paramArrayOfClass)
/*      */   {
/*      */     Value localValue;
/*  174 */     for (Class localClass1 : paramArrayOfClass)
/*      */     {
/*  176 */       if (localClass1.isInterface()) {
/*  177 */         throw SyntaxError.mustBeClass(localClass1);
/*      */       }
/*  179 */       localValue = new Value(localClass1);
/*      */ 
/*  181 */       for (Class localClass2 : localValue.getIfacesToProxy())
/*  182 */         this.ifacesToAnnotatedSuperclasses.put(localClass2, localValue);
/*      */     }
/*      */   }
/*      */ 
/*      */   Value get(Class paramClass)
/*      */   {
/*  188 */     if (null == paramClass) {
/*  189 */       return null;
/*      */     }
/*  191 */     return (Value)this.ifacesToAnnotatedSuperclasses.get(paramClass);
/*      */   }
/*      */ 
/*      */   Set<Class> keySet()
/*      */   {
/*  196 */     return this.ifacesToAnnotatedSuperclasses.keySet();
/*      */   }
/*      */ 
/*      */   Collection<Value> values()
/*      */   {
/*  201 */     return this.ifacesToAnnotatedSuperclasses.values();
/*      */   }
/*      */ 
/*      */   boolean containsKey(Object paramObject)
/*      */   {
/*  206 */     return this.ifacesToAnnotatedSuperclasses.containsKey(paramObject);
/*      */   }
/*      */ 
/*      */   static class Value
/*      */   {
/*      */     private final Class superclass;
/*  308 */     private final List<Class> ifacesToProxy = new ArrayList();
/*      */ 
/*  310 */     private final AnnotationsRegistry.Value.MethodSpecific.Pres pres = new AnnotationsRegistry.Value.MethodSpecific.Pres();
/*  311 */     private final AnnotationsRegistry.Value.MethodSpecific.VoidPosts voidPosts = new AnnotationsRegistry.Value.MethodSpecific.VoidPosts();
/*  312 */     private final AnnotationsRegistry.Value.MethodSpecific.ReturningPosts returningPosts = new AnnotationsRegistry.Value.MethodSpecific.ReturningPosts();
/*  313 */     private final AnnotationsRegistry.Value.MethodSpecific.VoidOnErrors voidOnErrors = new AnnotationsRegistry.Value.MethodSpecific.VoidOnErrors();
/*  314 */     private final AnnotationsRegistry.Value.MethodSpecific.ReturningOnErrors returningOnErrors = new AnnotationsRegistry.Value.MethodSpecific.ReturningOnErrors();
/*      */     private final Rest rest;
/*  318 */     private Method methodGetCreator = null;
/*  319 */     private Method methodGetDelegate = null;
/*  320 */     private Method methodGetProxy = null;
/*  321 */     private Method methodSetDelegate = null;
/*  322 */     private boolean isProxyLocale = false;
/*  323 */     private ProxyResultPolicy proxyResultPolicy = ProxyResultPolicy.CACHE;
/*  324 */     private Class proxyAccessIface = null;
/*  325 */     private Method proxyAccessGetter = null; private Method proxyAccessSetter = null;
/*      */ 
/*  335 */     private Method pre = null; private Method voidPost = null; private Method returningPost = null;
/*  336 */     private Map<Class, Method> voidOnErrorsMap = new HashMap(); private Map<Class, Method> returningOnErrorsMap = new HashMap();
/*      */ 
/*  442 */     private static final Class[] listOfMethodOperators = { Pre.class, Post.class, OnError.class, GetCreator.class, GetDelegate.class, GetProxy.class, SetDelegate.class };
/*      */ 
/*      */     Value(Class paramClass)
/*      */     {
/*  331 */       this.superclass = paramClass;
/*  332 */       this.rest = parseAnnotations();
/*      */     }
/*      */ 
/*      */     private void parseAnnotationTypeProxyResult()
/*      */     {
/*  342 */       if (this.superclass.isAnnotationPresent(ProxyResult.class))
/*      */       {
/*  344 */         ProxyResult localProxyResult = (ProxyResult)this.superclass.getAnnotation(ProxyResult.class);
/*  345 */         this.proxyResultPolicy = localProxyResult.value();
/*      */       }
/*      */     }
/*      */ 
/*      */     private void parseAnnotationProxyLocale()
/*      */     {
/*  351 */       if (this.superclass.isAnnotationPresent(ProxyLocale.class))
/*  352 */         this.isProxyLocale = true;
/*      */     }
/*      */ 
/*      */     private void parseAnnotationProxyFor()
/*      */     {
/*  357 */       if (this.superclass.isAnnotationPresent(ProxyFor.class))
/*      */       {
/*  359 */         ProxyFor localProxyFor = (ProxyFor)this.superclass.getAnnotation(ProxyFor.class);
/*      */ 
/*  361 */         for (Class localClass : localProxyFor.value())
/*      */         {
/*  363 */           if (!localClass.isInterface()) {
/*  364 */             throw AnnotationsRegistry.SyntaxError.access$300(localClass);
/*      */           }
/*  366 */           this.ifacesToProxy.add(localClass);
/*      */         }
/*      */       }
/*      */       else {
/*  370 */         throw AnnotationsRegistry.SyntaxError.access$400(this.superclass);
/*      */       }
/*      */     }
/*      */ 
/*      */     private boolean isProxyAccessGetter(Method paramMethod) {
/*  375 */       if (!Object.class.equals(paramMethod.getReturnType()))
/*      */       {
/*  377 */         return false;
/*      */       }
/*  379 */       if (!Arrays.deepEquals(new Class[0], paramMethod.getParameterTypes()))
/*      */       {
/*  382 */         return false;
/*      */       }
/*  384 */       if (!Arrays.deepEquals(new Class[0], paramMethod.getExceptionTypes()))
/*      */       {
/*  387 */         return false;
/*      */       }
/*  389 */       return true;
/*      */     }
/*      */ 
/*      */     private boolean isProxyAccessSetter(Method paramMethod)
/*      */     {
/*  394 */       if (!Void.TYPE.equals(paramMethod.getReturnType()))
/*      */       {
/*  396 */         return false;
/*      */       }
/*  398 */       if (!Arrays.deepEquals(new Class[] { Object.class }, paramMethod.getParameterTypes()))
/*      */       {
/*  401 */         return false;
/*      */       }
/*  403 */       if (!Arrays.deepEquals(new Class[0], paramMethod.getExceptionTypes()))
/*      */       {
/*  406 */         return false;
/*      */       }
/*  408 */       return true;
/*      */     }
/*      */ 
/*      */     private void parseAnnotationProxyAccess() {
/*  412 */       if (this.superclass.isAnnotationPresent(ProxyAccess.class)) {
/*  413 */         this.proxyAccessIface = ((ProxyAccess)this.superclass.getAnnotation(ProxyAccess.class)).value();
/*      */ 
/*  416 */         if (!this.proxyAccessIface.isInterface()) {
/*  417 */           throw AnnotationsRegistry.SyntaxError.access$300(this.proxyAccessIface);
/*      */         }
/*  419 */         if (0 != this.proxyAccessIface.getInterfaces().length) {
/*  420 */           throw AnnotationsRegistry.SyntaxError.access$500(this.proxyAccessIface);
/*      */         }
/*  422 */         Method[] arrayOfMethod = this.proxyAccessIface.getMethods();
/*      */ 
/*  424 */         if (2 != arrayOfMethod.length) {
/*  425 */           throw AnnotationsRegistry.SyntaxError.access$600(this.proxyAccessIface);
/*      */         }
/*  427 */         if ((isProxyAccessGetter(arrayOfMethod[0])) && (isProxyAccessSetter(arrayOfMethod[1])))
/*      */         {
/*  429 */           this.proxyAccessGetter = arrayOfMethod[0];
/*  430 */           this.proxyAccessSetter = arrayOfMethod[1];
/*      */         }
/*  432 */         else if ((isProxyAccessGetter(arrayOfMethod[1])) && (isProxyAccessSetter(arrayOfMethod[0])))
/*      */         {
/*  434 */           this.proxyAccessGetter = arrayOfMethod[1];
/*  435 */           this.proxyAccessSetter = arrayOfMethod[0];
/*      */         }
/*      */         else {
/*  438 */           throw AnnotationsRegistry.SyntaxError.access$600(this.proxyAccessIface);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*      */     private void checkIsSingle(Method paramMethod, Class paramClass)
/*      */     {
/*  450 */       for (Class localClass : listOfMethodOperators)
/*  451 */         if ((!localClass.equals(paramClass)) && 
/*  452 */           (paramMethod.isAnnotationPresent(localClass)))
/*  453 */           throw AnnotationsRegistry.SyntaxError.access$700();
/*      */     }
/*      */ 
/*      */     private void parseAnnotationPre(Method paramMethod)
/*      */     {
/*  458 */       if (paramMethod.isAnnotationPresent(Pre.class))
/*      */       {
/*  460 */         checkIsSingle(paramMethod, Pre.class);
/*      */ 
/*  462 */         if (!Arrays.deepEquals(new Class[0], paramMethod.getExceptionTypes()))
/*      */         {
/*  465 */           throw AnnotationsRegistry.SyntaxError.access$800();
/*      */         }
/*  467 */         if (!Arrays.deepEquals(new Class[] { Method.class, Object.class, [Ljava.lang.Object.class }, paramMethod.getParameterTypes()))
/*      */         {
/*  470 */           throw AnnotationsRegistry.SyntaxError.access$800();
/*      */         }
/*  472 */         if (!Void.TYPE.equals(paramMethod.getReturnType())) {
/*  473 */           throw AnnotationsRegistry.SyntaxError.access$800();
/*      */         }
/*  475 */         if (paramMethod.isAnnotationPresent(Methods.class)) {
/*  476 */           for (Signature localSignature : ((Methods)paramMethod.getAnnotation(Methods.class)).signatures())
/*  477 */             this.pres.put(new MethodSignature(localSignature.name(), localSignature.args(), null), paramMethod);
/*      */         }
/*      */         else {
/*  480 */           if (null != this.pre) throw AnnotationsRegistry.SyntaxError.access$900();
/*  481 */           this.pre = paramMethod;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*      */     private Class doAutoBoxing(Class paramClass)
/*      */     {
/*  488 */       if (Boolean.TYPE.equals(paramClass)) {
/*  489 */         return Boolean.class;
/*      */       }
/*  491 */       if (Character.TYPE.equals(paramClass)) {
/*  492 */         return Character.class;
/*      */       }
/*  494 */       if (Byte.TYPE.equals(paramClass)) {
/*  495 */         return Byte.class;
/*      */       }
/*  497 */       if (Short.TYPE.equals(paramClass)) {
/*  498 */         return Short.class;
/*      */       }
/*  500 */       if (Integer.TYPE.equals(paramClass)) {
/*  501 */         return Integer.class;
/*      */       }
/*  503 */       if (Long.TYPE.equals(paramClass)) {
/*  504 */         return Long.class;
/*      */       }
/*  506 */       if (Float.TYPE.equals(paramClass)) {
/*  507 */         return Float.class;
/*      */       }
/*  509 */       if (Double.TYPE.equals(paramClass)) {
/*  510 */         return Double.class;
/*      */       }
/*  512 */       return paramClass;
/*      */     }
/*      */ 
/*      */     private void checkReturnTypesMismatch(MethodSignature paramMethodSignature, Method paramMethod)
/*      */     {
/*  525 */       Method localMethod = null;
/*      */ 
/*  527 */       Class localClass1 = doAutoBoxing(paramMethod.getReturnType());
/*      */ 
/*  530 */       for (Class localClass2 : getIfacesToProxy())
/*      */         try
/*      */         {
/*  533 */           localMethod = localClass2.getDeclaredMethod(paramMethodSignature.getName(), paramMethodSignature.getParameterTypes());
/*      */ 
/*  538 */           Class localClass3 = doAutoBoxing(localMethod.getReturnType());
/*      */ 
/*  541 */           if (!Void.TYPE.equals(localClass3))
/*      */           {
/*  544 */             localClass1.asSubclass(localClass3);
/*      */           }
/*      */         }
/*      */         catch (NoSuchMethodException localNoSuchMethodException)
/*      */         {
/*      */         }
/*      */         catch (ClassCastException localClassCastException)
/*      */         {
/*  552 */           throw AnnotationsRegistry.SyntaxError.access$1000(paramMethod, localMethod);
/*      */         }
/*      */     }
/*      */ 
/*      */     private void checkReturnTypesMismatch(Method paramMethod)
/*      */     {
/*  567 */       Class localClass1 = doAutoBoxing(paramMethod.getReturnType());
/*      */ 
/*  570 */       for (Class localClass2 : getIfacesToProxy())
/*  571 */         for (Method localMethod : localClass2.getDeclaredMethods())
/*      */         {
/*  573 */           Class localClass3 = doAutoBoxing(localMethod.getReturnType());
/*      */ 
/*  576 */           if (!Void.TYPE.equals(localClass3))
/*      */           {
/*      */             try
/*      */             {
/*  581 */               localClass3.asSubclass(localClass1);
/*      */             }
/*      */             catch (ClassCastException localClassCastException)
/*      */             {
/*  585 */               throw AnnotationsRegistry.SyntaxError.access$1000(paramMethod, localMethod);
/*      */             }
/*      */           }
/*      */         }
/*      */     }
/*      */ 
/*      */     private void parseAnnotationPost(Method paramMethod)
/*      */     {
/*  594 */       if (paramMethod.isAnnotationPresent(Post.class))
/*      */       {
/*  596 */         checkIsSingle(paramMethod, Post.class);
/*      */ 
/*  598 */         Class localClass = paramMethod.getReturnType();
/*  599 */         Class[] arrayOfClass1 = paramMethod.getParameterTypes();
/*  600 */         Class[] arrayOfClass2 = paramMethod.getExceptionTypes();
/*      */ 
/*  602 */         if (!Arrays.deepEquals(new Class[0], arrayOfClass2))
/*  603 */           throw AnnotationsRegistry.SyntaxError.access$1100();
/*  605 */         Signature localSignature;
/*  605 */         if (Void.TYPE.equals(localClass)) if (Arrays.deepEquals(new Class[] { Method.class }, arrayOfClass1))
/*      */           {
/*  608 */             if (paramMethod.isAnnotationPresent(Methods.class)) {
/*  609 */               for (localSignature : ((Methods)paramMethod.getAnnotation(Methods.class)).signatures())
/*  610 */                 this.voidPosts.put(new MethodSignature(localSignature.name(), localSignature.args(), null), paramMethod);
/*  609 */               return;
/*      */             }
/*      */ 
/*  613 */             if (null != this.voidPost) throw AnnotationsRegistry.SyntaxError.access$900();
/*  614 */             this.voidPost = paramMethod; return;
/*      */           }
/*      */ 
/*  617 */         if (!Void.TYPE.equals(localClass)) if (Arrays.deepEquals(new Class[] { Method.class, localClass }, arrayOfClass1))
/*      */           {
/*  620 */             if (paramMethod.isAnnotationPresent(Methods.class)) {
/*  621 */               for (localSignature : ((Methods)paramMethod.getAnnotation(Methods.class)).signatures())
/*      */               {
/*  623 */                 MethodSignature localMethodSignature = new MethodSignature(localSignature.name(), localSignature.args(), null);
/*      */ 
/*  629 */                 checkReturnTypesMismatch(localMethodSignature, paramMethod);
/*  630 */                 this.returningPosts.put(localMethodSignature, paramMethod);
/*      */               }
/*  621 */               return;
/*      */             }
/*      */ 
/*  634 */             checkReturnTypesMismatch(paramMethod);
/*      */ 
/*  636 */             if (null != this.returningPost) throw AnnotationsRegistry.SyntaxError.access$900();
/*  637 */             this.returningPost = paramMethod; return;
/*      */           }
/*      */ 
/*      */ 
/*  641 */         throw AnnotationsRegistry.SyntaxError.access$1100();
/*      */       }
/*      */     }
/*      */ 
/*      */     private void parseAnnotationOnError(Method paramMethod)
/*      */     {
/*  647 */       if (paramMethod.isAnnotationPresent(OnError.class))
/*      */       {
/*  649 */         checkIsSingle(paramMethod, OnError.class);
/*      */ 
/*  651 */         Class localClass1 = paramMethod.getReturnType();
/*  652 */         Class[] arrayOfClass1 = paramMethod.getParameterTypes();
/*  653 */         Class[] arrayOfClass2 = paramMethod.getExceptionTypes();
/*      */ 
/*  655 */         OnError localOnError = (OnError)paramMethod.getAnnotation(OnError.class);
/*  656 */         Class localClass2 = localOnError.value();
/*      */         Signature localSignature;
/*      */         MethodSignature localMethodSignature;
/*      */         Object localObject;
/*  658 */         if (Arrays.deepEquals(new Class[] { Method.class, localClass2 }, arrayOfClass1)) if ((Arrays.deepEquals(new Class[] { localClass2 }, arrayOfClass2)) && (Void.TYPE.equals(localClass1)))
/*      */           {
/*  662 */             if (paramMethod.isAnnotationPresent(Methods.class)) {
/*  663 */               for (localSignature : ((Methods)paramMethod.getAnnotation(Methods.class)).signatures())
/*      */               {
/*  665 */                 localMethodSignature = new MethodSignature(localSignature.name(), localSignature.args(), null);
/*      */ 
/*  671 */                 localObject = (Map)this.voidOnErrors.get(localMethodSignature);
/*  672 */                 if (null == localObject) {
/*  673 */                   this.voidOnErrors.put(localMethodSignature, localObject = new HashMap());
/*      */                 }
/*  675 */                 if (null != ((Map)localObject).put(localClass2, paramMethod))
/*  676 */                   throw AnnotationsRegistry.SyntaxError.access$1200();
/*      */               }
/*  663 */               return;
/*      */             }
/*      */ 
/*  679 */             if (null == this.voidOnErrorsMap.put(localClass2, paramMethod)) return;
/*  680 */             throw AnnotationsRegistry.SyntaxError.access$900();
/*      */           }
/*  682 */         if (Arrays.deepEquals(new Class[] { Method.class, localClass2 }, arrayOfClass1)) if ((Arrays.deepEquals(new Class[] { localClass2 }, arrayOfClass2)) && (!Void.TYPE.equals(localClass1)))
/*      */           {
/*  686 */             if (paramMethod.isAnnotationPresent(Methods.class)) {
/*  687 */               for (localSignature : ((Methods)paramMethod.getAnnotation(Methods.class)).signatures())
/*      */               {
/*  689 */                 localMethodSignature = new MethodSignature(localSignature.name(), localSignature.args(), null);
/*      */ 
/*  695 */                 checkReturnTypesMismatch(localMethodSignature, paramMethod);
/*      */ 
/*  697 */                 localObject = (Map)this.returningOnErrors.get(localMethodSignature);
/*  698 */                 if (null == localObject) {
/*  699 */                   this.returningOnErrors.put(localMethodSignature, localObject = new HashMap());
/*      */                 }
/*  701 */                 if (null != ((Map)localObject).put(localClass2, paramMethod))
/*  702 */                   throw AnnotationsRegistry.SyntaxError.access$1200();
/*      */               }
/*  687 */               return;
/*      */             }
/*      */ 
/*  706 */             checkReturnTypesMismatch(paramMethod);
/*      */ 
/*  708 */             if (null == this.returningOnErrorsMap.put(localClass2, paramMethod)) return;
/*  709 */             throw AnnotationsRegistry.SyntaxError.access$900();
/*      */           }
/*      */ 
/*      */ 
/*  713 */         throw AnnotationsRegistry.SyntaxError.access$1300();
/*      */       }
/*      */     }
/*      */ 
/*      */     private void parseAnnotationGetCreator(Method paramMethod)
/*      */     {
/*  719 */       if (paramMethod.isAnnotationPresent(GetCreator.class))
/*      */       {
/*  721 */         checkIsSingle(paramMethod, GetCreator.class);
/*      */ 
/*  723 */         if (paramMethod.isAnnotationPresent(Methods.class)) {
/*  724 */           throw AnnotationsRegistry.SyntaxError.access$1400();
/*      */         }
/*  726 */         int i = paramMethod.getModifiers();
/*      */ 
/*  728 */         if (!Modifier.isProtected(i)) {
/*  729 */           throw AnnotationsRegistry.SyntaxError.access$1500();
/*      */         }
/*  731 */         if (!Modifier.isAbstract(i)) {
/*  732 */           throw AnnotationsRegistry.SyntaxError.access$1600();
/*      */         }
/*  734 */         if (!Arrays.deepEquals(new Class[0], paramMethod.getParameterTypes())) {
/*  735 */           throw AnnotationsRegistry.SyntaxError.access$1700();
/*      */         }
/*  737 */         if (!Object.class.equals(paramMethod.getReturnType())) {
/*  738 */           throw AnnotationsRegistry.SyntaxError.access$1700();
/*      */         }
/*  740 */         this.methodGetCreator = paramMethod;
/*      */       }
/*      */     }
/*      */ 
/*      */     private void parseAnnotationGetProxy(Method paramMethod)
/*      */     {
/*  746 */       if (paramMethod.isAnnotationPresent(GetProxy.class))
/*      */       {
/*  748 */         checkIsSingle(paramMethod, GetProxy.class);
/*      */ 
/*  750 */         if (paramMethod.isAnnotationPresent(Methods.class)) {
/*  751 */           throw AnnotationsRegistry.SyntaxError.access$1400();
/*      */         }
/*  753 */         int i = paramMethod.getModifiers();
/*      */ 
/*  755 */         if (!Modifier.isProtected(i)) {
/*  756 */           throw AnnotationsRegistry.SyntaxError.access$1800();
/*      */         }
/*  758 */         if (!Modifier.isAbstract(i)) {
/*  759 */           throw AnnotationsRegistry.SyntaxError.access$1900();
/*      */         }
/*  761 */         if (!Arrays.deepEquals(new Class[] { Object.class, Object.class }, paramMethod.getParameterTypes()))
/*      */         {
/*  764 */           throw AnnotationsRegistry.SyntaxError.access$2000();
/*      */         }
/*  766 */         if (!Object.class.equals(paramMethod.getReturnType())) {
/*  767 */           throw AnnotationsRegistry.SyntaxError.access$2000();
/*      */         }
/*  769 */         this.methodGetProxy = paramMethod;
/*      */       }
/*      */     }
/*      */ 
/*      */     private void parseAnnotationGetDelegate(Method paramMethod)
/*      */     {
/*  775 */       if (paramMethod.isAnnotationPresent(GetDelegate.class))
/*      */       {
/*  777 */         checkIsSingle(paramMethod, GetDelegate.class);
/*      */ 
/*  779 */         if (paramMethod.isAnnotationPresent(Methods.class)) {
/*  780 */           throw AnnotationsRegistry.SyntaxError.access$1400();
/*      */         }
/*  782 */         int i = paramMethod.getModifiers();
/*      */ 
/*  784 */         if (!Modifier.isProtected(i)) {
/*  785 */           throw AnnotationsRegistry.SyntaxError.access$2100();
/*      */         }
/*  787 */         if (!Modifier.isAbstract(i)) {
/*  788 */           throw AnnotationsRegistry.SyntaxError.access$2200();
/*      */         }
/*  790 */         if (!Arrays.deepEquals(new Class[0], paramMethod.getParameterTypes())) {
/*  791 */           throw AnnotationsRegistry.SyntaxError.access$2300();
/*      */         }
/*  793 */         if (Void.TYPE.equals(paramMethod.getReturnType())) {
/*  794 */           throw AnnotationsRegistry.SyntaxError.access$2300();
/*      */         }
/*  796 */         this.methodGetDelegate = paramMethod;
/*      */       }
/*      */     }
/*      */ 
/*      */     private void parseAnnotationSetDelegate(Method paramMethod)
/*      */     {
/*  802 */       if (paramMethod.isAnnotationPresent(SetDelegate.class))
/*      */       {
/*  804 */         checkIsSingle(paramMethod, SetDelegate.class);
/*      */ 
/*  806 */         if (paramMethod.isAnnotationPresent(Methods.class)) {
/*  807 */           throw AnnotationsRegistry.SyntaxError.access$1400();
/*      */         }
/*  809 */         int i = paramMethod.getModifiers();
/*      */ 
/*  811 */         if (!Modifier.isProtected(i)) {
/*  812 */           throw AnnotationsRegistry.SyntaxError.access$2400();
/*      */         }
/*  814 */         if (!Modifier.isAbstract(i)) {
/*  815 */           throw AnnotationsRegistry.SyntaxError.access$2500();
/*      */         }
/*  817 */         if (1 != paramMethod.getParameterTypes().length) {
/*  818 */           throw AnnotationsRegistry.SyntaxError.access$2600();
/*      */         }
/*  820 */         if (!Void.TYPE.equals(paramMethod.getReturnType())) {
/*  821 */           throw AnnotationsRegistry.SyntaxError.access$2600();
/*      */         }
/*  823 */         this.methodSetDelegate = paramMethod;
/*      */       }
/*      */     }
/*      */ 
/*      */     private Rest parseAnnotations()
/*      */     {
/*  829 */       parseAnnotationProxyFor();
/*  830 */       parseAnnotationProxyAccess();
/*  831 */       parseAnnotationProxyLocale();
/*  832 */       parseAnnotationTypeProxyResult();
/*      */ 
/*  834 */       for (Method localMethod : this.superclass.getDeclaredMethods())
/*      */       {
/*  836 */         parseAnnotationPre(localMethod);
/*  837 */         parseAnnotationPost(localMethod);
/*  838 */         parseAnnotationOnError(localMethod);
/*  839 */         parseAnnotationGetCreator(localMethod);
/*  840 */         parseAnnotationGetProxy(localMethod);
/*  841 */         parseAnnotationGetDelegate(localMethod);
/*  842 */         parseAnnotationSetDelegate(localMethod);
/*      */       }
/*      */ 
/*  847 */       if (null != this.proxyAccessIface)
/*  848 */         for (??? = this.ifacesToProxy.iterator(); ((Iterator)???).hasNext(); ) { Class localClass = (Class)((Iterator)???).next();
/*      */           try {
/*  850 */             localClass.asSubclass(this.proxyAccessIface);
/*      */           }
/*      */           catch (ClassCastException localClassCastException) {
/*  853 */             throw AnnotationsRegistry.SyntaxError.access$2700(localClass, this.proxyAccessIface);
/*      */           }
/*      */         }
/*  856 */       return new Rest(this.pre, this.voidPost, this.returningPost, this.voidOnErrorsMap, this.returningOnErrorsMap);
/*      */     }
/*      */ 
/*      */     boolean belongsToIfaceToProxy(Class paramClass, MethodSignature paramMethodSignature)
/*      */     {
/*  871 */       for (Class localClass : this.ifacesToProxy)
/*      */         try
/*      */         {
/*  874 */           paramClass.asSubclass(localClass);
/*      */ 
/*  876 */           if (isMethodDeclared(localClass, paramMethodSignature))
/*  877 */             return true;
/*      */         }
/*      */         catch (ClassCastException localClassCastException) {
/*      */         }
/*  881 */       return false;
/*      */     }
/*      */ 
/*      */     private boolean isMethodDeclared(Class paramClass, MethodSignature paramMethodSignature)
/*      */     {
/*      */       try
/*      */       {
/*  890 */         if (null != paramClass.getDeclaredMethod(paramMethodSignature.getName(), paramMethodSignature.getParameterTypes()))
/*      */         {
/*  893 */           return true;
/*      */         }
/*      */       } catch (NoSuchMethodException localNoSuchMethodException) {
/*      */       }
/*  897 */       for (Class localClass : paramClass.getInterfaces()) {
/*  898 */         if (isMethodDeclared(localClass, paramMethodSignature))
/*  899 */           return true;
/*      */       }
/*  901 */       return false;
/*      */     }
/*      */ 
/*      */     Method getMethodPre(Class paramClass, MethodSignature paramMethodSignature)
/*      */     {
/*  917 */       Method localMethod = (Method)this.pres.get(paramMethodSignature);
/*      */ 
/*  920 */       if (null != localMethod) {
/*  921 */         return localMethod;
/*      */       }
/*  923 */       return belongsToIfaceToProxy(paramClass, paramMethodSignature) ? this.rest.getPre() : null;
/*      */     }
/*      */ 
/*      */     Method getMethodVoidPost(Class paramClass, MethodSignature paramMethodSignature)
/*      */     {
/*  941 */       Method localMethod = (Method)this.voidPosts.get(paramMethodSignature);
/*      */ 
/*  944 */       if (null != localMethod) {
/*  945 */         return localMethod;
/*      */       }
/*  947 */       return belongsToIfaceToProxy(paramClass, paramMethodSignature) ? this.rest.getVoidPost() : null;
/*      */     }
/*      */ 
/*      */     Method getMethodReturningPost(Class paramClass, MethodSignature paramMethodSignature)
/*      */     {
/*  965 */       Method localMethod = (Method)this.returningPosts.get(paramMethodSignature);
/*      */ 
/*  968 */       if (null != localMethod) {
/*  969 */         return localMethod;
/*      */       }
/*  971 */       return belongsToIfaceToProxy(paramClass, paramMethodSignature) ? this.rest.getReturningPost() : null;
/*      */     }
/*      */ 
/*      */     Map<Class, Method> getMapVoidOnError(Class paramClass, MethodSignature paramMethodSignature)
/*      */     {
/*  989 */       Map localMap = (Map)this.voidOnErrors.get(paramMethodSignature);
/*      */ 
/*  992 */       if (null != localMap) {
/*  993 */         return localMap;
/*      */       }
/*  995 */       return belongsToIfaceToProxy(paramClass, paramMethodSignature) ? this.rest.getVoidOnError() : null;
/*      */     }
/*      */ 
/*      */     Map<Class, Method> getMapReturningOnError(Class paramClass, MethodSignature paramMethodSignature)
/*      */     {
/* 1013 */       Map localMap = (Map)this.returningOnErrors.get(paramMethodSignature);
/*      */ 
/* 1016 */       if (null != localMap) {
/* 1017 */         return localMap;
/*      */       }
/* 1019 */       return belongsToIfaceToProxy(paramClass, paramMethodSignature) ? this.rest.getReturningOnError() : null;
/*      */     }
/*      */ 
/*      */     Method getMethodGetCreator()
/*      */     {
/* 1029 */       return this.methodGetCreator;
/*      */     }
/*      */ 
/*      */     Method getMethodGetDelegate()
/*      */     {
/* 1037 */       return this.methodGetDelegate;
/*      */     }
/*      */ 
/*      */     Method getMethodGetProxy()
/*      */     {
/* 1045 */       return this.methodGetProxy;
/*      */     }
/*      */ 
/*      */     Method getMethodSetDelegate()
/*      */     {
/* 1053 */       return this.methodSetDelegate;
/*      */     }
/*      */ 
/*      */     List<Class> getIfacesToProxy()
/*      */     {
/* 1061 */       return this.ifacesToProxy;
/*      */     }
/*      */ 
/*      */     Class getSuperclass()
/*      */     {
/* 1069 */       return this.superclass;
/*      */     }
/*      */ 
/*      */     boolean isProxyLocale()
/*      */     {
/* 1077 */       return this.isProxyLocale;
/*      */     }
/*      */ 
/*      */     ProxyResultPolicy getProxyResultPolicy()
/*      */     {
/* 1086 */       return this.proxyResultPolicy;
/*      */     }
/*      */ 
/*      */     ProxyResultPolicy getProxyResultPolicy(Method paramMethod)
/*      */     {
/*      */       Method localMethod;
/*      */       try
/*      */       {
/* 1101 */         localMethod = this.superclass.getDeclaredMethod(paramMethod.getName(), paramMethod.getParameterTypes());
/*      */       }
/*      */       catch (NoSuchMethodException localNoSuchMethodException)
/*      */       {
/* 1105 */         return this.proxyResultPolicy;
/*      */       }
/*      */ 
/* 1108 */       if (localMethod.isAnnotationPresent(ProxyResult.class))
/*      */       {
/* 1110 */         ProxyResult localProxyResult = (ProxyResult)localMethod.getAnnotation(ProxyResult.class);
/* 1111 */         return localProxyResult.value();
/*      */       }
/*      */ 
/* 1114 */       return this.proxyResultPolicy;
/*      */     }
/*      */ 
/*      */     Class getProxyAccessIface()
/*      */     {
/* 1121 */       return this.proxyAccessIface;
/*      */     }
/*      */ 
/*      */     Method getProxyAccessGetter()
/*      */     {
/* 1128 */       return this.proxyAccessGetter;
/*      */     }
/*      */ 
/*      */     Method getProxyAccessSetter()
/*      */     {
/* 1135 */       return this.proxyAccessSetter;
/*      */     }
/*      */ 
/*      */     private static class Rest
/*      */     {
/*      */       private final Method pre;
/*      */       private final Method voidPost;
/*      */       private final Method returningPost;
/*      */       private final Map<Class, Method> voidOnErrorsMap;
/*      */       private final Map<Class, Method> returningOnErrorsMap;
/*      */ 
/*      */       Rest(Method paramMethod1, Method paramMethod2, Method paramMethod3, Map<Class, Method> paramMap1, Map<Class, Method> paramMap2)
/*      */       {
/*  259 */         this.pre = paramMethod1;
/*  260 */         this.voidPost = paramMethod2;
/*  261 */         this.returningPost = paramMethod3;
/*  262 */         this.voidOnErrorsMap = paramMap1;
/*  263 */         this.returningOnErrorsMap = paramMap2;
/*      */       }
/*      */ 
/*      */       Method getPre()
/*      */       {
/*  271 */         return this.pre;
/*      */       }
/*      */ 
/*      */       Map<Class, Method> getReturningOnError()
/*      */       {
/*  279 */         return this.returningOnErrorsMap;
/*      */       }
/*      */ 
/*      */       Method getReturningPost()
/*      */       {
/*  287 */         return this.returningPost;
/*      */       }
/*      */ 
/*      */       Map<Class, Method> getVoidOnError()
/*      */       {
/*  295 */         return this.voidOnErrorsMap;
/*      */       }
/*      */ 
/*      */       Method getVoidPost()
/*      */       {
/*  303 */         return this.voidPost;
/*      */       }
/*      */     }
/*      */ 
/*      */     private static class MethodSpecific<T>
/*      */     {
/*  219 */       private final Map<MethodSignature, T> ref = new HashMap();
/*      */       private final String annotationType;
/*      */ 
/*      */       private MethodSpecific(String paramString)
/*      */       {
/*  226 */         this.annotationType = paramString;
/*      */       }
/*      */ 
/*      */       void put(MethodSignature paramMethodSignature, T paramT)
/*      */       {
/*  231 */         if (null != this.ref.put(paramMethodSignature, paramT))
/*  232 */           throw AnnotationsRegistry.SyntaxError.access$200(this.annotationType);
/*      */       }
/*      */ 
/*      */       T get(MethodSignature paramMethodSignature)
/*      */       {
/*  237 */         return this.ref.get(paramMethodSignature);
/*      */       }
/*      */ 
/*      */       static final class ReturningOnErrors extends AnnotationsRegistry.Value.MethodSpecific<Map<Class, Method>>
/*      */       {
/*      */         ReturningOnErrors()
/*      */         {
/*  217 */           super(null);
/*      */         }
/*      */       }
/*      */ 
/*      */       static final class VoidOnErrors extends AnnotationsRegistry.Value.MethodSpecific<Map<Class, Method>>
/*      */       {
/*      */         VoidOnErrors()
/*      */         {
/*  216 */           super(null);
/*      */         }
/*      */       }
/*      */ 
/*      */       static final class ReturningPosts extends AnnotationsRegistry.Value.MethodSpecific<Method>
/*      */       {
/*      */         ReturningPosts()
/*      */         {
/*  215 */           super(null);
/*      */         }
/*      */       }
/*      */ 
/*      */       static final class VoidPosts extends AnnotationsRegistry.Value.MethodSpecific<Method>
/*      */       {
/*      */         VoidPosts()
/*      */         {
/*  214 */           super(null);
/*      */         }
/*      */       }
/*      */ 
/*      */       static final class Pres extends AnnotationsRegistry.Value.MethodSpecific<Method>
/*      */       {
/*      */         Pres()
/*      */         {
/*  213 */           super(null);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class SyntaxError extends RuntimeException
/*      */   {
/*   53 */     private static final SyntaxError onlyOneAllowed = new SyntaxError("only one @Pre/@Post/@OnError/@GetDelegate/@SetDelegate/@GetCreator/@GetProxy allowed");
/*      */ 
/*   56 */     private static final SyntaxError onlyOneMethodslessAllowed = new SyntaxError("only one @Methods-less @Pre/@Post/@OnError allowed");
/*      */ 
/*   59 */     private static final SyntaxError wrongMethodsContext = new SyntaxError("wrong context for @Methods");
/*      */ 
/*   62 */     private static final SyntaxError wrongPre = new SyntaxError("wrong @Pre");
/*      */ 
/*   65 */     private static final SyntaxError wrongPost = new SyntaxError("wrong @Post");
/*      */ 
/*   68 */     private static final SyntaxError wrongOnError = new SyntaxError("wrong @OnError");
/*      */ 
/*   71 */     private static final SyntaxError onlyOneOnErrorExceptionTypeAllowed = new SyntaxError("only one @OnError Exception type allowed for a given method");
/*      */ 
/*   74 */     private static final SyntaxError wrongGetCreator = new SyntaxError("wrong @GetCreator");
/*      */ 
/*   77 */     private static final SyntaxError wrongGetCreatorMustBeProtected = new SyntaxError("wrong @GetCreator: must be protected");
/*      */ 
/*   80 */     private static final SyntaxError wrongGetCreatorMustBeAbstract = new SyntaxError("wrong @GetCreator: must be abstract");
/*      */ 
/*   83 */     private static final SyntaxError wrongGetDelegate = new SyntaxError("wrong @GetDelegate");
/*      */ 
/*   86 */     private static final SyntaxError wrongGetDelegateMustBeProtected = new SyntaxError("wrong @GetDelegate: must be protected");
/*      */ 
/*   89 */     private static final SyntaxError wrongGetDelegateMustBeAbstract = new SyntaxError("wrong @GetDelegate: must be abstract");
/*      */ 
/*   92 */     private static final SyntaxError wrongGetProxy = new SyntaxError("wrong @GetProxy");
/*      */ 
/*   95 */     private static final SyntaxError wrongGetProxyMustBeProtected = new SyntaxError("wrong @GetProxy: must be protected");
/*      */ 
/*   98 */     private static final SyntaxError wrongGetProxyMustBeAbstract = new SyntaxError("wrong @GetProxy: must be abstract");
/*      */ 
/*  101 */     private static final SyntaxError wrongSetDelegate = new SyntaxError("wrong @SetDelegate");
/*      */ 
/*  104 */     private static final SyntaxError wrongSetDelegateMustBeProtected = new SyntaxError("wrong @SetDelegate: must be protected");
/*      */ 
/*  107 */     private static final SyntaxError wrongSetDelegateMustBeAbstract = new SyntaxError("wrong @SetDelegate: must be abstract");
/*      */ 
/*      */     SyntaxError(String paramString)
/*      */     {
/*   50 */       super();
/*      */     }
/*      */ 
/*      */     private static SyntaxError mustBeClass(Class paramClass)
/*      */     {
/*  112 */       return new SyntaxError(paramClass.getName() + " must be an abstract or concrete class");
/*      */     }
/*      */ 
/*      */     private static SyntaxError mustBeIface(Class paramClass)
/*      */     {
/*  118 */       return new SyntaxError(paramClass.getName() + " must be an interface");
/*      */     }
/*      */ 
/*      */     private static SyntaxError mustNotImplementIfaces(Class paramClass)
/*      */     {
/*  123 */       return new SyntaxError(paramClass.getName() + " must not implement interfaces");
/*      */     }
/*      */ 
/*      */     private static SyntaxError wrongProxyAccessIface(Class paramClass)
/*      */     {
/*  128 */       return new SyntaxError(paramClass.getName() + " wrong @ProxyAccess argument.  " + "Must contain an interface with a simple getter and a simple setter and nothing else, like:\n" + "public interface Proxyable<T> {\n" + "  void setProxy(T proxy);\n" + "  T getProxy();\n" + "}");
/*      */     }
/*      */ 
/*      */     private static SyntaxError annotationDefinedMoreThanOnce(String paramString)
/*      */     {
/*  138 */       return new SyntaxError(paramString + " is defined more than once for the same method");
/*      */     }
/*      */ 
/*      */     private static SyntaxError mustExtendProxyAccessIface(Class paramClass1, Class paramClass2)
/*      */     {
/*  144 */       return new SyntaxError(paramClass1.getName() + " must extends @ProxyAccess interface " + paramClass2.getName());
/*      */     }
/*      */ 
/*      */     private static SyntaxError noProxyForClass(Class paramClass)
/*      */     {
/*  150 */       return new SyntaxError("no @ProxyFor for class " + paramClass.getName());
/*      */     }
/*      */ 
/*      */     private static SyntaxError returnTypeMismatch(Method paramMethod1, Method paramMethod2)
/*      */     {
/*  157 */       return new SyntaxError("interceptor " + paramMethod1.getName() + " and interceptee " + paramMethod2.getName() + ": have different return types (" + paramMethod1.getReturnType().getName() + " and " + paramMethod2.getReturnType().getName() + ")");
/*      */     }
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.proxy.AnnotationsRegistry
 * JD-Core Version:    0.6.2
 */