/*      */ package oracle.jdbc.pool;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.io.ObjectOutputStream;
/*      */ import java.io.Serializable;
/*      */ import java.sql.CallableStatement;
/*      */ import java.sql.Connection;
/*      */ import java.sql.PreparedStatement;
/*      */ import java.sql.SQLException;
/*      */ import java.util.Enumeration;
/*      */ import java.util.HashMap;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Map;
/*      */ import java.util.Properties;
/*      */ import javax.sql.ConnectionEvent;
/*      */ import javax.sql.ConnectionEventListener;
/*      */ import javax.sql.PooledConnection;
/*      */ import javax.sql.StatementEventListener;
/*      */ import javax.transaction.xa.XAResource;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.driver.OracleCloseCallback;
/*      */ import oracle.jdbc.driver.OracleDriver;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ 
/*      */ public class OraclePooledConnection
/*      */   implements PooledConnection, Serializable
/*      */ {
/*      */   static final long serialVersionUID = -203725628718322873L;
/*      */   public static final String url_string = "connection_url";
/*      */   public static final String pool_auto_commit_string = "pool_auto_commit";
/*      */   public static final String object_type_map = "obj_type_map";
/*      */   public static final String transaction_isolation = "trans_isolation";
/*      */   public static final String statement_cache_size = "stmt_cache_size";
/*      */   public static final String isClearMetaData = "stmt_cache_clear_metadata";
/*      */   public static final String ImplicitStatementCachingEnabled = "ImplicitStatementCachingEnabled";
/*      */   public static final String ExplicitStatementCachingEnabled = "ExplicitStatementCachingEnabled";
/*      */   public static final String LoginTimeout = "LoginTimeout";
/*      */   public static final String connect_auto_commit_string = "connect_auto_commit";
/*      */   public static final String implicit_caching_enabled = "implicit_cache_enabled";
/*      */   public static final String explicit_caching_enabled = "explict_cache_enabled";
/*      */   public static final String connection_properties_string = "connection_properties";
/*      */   public static final String event_listener_string = "event_listener";
/*      */   public static final String sql_exception_string = "sql_exception";
/*      */   public static final String close_callback_string = "close_callback";
/*      */   public static final String private_data = "private_data";
/*      */   static final int CONNECTION_CLOSED_EVENT = 101;
/*      */   static final int CONNECTION_ERROROCCURED_EVENT = 102;
/*   78 */   private Hashtable eventListeners = null;
/*   79 */   private SQLException sqlException = null;
/*   80 */   protected boolean autoCommit = true;
/*      */ 
/*   84 */   private ConnectionEventListener iccEventListener = null;
/*      */ 
/*   87 */   protected transient OracleConnection logicalHandle = null;
/*      */ 
/*   90 */   protected transient OracleConnection physicalConn = null;
/*      */ 
/*   92 */   private Hashtable connectionProperty = null;
/*      */ 
/*   94 */   public Properties cachedConnectionAttributes = null;
/*   95 */   public Properties unMatchedCachedConnAttr = null;
/*   96 */   public int closeOption = 0;
/*      */ 
/*   98 */   private String pcKey = null;
/*      */ 
/*  101 */   private OracleCloseCallback closeCallback = null;
/*  102 */   private Object privateData = null;
/*      */ 
/*  105 */   private long lastAccessedTime = 0L;
/*      */ 
/*  108 */   protected String dataSourceInstanceNameKey = null;
/*  109 */   protected String dataSourceHostNameKey = null;
/*  110 */   protected String dataSourceDbUniqNameKey = null;
/*  111 */   protected boolean connectionMarkedDown = false;
/*  112 */   protected boolean needToAbort = false;
/*      */ 
/*  114 */   protected transient OracleDriver oracleDriver = new OracleDriver();
/*  115 */   boolean localTxnCommitOnClose = false;
/*      */ 
/* 1262 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public OraclePooledConnection()
/*      */   {
/*  120 */     this((Connection)null);
/*      */   }
/*      */ 
/*      */   public OraclePooledConnection(String paramString)
/*      */     throws SQLException
/*      */   {
/*  143 */     Connection localConnection = this.oracleDriver.connect(paramString, new Properties());
/*      */ 
/*  145 */     if (localConnection == null)
/*      */     {
/*  147 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 67);
/*  148 */       localSQLException.fillInStackTrace();
/*  149 */       throw localSQLException;
/*      */     }
/*      */ 
/*  152 */     initialize(localConnection);
/*      */   }
/*      */ 
/*      */   public OraclePooledConnection(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/*  172 */     Properties localProperties = new Properties();
/*      */ 
/*  174 */     localProperties.put("user", paramString2);
/*  175 */     localProperties.put("password", paramString3);
/*  176 */     Connection localConnection = this.oracleDriver.connect(paramString1, localProperties);
/*  177 */     if (localConnection == null)
/*      */     {
/*  179 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 67);
/*  180 */       localSQLException.fillInStackTrace();
/*  181 */       throw localSQLException;
/*      */     }
/*      */ 
/*  184 */     initialize(localConnection);
/*      */   }
/*      */ 
/*      */   public OraclePooledConnection(Connection paramConnection)
/*      */   {
/*  201 */     initialize(paramConnection);
/*      */   }
/*      */ 
/*      */   public OraclePooledConnection(Connection paramConnection, boolean paramBoolean)
/*      */   {
/*  213 */     this(paramConnection);
/*      */ 
/*  220 */     this.autoCommit = paramBoolean;
/*      */   }
/*      */ 
/*      */   private void initialize(Connection paramConnection)
/*      */   {
/*  229 */     this.physicalConn = ((OracleConnection)paramConnection);
/*  230 */     this.eventListeners = new Hashtable(10);
/*      */ 
/*  232 */     this.closeCallback = null;
/*  233 */     this.privateData = null;
/*  234 */     this.lastAccessedTime = 0L;
/*      */   }
/*      */ 
/*      */   public synchronized void addConnectionEventListener(ConnectionEventListener paramConnectionEventListener)
/*      */   {
/*  254 */     if (this.eventListeners == null)
/*  255 */       this.sqlException = new SQLException("Listener Hashtable Null");
/*      */     else
/*  257 */       this.eventListeners.put(paramConnectionEventListener, paramConnectionEventListener);
/*      */   }
/*      */ 
/*      */   public synchronized void close()
/*      */     throws SQLException
/*      */   {
/*  276 */     if (this.closeCallback != null) {
/*  277 */       this.closeCallback.beforeClose(this.physicalConn, this.privateData);
/*      */     }
/*  279 */     if (this.physicalConn != null)
/*      */     {
/*      */       try
/*      */       {
/*  283 */         this.physicalConn.close();
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/*      */       }
/*      */ 
/*  289 */       this.physicalConn = null;
/*      */     }
/*      */ 
/*  292 */     if (this.closeCallback != null) {
/*  293 */       this.closeCallback.afterClose(this.privateData);
/*      */     }
/*      */ 
/*  296 */     this.lastAccessedTime = 0L;
/*  297 */     this.iccEventListener = null;
/*      */   }
/*      */ 
/*      */   public synchronized Connection getConnection()
/*      */     throws SQLException
/*      */   {
/*  319 */     if (this.physicalConn == null)
/*      */     {
/*  321 */       this.sqlException = new SQLException("Physical Connection doesn't exist");
/*      */ 
/*  324 */       callListener(102);
/*      */ 
/*  327 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  328 */       localSQLException1.fillInStackTrace();
/*  329 */       throw localSQLException1;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  337 */       if (this.logicalHandle != null)
/*      */       {
/*  342 */         this.logicalHandle.closeInternal(false);
/*      */       }
/*      */ 
/*  346 */       this.logicalHandle = ((OracleConnection)this.physicalConn.getLogicalConnection(this, this.autoCommit));
/*      */     }
/*      */     catch (SQLException localSQLException2)
/*      */     {
/*  352 */       this.sqlException = localSQLException2;
/*      */ 
/*  354 */       callListener(102);
/*      */ 
/*  356 */       callImplicitCacheListener(102);
/*      */ 
/*  358 */       SQLException localSQLException3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8, "OraclePooledConnection.getConnection() - SQLException Ocurred:" + localSQLException2.getMessage());
/*      */ 
/*  360 */       localSQLException3.fillInStackTrace();
/*  361 */       throw localSQLException3;
/*      */     }
/*      */ 
/*  365 */     return this.logicalHandle;
/*      */   }
/*      */ 
/*      */   public Connection getLogicalHandle()
/*      */     throws SQLException
/*      */   {
/*  384 */     return this.logicalHandle;
/*      */   }
/*      */ 
/*      */   public Connection getPhysicalHandle()
/*      */     throws SQLException
/*      */   {
/*  396 */     return this.physicalConn;
/*      */   }
/*      */ 
/*      */   public synchronized void setLastAccessedTime(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  417 */     this.lastAccessedTime = paramLong;
/*      */   }
/*      */ 
/*      */   public long getLastAccessedTime()
/*      */     throws SQLException
/*      */   {
/*  436 */     return this.lastAccessedTime;
/*      */   }
/*      */ 
/*      */   public synchronized void registerCloseCallback(OracleCloseCallback paramOracleCloseCallback, Object paramObject)
/*      */   {
/*  456 */     this.closeCallback = paramOracleCloseCallback;
/*  457 */     this.privateData = paramObject;
/*      */   }
/*      */ 
/*      */   public synchronized void removeConnectionEventListener(ConnectionEventListener paramConnectionEventListener)
/*      */   {
/*  476 */     if (this.eventListeners == null)
/*  477 */       this.sqlException = new SQLException("Listener Hashtable Null");
/*      */     else
/*  479 */       this.eventListeners.remove(paramConnectionEventListener);
/*      */   }
/*      */ 
/*      */   public synchronized void registerImplicitCacheConnectionEventListener(ConnectionEventListener paramConnectionEventListener)
/*      */   {
/*  498 */     if (this.iccEventListener != null) {
/*  499 */       this.sqlException = new SQLException("Implicit cache listeneralready registered");
/*      */     }
/*      */     else
/*  502 */       this.iccEventListener = paramConnectionEventListener;
/*      */   }
/*      */ 
/*      */   public void logicalCloseForImplicitConnectionCache()
/*      */   {
/*  530 */     if (this.closeOption == 4096)
/*      */     {
/*  532 */       callImplicitCacheListener(102);
/*      */     }
/*      */     else
/*      */     {
/*  536 */       callImplicitCacheListener(101);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void logicalClose()
/*      */   {
/*  555 */     if (this.cachedConnectionAttributes != null)
/*      */     {
/*  557 */       logicalCloseForImplicitConnectionCache();
/*      */     }
/*      */     else
/*      */     {
/*  562 */       callListener(101);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void callListener(int paramInt)
/*      */   {
/*  577 */     if (this.eventListeners == null) {
/*  578 */       return;
/*      */     }
/*      */ 
/*  582 */     Enumeration localEnumeration = this.eventListeners.keys();
/*      */ 
/*  584 */     ConnectionEvent localConnectionEvent = new ConnectionEvent(this, this.sqlException);
/*      */ 
/*  586 */     while (localEnumeration.hasMoreElements())
/*      */     {
/*  588 */       ConnectionEventListener localConnectionEventListener1 = (ConnectionEventListener)localEnumeration.nextElement();
/*      */ 
/*  590 */       ConnectionEventListener localConnectionEventListener2 = (ConnectionEventListener)this.eventListeners.get(localConnectionEventListener1);
/*      */ 
/*  594 */       if (paramInt == 101)
/*  595 */         localConnectionEventListener2.connectionClosed(localConnectionEvent);
/*  596 */       else if (paramInt == 102)
/*  597 */         localConnectionEventListener2.connectionErrorOccurred(localConnectionEvent);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void callImplicitCacheListener(int paramInt)
/*      */   {
/*  611 */     if (this.iccEventListener == null) {
/*  612 */       return;
/*      */     }
/*  614 */     ConnectionEvent localConnectionEvent = new ConnectionEvent(this, this.sqlException);
/*      */ 
/*  617 */     switch (paramInt)
/*      */     {
/*      */     case 101:
/*  622 */       this.iccEventListener.connectionClosed(localConnectionEvent);
/*      */ 
/*  624 */       break;
/*      */     case 102:
/*  629 */       this.iccEventListener.connectionErrorOccurred(localConnectionEvent);
/*      */     }
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public synchronized void setStmtCacheSize(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  663 */     setStmtCacheSize(paramInt, false);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public synchronized void setStmtCacheSize(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  694 */     if (paramInt < 0)
/*      */     {
/*  696 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  697 */       localSQLException.fillInStackTrace();
/*  698 */       throw localSQLException;
/*      */     }
/*      */ 
/*  702 */     if (this.physicalConn != null)
/*  703 */       this.physicalConn.setStmtCacheSize(paramInt, paramBoolean);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public synchronized int getStmtCacheSize()
/*      */   {
/*  723 */     if (this.physicalConn != null) {
/*  724 */       return this.physicalConn.getStmtCacheSize();
/*      */     }
/*  726 */     return 0;
/*      */   }
/*      */ 
/*      */   public void setStatementCacheSize(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  750 */     if (this.physicalConn != null)
/*  751 */       this.physicalConn.setStatementCacheSize(paramInt);
/*      */   }
/*      */ 
/*      */   public int getStatementCacheSize()
/*      */     throws SQLException
/*      */   {
/*  773 */     if (this.physicalConn != null) {
/*  774 */       return this.physicalConn.getStatementCacheSize();
/*      */     }
/*  776 */     return 0;
/*      */   }
/*      */ 
/*      */   public void setImplicitCachingEnabled(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  802 */     if (this.physicalConn != null)
/*  803 */       this.physicalConn.setImplicitCachingEnabled(paramBoolean);
/*      */   }
/*      */ 
/*      */   public boolean getImplicitCachingEnabled()
/*      */     throws SQLException
/*      */   {
/*  824 */     if (this.physicalConn != null) {
/*  825 */       return this.physicalConn.getImplicitCachingEnabled();
/*      */     }
/*  827 */     return false;
/*      */   }
/*      */ 
/*      */   public void setExplicitCachingEnabled(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  853 */     if (this.physicalConn != null)
/*  854 */       this.physicalConn.setExplicitCachingEnabled(paramBoolean);
/*      */   }
/*      */ 
/*      */   public boolean getExplicitCachingEnabled()
/*      */     throws SQLException
/*      */   {
/*  875 */     if (this.physicalConn != null) {
/*  876 */       return this.physicalConn.getExplicitCachingEnabled();
/*      */     }
/*      */ 
/*  879 */     return false;
/*      */   }
/*      */ 
/*      */   public void purgeImplicitCache()
/*      */     throws SQLException
/*      */   {
/*  901 */     if (this.physicalConn != null)
/*  902 */       this.physicalConn.purgeImplicitCache();
/*      */   }
/*      */ 
/*      */   public void purgeExplicitCache()
/*      */     throws SQLException
/*      */   {
/*  924 */     if (this.physicalConn != null)
/*  925 */       this.physicalConn.purgeExplicitCache();
/*      */   }
/*      */ 
/*      */   public PreparedStatement getStatementWithKey(String paramString)
/*      */     throws SQLException
/*      */   {
/*  951 */     if (this.physicalConn != null) {
/*  952 */       return this.physicalConn.getStatementWithKey(paramString);
/*      */     }
/*      */ 
/*  955 */     return null;
/*      */   }
/*      */ 
/*      */   public CallableStatement getCallWithKey(String paramString)
/*      */     throws SQLException
/*      */   {
/*  981 */     if (this.physicalConn != null) {
/*  982 */       return this.physicalConn.getCallWithKey(paramString);
/*      */     }
/*      */ 
/*  985 */     return null;
/*      */   }
/*      */ 
/*      */   public boolean isStatementCacheInitialized()
/*      */   {
/* 1003 */     if (this.physicalConn != null) {
/* 1004 */       return this.physicalConn.isStatementCacheInitialized();
/*      */     }
/*      */ 
/* 1007 */     return false;
/*      */   }
/*      */ 
/*      */   public final void setProperties(Hashtable paramHashtable)
/*      */   {
/* 1020 */     this.connectionProperty = paramHashtable;
/*      */   }
/*      */ 
/*      */   public final void setUserName(String paramString1, String paramString2)
/*      */   {
/* 1035 */     this.pcKey = generateKey(paramString1, paramString2);
/*      */   }
/*      */ 
/*      */   static final String generateKey(String paramString1, String paramString2)
/*      */   {
/* 1042 */     return paramString1.toUpperCase() + paramString2;
/*      */   }
/*      */ 
/*      */   final OracleConnectionCacheEntry addToImplicitCache(HashMap paramHashMap, OracleConnectionCacheEntry paramOracleConnectionCacheEntry)
/*      */   {
/* 1053 */     return (OracleConnectionCacheEntry)paramHashMap.put(this.pcKey, paramOracleConnectionCacheEntry);
/*      */   }
/*      */ 
/*      */   final OracleConnectionCacheEntry removeFromImplictCache(HashMap paramHashMap)
/*      */   {
/* 1064 */     return (OracleConnectionCacheEntry)paramHashMap.get(this.pcKey);
/*      */   }
/*      */ 
/*      */   final boolean isSameUser(String paramString1, String paramString2)
/*      */   {
/* 1075 */     return (paramString1 != null) && (paramString2 != null) && (this.pcKey.equalsIgnoreCase(paramString1 + paramString2));
/*      */   }
/*      */ 
/*      */   public XAResource getXAResource()
/*      */     throws SQLException
/*      */   {
/* 1096 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 1097 */     localSQLException.fillInStackTrace();
/* 1098 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*      */     throws IOException
/*      */   {
/* 1111 */     paramObjectOutputStream.defaultWriteObject();
/*      */     try
/*      */     {
/* 1120 */       this.physicalConn.getPropertyForPooledConnection(this);
/*      */ 
/* 1122 */       if (this.eventListeners != null) {
/* 1123 */         this.connectionProperty.put("event_listener", this.eventListeners);
/*      */       }
/* 1125 */       if (this.sqlException != null) {
/* 1126 */         this.connectionProperty.put("sql_exception", this.sqlException);
/*      */       }
/* 1128 */       this.connectionProperty.put("pool_auto_commit", "" + this.autoCommit);
/*      */ 
/* 1130 */       if (this.closeCallback != null) {
/* 1131 */         this.connectionProperty.put("close_callback", this.closeCallback);
/*      */       }
/* 1133 */       if (this.privateData != null) {
/* 1134 */         this.connectionProperty.put("private_data", this.privateData);
/*      */       }
/* 1136 */       paramObjectOutputStream.writeObject(this.connectionProperty);
/* 1137 */       this.physicalConn.close();
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   private void readObject(ObjectInputStream paramObjectInputStream)
/*      */     throws IOException, ClassNotFoundException, SQLException
/*      */   {
/* 1155 */     paramObjectInputStream.defaultReadObject();
/*      */ 
/* 1157 */     this.connectionProperty = ((Hashtable)paramObjectInputStream.readObject());
/*      */     try
/*      */     {
/* 1164 */       Properties localProperties = (Properties)this.connectionProperty.get("connection_properties");
/*      */ 
/* 1166 */       String str1 = localProperties.getProperty("connection_url");
/*      */ 
/* 1168 */       this.oracleDriver = new OracleDriver();
/*      */ 
/* 1170 */       Connection localConnection = this.oracleDriver.connect(str1, localProperties);
/*      */ 
/* 1174 */       initialize(localConnection);
/*      */ 
/* 1176 */       this.eventListeners = ((Hashtable)this.connectionProperty.get("event_listener"));
/*      */ 
/* 1178 */       this.sqlException = ((SQLException)this.connectionProperty.get("sql_exception"));
/*      */ 
/* 1180 */       this.autoCommit = ((String)this.connectionProperty.get("pool_auto_commit")).equals("true");
/*      */ 
/* 1182 */       this.closeCallback = ((OracleCloseCallback)this.connectionProperty.get("close_callback"));
/*      */ 
/* 1184 */       this.privateData = this.connectionProperty.get("private_data");
/*      */ 
/* 1186 */       Map localMap = (Map)this.connectionProperty.get("obj_type_map");
/*      */ 
/* 1189 */       if (localMap != null) {
/* 1190 */         ((OracleConnection)localConnection).setTypeMap(localMap);
/*      */       }
/* 1192 */       String str2 = localProperties.getProperty("trans_isolation");
/*      */ 
/* 1194 */       localConnection.setTransactionIsolation(Integer.parseInt(str2));
/*      */ 
/* 1196 */       str2 = localProperties.getProperty("stmt_cache_size");
/*      */ 
/* 1198 */       int i = Integer.parseInt(str2);
/*      */ 
/* 1200 */       if (i != -1)
/*      */       {
/* 1202 */         setStatementCacheSize(i);
/*      */ 
/* 1204 */         str2 = localProperties.getProperty("implicit_cache_enabled");
/* 1205 */         if ((str2 != null) && (str2.equalsIgnoreCase("true")))
/* 1206 */           setImplicitCachingEnabled(true);
/*      */         else {
/* 1208 */           setImplicitCachingEnabled(false);
/*      */         }
/* 1210 */         str2 = localProperties.getProperty("explict_cache_enabled");
/* 1211 */         if ((str2 != null) && (str2.equalsIgnoreCase("true")))
/* 1212 */           setExplicitCachingEnabled(true);
/*      */         else
/* 1214 */           setExplicitCachingEnabled(false);
/*      */       }
/* 1216 */       this.physicalConn.setAutoCommit(((String)localProperties.get("connect_auto_commit")).equals("true"));
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addStatementEventListener(StatementEventListener paramStatementEventListener)
/*      */   {
/*      */   }
/*      */ 
/*      */   public void removeStatementEventListener(StatementEventListener paramStatementEventListener)
/*      */   {
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1257 */     return null;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.pool.OraclePooledConnection
 * JD-Core Version:    0.6.2
 */