/*      */ package oracle.jdbc.pool;
/*      */ 
/*      */ import java.sql.Connection;
/*      */ import java.sql.SQLException;
/*      */ import java.util.Collection;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Iterator;
/*      */ import java.util.Properties;
/*      */ import javax.naming.NamingException;
/*      */ import javax.naming.Reference;
/*      */ import javax.naming.StringRefAddr;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.driver.OracleDriver;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.oci.OracleOCIConnection;
/*      */ 
/*      */ public class OracleOCIConnectionPool extends OracleDataSource
/*      */ {
/*      */   public OracleOCIConnection m_connection_pool;
/*      */   public static final String IS_CONNECTION_POOLING = "is_connection_pooling";
/*   44 */   private int m_conn_min_limit = 0;
/*   45 */   private int m_conn_max_limit = 0;
/*   46 */   private int m_conn_increment = 0;
/*   47 */   private int m_conn_active_size = 0;
/*   48 */   private int m_conn_pool_size = 0;
/*   49 */   private int m_conn_timeout = 0;
/*   50 */   private String m_conn_nowait = "false";
/*   51 */   private int m_is_transactions_distributed = 0;
/*      */   public static final String CONNPOOL_OBJECT = "connpool_object";
/*      */   public static final String CONNPOOL_LOGON_MODE = "connection_pool";
/*      */   public static final String CONNECTION_POOL = "connection_pool";
/*      */   public static final String CONNPOOL_CONNECTION = "connpool_connection";
/*      */   public static final String CONNPOOL_PROXY_CONNECTION = "connpool_proxy_connection";
/*      */   public static final String CONNPOOL_ALIASED_CONNECTION = "connpool_alias_connection";
/*      */   public static final String PROXY_USER_NAME = "proxy_user_name";
/*      */   public static final String PROXY_DISTINGUISHED_NAME = "proxy_distinguished_name";
/*      */   public static final String PROXY_CERTIFICATE = "proxy_certificate";
/*      */   public static final String PROXY_ROLES = "proxy_roles";
/*      */   public static final String PROXY_NUM_ROLES = "proxy_num_roles";
/*      */   public static final String PROXY_PASSWORD = "proxy_password";
/*      */   public static final String PROXYTYPE = "proxytype";
/*      */   public static final String PROXYTYPE_USER_NAME = "proxytype_user_name";
/*      */   public static final String PROXYTYPE_DISTINGUISHED_NAME = "proxytype_distinguished_name";
/*      */   public static final String PROXYTYPE_CERTIFICATE = "proxytype_certificate";
/*      */   public static final String CONNECTION_ID = "connection_id";
/*      */   public static final String CONNPOOL_MIN_LIMIT = "connpool_min_limit";
/*      */   public static final String CONNPOOL_MAX_LIMIT = "connpool_max_limit";
/*      */   public static final String CONNPOOL_INCREMENT = "connpool_increment";
/*      */   public static final String CONNPOOL_ACTIVE_SIZE = "connpool_active_size";
/*      */   public static final String CONNPOOL_POOL_SIZE = "connpool_pool_size";
/*      */   public static final String CONNPOOL_TIMEOUT = "connpool_timeout";
/*      */   public static final String CONNPOOL_NOWAIT = "connpool_nowait";
/*      */   public static final String CONNPOOL_IS_POOLCREATED = "connpool_is_poolcreated";
/*      */   public static final String TRANSACTIONS_DISTRIBUTED = "transactions_distributed";
/*   99 */   private Hashtable m_lconnections = null;
/*      */ 
/*  102 */   private Lifecycle lifecycle = Lifecycle.NEW;
/*      */ 
/*  127 */   private OracleDriver m_oracleDriver = new OracleDriver();
/*      */ 
/*  130 */   protected int m_stmtCacheSize = 0;
/*  131 */   protected boolean m_stmtClearMetaData = false;
/*      */ 
/* 1185 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   private void ensureOpen()
/*      */     throws SQLException
/*      */   {
/*  112 */     if (this.lifecycle == Lifecycle.NEW) {
/*  113 */       createConnectionPool(null);
/*      */     }
/*  115 */     if (this.lifecycle != Lifecycle.OPEN)
/*      */     {
/*  117 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  118 */       localSQLException.fillInStackTrace();
/*  119 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public OracleOCIConnectionPool(String paramString1, String paramString2, String paramString3, Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  147 */     this();
/*      */ 
/*  154 */     setURL(paramString3);
/*  155 */     setUser(paramString1);
/*  156 */     setPassword(paramString2);
/*  157 */     createConnectionPool(paramProperties);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public OracleOCIConnectionPool(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/*  168 */     this();
/*      */ 
/*  175 */     setURL(paramString3);
/*  176 */     setUser(paramString1);
/*  177 */     setPassword(paramString2);
/*  178 */     createConnectionPool(null);
/*      */   }
/*      */ 
/*      */   public OracleOCIConnectionPool()
/*      */     throws SQLException
/*      */   {
/*  201 */     this.isOracleDataSource = false;
/*  202 */     this.m_lconnections = new Hashtable(10);
/*      */ 
/*  204 */     setDriverType("oci8");
/*      */   }
/*      */ 
/*      */   public synchronized Connection getConnection()
/*      */     throws SQLException
/*      */   {
/*  229 */     ensureOpen();
/*      */ 
/*  233 */     Connection localConnection = getConnection(this.user, this.password);
/*      */ 
/*  235 */     return localConnection;
/*      */   }
/*      */ 
/*      */   public synchronized Connection getConnection(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/*  254 */     ensureOpen();
/*      */     Properties localProperties;
/*  257 */     if (this.connectionProperties != null)
/*  258 */       localProperties = new Properties(this.connectionProperties);
/*      */     else {
/*  260 */       localProperties = new Properties();
/*      */     }
/*  262 */     localProperties.put("is_connection_pooling", "true");
/*  263 */     localProperties.put("user", paramString1);
/*  264 */     localProperties.put("password", paramString2);
/*  265 */     localProperties.put("connection_pool", "connpool_connection");
/*  266 */     localProperties.put("connpool_object", this.m_connection_pool);
/*      */ 
/*  268 */     OracleOCIConnection localOracleOCIConnection = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, localProperties);
/*      */ 
/*  270 */     if (localOracleOCIConnection == null)
/*      */     {
/*  272 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 67);
/*  273 */       localSQLException.fillInStackTrace();
/*  274 */       throw localSQLException;
/*      */     }
/*      */ 
/*  280 */     localOracleOCIConnection.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
/*      */ 
/*  282 */     this.m_lconnections.put(localOracleOCIConnection, localOracleOCIConnection);
/*      */ 
/*  284 */     localOracleOCIConnection.setConnectionPool(this);
/*      */ 
/*  286 */     return localOracleOCIConnection;
/*      */   }
/*      */ 
/*      */   public synchronized Reference getReference()
/*      */     throws NamingException
/*      */   {
/*  304 */     Reference localReference = new Reference(getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
/*      */ 
/*  307 */     super.addRefProperties(localReference);
/*      */ 
/*  311 */     localReference.add(new StringRefAddr("connpool_min_limit", String.valueOf(this.m_conn_min_limit)));
/*      */ 
/*  314 */     localReference.add(new StringRefAddr("connpool_max_limit", String.valueOf(this.m_conn_max_limit)));
/*      */ 
/*  316 */     localReference.add(new StringRefAddr("connpool_increment", String.valueOf(this.m_conn_increment)));
/*      */ 
/*  319 */     localReference.add(new StringRefAddr("connpool_active_size", String.valueOf(this.m_conn_active_size)));
/*      */ 
/*  322 */     localReference.add(new StringRefAddr("connpool_pool_size", String.valueOf(this.m_conn_pool_size)));
/*      */ 
/*  325 */     localReference.add(new StringRefAddr("connpool_timeout", String.valueOf(this.m_conn_timeout)));
/*      */ 
/*  328 */     localReference.add(new StringRefAddr("connpool_nowait", this.m_conn_nowait));
/*      */ 
/*  330 */     localReference.add(new StringRefAddr("connpool_is_poolcreated", String.valueOf(isPoolCreated())));
/*      */ 
/*  333 */     localReference.add(new StringRefAddr("transactions_distributed", String.valueOf(isDistributedTransEnabled())));
/*      */ 
/*  336 */     return localReference;
/*      */   }
/*      */ 
/*      */   public synchronized OracleConnection getProxyConnection(String paramString, Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  371 */     ensureOpen();
/*      */ 
/*  375 */     if ("proxytype_user_name".equals(paramString)) {
/*  376 */       paramProperties.put("user", paramProperties.getProperty("proxy_user_name"));
/*  377 */     } else if ("proxytype_distinguished_name".equals(paramString)) {
/*  378 */       paramProperties.put("user", paramProperties.getProperty("proxy_distinguished_name"));
/*      */     }
/*  380 */     else if ("proxytype_certificate".equals(paramString)) {
/*  381 */       paramProperties.put("user", String.valueOf(paramProperties.getProperty("proxy_user_name")));
/*      */     }
/*      */     else
/*      */     {
/*  385 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 107, "null properties");
/*      */ 
/*  387 */       ((SQLException)localObject).fillInStackTrace();
/*  388 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/*  391 */     paramProperties.put("is_connection_pooling", "true");
/*  392 */     paramProperties.put("proxytype", paramString);
/*      */     String[] arrayOfString;
/*  394 */     if ((arrayOfString = (String[])paramProperties.get("proxy_roles")) != null)
/*      */     {
/*  396 */       paramProperties.put("proxy_num_roles", new Integer(arrayOfString.length));
/*      */     }
/*      */     else
/*      */     {
/*  400 */       paramProperties.put("proxy_num_roles", new Integer(0));
/*      */     }
/*      */ 
/*  403 */     paramProperties.put("connection_pool", "connpool_proxy_connection");
/*  404 */     paramProperties.put("connpool_object", this.m_connection_pool);
/*      */ 
/*  406 */     Object localObject = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, paramProperties);
/*      */ 
/*  409 */     if (localObject == null)
/*      */     {
/*  411 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 67);
/*  412 */       localSQLException.fillInStackTrace();
/*  413 */       throw localSQLException;
/*      */     }
/*      */ 
/*  418 */     ((OracleOCIConnection)localObject).setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
/*      */ 
/*  420 */     this.m_lconnections.put(localObject, localObject);
/*  421 */     ((OracleOCIConnection)localObject).setConnectionPool(this);
/*      */ 
/*  423 */     return localObject;
/*      */   }
/*      */ 
/*      */   public synchronized OracleConnection getAliasedConnection(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  447 */     ensureOpen();
/*  448 */     Properties localProperties = new Properties();
/*      */ 
/*  450 */     localProperties.put("is_connection_pooling", "true");
/*  451 */     localProperties.put("connection_id", paramArrayOfByte);
/*  452 */     localProperties.put("connection_pool", "connpool_alias_connection");
/*  453 */     localProperties.put("connpool_object", this.m_connection_pool);
/*      */ 
/*  455 */     OracleOCIConnection localOracleOCIConnection = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, localProperties);
/*      */ 
/*  457 */     if (localOracleOCIConnection == null)
/*      */     {
/*  459 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 67);
/*  460 */       localSQLException.fillInStackTrace();
/*  461 */       throw localSQLException;
/*      */     }
/*      */ 
/*  465 */     localOracleOCIConnection.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
/*      */ 
/*  467 */     this.m_lconnections.put(localOracleOCIConnection, localOracleOCIConnection);
/*  468 */     localOracleOCIConnection.setConnectionPool(this);
/*      */ 
/*  470 */     return localOracleOCIConnection;
/*      */   }
/*      */ 
/*      */   public synchronized void close()
/*      */     throws SQLException
/*      */   {
/*  491 */     if (this.lifecycle != Lifecycle.OPEN) {
/*  492 */       return;
/*      */     }
/*  494 */     this.lifecycle = Lifecycle.CLOSING;
/*      */ 
/*  497 */     Iterator localIterator = this.m_lconnections.values().iterator();
/*      */ 
/*  499 */     while (localIterator.hasNext())
/*      */     {
/*  501 */       OracleOCIConnection localOracleOCIConnection = (OracleOCIConnection)localIterator.next();
/*      */ 
/*  503 */       if ((localOracleOCIConnection != null) && (localOracleOCIConnection != this.m_connection_pool))
/*      */       {
/*  505 */         localOracleOCIConnection.close();
/*      */       }
/*  507 */       localIterator.remove();
/*      */     }
/*      */ 
/*  511 */     this.m_connection_pool.close();
/*      */ 
/*  513 */     this.lifecycle = Lifecycle.CLOSED;
/*      */   }
/*      */ 
/*      */   public synchronized void setPoolConfig(Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*      */     Object localObject;
/*  538 */     if (paramProperties == null)
/*      */     {
/*  540 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 106, "null properties");
/*  541 */       ((SQLException)localObject).fillInStackTrace();
/*  542 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/*  547 */     if (!isPoolCreated())
/*      */     {
/*  549 */       createConnectionPool(paramProperties);
/*      */     }
/*      */     else
/*      */     {
/*  553 */       localObject = new Properties();
/*      */ 
/*  555 */       checkPoolConfig(paramProperties, (Properties)localObject);
/*      */ 
/*  557 */       int[] arrayOfInt = new int[6];
/*      */ 
/*  559 */       readPoolConfig((Properties)localObject, arrayOfInt);
/*      */ 
/*  562 */       this.m_connection_pool.setConnectionPoolInfo(arrayOfInt[0], arrayOfInt[1], arrayOfInt[2], arrayOfInt[3], arrayOfInt[4], arrayOfInt[5]);
/*      */     }
/*      */ 
/*  568 */     storePoolProperties();
/*      */   }
/*      */ 
/*      */   public static void readPoolConfig(int paramInt1, int paramInt2, int paramInt3, int paramInt4, boolean paramBoolean1, boolean paramBoolean2, int[] paramArrayOfInt)
/*      */   {
/*  589 */     for (int i = 0; i < 6; i++)
/*  590 */       paramArrayOfInt[i] = 0;
/*  591 */     paramArrayOfInt[0] = paramInt1;
/*  592 */     paramArrayOfInt[1] = paramInt2;
/*  593 */     paramArrayOfInt[2] = paramInt3;
/*  594 */     paramArrayOfInt[3] = paramInt4;
/*  595 */     if (paramBoolean1)
/*  596 */       paramArrayOfInt[4] = 1;
/*  597 */     if (paramBoolean2)
/*  598 */       paramArrayOfInt[5] = 1;
/*      */   }
/*      */ 
/*      */   public static void readPoolConfig(Properties paramProperties, int[] paramArrayOfInt)
/*      */   {
/*  609 */     String str = paramProperties.getProperty("connpool_min_limit");
/*      */ 
/*  611 */     if (str != null) {
/*  612 */       paramArrayOfInt[0] = Integer.parseInt(str);
/*      */     }
/*  614 */     str = paramProperties.getProperty("connpool_max_limit");
/*      */ 
/*  616 */     if (str != null) {
/*  617 */       paramArrayOfInt[1] = Integer.parseInt(str);
/*      */     }
/*  619 */     str = paramProperties.getProperty("connpool_increment");
/*      */ 
/*  621 */     if (str != null) {
/*  622 */       paramArrayOfInt[2] = Integer.parseInt(str);
/*      */     }
/*  624 */     str = paramProperties.getProperty("connpool_timeout");
/*      */ 
/*  626 */     if (str != null) {
/*  627 */       paramArrayOfInt[3] = Integer.parseInt(str);
/*      */     }
/*  629 */     str = paramProperties.getProperty("connpool_nowait");
/*      */ 
/*  631 */     if ((str != null) && (str.equalsIgnoreCase("true"))) {
/*  632 */       paramArrayOfInt[4] = 1;
/*      */     }
/*  634 */     str = paramProperties.getProperty("transactions_distributed");
/*      */ 
/*  636 */     if ((str != null) && (str.equalsIgnoreCase("true")))
/*  637 */       paramArrayOfInt[5] = 1;
/*      */   }
/*      */ 
/*      */   private void checkPoolConfig(Properties paramProperties1, Properties paramProperties2)
/*      */     throws SQLException
/*      */   {
/*  646 */     String str1 = (String)paramProperties1.get("transactions_distributed");
/*  647 */     String str2 = (String)paramProperties1.get("connpool_nowait");
/*      */ 
/*  649 */     if (((str1 != null) && (!str1.equalsIgnoreCase("true"))) || ((str2 != null) && (!str2.equalsIgnoreCase("true"))) || (paramProperties1.get("connpool_min_limit") == null) || (paramProperties1.get("connpool_max_limit") == null) || (paramProperties1.get("connpool_increment") == null) || (Integer.decode((String)paramProperties1.get("connpool_min_limit")).intValue() < 0) || (Integer.decode((String)paramProperties1.get("connpool_max_limit")).intValue() < 0) || (Integer.decode((String)paramProperties1.get("connpool_increment")).intValue() < 0))
/*      */     {
/*  671 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 106, "");
/*  672 */       ((SQLException)localObject).fillInStackTrace();
/*  673 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/*  679 */     Object localObject = paramProperties1.propertyNames();
/*      */ 
/*  683 */     while (((Enumeration)localObject).hasMoreElements())
/*      */     {
/*  685 */       String str3 = (String)((Enumeration)localObject).nextElement();
/*  686 */       String str4 = paramProperties1.getProperty(str3);
/*      */ 
/*  691 */       if (("transactions_distributed".equals(str3)) || ("connpool_nowait".equals(str3)))
/*  692 */         paramProperties2.put(str3, "true");
/*      */       else
/*  694 */         paramProperties2.put(str3, str4);
/*      */     }
/*      */   }
/*      */ 
/*      */   private synchronized void storePoolProperties()
/*      */     throws SQLException
/*      */   {
/*  703 */     Properties localProperties = getPoolConfig();
/*      */ 
/*  705 */     this.m_conn_min_limit = Integer.decode(localProperties.getProperty("connpool_min_limit")).intValue();
/*      */ 
/*  707 */     this.m_conn_max_limit = Integer.decode(localProperties.getProperty("connpool_max_limit")).intValue();
/*      */ 
/*  709 */     this.m_conn_increment = Integer.decode(localProperties.getProperty("connpool_increment")).intValue();
/*      */ 
/*  711 */     this.m_conn_active_size = Integer.decode(localProperties.getProperty("connpool_active_size")).intValue();
/*      */ 
/*  713 */     this.m_conn_pool_size = Integer.decode(localProperties.getProperty("connpool_pool_size")).intValue();
/*      */ 
/*  715 */     this.m_conn_timeout = Integer.decode(localProperties.getProperty("connpool_timeout")).intValue();
/*      */ 
/*  717 */     this.m_conn_nowait = localProperties.getProperty("connpool_nowait");
/*      */   }
/*      */ 
/*      */   public synchronized Properties getPoolConfig()
/*      */     throws SQLException
/*      */   {
/*  731 */     ensureOpen();
/*      */ 
/*  735 */     Properties localProperties = this.m_connection_pool.getConnectionPoolInfo();
/*      */ 
/*  737 */     localProperties.put("connpool_is_poolcreated", String.valueOf(isPoolCreated()));
/*      */ 
/*  739 */     return localProperties;
/*      */   }
/*      */ 
/*      */   public synchronized int getActiveSize()
/*      */     throws SQLException
/*      */   {
/*  760 */     ensureOpen();
/*      */ 
/*  762 */     Properties localProperties = this.m_connection_pool.getConnectionPoolInfo();
/*      */ 
/*  764 */     String str = localProperties.getProperty("connpool_active_size");
/*  765 */     int i = Integer.decode(str).intValue();
/*      */ 
/*  767 */     return i;
/*      */   }
/*      */ 
/*      */   public synchronized int getPoolSize()
/*      */     throws SQLException
/*      */   {
/*  788 */     ensureOpen();
/*      */ 
/*  790 */     Properties localProperties = this.m_connection_pool.getConnectionPoolInfo();
/*      */ 
/*  792 */     String str = localProperties.getProperty("connpool_pool_size");
/*  793 */     int i = Integer.decode(str).intValue();
/*      */ 
/*  795 */     return i;
/*      */   }
/*      */ 
/*      */   public synchronized int getTimeout()
/*      */     throws SQLException
/*      */   {
/*  817 */     ensureOpen();
/*      */ 
/*  819 */     Properties localProperties = this.m_connection_pool.getConnectionPoolInfo();
/*      */ 
/*  821 */     String str = localProperties.getProperty("connpool_timeout");
/*  822 */     int i = Integer.decode(str).intValue();
/*      */ 
/*  824 */     return i;
/*      */   }
/*      */ 
/*      */   public synchronized String getNoWait()
/*      */     throws SQLException
/*      */   {
/*  849 */     ensureOpen();
/*      */ 
/*  851 */     Properties localProperties = this.m_connection_pool.getConnectionPoolInfo();
/*      */ 
/*  853 */     return localProperties.getProperty("connpool_nowait");
/*      */   }
/*      */ 
/*      */   public synchronized int getMinLimit()
/*      */     throws SQLException
/*      */   {
/*  873 */     ensureOpen();
/*      */ 
/*  875 */     Properties localProperties = this.m_connection_pool.getConnectionPoolInfo();
/*      */ 
/*  877 */     String str = localProperties.getProperty("connpool_min_limit");
/*  878 */     int i = Integer.decode(str).intValue();
/*      */ 
/*  880 */     return i;
/*      */   }
/*      */ 
/*      */   public synchronized int getMaxLimit()
/*      */     throws SQLException
/*      */   {
/*  898 */     ensureOpen();
/*      */ 
/*  900 */     Properties localProperties = this.m_connection_pool.getConnectionPoolInfo();
/*      */ 
/*  902 */     String str = localProperties.getProperty("connpool_max_limit");
/*  903 */     int i = Integer.decode(str).intValue();
/*      */ 
/*  905 */     return i;
/*      */   }
/*      */ 
/*      */   public synchronized int getConnectionIncrement()
/*      */     throws SQLException
/*      */   {
/*  923 */     ensureOpen();
/*      */ 
/*  925 */     Properties localProperties = this.m_connection_pool.getConnectionPoolInfo();
/*      */ 
/*  927 */     String str = localProperties.getProperty("connpool_increment");
/*  928 */     int i = Integer.decode(str).intValue();
/*      */ 
/*  930 */     return i;
/*      */   }
/*      */ 
/*      */   public synchronized boolean isDistributedTransEnabled()
/*      */   {
/*  944 */     if (this.m_is_transactions_distributed == 1) {
/*  945 */       return true;
/*      */     }
/*  947 */     return false;
/*      */   }
/*      */ 
/*      */   private void createConnectionPool(Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  959 */     if (this.lifecycle != Lifecycle.NEW) {
/*  960 */       return;
/*      */     }
/*  962 */     if ((this.user == null) || (this.password == null))
/*      */     {
/*  965 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 106, " ");
/*  966 */       ((SQLException)localObject).fillInStackTrace();
/*  967 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/*  972 */     Object localObject = new Properties();
/*      */ 
/*  975 */     if (paramProperties != null) {
/*  976 */       checkPoolConfig(paramProperties, (Properties)localObject);
/*      */     }
/*  978 */     ((Properties)localObject).put("is_connection_pooling", "true");
/*  979 */     ((Properties)localObject).put("user", this.user);
/*  980 */     ((Properties)localObject).put("password", this.password);
/*  981 */     ((Properties)localObject).put("connection_pool", "connection_pool");
/*      */ 
/*  983 */     if (getURL() == null) {
/*  984 */       makeURL();
/*      */     }
/*      */ 
/*  990 */     this.m_connection_pool = ((OracleOCIConnection)this.m_oracleDriver.connect(this.url, (Properties)localObject));
/*      */ 
/*  992 */     if (this.m_connection_pool == null)
/*      */     {
/*  994 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 67);
/*  995 */       localSQLException.fillInStackTrace();
/*  996 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1003 */     this.m_connection_pool.setConnectionPool(this);
/*      */ 
/* 1006 */     this.m_lconnections.put(this.m_connection_pool, this.m_connection_pool);
/*      */ 
/* 1008 */     this.lifecycle = Lifecycle.OPEN;
/*      */ 
/* 1014 */     storePoolProperties();
/*      */ 
/* 1016 */     if (paramProperties != null)
/*      */     {
/* 1018 */       if ("true".equalsIgnoreCase(paramProperties.getProperty("transactions_distributed")))
/* 1019 */         this.m_is_transactions_distributed = 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized boolean isPoolCreated()
/*      */   {
/* 1039 */     return this.lifecycle == Lifecycle.OPEN;
/*      */   }
/*      */ 
/*      */   public synchronized void connectionClosed(OracleOCIConnection paramOracleOCIConnection)
/*      */     throws SQLException
/*      */   {
/* 1053 */     if (this.lifecycle != Lifecycle.CLOSING)
/*      */     {
/* 1055 */       if (this.m_lconnections.remove(paramOracleOCIConnection) == null)
/*      */       {
/* 1057 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "internal OracleOCIConnectionPool error");
/* 1058 */         localSQLException.fillInStackTrace();
/* 1059 */         throw localSQLException;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void setStmtCacheSize(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1088 */     setStmtCacheSize(paramInt, false);
/*      */   }
/*      */ 
/*      */   public synchronized void setStmtCacheSize(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1118 */     if (paramInt < 0)
/*      */     {
/* 1120 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 1121 */       localSQLException.fillInStackTrace();
/* 1122 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1125 */     this.m_stmtCacheSize = paramInt;
/* 1126 */     this.m_stmtClearMetaData = paramBoolean;
/*      */   }
/*      */ 
/*      */   public synchronized int getStmtCacheSize()
/*      */   {
/* 1144 */     return this.m_stmtCacheSize;
/*      */   }
/*      */ 
/*      */   public synchronized boolean isStmtCacheEnabled()
/*      */   {
/* 1161 */     if (this.m_stmtCacheSize > 0) {
/* 1162 */       return true;
/*      */     }
/* 1164 */     return false;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1180 */     return null;
/*      */   }
/*      */ 
/*      */   private static enum Lifecycle
/*      */   {
/*  101 */     NEW, OPEN, CLOSING, CLOSED;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.pool.OracleOCIConnectionPool
 * JD-Core Version:    0.6.2
 */