/*     */ package oracle.jdbc.pool;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Vector;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ /** @deprecated */
/*     */ class OracleImplicitConnectionCacheThread extends Thread
/*     */ {
/*  33 */   private OracleImplicitConnectionCache implicitCache = null;
/*  34 */   protected boolean timeToLive = true;
/*  35 */   protected boolean isSleeping = false;
/*     */ 
/* 272 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   OracleImplicitConnectionCacheThread(OracleImplicitConnectionCache paramOracleImplicitConnectionCache)
/*     */     throws SQLException
/*     */   {
/*  43 */     this.implicitCache = paramOracleImplicitConnectionCache;
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*  51 */     long l1 = 0L;
/*  52 */     long l2 = 0L;
/*  53 */     long l3 = 0L;
/*     */ 
/*  58 */     while (this.timeToLive)
/*     */     {
/*     */       try
/*     */       {
/*  65 */         if ((this.timeToLive) && ((l1 = this.implicitCache.getCacheTimeToLiveTimeout()) > 0L))
/*     */         {
/*  68 */           runTimeToLiveTimeout(l1);
/*     */         }
/*     */ 
/*  72 */         if ((this.timeToLive) && ((l2 = this.implicitCache.getCacheInactivityTimeout()) > 0L))
/*     */         {
/*  74 */           runInactivityTimeout();
/*     */         }
/*     */ 
/*  78 */         if ((this.timeToLive) && ((l3 = this.implicitCache.getCacheAbandonedTimeout()) > 0L))
/*     */         {
/*  80 */           runAbandonedTimeout(l3);
/*     */         }
/*     */ 
/*  84 */         if (this.timeToLive)
/*     */         {
/*  86 */           this.isSleeping = true;
/*     */           try
/*     */           {
/*  91 */             sleep(this.implicitCache.getCachePropertyCheckInterval() * 1000);
/*     */           }
/*     */           catch (InterruptedException localInterruptedException)
/*     */           {
/*     */           }
/*     */ 
/*  98 */           this.isSleeping = false;
/*     */         }
/*     */ 
/* 102 */         if ((this.implicitCache == null) || ((l1 <= 0L) && (l2 <= 0L) && (l3 <= 0L)))
/*     */         {
/* 105 */           this.timeToLive = false;
/*     */         }
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void runTimeToLiveTimeout(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 121 */     long l1 = 0L;
/* 122 */     long l2 = 0L;
/*     */ 
/* 125 */     if (this.implicitCache.getNumberOfCheckedOutConnections() > 0)
/*     */     {
/* 127 */       OraclePooledConnection localOraclePooledConnection = null;
/*     */ 
/* 132 */       synchronized (this.implicitCache)
/*     */       {
/* 136 */         Object[] arrayOfObject = this.implicitCache.checkedOutConnectionList.toArray();
/* 137 */         int i = this.implicitCache.checkedOutConnectionList.size();
/*     */ 
/* 139 */         for (int j = 0; j < i; j++)
/*     */         {
/* 141 */           localOraclePooledConnection = (OraclePooledConnection)arrayOfObject[j];
/*     */ 
/* 143 */           Connection localConnection = localOraclePooledConnection.getLogicalHandle();
/*     */ 
/* 145 */           if (localConnection != null)
/*     */           {
/* 147 */             l2 = ((OracleConnection)localConnection).getStartTime();
/*     */ 
/* 149 */             l1 = System.currentTimeMillis();
/*     */ 
/* 152 */             if (l1 - l2 > paramLong * 1000L)
/*     */             {
/*     */               try
/*     */               {
/* 158 */                 this.implicitCache.closeCheckedOutConnection(localOraclePooledConnection, true);
/*     */               }
/*     */               catch (SQLException localSQLException)
/*     */               {
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void runInactivityTimeout()
/*     */   {
/*     */     try
/*     */     {
/* 180 */       this.implicitCache.doForEveryCachedConnection(4);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   private void runAbandonedTimeout(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 198 */     if (this.implicitCache.getNumberOfCheckedOutConnections() > 0)
/*     */     {
/* 200 */       OraclePooledConnection localOraclePooledConnection = null;
/*     */ 
/* 205 */       synchronized (this.implicitCache)
/*     */       {
/* 207 */         Object[] arrayOfObject = this.implicitCache.checkedOutConnectionList.toArray();
/*     */ 
/* 210 */         for (int i = 0; i < arrayOfObject.length; i++)
/*     */         {
/* 212 */           localOraclePooledConnection = (OraclePooledConnection)arrayOfObject[i];
/*     */ 
/* 214 */           OracleConnection localOracleConnection = (OracleConnection)localOraclePooledConnection.getLogicalHandle();
/*     */ 
/* 216 */           if (localOracleConnection != null)
/*     */           {
/* 220 */             OracleConnectionCacheCallback localOracleConnectionCacheCallback = localOracleConnection.getConnectionCacheCallbackObj();
/*     */ 
/* 224 */             if (localOracleConnection.getHeartbeatNoChangeCount() * this.implicitCache.getCachePropertyCheckInterval() > paramLong)
/*     */             {
/*     */               try
/*     */               {
/* 232 */                 boolean bool = true;
/* 233 */                 if ((localOracleConnectionCacheCallback != null) && ((localOracleConnection.getConnectionCacheCallbackFlag() == 4) || (localOracleConnection.getConnectionCacheCallbackFlag() == 1)))
/*     */                 {
/* 244 */                   bool = localOracleConnectionCacheCallback.handleAbandonedConnection(localOracleConnection, localOracleConnection.getConnectionCacheCallbackPrivObj());
/*     */                 }
/*     */ 
/* 249 */                 if (bool)
/*     */                 {
/* 251 */                   this.implicitCache.closeCheckedOutConnection(localOraclePooledConnection, true);
/* 252 */                   this.implicitCache.checkedOutConnectionList.remove(localOraclePooledConnection);
/* 253 */                   this.implicitCache.storeCacheConnection(localOraclePooledConnection.cachedConnectionAttributes, localOraclePooledConnection);
/*     */                 }
/*     */               }
/*     */               catch (SQLException localSQLException)
/*     */               {
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.pool.OracleImplicitConnectionCacheThread
 * JD-Core Version:    0.6.2
 */