/*      */ package oracle.jdbc.pool;
/*      */ 
/*      */ import java.sql.Connection;
/*      */ import java.sql.SQLException;
/*      */ import java.util.EnumSet;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.LinkedList;
/*      */ import java.util.Map;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Properties;
/*      */ import java.util.Random;
/*      */ import java.util.Set;
/*      */ import java.util.Vector;
/*      */ import javax.sql.PooledConnection;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.internal.OracleConnection.TransactionState;
/*      */ import oracle.jdbc.xa.client.OracleXADataSource;
/*      */ 
/*      */ /** @deprecated */
/*      */ class OracleImplicitConnectionCache
/*      */ {
/*   49 */   protected OracleDataSource cacheEnabledDS = null;
/*   50 */   protected String cacheName = null;
/*   51 */   protected OracleConnectionPoolDataSource connectionPoolDS = null;
/*   52 */   protected boolean fastConnectionFailoverEnabled = false;
/*      */ 
/*   55 */   protected String defaultUser = null;
/*   56 */   protected String defaultPassword = null;
/*      */   protected static final int DEFAULT_MIN_LIMIT = 0;
/*      */   protected static final int DEFAULT_MAX_LIMIT = 2147483647;
/*      */   protected static final int DEFAULT_INITIAL_LIMIT = 0;
/*      */   protected static final int DEFAULT_MAX_STATEMENTS_LIMIT = 0;
/*      */   protected static final int DEFAULT_INACTIVITY_TIMEOUT = 0;
/*      */   protected static final int DEFAULT_TIMETOLIVE_TIMEOUT = 0;
/*      */   protected static final int DEFAULT_ABANDONED_CONN_TIMEOUT = 0;
/*      */   protected static final int DEFAULT_CONNECTION_WAIT_TIMEOUT = 0;
/*      */   protected static final String DEFAULT_ATTRIBUTE_WEIGHT = "0";
/*      */   protected static final int DEFAULT_LOWER_THRESHOLD_LIMIT = 20;
/*      */   protected static final int DEFAULT_PROPERTY_CHECK_INTERVAL = 900;
/*      */   protected static final int CLOSE_AND_REMOVE_ALL_CONNECTIONS = 1;
/*      */   protected static final int CLOSE_AND_REMOVE_FAILOVER_CONNECTIONS = 2;
/*      */   protected static final int PROCESS_INACTIVITY_TIMEOUT = 4;
/*      */   protected static final int CLOSE_AND_REMOVE_N_CONNECTIONS = 8;
/*      */   protected static final int DISABLE_STATEMENT_CACHING = 16;
/*      */   protected static final int RESET_STATEMENT_CACHE_SIZE = 18;
/*      */   protected static final int CLOSE_AND_REMOVE_RLB_CONNECTIONS = 24;
/*      */   protected static final int ABORT_AND_CLOSE_ALL_CONNECTIONS = 32;
/*      */   public static final int REFRESH_INVALID_CONNECTIONS = 4096;
/*      */   public static final int REFRESH_ALL_CONNECTIONS = 8192;
/*      */   private static final String ATTRKEY_DELIM = "0xffff";
/*   87 */   protected int cacheMinLimit = 0;
/*   88 */   protected int cacheMaxLimit = 2147483647;
/*   89 */   protected int cacheInitialLimit = 0;
/*   90 */   protected int cacheMaxStatementsLimit = 0;
/*   91 */   protected Properties cacheAttributeWeights = null;
/*   92 */   protected int cacheInactivityTimeout = 0;
/*   93 */   protected int cacheTimeToLiveTimeout = 0;
/*   94 */   protected int cacheAbandonedConnectionTimeout = 0;
/*   95 */   protected int cacheLowerThresholdLimit = 20;
/*   96 */   protected int cachePropertyCheckInterval = 900;
/*   97 */   protected boolean cacheClosestConnectionMatch = false;
/*   98 */   protected boolean cacheValidateConnection = false;
/*   99 */   protected boolean cacheUseLIFO = false;
/*  100 */   protected int cacheConnectionWaitTimeout = 0;
/*      */   static final String MIN_LIMIT_KEY = "MinLimit";
/*      */   static final String MAX_LIMIT_KEY = "MaxLimit";
/*      */   static final String INITIAL_LIMIT_KEY = "InitialLimit";
/*      */   static final String MAX_STATEMENTS_LIMIT_KEY = "MaxStatementsLimit";
/*      */   static final String ATTRIBUTE_WEIGHTS_KEY = "AttributeWeights";
/*      */   static final String INACTIVITY_TIMEOUT_KEY = "InactivityTimeout";
/*      */   static final String TIME_TO_LIVE_TIMEOUT_KEY = "TimeToLiveTimeout";
/*      */   static final String ABANDONED_CONNECTION_TIMEOUT_KEY = "AbandonedConnectionTimeout";
/*      */   static final String LOWER_THRESHOLD_LIMIT_KEY = "LowerThresholdLimit";
/*      */   static final String PROPERTY_CHECK_INTERVAL_KEY = "PropertyCheckInterval";
/*      */   static final String VALIDATE_CONNECTION_KEY = "ValidateConnection";
/*      */   static final String CLOSEST_CONNECTION_MATCH_KEY = "ClosestConnectionMatch";
/*      */   static final String CONNECTION_WAIT_TIMEOUT_KEY = "ConnectionWaitTimeout";
/*      */   static final String LOCAL_TXN_COMMIT_ON_CLOSE = "LocalTransactionCommitOnClose";
/*      */   static final String USE_LIFO_KEY = "UseLIFO";
/*      */   static final int INSTANCE_GOOD = 1;
/*      */   static final int INSTANCE_UNKNOWN = 2;
/*      */   static final int INSTANCE_VIOLATING = 3;
/*      */   static final int INSTANCE_NO_DATA = 4;
/*      */   static final int INSTANCE_BLOCKED = 5;
/*      */   static final int RLB_NUMBER_OF_HITS_PER_INSTANCE = 1000;
/*  130 */   int dbInstancePercentTotal = 0;
/*  131 */   boolean useGoodGroup = false;
/*  132 */   Vector instancesToRetireQueue = null;
/*  133 */   OracleDatabaseInstance instanceToRetire = null;
/*  134 */   int retireConnectionsCount = 0;
/*  135 */   int countTotal = 0;
/*      */ 
/*  137 */   protected OracleConnectionCacheManager cacheManager = null;
/*  138 */   protected boolean disableConnectionRequest = false;
/*  139 */   protected OracleImplicitConnectionCacheThread timeoutThread = null;
/*      */ 
/*  146 */   protected OracleRuntimeLoadBalancingEventHandlerThread runtimeLoadBalancingThread = null;
/*      */ 
/*  150 */   protected OracleGravitateConnectionCacheThread gravitateCacheThread = null;
/*  151 */   protected int connectionsToRemove = 0;
/*      */ 
/*  155 */   private HashMap userMap = null;
/*  156 */   Vector checkedOutConnectionList = null;
/*      */ 
/*  159 */   LinkedList databaseInstancesList = null;
/*      */ 
/*  161 */   int cacheSize = 0;
/*      */   protected static final String EVENT_DELIMITER = " ";
/*  165 */   protected boolean isEntireServiceDownProcessed = false;
/*  166 */   protected int defaultUserPreFailureSize = 0;
/*  167 */   protected String dataSourceServiceName = null;
/*  168 */   protected OracleFailoverWorkerThread failoverWorkerThread = null;
/*  169 */   protected Random rand = null;
/*  170 */   protected int downEventCount = 0;
/*  171 */   protected int upEventCount = 0;
/*  172 */   protected int pendingCreationRequests = 0;
/*      */ 
/*  174 */   protected int connectionClosedCount = 0;
/*  175 */   protected int connectionCreatedCount = 0;
/*  176 */   boolean cacheLocalTxnCommitOnClose = false;
/*      */ 
/* 3467 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   OracleImplicitConnectionCache(OracleDataSource paramOracleDataSource, Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  188 */     this.cacheEnabledDS = paramOracleDataSource;
/*      */ 
/*  190 */     initializeConnectionCache();
/*  191 */     setConnectionCacheProperties(paramProperties);
/*      */ 
/*  198 */     defaultUserPrePopulateCache(this.cacheInitialLimit);
/*      */   }
/*      */ 
/*      */   private void defaultUserPrePopulateCache(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  211 */     if (paramInt > 0)
/*      */     {
/*  213 */       String str1 = this.defaultUser;
/*  214 */       String str2 = this.defaultPassword;
/*      */ 
/*  216 */       validateUser(str1, str2);
/*      */ 
/*  218 */       OraclePooledConnection localOraclePooledConnection = null;
/*      */ 
/*  220 */       for (int i = 0; i < paramInt; i++)
/*      */       {
/*  222 */         localOraclePooledConnection = makeOneConnection(str1, str2);
/*  223 */         synchronized (this)
/*      */         {
/*  225 */           if (localOraclePooledConnection != null)
/*      */           {
/*  229 */             this.cacheSize -= 1;
/*  230 */             storeCacheConnection(null, localOraclePooledConnection);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initializeConnectionCache()
/*      */     throws SQLException
/*      */   {
/*  245 */     this.userMap = new HashMap();
/*  246 */     this.checkedOutConnectionList = new Vector();
/*      */ 
/*  248 */     if (this.cacheManager == null) {
/*  249 */       this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
/*      */     }
/*      */ 
/*  252 */     if ((this.cacheEnabledDS.user != null) && (!this.cacheEnabledDS.user.startsWith("\"")))
/*      */     {
/*  254 */       this.defaultUser = this.cacheEnabledDS.user.toLowerCase();
/*      */     }
/*  256 */     else this.defaultUser = this.cacheEnabledDS.user;
/*      */ 
/*  258 */     this.defaultPassword = this.cacheEnabledDS.password;
/*  259 */     if (this.connectionPoolDS == null)
/*      */     {
/*  261 */       if ((this.cacheEnabledDS instanceof OracleXADataSource))
/*      */       {
/*  263 */         this.connectionPoolDS = new OracleXADataSource();
/*      */       }
/*      */       else
/*      */       {
/*  267 */         this.connectionPoolDS = new OracleConnectionPoolDataSource();
/*      */       }
/*      */ 
/*  271 */       this.cacheEnabledDS.copy(this.connectionPoolDS);
/*      */     }
/*      */ 
/*  274 */     if ((this.fastConnectionFailoverEnabled = this.cacheEnabledDS.getFastConnectionFailoverEnabled()))
/*      */     {
/*  277 */       this.rand = new Random(0L);
/*  278 */       this.instancesToRetireQueue = new Vector();
/*  279 */       this.cacheManager.failoverEnabledCacheCount += 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   private void validateUser(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/*  293 */     if ((paramString1 == null) || (paramString2 == null))
/*      */     {
/*  295 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 79);
/*  296 */       localSQLException.fillInStackTrace();
/*  297 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected Connection getConnection(String paramString1, String paramString2, Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  317 */     OraclePooledConnection localOraclePooledConnection = null;
/*  318 */     Connection localConnection = null;
/*      */     try
/*      */     {
/*  327 */       if (this.disableConnectionRequest)
/*      */       {
/*  330 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 142);
/*  331 */         localSQLException1.fillInStackTrace();
/*  332 */         throw localSQLException1;
/*      */       }
/*      */ 
/*  337 */       validateUser(paramString1, paramString2);
/*      */ 
/*  340 */       if (!paramString1.startsWith("\"")) {
/*  341 */         paramString1 = paramString1.toLowerCase();
/*      */       }
/*      */ 
/*  356 */       if (getNumberOfCheckedOutConnections() < this.cacheMaxLimit)
/*      */       {
/*  358 */         localOraclePooledConnection = getCacheConnection(paramString1, paramString2, paramProperties);
/*      */       }
/*      */ 
/*  362 */       if (localOraclePooledConnection == null)
/*      */       {
/*  369 */         processConnectionCacheCallback();
/*      */ 
/*  371 */         if (this.cacheSize > 0) {
/*  372 */           localOraclePooledConnection = getCacheConnection(paramString1, paramString2, paramProperties);
/*      */         }
/*      */ 
/*  381 */         if ((localOraclePooledConnection == null) && (this.cacheConnectionWaitTimeout > 0))
/*      */         {
/*  383 */           long l1 = this.cacheConnectionWaitTimeout * 1000L;
/*  384 */           long l2 = System.currentTimeMillis();
/*  385 */           long l3 = 0L;
/*      */           do
/*      */           {
/*  388 */             processConnectionWaitTimeout(l1);
/*      */ 
/*  390 */             if (this.cacheSize > 0) {
/*  391 */               localOraclePooledConnection = getCacheConnection(paramString1, paramString2, paramProperties);
/*      */             }
/*  393 */             l3 = System.currentTimeMillis();
/*  394 */             l1 -= System.currentTimeMillis() - l2;
/*  395 */             l2 = l3;
/*      */           }
/*      */ 
/*  398 */           while ((localOraclePooledConnection == null) && (l1 > 0L));
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  403 */       if ((localOraclePooledConnection != null) && (localOraclePooledConnection.physicalConn != null))
/*      */       {
/*  407 */         localConnection = localOraclePooledConnection.getConnection();
/*      */ 
/*  409 */         if (localConnection != null)
/*      */         {
/*  411 */           if ((this.cacheValidateConnection) && (testDatabaseConnection((OracleConnection)localConnection) != 0))
/*      */           {
/*  415 */             ((OracleConnection)localConnection).close(4096);
/*      */ 
/*  418 */             SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 143);
/*  419 */             localSQLException2.fillInStackTrace();
/*  420 */             throw localSQLException2;
/*      */           }
/*      */ 
/*  425 */           if (this.cacheAbandonedConnectionTimeout > 0) {
/*  426 */             ((OracleConnection)localConnection).setAbandonedTimeoutEnabled(true);
/*      */           }
/*      */ 
/*  429 */           if (this.cacheTimeToLiveTimeout > 0) {
/*  430 */             ((OracleConnection)localConnection).setStartTime(System.currentTimeMillis());
/*      */           }
/*  432 */           synchronized (this)
/*      */           {
/*  436 */             this.cacheSize -= 1;
/*  437 */             this.checkedOutConnectionList.addElement(localOraclePooledConnection);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     catch (SQLException localSQLException3) {
/*  443 */       synchronized (this)
/*      */       {
/*  445 */         if (localOraclePooledConnection != null)
/*      */         {
/*  447 */           this.cacheSize -= 1;
/*  448 */           abortConnection(localOraclePooledConnection);
/*      */         }
/*      */       }
/*  451 */       throw localSQLException3;
/*      */     }
/*      */ 
/*  457 */     return localConnection;
/*      */   }
/*      */ 
/*      */   private OraclePooledConnection getCacheConnection(String paramString1, String paramString2, Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  473 */     OraclePooledConnection localOraclePooledConnection = retrieveCacheConnection(paramString1, paramString2, paramProperties);
/*      */ 
/*  475 */     if (localOraclePooledConnection == null)
/*      */     {
/*  477 */       localOraclePooledConnection = makeOneConnection(paramString1, paramString2);
/*      */ 
/*  479 */       if ((localOraclePooledConnection != null) && (paramProperties != null) && (!paramProperties.isEmpty())) {
/*  480 */         setUnMatchedAttributes(paramProperties, localOraclePooledConnection);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  488 */     return localOraclePooledConnection;
/*      */   }
/*      */ 
/*      */   OraclePooledConnection makeOneConnection(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/*  500 */     OraclePooledConnection localOraclePooledConnection = null;
/*  501 */     int i = 0;
/*  502 */     synchronized (this)
/*      */     {
/*  505 */       if (getTotalCachedConnections() + this.pendingCreationRequests < this.cacheMaxLimit)
/*      */       {
/*  508 */         this.pendingCreationRequests += 1;
/*  509 */         i = 1;
/*      */       }
/*      */     }
/*      */ 
/*  513 */     if (i != 0)
/*      */     {
/*      */       try
/*      */       {
/*  517 */         localOraclePooledConnection = makeCacheConnection(paramString1, paramString2);
/*      */       }
/*      */       finally
/*      */       {
/*  525 */         synchronized (this)
/*      */         {
/*  527 */           if (localOraclePooledConnection != null)
/*  528 */             this.connectionCreatedCount += 1;
/*  529 */           this.pendingCreationRequests -= 1;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  534 */     return localOraclePooledConnection;
/*      */   }
/*      */ 
/*      */   protected int getTotalCachedConnections()
/*      */   {
/*  545 */     return this.cacheSize + getNumberOfCheckedOutConnections();
/*      */   }
/*      */ 
/*      */   protected int getNumberOfCheckedOutConnections()
/*      */   {
/*  556 */     return this.checkedOutConnectionList.size();
/*      */   }
/*      */ 
/*      */   private synchronized OraclePooledConnection retrieveCacheConnection(String paramString1, String paramString2, Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  568 */     OraclePooledConnection localOraclePooledConnection = null;
/*      */ 
/*  570 */     OracleConnectionCacheEntry localOracleConnectionCacheEntry = (OracleConnectionCacheEntry)this.userMap.get(OraclePooledConnection.generateKey(paramString1, paramString2));
/*      */ 
/*  573 */     if (localOracleConnectionCacheEntry != null)
/*      */     {
/*  578 */       if ((paramProperties == null) || ((paramProperties != null) && (paramProperties.isEmpty())))
/*      */       {
/*  580 */         if (localOracleConnectionCacheEntry.userConnList != null)
/*  581 */           localOraclePooledConnection = retrieveFromConnectionList(localOracleConnectionCacheEntry.userConnList);
/*      */       }
/*  583 */       else if (localOracleConnectionCacheEntry.attrConnMap != null)
/*      */       {
/*  585 */         String str = buildAttrKey(paramProperties);
/*  586 */         Vector localVector = (Vector)localOracleConnectionCacheEntry.attrConnMap.get(str);
/*      */ 
/*  589 */         if (localVector != null)
/*      */         {
/*  596 */           localOraclePooledConnection = retrieveFromConnectionList(localVector);
/*      */         }
/*      */ 
/*  604 */         if ((localOraclePooledConnection == null) && (this.cacheClosestConnectionMatch)) {
/*  605 */           localOraclePooledConnection = retrieveClosestConnectionMatch(localOracleConnectionCacheEntry.attrConnMap, paramProperties);
/*      */         }
/*      */ 
/*  610 */         if ((localOraclePooledConnection == null) && (localOracleConnectionCacheEntry.userConnList != null)) {
/*  611 */           localOraclePooledConnection = retrieveFromConnectionList(localOracleConnectionCacheEntry.userConnList);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  616 */     if (localOraclePooledConnection != null)
/*      */     {
/*  618 */       if ((paramProperties != null) && (!paramProperties.isEmpty())) {
/*  619 */         setUnMatchedAttributes(paramProperties, localOraclePooledConnection);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  625 */     return localOraclePooledConnection;
/*      */   }
/*      */ 
/*      */   private OraclePooledConnection retrieveClosestConnectionMatch(HashMap paramHashMap, Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  637 */     OraclePooledConnection localOraclePooledConnection1 = null;
/*  638 */     OraclePooledConnection localOraclePooledConnection2 = null;
/*  639 */     Object localObject = null;
/*      */ 
/*  641 */     int i = paramProperties.size();
/*  642 */     int j = 0;
/*  643 */     int k = 0;
/*  644 */     int m = 0;
/*  645 */     int n = 0;
/*  646 */     int i1 = 0;
/*      */ 
/*  648 */     if (this.cacheAttributeWeights != null) {
/*  649 */       j = getAttributesWeightCount(paramProperties, null);
/*      */     }
/*  651 */     if ((paramHashMap != null) && (!paramHashMap.isEmpty()))
/*      */     {
/*  655 */       Iterator localIterator = paramHashMap.entrySet().iterator();
/*      */ 
/*  657 */       while (localIterator.hasNext())
/*      */       {
/*  659 */         Map.Entry localEntry = (Map.Entry)localIterator.next();
/*      */ 
/*  661 */         Vector localVector = (Vector)localEntry.getValue();
/*  662 */         Object[] arrayOfObject = localVector.toArray();
/*  663 */         int i2 = localVector.size();
/*      */ 
/*  665 */         for (int i3 = 0; i3 < i2; i3++)
/*      */         {
/*  667 */           localOraclePooledConnection1 = (OraclePooledConnection)arrayOfObject[i3];
/*      */ 
/*  674 */           if ((localOraclePooledConnection1.cachedConnectionAttributes != null) && (!localOraclePooledConnection1.cachedConnectionAttributes.isEmpty()) && (localOraclePooledConnection1.cachedConnectionAttributes.size() <= i))
/*      */           {
/*  688 */             if (j > 0)
/*      */             {
/*  690 */               m = getAttributesWeightCount(paramProperties, localOraclePooledConnection1.cachedConnectionAttributes);
/*      */ 
/*  694 */               if (m > k)
/*      */               {
/*  696 */                 localOraclePooledConnection2 = localOraclePooledConnection1;
/*  697 */                 k = m;
/*  698 */                 localObject = localVector;
/*      */               }
/*      */             }
/*      */             else
/*      */             {
/*  703 */               i1 = getAttributesMatchCount(paramProperties, localOraclePooledConnection1.cachedConnectionAttributes);
/*      */ 
/*  706 */               if (i1 > n)
/*      */               {
/*  708 */                 localOraclePooledConnection2 = localOraclePooledConnection1;
/*  709 */                 n = i1;
/*  710 */                 localObject = localVector;
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  718 */     if (localObject != null) {
/*  719 */       localObject.remove(localOraclePooledConnection2);
/*      */     }
/*  721 */     return localOraclePooledConnection2;
/*      */   }
/*      */ 
/*      */   private int getAttributesMatchCount(Properties paramProperties1, Properties paramProperties2)
/*      */     throws SQLException
/*      */   {
/*  736 */     int i = 0;
/*  737 */     Map.Entry localEntry = null;
/*  738 */     Object localObject1 = null;
/*  739 */     Object localObject2 = null;
/*      */ 
/*  741 */     Iterator localIterator = paramProperties1.entrySet().iterator();
/*      */ 
/*  743 */     while (localIterator.hasNext())
/*      */     {
/*  745 */       localEntry = (Map.Entry)localIterator.next();
/*  746 */       localObject1 = localEntry.getKey();
/*  747 */       localObject2 = localEntry.getValue();
/*      */ 
/*  749 */       if ((paramProperties2.containsKey(localObject1)) && (localObject2.equals(paramProperties2.get(localObject1))))
/*      */       {
/*  751 */         i++;
/*      */       }
/*      */     }
/*  753 */     return i;
/*      */   }
/*      */ 
/*      */   private int getAttributesWeightCount(Properties paramProperties1, Properties paramProperties2)
/*      */     throws SQLException
/*      */   {
/*  782 */     Map.Entry localEntry = null;
/*  783 */     Object localObject1 = null;
/*  784 */     Object localObject2 = null;
/*  785 */     int i = 0;
/*      */ 
/*  787 */     Iterator localIterator = paramProperties1.entrySet().iterator();
/*      */ 
/*  789 */     while (localIterator.hasNext())
/*      */     {
/*  791 */       localEntry = (Map.Entry)localIterator.next();
/*  792 */       localObject1 = localEntry.getKey();
/*  793 */       localObject2 = localEntry.getValue();
/*      */ 
/*  796 */       if (paramProperties2 == null)
/*      */       {
/*  798 */         if (this.cacheAttributeWeights.containsKey(localObject1))
/*      */         {
/*  800 */           i += Integer.parseInt((String)this.cacheAttributeWeights.get(localObject1));
/*      */         }
/*      */ 
/*      */       }
/*  804 */       else if ((paramProperties2.containsKey(localObject1)) && (localObject2.equals(paramProperties2.get(localObject1))))
/*      */       {
/*  807 */         if (this.cacheAttributeWeights.containsKey(localObject1))
/*      */         {
/*  809 */           i += Integer.parseInt((String)this.cacheAttributeWeights.get(localObject1));
/*      */         }
/*      */         else
/*      */         {
/*  815 */           i++;
/*      */         }
/*      */       }
/*      */     }
/*  819 */     return i;
/*      */   }
/*      */ 
/*      */   private void setUnMatchedAttributes(Properties paramProperties, OraclePooledConnection paramOraclePooledConnection)
/*      */     throws SQLException
/*      */   {
/*  833 */     if (paramOraclePooledConnection.unMatchedCachedConnAttr == null)
/*  834 */       paramOraclePooledConnection.unMatchedCachedConnAttr = new Properties();
/*      */     else {
/*  836 */       paramOraclePooledConnection.unMatchedCachedConnAttr.clear();
/*      */     }
/*  838 */     if (!this.cacheClosestConnectionMatch)
/*      */     {
/*  840 */       paramOraclePooledConnection.unMatchedCachedConnAttr.putAll(paramProperties);
/*      */     }
/*      */     else
/*      */     {
/*  844 */       Properties localProperties = paramOraclePooledConnection.cachedConnectionAttributes;
/*  845 */       Map.Entry localEntry = null;
/*  846 */       Object localObject1 = null;
/*  847 */       Object localObject2 = null;
/*      */ 
/*  849 */       Iterator localIterator = paramProperties.entrySet().iterator();
/*      */ 
/*  851 */       while (localIterator.hasNext())
/*      */       {
/*  853 */         localEntry = (Map.Entry)localIterator.next();
/*  854 */         localObject1 = localEntry.getKey();
/*  855 */         localObject2 = localEntry.getValue();
/*      */ 
/*  857 */         if ((!localProperties.containsKey(localObject1)) && (!localObject2.equals(localProperties.get(localObject1))))
/*      */         {
/*  859 */           paramOraclePooledConnection.unMatchedCachedConnAttr.put(localObject1, localObject2);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private OraclePooledConnection retrieveFromConnectionList(Vector paramVector)
/*      */     throws SQLException
/*      */   {
/*  876 */     if (paramVector.isEmpty()) {
/*  877 */       return null;
/*      */     }
/*  879 */     Object localObject1 = null;
/*  880 */     if (this.fastConnectionFailoverEnabled)
/*      */     {
/*      */       int i;
/*      */       Object localObject2;
/*      */       Object localObject3;
/*  883 */       if ((this.useGoodGroup) && (this.databaseInstancesList != null) && (this.databaseInstancesList.size() > 0))
/*      */       {
/*  886 */         label234: synchronized (this.databaseInstancesList)
/*      */         {
/*  888 */           i = this.databaseInstancesList.size();
/*  889 */           localObject2 = null;
/*  890 */           localObject3 = 0;
/*      */ 
/*  892 */           boolean[] arrayOfBoolean = new boolean[i];
/*  893 */           int k = this.dbInstancePercentTotal;
/*      */ 
/*  896 */           for (int m = 0; m < i; m++)
/*      */           {
/*  898 */             Object localObject4 = 0;
/*      */ 
/*  901 */             if (k <= 1)
/*  902 */               localObject3 = 0;
/*      */             else {
/*  904 */               localObject3 = this.rand.nextInt(k - 1);
/*      */             }
/*      */ 
/*  907 */             for (int n = 0; n < i; n++)
/*      */             {
/*  909 */               localObject2 = (OracleDatabaseInstance)this.databaseInstancesList.get(n);
/*      */ 
/*  911 */               if ((arrayOfBoolean[n] == 0) && (((OracleDatabaseInstance)localObject2).flag <= 3))
/*      */               {
/*  913 */                 localObject4 += ((OracleDatabaseInstance)localObject2).percent;
/*      */ 
/*  916 */                 if (localObject3 <= localObject4)
/*      */                 {
/*  919 */                   if (m == 0) {
/*  920 */                     localObject2.attemptedConnRequestCount += 1;
/*      */                   }
/*  922 */                   if ((localObject1 = selectConnectionFromList(paramVector, (OracleDatabaseInstance)localObject2)) != null)
/*      */                   {
/*      */                     break label234;
/*      */                   }
/*      */ 
/*  928 */                   k -= ((OracleDatabaseInstance)localObject2).percent;
/*  929 */                   arrayOfBoolean[n] = true;
/*  930 */                   break;
/*      */                 }
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*  938 */       else if (!this.cacheUseLIFO)
/*      */       {
/*  946 */         ??? = paramVector.size();
/*  947 */         i = this.rand.nextInt(???);
/*  948 */         localObject2 = null;
/*      */ 
/*  950 */         for (localObject3 = 0; localObject3 < ???; localObject3++)
/*      */         {
/*  952 */           int j = (i++ + ???) % ???;
/*  953 */           localObject2 = (OraclePooledConnection)paramVector.get(j);
/*      */ 
/*  956 */           if (!((OraclePooledConnection)localObject2).connectionMarkedDown)
/*      */           {
/*  958 */             localObject1 = localObject2;
/*  959 */             paramVector.remove(localObject1);
/*  960 */             break;
/*      */           }
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  966 */         localObject1 = (OraclePooledConnection)paramVector.remove(0);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  971 */       localObject1 = (OraclePooledConnection)paramVector.remove(0);
/*      */     }
/*  973 */     return localObject1;
/*      */   }
/*      */ 
/*      */   private OraclePooledConnection selectConnectionFromList(Vector paramVector, OracleDatabaseInstance paramOracleDatabaseInstance)
/*      */   {
/*  985 */     Object localObject = null;
/*  986 */     OraclePooledConnection localOraclePooledConnection = null;
/*      */ 
/*  989 */     int i = paramVector.size();
/*  990 */     for (int j = 0; j < i; j++)
/*      */     {
/*  992 */       localOraclePooledConnection = (OraclePooledConnection)paramVector.get(j);
/*      */ 
/*  994 */       if ((!localOraclePooledConnection.connectionMarkedDown) && (localOraclePooledConnection.dataSourceDbUniqNameKey == paramOracleDatabaseInstance.databaseUniqName) && (localOraclePooledConnection.dataSourceInstanceNameKey == paramOracleDatabaseInstance.instanceName))
/*      */       {
/*  998 */         localObject = localOraclePooledConnection;
/*  999 */         paramVector.remove(localObject);
/* 1000 */         break;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1007 */     return localObject;
/*      */   }
/*      */ 
/*      */   private void removeCacheConnection(OraclePooledConnection paramOraclePooledConnection)
/*      */     throws SQLException
/*      */   {
/* 1019 */     boolean bool = false;
/*      */ 
/* 1021 */     OracleConnectionCacheEntry localOracleConnectionCacheEntry = paramOraclePooledConnection.removeFromImplictCache(this.userMap);
/*      */ 
/* 1024 */     if (localOracleConnectionCacheEntry != null)
/*      */     {
/* 1026 */       Properties localProperties = paramOraclePooledConnection.cachedConnectionAttributes;
/*      */ 
/* 1028 */       if ((localProperties == null) || ((localProperties != null) && (localProperties.isEmpty())))
/*      */       {
/* 1030 */         if (localOracleConnectionCacheEntry.userConnList != null)
/* 1031 */           bool = localOracleConnectionCacheEntry.userConnList.removeElement(paramOraclePooledConnection);
/*      */       }
/* 1033 */       else if (localOracleConnectionCacheEntry.attrConnMap != null)
/*      */       {
/* 1035 */         String str = buildAttrKey(localProperties);
/*      */ 
/* 1037 */         Vector localVector = (Vector)localOracleConnectionCacheEntry.attrConnMap.get(str);
/*      */ 
/* 1040 */         if (localVector != null)
/*      */         {
/* 1044 */           if (paramOraclePooledConnection.unMatchedCachedConnAttr != null)
/*      */           {
/* 1046 */             paramOraclePooledConnection.unMatchedCachedConnAttr.clear();
/* 1047 */             paramOraclePooledConnection.unMatchedCachedConnAttr = null;
/*      */           }
/*      */ 
/* 1050 */           if (paramOraclePooledConnection.cachedConnectionAttributes != null)
/*      */           {
/* 1052 */             paramOraclePooledConnection.cachedConnectionAttributes.clear();
/* 1053 */             paramOraclePooledConnection.cachedConnectionAttributes = null;
/*      */           }
/*      */ 
/* 1056 */           localProperties = null;
/* 1057 */           bool = localVector.removeElement(paramOraclePooledConnection);
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1063 */     if (bool)
/*      */     {
/* 1065 */       this.cacheSize -= 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void doForEveryCachedConnection(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1090 */     int i = 0;
/*      */ 
/* 1092 */     synchronized (this)
/*      */     {
/* 1094 */       if ((this.userMap != null) && (!this.userMap.isEmpty()))
/*      */       {
/* 1096 */         Iterator localIterator = this.userMap.entrySet().iterator();
/*      */ 
/* 1098 */         while (localIterator.hasNext())
/*      */         {
/* 1100 */           Map.Entry localEntry = (Map.Entry)localIterator.next();
/* 1101 */           OracleConnectionCacheEntry localOracleConnectionCacheEntry = (OracleConnectionCacheEntry)localEntry.getValue();
/*      */           Object localObject1;
/*      */           Object localObject2;
/*      */           OraclePooledConnection localOraclePooledConnection;
/* 1105 */           if ((localOracleConnectionCacheEntry.userConnList != null) && (!localOracleConnectionCacheEntry.userConnList.isEmpty()))
/*      */           {
/* 1107 */             localObject1 = localOracleConnectionCacheEntry.userConnList;
/* 1108 */             localObject2 = ((Vector)localObject1).toArray();
/*      */ 
/* 1110 */             for (int j = 0; j < localObject2.length; j++)
/*      */             {
/* 1112 */               localOraclePooledConnection = (OraclePooledConnection)localObject2[j];
/*      */ 
/* 1114 */               if ((localOraclePooledConnection != null) && (performPooledConnectionTask(localOraclePooledConnection, paramInt))) {
/* 1115 */                 i++;
/*      */               }
/*      */             }
/*      */           }
/* 1119 */           if ((localOracleConnectionCacheEntry.attrConnMap != null) && (!localOracleConnectionCacheEntry.attrConnMap.isEmpty()))
/*      */           {
/* 1121 */             localObject1 = localOracleConnectionCacheEntry.attrConnMap.entrySet().iterator();
/*      */ 
/* 1123 */             while (((Iterator)localObject1).hasNext())
/*      */             {
/* 1125 */               localObject2 = (Map.Entry)((Iterator)localObject1).next();
/*      */ 
/* 1127 */               Vector localVector = (Vector)((Map.Entry)localObject2).getValue();
/* 1128 */               Object[] arrayOfObject = localVector.toArray();
/*      */ 
/* 1130 */               for (int k = 0; k < arrayOfObject.length; k++)
/*      */               {
/* 1132 */                 localOraclePooledConnection = (OraclePooledConnection)arrayOfObject[k];
/*      */ 
/* 1134 */                 if ((localOraclePooledConnection != null) && (performPooledConnectionTask(localOraclePooledConnection, paramInt))) {
/* 1135 */                   i++;
/*      */                 }
/*      */               }
/*      */             }
/* 1139 */             if ((paramInt == 1) || (paramInt == 32))
/*      */             {
/* 1141 */               localOracleConnectionCacheEntry.attrConnMap.clear();
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/* 1146 */         if ((paramInt == 1) || (paramInt == 32))
/*      */         {
/* 1149 */           this.userMap.clear();
/*      */ 
/* 1151 */           this.cacheSize = 0;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1161 */     if (i > 0)
/*      */     {
/* 1164 */       defaultUserPrePopulateCache(i);
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean performPooledConnectionTask(OraclePooledConnection paramOraclePooledConnection, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1185 */     boolean bool = false;
/*      */ 
/* 1187 */     switch (paramInt)
/*      */     {
/*      */     case 2:
/* 1193 */       if (paramOraclePooledConnection.connectionMarkedDown)
/*      */       {
/* 1197 */         paramOraclePooledConnection.needToAbort = true;
/* 1198 */         closeAndRemovePooledConnection(paramOraclePooledConnection); } break;
/*      */     case 8:
/* 1207 */       if (this.connectionsToRemove > 0)
/*      */       {
/* 1209 */         closeAndRemovePooledConnection(paramOraclePooledConnection);
/*      */ 
/* 1211 */         this.connectionsToRemove -= 1; } break;
/*      */     case 24:
/* 1220 */       if (this.retireConnectionsCount > 0)
/*      */       {
/* 1222 */         if ((this.instanceToRetire.databaseUniqName == paramOraclePooledConnection.dataSourceDbUniqNameKey) && (this.instanceToRetire.instanceName == paramOraclePooledConnection.dataSourceInstanceNameKey))
/*      */         {
/* 1225 */           closeAndRemovePooledConnection(paramOraclePooledConnection);
/* 1226 */           this.retireConnectionsCount -= 1;
/*      */ 
/* 1228 */           if (getTotalCachedConnections() < this.cacheMinLimit)
/* 1229 */             bool = true;  }  } break;
/*      */     case 4096:
/* 1238 */       Connection localConnection = paramOraclePooledConnection.getLogicalHandle();
/*      */ 
/* 1240 */       if ((localConnection != null) || ((localConnection = paramOraclePooledConnection.getPhysicalHandle()) != null))
/*      */       {
/* 1243 */         if (testDatabaseConnection((OracleConnection)localConnection) != 0)
/*      */         {
/* 1246 */           closeAndRemovePooledConnection(paramOraclePooledConnection);
/*      */ 
/* 1248 */           bool = true; }  } break;
/*      */     case 8192:
/* 1257 */       closeAndRemovePooledConnection(paramOraclePooledConnection);
/*      */ 
/* 1259 */       bool = true;
/*      */ 
/* 1261 */       break;
/*      */     case 1:
/* 1266 */       closeAndRemovePooledConnection(paramOraclePooledConnection);
/*      */ 
/* 1268 */       break;
/*      */     case 4:
/* 1273 */       processInactivityTimeout(paramOraclePooledConnection);
/*      */ 
/* 1275 */       break;
/*      */     case 16:
/* 1280 */       setStatementCaching(paramOraclePooledConnection, this.cacheMaxStatementsLimit, false);
/*      */ 
/* 1282 */       break;
/*      */     case 18:
/* 1287 */       setStatementCaching(paramOraclePooledConnection, this.cacheMaxStatementsLimit, true);
/*      */ 
/* 1289 */       break;
/*      */     case 32:
/* 1294 */       abortConnection(paramOraclePooledConnection);
/* 1295 */       closeAndRemovePooledConnection(paramOraclePooledConnection);
/* 1296 */       break;
/*      */     }
/*      */ 
/* 1303 */     return bool;
/*      */   }
/*      */ 
/*      */   protected synchronized void doForEveryCheckedOutConnection(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1320 */     int i = this.checkedOutConnectionList.size();
/*      */     int j;
/*      */     OraclePooledConnection localOraclePooledConnection;
/* 1323 */     switch (paramInt)
/*      */     {
/*      */     case 1:
/* 1326 */       for (j = 0; j < i; j++)
/*      */       {
/* 1328 */         closeCheckedOutConnection((OraclePooledConnection)this.checkedOutConnectionList.get(j), false);
/*      */       }
/*      */ 
/* 1332 */       this.checkedOutConnectionList.removeAllElements();
/* 1333 */       break;
/*      */     case 24:
/* 1336 */       for (j = 0; (j < i) && (this.retireConnectionsCount > 0); j++)
/*      */       {
/* 1338 */         localOraclePooledConnection = (OraclePooledConnection)this.checkedOutConnectionList.get(j);
/* 1339 */         if ((this.instanceToRetire.databaseUniqName == localOraclePooledConnection.dataSourceDbUniqNameKey) && (this.instanceToRetire.instanceName == localOraclePooledConnection.dataSourceInstanceNameKey))
/*      */         {
/* 1342 */           localOraclePooledConnection.closeOption = 4096;
/*      */ 
/* 1345 */           this.retireConnectionsCount -= 2;
/*      */         }
/*      */       }
/* 1348 */       break;
/*      */     case 32:
/* 1351 */       for (j = 0; j < i; j++)
/*      */       {
/* 1353 */         localOraclePooledConnection = null;
/* 1354 */         abortConnection(localOraclePooledConnection = (OraclePooledConnection)this.checkedOutConnectionList.get(j));
/* 1355 */         closeCheckedOutConnection(localOraclePooledConnection, false);
/*      */       }
/*      */ 
/* 1359 */       this.checkedOutConnectionList.removeAllElements();
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void closeCheckedOutConnection(OraclePooledConnection paramOraclePooledConnection, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1380 */     if (paramOraclePooledConnection != null)
/*      */     {
/* 1382 */       OracleConnection localOracleConnection1 = (OracleConnection)paramOraclePooledConnection.getLogicalHandle();
/* 1383 */       OracleConnection localOracleConnection2 = (OracleConnection)paramOraclePooledConnection.getPhysicalHandle();
/* 1384 */       boolean bool1 = localOracleConnection1.getAutoCommit();
/*      */ 
/* 1386 */       if (paramBoolean)
/*      */       {
/* 1392 */         boolean bool2 = paramOraclePooledConnection.localTxnCommitOnClose;
/*      */         try
/*      */         {
/* 1396 */           paramOraclePooledConnection.localTxnCommitOnClose = false;
/* 1397 */           localOracleConnection1.cleanupAndClose(true);
/*      */           try
/*      */           {
/* 1401 */             if ((!bool1) && (!paramOraclePooledConnection.needToAbort)) {
/* 1402 */               localOracleConnection2.rollback();
/*      */             }
/*      */ 
/*      */           }
/*      */           catch (SQLException localSQLException2)
/*      */           {
/*      */           }
/*      */ 
/* 1414 */           if (paramOraclePooledConnection.localTxnCommitOnClose != bool2)
/* 1415 */             paramOraclePooledConnection.localTxnCommitOnClose = bool2;
/*      */         }
/*      */         catch (SQLException localSQLException3)
/*      */         {
/* 1414 */           if (paramOraclePooledConnection.localTxnCommitOnClose != bool2)
/* 1415 */             paramOraclePooledConnection.localTxnCommitOnClose = bool2;
/*      */         }
/*      */         finally
/*      */         {
/* 1414 */           if (paramOraclePooledConnection.localTxnCommitOnClose != bool2) {
/* 1415 */             paramOraclePooledConnection.localTxnCommitOnClose = bool2;
/*      */           }
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*      */         try
/*      */         {
/* 1423 */           if ((!bool1) && (!paramOraclePooledConnection.needToAbort))
/*      */           {
/* 1425 */             localOracleConnection2.cancel();
/* 1426 */             localOracleConnection2.rollback();
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (SQLException localSQLException1)
/*      */         {
/*      */         }
/*      */ 
/* 1434 */         actualPooledConnectionClose(paramOraclePooledConnection);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized void storeCacheConnection(Properties paramProperties, OraclePooledConnection paramOraclePooledConnection)
/*      */     throws SQLException
/*      */   {
/* 1452 */     boolean bool = false;
/*      */ 
/* 1454 */     if ((paramOraclePooledConnection == null) || (paramOraclePooledConnection.physicalConn == null))
/*      */     {
/* 1456 */       return;
/*      */     }
/*      */ 
/* 1459 */     if (this.cacheInactivityTimeout > 0)
/*      */     {
/* 1461 */       paramOraclePooledConnection.setLastAccessedTime(System.currentTimeMillis());
/*      */     }
/*      */ 
/* 1464 */     if (paramOraclePooledConnection.unMatchedCachedConnAttr != null)
/*      */     {
/* 1466 */       paramOraclePooledConnection.unMatchedCachedConnAttr.clear();
/* 1467 */       paramOraclePooledConnection.unMatchedCachedConnAttr = null;
/*      */     }
/*      */ 
/* 1470 */     OracleConnectionCacheEntry localOracleConnectionCacheEntry = paramOraclePooledConnection.removeFromImplictCache(this.userMap);
/*      */     Object localObject1;
/*      */     Object localObject2;
/* 1473 */     if (localOracleConnectionCacheEntry != null)
/*      */     {
/* 1475 */       if ((paramProperties == null) || ((paramProperties != null) && (paramProperties.isEmpty())))
/*      */       {
/* 1477 */         if (localOracleConnectionCacheEntry.userConnList == null) {
/* 1478 */           localOracleConnectionCacheEntry.userConnList = new Vector();
/*      */         }
/* 1480 */         if (this.cacheUseLIFO)
/*      */         {
/* 1482 */           localOracleConnectionCacheEntry.userConnList.add(0, paramOraclePooledConnection);
/* 1483 */           bool = true;
/*      */         }
/*      */         else
/*      */         {
/* 1487 */           bool = localOracleConnectionCacheEntry.userConnList.add(paramOraclePooledConnection);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 1493 */         paramOraclePooledConnection.cachedConnectionAttributes = paramProperties;
/*      */ 
/* 1495 */         if (localOracleConnectionCacheEntry.attrConnMap == null) {
/* 1496 */           localOracleConnectionCacheEntry.attrConnMap = new HashMap();
/*      */         }
/* 1498 */         localObject1 = buildAttrKey(paramProperties);
/* 1499 */         localObject2 = (Vector)localOracleConnectionCacheEntry.attrConnMap.get(localObject1);
/*      */ 
/* 1502 */         if (localObject2 != null)
/*      */         {
/* 1504 */           if (this.cacheUseLIFO)
/*      */           {
/* 1506 */             ((Vector)localObject2).add(0, paramOraclePooledConnection);
/* 1507 */             bool = true;
/*      */           }
/*      */           else
/*      */           {
/* 1511 */             bool = ((Vector)localObject2).add(paramOraclePooledConnection);
/*      */           }
/*      */         }
/*      */         else
/*      */         {
/* 1516 */           localObject2 = new Vector();
/*      */ 
/* 1518 */           bool = ((Vector)localObject2).add(paramOraclePooledConnection);
/* 1519 */           localOracleConnectionCacheEntry.attrConnMap.put(localObject1, localObject2);
/*      */         }
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1525 */       localOracleConnectionCacheEntry = new OracleConnectionCacheEntry();
/*      */ 
/* 1527 */       paramOraclePooledConnection.addToImplicitCache(this.userMap, localOracleConnectionCacheEntry);
/*      */ 
/* 1529 */       if ((paramProperties == null) || ((paramProperties != null) && (paramProperties.isEmpty())))
/*      */       {
/* 1531 */         localObject1 = new Vector();
/*      */ 
/* 1533 */         bool = ((Vector)localObject1).add(paramOraclePooledConnection);
/*      */ 
/* 1535 */         localOracleConnectionCacheEntry.userConnList = ((Vector)localObject1);
/*      */       }
/*      */       else
/*      */       {
/* 1539 */         localObject1 = buildAttrKey(paramProperties);
/*      */ 
/* 1542 */         paramOraclePooledConnection.cachedConnectionAttributes = paramProperties;
/*      */ 
/* 1544 */         localObject2 = new HashMap();
/* 1545 */         Vector localVector = new Vector();
/*      */ 
/* 1547 */         bool = localVector.add(paramOraclePooledConnection);
/* 1548 */         ((HashMap)localObject2).put(localObject1, localVector);
/*      */ 
/* 1550 */         localOracleConnectionCacheEntry.attrConnMap = ((HashMap)localObject2);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1555 */     if (bool) {
/* 1556 */       this.cacheSize += 1;
/*      */     }
/*      */ 
/* 1567 */     if (this.cacheConnectionWaitTimeout > 0)
/*      */     {
/* 1569 */       notifyAll();
/*      */     }
/*      */   }
/*      */ 
/*      */   private String buildAttrKey(Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/* 1586 */     int i = paramProperties.keySet().size();
/* 1587 */     Object[] arrayOfObject = paramProperties.keySet().toArray();
/* 1588 */     int j = 1;
/* 1589 */     StringBuffer localStringBuffer = new StringBuffer();
/*      */ 
/* 1592 */     while (j != 0)
/*      */     {
/* 1594 */       j = 0;
/*      */ 
/* 1596 */       for (k = 0; k < i - 1; k++)
/*      */       {
/* 1598 */         if (((String)arrayOfObject[k]).compareTo((String)arrayOfObject[(k + 1)]) > 0)
/*      */         {
/* 1600 */           j = 1;
/*      */ 
/* 1602 */           Object localObject = arrayOfObject[k];
/*      */ 
/* 1604 */           arrayOfObject[k] = arrayOfObject[(k + 1)];
/* 1605 */           arrayOfObject[(k + 1)] = localObject;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1611 */     for (int k = 0; k < i; k++) {
/* 1612 */       localStringBuffer.append(arrayOfObject[k] + "0xffff" + paramProperties.get(arrayOfObject[k]));
/*      */     }
/* 1614 */     return localStringBuffer.toString();
/*      */   }
/*      */ 
/*      */   protected OraclePooledConnection makeCacheConnection(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 1627 */     OraclePooledConnection localOraclePooledConnection = (OraclePooledConnection)this.connectionPoolDS.getPooledConnection(paramString1, paramString2);
/*      */ 
/* 1631 */     if (localOraclePooledConnection != null)
/*      */     {
/* 1639 */       if (this.cacheMaxStatementsLimit > 0) {
/* 1640 */         setStatementCaching(localOraclePooledConnection, this.cacheMaxStatementsLimit, true);
/*      */       }
/*      */ 
/* 1643 */       localOraclePooledConnection.registerImplicitCacheConnectionEventListener(new OracleConnectionCacheEventListener(this));
/*      */ 
/* 1646 */       localOraclePooledConnection.cachedConnectionAttributes = new Properties();
/*      */ 
/* 1649 */       if (this.fastConnectionFailoverEnabled)
/*      */       {
/* 1651 */         initFailoverParameters(localOraclePooledConnection);
/*      */       }
/*      */ 
/* 1655 */       synchronized (this)
/*      */       {
/* 1657 */         this.cacheSize += 1;
/*      */ 
/* 1662 */         if ((this.fastConnectionFailoverEnabled) && (this.runtimeLoadBalancingThread == null))
/*      */         {
/* 1665 */           this.runtimeLoadBalancingThread = new OracleRuntimeLoadBalancingEventHandlerThread(this.dataSourceServiceName);
/*      */ 
/* 1667 */           this.cacheManager.checkAndStartThread(this.runtimeLoadBalancingThread);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1673 */       localOraclePooledConnection.localTxnCommitOnClose = this.cacheLocalTxnCommitOnClose;
/*      */     }
/* 1675 */     return localOraclePooledConnection;
/*      */   }
/*      */ 
/*      */   private void setStatementCaching(OraclePooledConnection paramOraclePooledConnection, int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1686 */     if (paramInt > 0) {
/* 1687 */       paramOraclePooledConnection.setStatementCacheSize(paramInt);
/*      */     }
/* 1689 */     paramOraclePooledConnection.setImplicitCachingEnabled(paramBoolean);
/* 1690 */     paramOraclePooledConnection.setExplicitCachingEnabled(paramBoolean);
/*      */   }
/*      */ 
/*      */   protected synchronized void reusePooledConnection(PooledConnection paramPooledConnection)
/*      */     throws SQLException
/*      */   {
/* 1712 */     OraclePooledConnection localOraclePooledConnection = (OraclePooledConnection)paramPooledConnection;
/* 1713 */     if ((localOraclePooledConnection != null) && (localOraclePooledConnection.physicalConn != null))
/*      */     {
/* 1715 */       if (localOraclePooledConnection.localTxnCommitOnClose)
/*      */       {
/* 1717 */         localOraclePooledConnection.physicalConn.commit();
/*      */       }
/* 1719 */       else if (localOraclePooledConnection.physicalConn.getProtocolType().equals("thin"))
/*      */       {
/* 1721 */         if (localOraclePooledConnection.physicalConn.getTransactionState().contains(OracleConnection.TransactionState.TRANSACTION_STARTED))
/*      */         {
/* 1724 */           localOraclePooledConnection.physicalConn.rollback();
/*      */         }
/*      */       }
/* 1727 */       storeCacheConnection(localOraclePooledConnection.cachedConnectionAttributes, localOraclePooledConnection);
/*      */ 
/* 1730 */       this.checkedOutConnectionList.removeElement(localOraclePooledConnection);
/*      */ 
/* 1734 */       localOraclePooledConnection.logicalHandle = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void closePooledConnection(PooledConnection paramPooledConnection)
/*      */     throws SQLException
/*      */   {
/* 1757 */     if (paramPooledConnection != null)
/*      */     {
/* 1759 */       actualPooledConnectionClose((OraclePooledConnection)paramPooledConnection);
/*      */ 
/* 1765 */       if (((OraclePooledConnection)paramPooledConnection).closeOption == 4096) {
/* 1766 */         this.checkedOutConnectionList.removeElement(paramPooledConnection);
/*      */       }
/* 1768 */       paramPooledConnection = null;
/*      */ 
/* 1770 */       if (getTotalCachedConnections() < this.cacheMinLimit)
/* 1771 */         defaultUserPrePopulateCache(1);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void refreshCacheConnections(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1787 */     doForEveryCachedConnection(paramInt);
/*      */   }
/*      */ 
/*      */   protected void reinitializeCacheConnections(Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/* 1803 */     int m = 0;
/*      */ 
/* 1806 */     synchronized (this)
/*      */     {
/* 1808 */       this.defaultUser = this.cacheEnabledDS.user;
/* 1809 */       this.defaultPassword = this.cacheEnabledDS.password;
/* 1810 */       this.fastConnectionFailoverEnabled = this.cacheEnabledDS.getFastConnectionFailoverEnabled();
/*      */ 
/* 1818 */       cleanupTimeoutThread();
/*      */ 
/* 1822 */       doForEveryCheckedOutConnection(1);
/*      */ 
/* 1825 */       int i = this.cacheInitialLimit;
/* 1826 */       int j = this.cacheMaxLimit;
/* 1827 */       int k = this.cacheMaxStatementsLimit;
/*      */ 
/* 1830 */       setConnectionCacheProperties(paramProperties);
/*      */ 
/* 1832 */       if (this.cacheInitialLimit > i) {
/* 1833 */         m = this.cacheInitialLimit - i;
/*      */       }
/*      */ 
/* 1839 */       if (j != 2147483647)
/*      */       {
/* 1841 */         if ((this.cacheMaxLimit < j) && (this.cacheSize > this.cacheMaxLimit))
/*      */         {
/* 1843 */           this.connectionsToRemove = (this.cacheSize - this.cacheMaxLimit);
/*      */ 
/* 1845 */           doForEveryCachedConnection(8);
/*      */ 
/* 1847 */           this.connectionsToRemove = 0;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1853 */       if (this.cacheMaxStatementsLimit != k)
/*      */       {
/* 1855 */         if (this.cacheMaxStatementsLimit == 0)
/* 1856 */           doForEveryCachedConnection(16);
/*      */         else {
/* 1858 */           doForEveryCachedConnection(18);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1865 */     if (m > 0)
/*      */     {
/* 1867 */       defaultUserPrePopulateCache(m);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected synchronized void setConnectionCacheProperties(Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 1894 */       if (paramProperties != null)
/*      */       {
/* 1896 */         String str = null;
/*      */ 
/* 1899 */         if ((str = paramProperties.getProperty("MinLimit")) != null)
/*      */         {
/* 1901 */           if ((this.cacheMinLimit = Integer.parseInt(str)) < 0) {
/* 1902 */             this.cacheMinLimit = 0;
/*      */           }
/*      */         }
/*      */ 
/* 1906 */         if ((str = paramProperties.getProperty("MaxLimit")) != null)
/*      */         {
/* 1908 */           if ((this.cacheMaxLimit = Integer.parseInt(str)) < 0) {
/* 1909 */             this.cacheMaxLimit = 2147483647;
/*      */           }
/*      */         }
/*      */ 
/* 1913 */         if (this.cacheMaxLimit < this.cacheMinLimit) {
/* 1914 */           this.cacheMinLimit = this.cacheMaxLimit;
/*      */         }
/*      */ 
/* 1917 */         if ((str = paramProperties.getProperty("InitialLimit")) != null)
/*      */         {
/* 1919 */           if ((this.cacheInitialLimit = Integer.parseInt(str)) < 0) {
/* 1920 */             this.cacheInitialLimit = 0;
/*      */           }
/*      */         }
/* 1923 */         if (this.cacheInitialLimit > this.cacheMaxLimit) {
/* 1924 */           this.cacheInitialLimit = this.cacheMaxLimit;
/*      */         }
/*      */ 
/* 1927 */         if ((str = paramProperties.getProperty("MaxStatementsLimit")) != null)
/*      */         {
/* 1929 */           if ((this.cacheMaxStatementsLimit = Integer.parseInt(str)) < 0) {
/* 1930 */             this.cacheMaxStatementsLimit = 0;
/*      */           }
/*      */         }
/*      */ 
/* 1934 */         localObject1 = (Properties)paramProperties.get("AttributeWeights");
/*      */ 
/* 1937 */         if (localObject1 != null)
/*      */         {
/* 1939 */           Map.Entry localEntry = null;
/* 1940 */           int i = 0;
/* 1941 */           Object localObject2 = null;
/*      */ 
/* 1943 */           Iterator localIterator = ((Properties)localObject1).entrySet().iterator();
/*      */ 
/* 1945 */           while (localIterator.hasNext())
/*      */           {
/* 1947 */             localEntry = (Map.Entry)localIterator.next();
/* 1948 */             localObject2 = localEntry.getKey();
/*      */ 
/* 1950 */             if (((str = (String)((Properties)localObject1).get(localObject2)) != null) && 
/* 1952 */               ((i = Integer.parseInt(str)) < 0)) {
/* 1953 */               ((Properties)localObject1).put(localObject2, "0");
/*      */             }
/*      */           }
/*      */ 
/* 1957 */           if (this.cacheAttributeWeights == null) {
/* 1958 */             this.cacheAttributeWeights = new Properties();
/*      */           }
/* 1960 */           this.cacheAttributeWeights.putAll((Map)localObject1);
/*      */         }
/*      */ 
/* 1964 */         if ((str = paramProperties.getProperty("InactivityTimeout")) != null)
/*      */         {
/* 1966 */           if ((this.cacheInactivityTimeout = Integer.parseInt(str)) < 0) {
/* 1967 */             this.cacheInactivityTimeout = 0;
/*      */           }
/*      */         }
/*      */ 
/* 1971 */         if ((str = paramProperties.getProperty("TimeToLiveTimeout")) != null)
/*      */         {
/* 1973 */           if ((this.cacheTimeToLiveTimeout = Integer.parseInt(str)) < 0) {
/* 1974 */             this.cacheTimeToLiveTimeout = 0;
/*      */           }
/*      */         }
/*      */ 
/* 1978 */         if ((str = paramProperties.getProperty("AbandonedConnectionTimeout")) != null)
/*      */         {
/* 1980 */           if ((this.cacheAbandonedConnectionTimeout = Integer.parseInt(str)) < 0) {
/* 1981 */             this.cacheAbandonedConnectionTimeout = 0;
/*      */           }
/*      */         }
/*      */ 
/* 1985 */         if ((str = paramProperties.getProperty("LowerThresholdLimit")) != null)
/*      */         {
/* 1987 */           this.cacheLowerThresholdLimit = Integer.parseInt(str);
/*      */ 
/* 1989 */           if ((this.cacheLowerThresholdLimit < 0) || (this.cacheLowerThresholdLimit > 100))
/*      */           {
/* 1991 */             this.cacheLowerThresholdLimit = 20;
/*      */           }
/*      */         }
/*      */ 
/* 1995 */         if ((str = paramProperties.getProperty("PropertyCheckInterval")) != null)
/*      */         {
/* 1997 */           if ((this.cachePropertyCheckInterval = Integer.parseInt(str)) < 0)
/*      */           {
/* 1999 */             this.cachePropertyCheckInterval = 900;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 2004 */         if ((str = paramProperties.getProperty("ValidateConnection")) != null) {
/* 2005 */           this.cacheValidateConnection = Boolean.valueOf(str).booleanValue();
/*      */         }
/*      */ 
/* 2008 */         if ((str = paramProperties.getProperty("ClosestConnectionMatch")) != null)
/*      */         {
/* 2010 */           this.cacheClosestConnectionMatch = Boolean.valueOf(str).booleanValue();
/*      */         }
/*      */ 
/* 2014 */         if ((str = paramProperties.getProperty("UseLIFO")) != null) {
/* 2015 */           this.cacheUseLIFO = Boolean.valueOf(str).booleanValue();
/*      */         }
/*      */ 
/* 2018 */         if ((str = paramProperties.getProperty("ConnectionWaitTimeout")) != null)
/*      */         {
/* 2020 */           if ((this.cacheConnectionWaitTimeout = Integer.parseInt(str)) < 0) {
/* 2021 */             this.cacheConnectionWaitTimeout = 0;
/*      */           }
/*      */         }
/*      */ 
/* 2025 */         if ((str = paramProperties.getProperty("LocalTransactionCommitOnClose")) != null)
/*      */         {
/* 2027 */           this.cacheLocalTxnCommitOnClose = str.equalsIgnoreCase("true");
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 2033 */         this.cacheMinLimit = 0;
/* 2034 */         this.cacheMaxLimit = 2147483647;
/* 2035 */         this.cacheInitialLimit = 0;
/* 2036 */         this.cacheMaxStatementsLimit = 0;
/* 2037 */         this.cacheAttributeWeights = null;
/* 2038 */         this.cacheInactivityTimeout = 0;
/* 2039 */         this.cacheTimeToLiveTimeout = 0;
/* 2040 */         this.cacheAbandonedConnectionTimeout = 0;
/* 2041 */         this.cacheLowerThresholdLimit = 20;
/* 2042 */         this.cachePropertyCheckInterval = 900;
/* 2043 */         this.cacheClosestConnectionMatch = false;
/* 2044 */         this.cacheValidateConnection = false;
/* 2045 */         this.cacheConnectionWaitTimeout = 0;
/* 2046 */         this.cacheLocalTxnCommitOnClose = false;
/* 2047 */         this.cacheUseLIFO = false;
/*      */       }
/*      */ 
/* 2051 */       if (((this.cacheInactivityTimeout > 0) || (this.cacheTimeToLiveTimeout > 0) || (this.cacheAbandonedConnectionTimeout > 0)) && (this.cachePropertyCheckInterval > 0))
/*      */       {
/* 2056 */         if (this.timeoutThread == null) {
/* 2057 */           this.timeoutThread = new OracleImplicitConnectionCacheThread(this);
/*      */         }
/* 2059 */         this.cacheManager.checkAndStartThread(this.timeoutThread);
/*      */       }
/*      */ 
/* 2062 */       if (this.cachePropertyCheckInterval == 0)
/*      */       {
/* 2066 */         cleanupTimeoutThread();
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (NumberFormatException localNumberFormatException)
/*      */     {
/* 2072 */       Object localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 139, "OracleImplicitConnectionCache:setConnectionCacheProperties() - NumberFormatException Occurred :" + localNumberFormatException.getMessage());
/*      */ 
/* 2076 */       ((SQLException)localObject1).fillInStackTrace();
/* 2077 */       throw ((Throwable)localObject1);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected Properties getConnectionCacheProperties()
/*      */     throws SQLException
/*      */   {
/* 2091 */     Properties localProperties = new Properties();
/*      */ 
/* 2093 */     localProperties.setProperty("MinLimit", String.valueOf(this.cacheMinLimit));
/* 2094 */     localProperties.setProperty("MaxLimit", String.valueOf(this.cacheMaxLimit));
/* 2095 */     localProperties.setProperty("InitialLimit", String.valueOf(this.cacheInitialLimit));
/*      */ 
/* 2097 */     localProperties.setProperty("MaxStatementsLimit", String.valueOf(this.cacheMaxStatementsLimit));
/*      */ 
/* 2100 */     if (this.cacheAttributeWeights != null)
/* 2101 */       localProperties.put("AttributeWeights", this.cacheAttributeWeights);
/*      */     else {
/* 2103 */       localProperties.setProperty("AttributeWeights", "NULL");
/*      */     }
/* 2105 */     localProperties.setProperty("InactivityTimeout", String.valueOf(this.cacheInactivityTimeout));
/*      */ 
/* 2107 */     localProperties.setProperty("TimeToLiveTimeout", String.valueOf(this.cacheTimeToLiveTimeout));
/*      */ 
/* 2109 */     localProperties.setProperty("AbandonedConnectionTimeout", String.valueOf(this.cacheAbandonedConnectionTimeout));
/*      */ 
/* 2111 */     localProperties.setProperty("LowerThresholdLimit", String.valueOf(this.cacheLowerThresholdLimit));
/*      */ 
/* 2113 */     localProperties.setProperty("PropertyCheckInterval", String.valueOf(this.cachePropertyCheckInterval));
/*      */ 
/* 2115 */     localProperties.setProperty("ConnectionWaitTimeout", String.valueOf(this.cacheConnectionWaitTimeout));
/*      */ 
/* 2117 */     localProperties.setProperty("ValidateConnection", String.valueOf(this.cacheValidateConnection));
/*      */ 
/* 2119 */     localProperties.setProperty("ClosestConnectionMatch", String.valueOf(this.cacheClosestConnectionMatch));
/*      */ 
/* 2121 */     localProperties.setProperty("LocalTransactionCommitOnClose", String.valueOf(this.cacheLocalTxnCommitOnClose));
/*      */ 
/* 2123 */     localProperties.setProperty("UseLIFO", String.valueOf(this.cacheUseLIFO));
/*      */ 
/* 2126 */     return localProperties;
/*      */   }
/*      */ 
/*      */   protected int testDatabaseConnection(OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/* 2138 */     return paramOracleConnection.pingDatabase();
/*      */   }
/*      */ 
/*      */   protected synchronized void closeConnectionCache(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2155 */     cleanupTimeoutThread();
/*      */ 
/* 2159 */     purgeCacheConnections(true, paramInt);
/*      */ 
/* 2166 */     this.connectionPoolDS = null;
/* 2167 */     this.cacheEnabledDS = null;
/* 2168 */     this.checkedOutConnectionList = null;
/* 2169 */     this.userMap = null;
/* 2170 */     this.cacheManager = null;
/*      */   }
/*      */ 
/*      */   protected synchronized void disableConnectionCache()
/*      */     throws SQLException
/*      */   {
/* 2182 */     this.disableConnectionRequest = true;
/*      */   }
/*      */ 
/*      */   protected synchronized void enableConnectionCache()
/*      */     throws SQLException
/*      */   {
/* 2194 */     this.disableConnectionRequest = false;
/*      */   }
/*      */ 
/*      */   protected void initFailoverParameters(OraclePooledConnection paramOraclePooledConnection)
/*      */     throws SQLException
/*      */   {
/* 2208 */     String str1 = null;
/* 2209 */     String str2 = null;
/* 2210 */     String str3 = null;
/*      */ 
/* 2212 */     Properties localProperties = ((OracleConnection)paramOraclePooledConnection.getPhysicalHandle()).getServerSessionInfo();
/*      */ 
/* 2214 */     str3 = localProperties.getProperty("INSTANCE_NAME");
/* 2215 */     if (str3 != null) {
/* 2216 */       str1 = paramOraclePooledConnection.dataSourceInstanceNameKey = str3.trim().toLowerCase().intern();
/*      */     }
/*      */ 
/* 2220 */     str3 = localProperties.getProperty("SERVER_HOST");
/* 2221 */     if (str3 != null) {
/* 2222 */       paramOraclePooledConnection.dataSourceHostNameKey = str3.trim().toLowerCase().intern();
/*      */     }
/*      */ 
/* 2227 */     str3 = localProperties.getProperty("SERVICE_NAME");
/* 2228 */     if (str3 != null) {
/* 2229 */       this.dataSourceServiceName = str3.trim();
/*      */     }
/*      */ 
/* 2233 */     str3 = localProperties.getProperty("DATABASE_NAME");
/* 2234 */     if (str3 != null) {
/* 2235 */       str2 = paramOraclePooledConnection.dataSourceDbUniqNameKey = str3.trim().toLowerCase().intern();
/*      */     }
/*      */ 
/* 2242 */     if (this.databaseInstancesList == null) {
/* 2243 */       this.databaseInstancesList = new LinkedList();
/*      */     }
/* 2245 */     int i = this.databaseInstancesList.size();
/* 2246 */     synchronized (this.databaseInstancesList)
/*      */     {
/* 2248 */       OracleDatabaseInstance localOracleDatabaseInstance1 = null;
/* 2249 */       int j = 0;
/*      */ 
/* 2251 */       for (int k = 0; k < i; k++)
/*      */       {
/* 2253 */         localOracleDatabaseInstance1 = (OracleDatabaseInstance)this.databaseInstancesList.get(k);
/* 2254 */         if ((localOracleDatabaseInstance1.databaseUniqName == str2) && (localOracleDatabaseInstance1.instanceName == str1))
/*      */         {
/* 2257 */           localOracleDatabaseInstance1.numberOfConnectionsCount += 1;
/* 2258 */           j = 1;
/* 2259 */           break;
/*      */         }
/*      */       }
/*      */ 
/* 2263 */       if (j == 0)
/*      */       {
/* 2265 */         OracleDatabaseInstance localOracleDatabaseInstance2 = new OracleDatabaseInstance(str2, str1);
/*      */ 
/* 2268 */         localOracleDatabaseInstance2.numberOfConnectionsCount += 1;
/* 2269 */         this.databaseInstancesList.add(localOracleDatabaseInstance2);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void processFailoverEvent(int paramInt1, String paramString1, String paramString2, String paramString3, String paramString4, int paramInt2)
/*      */   {
/* 2296 */     if (paramInt1 == 256)
/*      */     {
/* 2298 */       if ((paramString4.equalsIgnoreCase("down")) || (paramString4.equalsIgnoreCase("not_restarting")) || (paramString4.equalsIgnoreCase("restart_failed")))
/*      */       {
/* 2302 */         this.downEventCount += 1;
/*      */ 
/* 2304 */         markDownLostConnections(true, false, paramString1, paramString2, paramString3, paramString4);
/*      */ 
/* 2306 */         cleanupFailoverConnections(true, false, paramString1, paramString2, paramString3, paramString4);
/*      */       }
/* 2309 */       else if (paramString4.equalsIgnoreCase("up"))
/*      */       {
/* 2313 */         if (this.downEventCount > 0) {
/* 2314 */           this.upEventCount += 1;
/*      */         }
/*      */         try
/*      */         {
/* 2318 */           processUpEvent(paramInt2);
/*      */         }
/*      */         catch (Exception localException)
/*      */         {
/*      */         }
/*      */ 
/* 2326 */         this.isEntireServiceDownProcessed = false;
/*      */       }
/*      */     }
/* 2329 */     else if ((paramInt1 == 512) && (paramString4.equalsIgnoreCase("nodedown")))
/*      */     {
/* 2333 */       markDownLostConnections(false, true, paramString1, paramString2, paramString3, paramString4);
/*      */ 
/* 2335 */       cleanupFailoverConnections(false, true, paramString1, paramString2, paramString3, paramString4);
/*      */     }
/*      */   }
/*      */ 
/*      */   void processUpEvent(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2412 */     int i = 0;
/* 2413 */     int j = 0;
/* 2414 */     int k = getTotalCachedConnections();
/* 2415 */     boolean bool = false;
/*      */ 
/* 2417 */     synchronized (this)
/*      */     {
/* 2421 */       if (paramInt <= 1) {
/* 2422 */         paramInt = 2;
/*      */       }
/*      */ 
/* 2429 */       if ((this.downEventCount == 0) && (this.upEventCount == 0) && (getNumberOfDefaultUserConnections() > 0))
/*      */       {
/* 2433 */         i = (int)(this.cacheSize * 0.25D);
/*      */       }
/*      */       else
/*      */       {
/* 2437 */         i = this.defaultUserPreFailureSize;
/*      */       }
/*      */ 
/* 2449 */       if (i <= 0)
/*      */       {
/* 2451 */         if (getNumberOfDefaultUserConnections() > 0)
/*      */         {
/* 2453 */           j = (int)(this.cacheSize * 0.25D);
/* 2454 */           bool = true;
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 2463 */         j = i / paramInt;
/*      */ 
/* 2467 */         if (j + k > this.cacheMaxLimit) {
/* 2468 */           bool = true;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 2483 */       if (this.downEventCount == this.upEventCount)
/*      */       {
/* 2485 */         this.defaultUserPreFailureSize = 0;
/* 2486 */         this.downEventCount = 0;
/* 2487 */         this.upEventCount = 0;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2492 */     if (j > 0)
/* 2493 */       loadBalanceConnections(j, bool);
/*      */   }
/*      */ 
/*      */   private void loadBalanceConnections(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 2505 */     if (paramBoolean)
/*      */     {
/* 2507 */       this.connectionsToRemove = paramInt;
/*      */ 
/* 2509 */       doForEveryCachedConnection(8);
/*      */ 
/* 2511 */       this.connectionsToRemove = 0;
/*      */     }
/*      */ 
/* 2515 */     if (paramInt <= 10)
/*      */     {
/*      */       try
/*      */       {
/* 2519 */         defaultUserPrePopulateCache(paramInt);
/*      */       }
/*      */       catch (Exception localException1)
/*      */       {
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 2531 */       int i = (int)(paramInt * 0.25D);
/*      */ 
/* 2533 */       for (int j = 0; j < 4; j++)
/*      */       {
/*      */         try
/*      */         {
/* 2537 */           defaultUserPrePopulateCache(i);
/*      */         }
/*      */         catch (Exception localException2)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private int getNumberOfDefaultUserConnections()
/*      */   {
/* 2556 */     int i = 0;
/*      */ 
/* 2558 */     if ((this.userMap != null) && (!this.userMap.isEmpty()))
/*      */     {
/* 2561 */       OracleConnectionCacheEntry localOracleConnectionCacheEntry = (OracleConnectionCacheEntry)this.userMap.get(OraclePooledConnection.generateKey(this.defaultUser, this.defaultPassword));
/*      */ 
/* 2565 */       if ((localOracleConnectionCacheEntry != null) && (localOracleConnectionCacheEntry.userConnList != null) && (!localOracleConnectionCacheEntry.userConnList.isEmpty()))
/*      */       {
/* 2568 */         i = localOracleConnectionCacheEntry.userConnList.size();
/*      */       }
/*      */     }
/* 2571 */     return i;
/*      */   }
/*      */ 
/*      */   synchronized void markDownLostConnections(boolean paramBoolean1, boolean paramBoolean2, String paramString1, String paramString2, String paramString3, String paramString4)
/*      */   {
/* 2592 */     if (!this.isEntireServiceDownProcessed)
/*      */     {
/* 2594 */       if ((this.userMap != null) && (!this.userMap.isEmpty()))
/*      */       {
/* 2598 */         Iterator localIterator1 = this.userMap.entrySet().iterator();
/*      */ 
/* 2606 */         while (localIterator1.hasNext())
/*      */         {
/* 2608 */           int i = 0;
/*      */ 
/* 2610 */           Map.Entry localEntry = (Map.Entry)localIterator1.next();
/* 2611 */           String str = null;
/* 2612 */           if ((this.defaultUser != null) && (this.defaultPassword != null)) {
/* 2613 */             str = this.defaultUser + this.defaultPassword;
/*      */           }
/*      */ 
/* 2616 */           if ((str != null) && (str.equalsIgnoreCase((String)localEntry.getKey())))
/*      */           {
/* 2618 */             i = 1;
/*      */           }
/* 2620 */           OracleConnectionCacheEntry localOracleConnectionCacheEntry = (OracleConnectionCacheEntry)localEntry.getValue();
/*      */           Object localObject1;
/*      */           Object localObject2;
/* 2624 */           if ((localOracleConnectionCacheEntry != null) && (localOracleConnectionCacheEntry.userConnList != null) && (!localOracleConnectionCacheEntry.userConnList.isEmpty()))
/*      */           {
/* 2627 */             boolean bool = false;
/* 2628 */             localObject1 = localOracleConnectionCacheEntry.userConnList.iterator();
/*      */ 
/* 2630 */             while (((Iterator)localObject1).hasNext())
/*      */             {
/* 2632 */               localObject2 = (OraclePooledConnection)((Iterator)localObject1).next();
/*      */ 
/* 2634 */               if (paramBoolean1) {
/* 2635 */                 bool = markDownConnectionsForServiceEvent(paramString1, paramString2, (OraclePooledConnection)localObject2);
/*      */               }
/* 2637 */               else if (paramBoolean2) {
/* 2638 */                 bool = markDownConnectionsForHostEvent(paramString3, (OraclePooledConnection)localObject2);
/*      */               }
/*      */ 
/* 2642 */               if ((bool) && (i != 0)) {
/* 2643 */                 this.defaultUserPreFailureSize += 1;
/*      */               }
/*      */             }
/*      */           }
/*      */ 
/* 2648 */           if ((localOracleConnectionCacheEntry != null) && (localOracleConnectionCacheEntry.attrConnMap != null) && (!localOracleConnectionCacheEntry.attrConnMap.isEmpty()))
/*      */           {
/* 2651 */             Iterator localIterator2 = localOracleConnectionCacheEntry.attrConnMap.entrySet().iterator();
/*      */ 
/* 2653 */             while (localIterator2.hasNext())
/*      */             {
/* 2655 */               localObject1 = (Map.Entry)localIterator2.next();
/* 2656 */               localObject2 = ((Vector)((Map.Entry)localObject1).getValue()).iterator();
/*      */ 
/* 2658 */               while (((Iterator)localObject2).hasNext())
/*      */               {
/* 2660 */                 OraclePooledConnection localOraclePooledConnection = (OraclePooledConnection)((Iterator)localObject2).next();
/*      */ 
/* 2662 */                 if (paramBoolean1) {
/* 2663 */                   markDownConnectionsForServiceEvent(paramString1, paramString2, localOraclePooledConnection);
/*      */                 }
/* 2665 */                 else if (paramBoolean2) {
/* 2666 */                   markDownConnectionsForHostEvent(paramString3, localOraclePooledConnection);
/*      */                 }
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/* 2673 */       if (paramString1 == null)
/* 2674 */         this.isEntireServiceDownProcessed = true;
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean markDownConnectionsForServiceEvent(String paramString1, String paramString2, OraclePooledConnection paramOraclePooledConnection)
/*      */   {
/* 2688 */     boolean bool = false;
/*      */ 
/* 2690 */     if ((paramString1 == null) || ((paramString2 == paramOraclePooledConnection.dataSourceDbUniqNameKey) && (paramString1 == paramOraclePooledConnection.dataSourceInstanceNameKey)))
/*      */     {
/* 2694 */       paramOraclePooledConnection.connectionMarkedDown = true;
/* 2695 */       bool = true;
/*      */     }
/*      */ 
/* 2698 */     return bool;
/*      */   }
/*      */ 
/*      */   private boolean markDownConnectionsForHostEvent(String paramString, OraclePooledConnection paramOraclePooledConnection)
/*      */   {
/* 2709 */     boolean bool = false;
/*      */ 
/* 2711 */     if (paramString == paramOraclePooledConnection.dataSourceHostNameKey)
/*      */     {
/* 2713 */       paramOraclePooledConnection.connectionMarkedDown = true;
/* 2714 */       paramOraclePooledConnection.needToAbort = true;
/* 2715 */       bool = true;
/*      */     }
/* 2717 */     return bool;
/*      */   }
/*      */ 
/*      */   synchronized void cleanupFailoverConnections(boolean paramBoolean1, boolean paramBoolean2, String paramString1, String paramString2, String paramString3, String paramString4)
/*      */   {
/* 2739 */     OraclePooledConnection localOraclePooledConnection = null;
/* 2740 */     Object[] arrayOfObject = this.checkedOutConnectionList.toArray();
/* 2741 */     int i = this.checkedOutConnectionList.size();
/*      */ 
/* 2743 */     OraclePooledConnection[] arrayOfOraclePooledConnection = new OraclePooledConnection[i];
/* 2744 */     int j = 0;
/*      */ 
/* 2746 */     for (int k = 0; k < i; k++)
/*      */     {
/*      */       try
/*      */       {
/* 2750 */         localOraclePooledConnection = (OraclePooledConnection)arrayOfObject[k];
/*      */ 
/* 2752 */         if (((paramBoolean1) && ((paramString1 == null) || (paramString1 == localOraclePooledConnection.dataSourceInstanceNameKey)) && (paramString2 == localOraclePooledConnection.dataSourceDbUniqNameKey)) || ((paramBoolean2) && (paramString3 == localOraclePooledConnection.dataSourceHostNameKey)))
/*      */         {
/* 2759 */           if ((localOraclePooledConnection.isSameUser(this.defaultUser, this.defaultPassword)) && (localOraclePooledConnection.cachedConnectionAttributes != null) && (localOraclePooledConnection.cachedConnectionAttributes.isEmpty()))
/*      */           {
/* 2762 */             this.defaultUserPreFailureSize += 1;
/*      */           }
/*      */ 
/* 2765 */           this.checkedOutConnectionList.removeElement(localOraclePooledConnection);
/*      */ 
/* 2772 */           abortConnection(localOraclePooledConnection);
/* 2773 */           localOraclePooledConnection.needToAbort = true;
/*      */ 
/* 2776 */           arrayOfOraclePooledConnection[(j++)] = localOraclePooledConnection;
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (Exception localException)
/*      */       {
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2786 */     for (k = 0; k < j; k++)
/*      */     {
/*      */       try
/*      */       {
/* 2790 */         closeCheckedOutConnection(arrayOfOraclePooledConnection[k], false);
/*      */       }
/*      */       catch (SQLException localSQLException2)
/*      */       {
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2799 */     if ((this.checkedOutConnectionList.size() < i) && (this.cacheConnectionWaitTimeout > 0))
/*      */     {
/* 2802 */       notifyAll();
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 2808 */       doForEveryCachedConnection(2);
/*      */     }
/*      */     catch (SQLException localSQLException1)
/*      */     {
/*      */     }
/*      */ 
/* 2817 */     if ((this.databaseInstancesList != null) && ((i = this.databaseInstancesList.size()) > 0))
/*      */     {
/* 2820 */       synchronized (this.databaseInstancesList)
/*      */       {
/* 2822 */         OracleDatabaseInstance localOracleDatabaseInstance = null;
/* 2823 */         arrayOfObject = this.databaseInstancesList.toArray();
/*      */ 
/* 2825 */         for (int m = 0; m < i; m++)
/*      */         {
/* 2827 */           localOracleDatabaseInstance = (OracleDatabaseInstance)arrayOfObject[m];
/*      */ 
/* 2829 */           if ((localOracleDatabaseInstance.databaseUniqName == paramString2) && (localOracleDatabaseInstance.instanceName == paramString1))
/*      */           {
/* 2833 */             if (localOracleDatabaseInstance.flag <= 3)
/* 2834 */               this.dbInstancePercentTotal -= localOracleDatabaseInstance.percent;
/* 2835 */             this.databaseInstancesList.remove(localOracleDatabaseInstance);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void zapRLBInfo()
/*      */   {
/* 2849 */     this.databaseInstancesList.clear();
/*      */   }
/*      */ 
/*      */   protected synchronized void closeAndRemovePooledConnection(OraclePooledConnection paramOraclePooledConnection)
/*      */     throws SQLException
/*      */   {
/* 2861 */     if (paramOraclePooledConnection != null)
/*      */     {
/* 2863 */       if (paramOraclePooledConnection.needToAbort) {
/* 2864 */         abortConnection(paramOraclePooledConnection);
/*      */       }
/* 2866 */       actualPooledConnectionClose(paramOraclePooledConnection);
/* 2867 */       removeCacheConnection(paramOraclePooledConnection);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void abortConnection(OraclePooledConnection paramOraclePooledConnection)
/*      */   {
/*      */     try
/*      */     {
/* 2886 */       ((OracleConnection)paramOraclePooledConnection.getPhysicalHandle()).abort();
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   private void actualPooledConnectionClose(OraclePooledConnection paramOraclePooledConnection)
/*      */     throws SQLException
/*      */   {
/* 2906 */     int i = 0;
/* 2907 */     if ((this.databaseInstancesList != null) && ((i = this.databaseInstancesList.size()) > 0))
/*      */     {
/* 2910 */       synchronized (this.databaseInstancesList)
/*      */       {
/* 2912 */         OracleDatabaseInstance localOracleDatabaseInstance = null;
/*      */ 
/* 2914 */         for (int j = 0; j < i; j++)
/*      */         {
/* 2916 */           localOracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(j);
/* 2917 */           if ((localOracleDatabaseInstance.databaseUniqName == paramOraclePooledConnection.dataSourceDbUniqNameKey) && (localOracleDatabaseInstance.instanceName == paramOraclePooledConnection.dataSourceInstanceNameKey))
/*      */           {
/* 2920 */             if (localOracleDatabaseInstance.numberOfConnectionsCount <= 0) break;
/* 2921 */             localOracleDatabaseInstance.numberOfConnectionsCount -= 1; break;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 2935 */       this.connectionClosedCount += 1;
/* 2936 */       paramOraclePooledConnection.close();
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   protected int getCacheTimeToLiveTimeout()
/*      */   {
/* 2948 */     return this.cacheTimeToLiveTimeout;
/*      */   }
/*      */ 
/*      */   protected int getCacheInactivityTimeout()
/*      */   {
/* 2955 */     return this.cacheInactivityTimeout;
/*      */   }
/*      */ 
/*      */   protected int getCachePropertyCheckInterval()
/*      */   {
/* 2962 */     return this.cachePropertyCheckInterval;
/*      */   }
/*      */ 
/*      */   protected int getCacheAbandonedTimeout()
/*      */   {
/* 2969 */     return this.cacheAbandonedConnectionTimeout;
/*      */   }
/*      */ 
/*      */   private synchronized void processConnectionCacheCallback()
/*      */     throws SQLException
/*      */   {
/* 2984 */     float f = this.cacheMaxLimit / 100.0F;
/* 2985 */     int i = (int)(this.cacheLowerThresholdLimit * f);
/*      */ 
/* 2988 */     releaseBasedOnPriority(1024, i);
/*      */ 
/* 2991 */     if (this.cacheSize < i)
/* 2992 */       releaseBasedOnPriority(512, i);
/*      */   }
/*      */ 
/*      */   private void releaseBasedOnPriority(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3005 */     Object[] arrayOfObject = this.checkedOutConnectionList.toArray();
/*      */ 
/* 3007 */     for (int i = 0; (i < arrayOfObject.length) && (this.cacheSize < paramInt2); i++)
/*      */     {
/* 3009 */       OraclePooledConnection localOraclePooledConnection = (OraclePooledConnection)arrayOfObject[i];
/* 3010 */       OracleConnection localOracleConnection = null;
/*      */ 
/* 3012 */       if (localOraclePooledConnection != null) {
/* 3013 */         localOracleConnection = (OracleConnection)localOraclePooledConnection.getLogicalHandle();
/*      */       }
/* 3015 */       if (localOracleConnection != null)
/*      */       {
/* 3017 */         OracleConnectionCacheCallback localOracleConnectionCacheCallback = localOracleConnection.getConnectionCacheCallbackObj();
/*      */ 
/* 3020 */         if ((localOracleConnectionCacheCallback != null) && ((localOracleConnection.getConnectionCacheCallbackFlag() == 2) || (localOracleConnection.getConnectionCacheCallbackFlag() == 4)))
/*      */         {
/* 3026 */           if (paramInt1 == localOracleConnection.getConnectionReleasePriority())
/*      */           {
/* 3028 */             Object localObject = localOracleConnection.getConnectionCacheCallbackPrivObj();
/* 3029 */             localOracleConnectionCacheCallback.releaseConnection(localOracleConnection, localObject);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private synchronized void processConnectionWaitTimeout(long paramLong)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 3050 */       wait(paramLong);
/*      */     }
/*      */     catch (InterruptedException localInterruptedException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processInactivityTimeout(OraclePooledConnection paramOraclePooledConnection)
/*      */     throws SQLException
/*      */   {
/* 3072 */     long l1 = paramOraclePooledConnection.getLastAccessedTime();
/* 3073 */     long l2 = System.currentTimeMillis();
/*      */ 
/* 3081 */     if ((getTotalCachedConnections() > this.cacheMinLimit) && (l2 - l1 > this.cacheInactivityTimeout * 1000))
/*      */     {
/* 3087 */       closeAndRemovePooledConnection(paramOraclePooledConnection);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void cleanupTimeoutThread()
/*      */     throws SQLException
/*      */   {
/* 3101 */     if (this.timeoutThread != null)
/*      */     {
/* 3103 */       this.timeoutThread.timeToLive = false;
/*      */ 
/* 3107 */       if (this.timeoutThread.isSleeping) {
/* 3108 */         this.timeoutThread.interrupt();
/*      */       }
/* 3110 */       this.timeoutThread = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void purgeCacheConnections(boolean paramBoolean, int paramInt)
/*      */   {
/*      */     try
/*      */     {
/* 3127 */       if (paramBoolean) {
/* 3128 */         doForEveryCheckedOutConnection(paramInt);
/*      */       }
/*      */ 
/* 3131 */       doForEveryCachedConnection(paramInt);
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void updateDatabaseInstance(String paramString1, String paramString2, int paramInt1, int paramInt2)
/*      */   {
/* 3148 */     if (this.databaseInstancesList == null) {
/* 3149 */       this.databaseInstancesList = new LinkedList();
/*      */     }
/* 3151 */     synchronized (this.databaseInstancesList)
/*      */     {
/* 3153 */       int i = this.databaseInstancesList.size();
/* 3154 */       int j = 0;
/*      */ 
/* 3156 */       for (int k = 0; k < i; k++)
/*      */       {
/* 3158 */         OracleDatabaseInstance localOracleDatabaseInstance2 = (OracleDatabaseInstance)this.databaseInstancesList.get(k);
/*      */ 
/* 3161 */         if ((localOracleDatabaseInstance2.databaseUniqName == paramString1) && (localOracleDatabaseInstance2.instanceName == paramString2))
/*      */         {
/* 3164 */           localOracleDatabaseInstance2.percent = paramInt1;
/* 3165 */           localOracleDatabaseInstance2.flag = paramInt2;
/* 3166 */           j = 1;
/* 3167 */           break;
/*      */         }
/*      */       }
/*      */ 
/* 3171 */       if (j == 0)
/*      */       {
/* 3173 */         OracleDatabaseInstance localOracleDatabaseInstance1 = new OracleDatabaseInstance(paramString1, paramString2);
/*      */ 
/* 3176 */         localOracleDatabaseInstance1.percent = paramInt1;
/* 3177 */         localOracleDatabaseInstance1.flag = paramInt2;
/*      */ 
/* 3179 */         this.databaseInstancesList.add(localOracleDatabaseInstance1);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void processDatabaseInstances()
/*      */     throws SQLException
/*      */   {
/* 3194 */     OracleDatabaseInstance localOracleDatabaseInstance = null;
/*      */ 
/* 3196 */     if (this.databaseInstancesList != null)
/*      */     {
/* 3198 */       synchronized (this.databaseInstancesList)
/*      */       {
/* 3200 */         int i = 0;
/* 3201 */         int j = 0;
/*      */ 
/* 3204 */         this.useGoodGroup = false;
/*      */ 
/* 3207 */         int k = this.databaseInstancesList.size();
/*      */ 
/* 3209 */         for (int m = 0; m < k; m++)
/*      */         {
/* 3211 */           localOracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(m);
/*      */ 
/* 3215 */           if (localOracleDatabaseInstance.flag <= 3) {
/* 3216 */             i += localOracleDatabaseInstance.percent;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 3222 */         if (i > 0)
/*      */         {
/* 3224 */           this.dbInstancePercentTotal = i;
/* 3225 */           this.useGoodGroup = true;
/*      */         }
/*      */ 
/* 3232 */         if (k > 1)
/*      */         {
/* 3235 */           for (m = 0; m < k; m++)
/*      */           {
/* 3237 */             localOracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(m);
/* 3238 */             this.countTotal += localOracleDatabaseInstance.attemptedConnRequestCount;
/*      */           }
/*      */ 
/* 3246 */           if (this.countTotal > k * 1000)
/*      */           {
/* 3248 */             for (m = 0; m < k; m++)
/*      */             {
/* 3250 */               localOracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(m);
/*      */ 
/* 3253 */               float f1 = localOracleDatabaseInstance.attemptedConnRequestCount / this.countTotal;
/*      */ 
/* 3255 */               float f2 = localOracleDatabaseInstance.numberOfConnectionsCount / getTotalCachedConnections();
/*      */ 
/* 3268 */               if (f2 > f1 * 2.0F)
/*      */               {
/* 3272 */                 if ((int)(localOracleDatabaseInstance.numberOfConnectionsCount * 0.25D) >= 1) {
/* 3273 */                   this.instancesToRetireQueue.addElement(localOracleDatabaseInstance);
/*      */                 }
/* 3275 */                 j = 1;
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/* 3280 */             if (j != 0)
/*      */             {
/* 3282 */               for (m = 0; m < k; m++)
/*      */               {
/* 3284 */                 localOracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(m);
/*      */ 
/* 3286 */                 localOracleDatabaseInstance.attemptedConnRequestCount = 0;
/*      */               }
/* 3288 */               j = 0;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 3305 */       if (this.instancesToRetireQueue.size() > 0)
/*      */       {
/* 3307 */         if (this.gravitateCacheThread != null)
/*      */         {
/*      */           try
/*      */           {
/* 3311 */             this.gravitateCacheThread.interrupt();
/* 3312 */             this.gravitateCacheThread.join();
/*      */           }
/*      */           catch (InterruptedException localInterruptedException)
/*      */           {
/*      */           }
/*      */ 
/* 3319 */           this.gravitateCacheThread = null;
/*      */         }
/*      */ 
/* 3323 */         this.gravitateCacheThread = new OracleGravitateConnectionCacheThread(this);
/*      */ 
/* 3326 */         this.cacheManager.checkAndStartThread(this.gravitateCacheThread);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void gravitateCache()
/*      */   {
/* 3341 */     while (this.instancesToRetireQueue.size() > 0)
/*      */     {
/* 3344 */       this.instanceToRetire = ((OracleDatabaseInstance)this.instancesToRetireQueue.remove(0));
/* 3345 */       this.retireConnectionsCount = ((int)(this.instanceToRetire.numberOfConnectionsCount * 0.25D));
/*      */       try
/*      */       {
/* 3353 */         doForEveryCachedConnection(24);
/*      */       }
/*      */       catch (SQLException localSQLException1)
/*      */       {
/*      */       }
/*      */ 
/* 3367 */       if (this.retireConnectionsCount > 0)
/*      */       {
/*      */         try
/*      */         {
/* 3373 */           doForEveryCheckedOutConnection(24);
/*      */         }
/*      */         catch (SQLException localSQLException2)
/*      */         {
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3384 */     this.retireConnectionsCount = 0;
/* 3385 */     this.instanceToRetire = null;
/* 3386 */     this.countTotal = 0;
/*      */   }
/*      */ 
/*      */   protected void cleanupRLBThreads()
/*      */   {
/* 3405 */     if (this.gravitateCacheThread != null)
/*      */     {
/*      */       try
/*      */       {
/* 3409 */         this.gravitateCacheThread.interrupt();
/* 3410 */         this.gravitateCacheThread.join();
/*      */       }
/*      */       catch (InterruptedException localInterruptedException)
/*      */       {
/*      */       }
/*      */ 
/* 3417 */       this.gravitateCacheThread = null;
/*      */     }
/*      */ 
/* 3420 */     if (this.runtimeLoadBalancingThread != null)
/*      */     {
/*      */       try
/*      */       {
/* 3424 */         this.runtimeLoadBalancingThread.interrupt();
/*      */       }
/*      */       catch (Exception localException)
/*      */       {
/*      */       }
/*      */ 
/* 3431 */       this.runtimeLoadBalancingThread = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   Map getStatistics()
/*      */     throws SQLException
/*      */   {
/* 3443 */     HashMap localHashMap = new HashMap(2);
/* 3444 */     localHashMap.put("PhysicalConnectionClosedCount", new Integer(this.connectionClosedCount));
/* 3445 */     localHashMap.put("PhysicalConnectionCreatedCount", new Integer(this.connectionCreatedCount));
/*      */ 
/* 3447 */     return localHashMap;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 3462 */     return null;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.pool.OracleImplicitConnectionCache
 * JD-Core Version:    0.6.2
 */