/*     */ package oracle.jdbc.pool;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.sql.SQLException;
/*     */ import oracle.ons.Notification;
/*     */ import oracle.ons.ONSException;
/*     */ import oracle.ons.Subscriber;
/*     */ import oracle.ons.SubscriptionException;
/*     */ 
/*     */ /** @deprecated */
/*     */ class OracleFailoverEventHandlerThread extends Thread
/*     */ {
/*  39 */   private Notification event = null;
/*  40 */   private OracleConnectionCacheManager cacheManager = null;
/*     */ 
/* 145 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   OracleFailoverEventHandlerThread()
/*     */     throws SQLException
/*     */   {
/*  46 */     this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*  55 */     Subscriber localSubscriber = null;
/*     */ 
/*  60 */     while (this.cacheManager.failoverEnabledCacheExists())
/*     */     {
/*     */       try
/*     */       {
/*  65 */         localSubscriber = (Subscriber)AccessController.doPrivileged(new PrivilegedExceptionAction()
/*     */         {
/*     */           public Object run()
/*     */           {
/*     */             try
/*     */             {
/*  74 */               return new Subscriber("(%\"eventType=database/event/service\")|(%\"eventType=database/event/host\")", "", 30000L);
/*     */             }
/*     */             catch (SubscriptionException localSubscriptionException)
/*     */             {
/*     */             }
/*  79 */             return null;
/*     */           }
/*     */ 
/*     */         });
/*     */       }
/*     */       catch (PrivilegedActionException localPrivilegedActionException)
/*     */       {
/*     */       }
/*     */ 
/*  89 */       if (localSubscriber != null)
/*     */       {
/*     */         try
/*     */         {
/*  93 */           while (this.cacheManager.failoverEnabledCacheExists())
/*     */           {
/*  96 */             if ((this.event = localSubscriber.receive(true)) != null)
/*  97 */               handleEvent(this.event);
/*     */           }
/*     */         }
/*     */         catch (ONSException localONSException)
/*     */         {
/* 102 */           localSubscriber.close();
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 110 */         Thread.currentThread(); Thread.sleep(10000L);
/*     */       }
/*     */       catch (InterruptedException localInterruptedException)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   void handleEvent(Notification paramNotification)
/*     */   {
/*     */     try
/*     */     {
/* 127 */       int i = 0;
/*     */ 
/* 129 */       if (paramNotification.type().equalsIgnoreCase("database/event/service"))
/* 130 */         i = 256;
/* 131 */       else if (paramNotification.type().equalsIgnoreCase("database/event/host")) {
/* 132 */         i = 512;
/*     */       }
/* 134 */       if (i != 0)
/* 135 */         this.cacheManager.verifyAndHandleEvent(i, paramNotification.body());
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.pool.OracleFailoverEventHandlerThread
 * JD-Core Version:    0.6.2
 */