/*     */ package oracle.jdbc.pool;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Properties;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.StringRefAddr;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.xa.client.OracleXADataSource;
/*     */ 
/*     */ public class OracleDataSourceFactory
/*     */   implements ObjectFactory
/*     */ {
/*     */   private static final String CONNECTION_CACHING_ENABLED = "connectionCachingEnabled";
/*     */   private static final String CONNECTION_CACHE_NAME = "connectionCacheName";
/*     */   private static final String CONNECTION_CACHE_PROPERTIES = "connectionCacheProperties";
/*     */   private static final String CONNECTION_PROPERTIES = "connectionProperties";
/*     */   private static final String FAST_CONNECTION_FAILOVER_ENABLED = "fastConnectionFailoverEnabled";
/*     */   private static final String ONS_CONFIG_STR = "onsConfigStr";
/*     */   private static final String ORACLE_CONN_DATA_POOL_SOURCE = "oracle.jdbc.pool.OracleConnectionPoolDataSource";
/*     */   private static final String ORACLE_OCI_CONN_POOL = "oracle.jdbc.pool.OracleOCIConnectionPool";
/*     */   private static final String ORACLE_DATA_SOURCE = "oracle.jdbc.pool.OracleDataSource";
/*     */   private static final String ORACLE_XA_DATA_SOURCE = "oracle.jdbc.xa.client.OracleXADataSource";
/* 459 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public Object getObjectInstance(Object paramObject, Name paramName, Context paramContext, Hashtable paramHashtable)
/*     */     throws Exception
/*     */   {
/*  66 */     Reference localReference = (Reference)paramObject;
/*  67 */     Object localObject1 = null;
/*  68 */     String str1 = localReference.getClassName();
/*  69 */     Properties localProperties = new Properties();
/*     */     Object localObject2;
/*     */     String str2;
/*     */     Object localObject3;
/*  71 */     if ((str1.equals("oracle.jdbc.pool.OracleDataSource")) || (str1.equals("oracle.jdbc.xa.client.OracleXADataSource")))
/*     */     {
/*  74 */       if (str1.equals("oracle.jdbc.pool.OracleDataSource")) {
/*  75 */         localObject1 = new OracleDataSource();
/*     */       }
/*     */       else {
/*  78 */         localObject1 = new OracleXADataSource();
/*     */       }
/*     */ 
/*  81 */       localObject2 = null;
/*     */ 
/*  84 */       if ((localObject2 = (StringRefAddr)localReference.get("connectionCachingEnabled")) != null) {
/*  85 */         str2 = (String)((StringRefAddr)localObject2).getContent();
/*     */ 
/*  87 */         if (str2.equals(String.valueOf("true"))) {
/*  88 */           ((OracleDataSource)localObject1).setConnectionCachingEnabled(true);
/*     */         }
/*     */       }
/*     */ 
/*  92 */       if ((localObject2 = (StringRefAddr)localReference.get("connectionCacheName")) != null) {
/*  93 */         ((OracleDataSource)localObject1).setConnectionCacheName((String)((StringRefAddr)localObject2).getContent());
/*     */       }
/*     */ 
/*  96 */       if ((localObject2 = (StringRefAddr)localReference.get("connectionCacheProperties")) != null) {
/*  97 */         str2 = (String)((StringRefAddr)localObject2).getContent();
/*  98 */         localObject3 = extractConnectionCacheProperties(str2);
/*  99 */         ((OracleDataSource)localObject1).setConnectionCacheProperties((Properties)localObject3);
/*     */       }
/*     */ 
/* 102 */       if ((localObject2 = (StringRefAddr)localReference.get("connectionProperties")) != null) {
/* 103 */         str2 = (String)((StringRefAddr)localObject2).getContent();
/* 104 */         localObject3 = extractConnectionProperties(str2);
/* 105 */         ((OracleDataSource)localObject1).setConnectionProperties((Properties)localObject3);
/*     */       }
/*     */ 
/* 108 */       if ((localObject2 = (StringRefAddr)localReference.get("fastConnectionFailoverEnabled")) != null)
/*     */       {
/* 110 */         str2 = (String)((StringRefAddr)localObject2).getContent();
/*     */ 
/* 112 */         if (str2.equals(String.valueOf("true"))) {
/* 113 */           ((OracleDataSource)localObject1).setFastConnectionFailoverEnabled(true);
/*     */         }
/*     */       }
/*     */ 
/* 117 */       if ((localObject2 = (StringRefAddr)localReference.get("onsConfigStr")) != null) {
/* 118 */         ((OracleDataSource)localObject1).setONSConfiguration((String)((StringRefAddr)localObject2).getContent());
/*     */       }
/*     */     }
/* 121 */     else if (str1.equals("oracle.jdbc.pool.OracleConnectionPoolDataSource")) {
/* 122 */       localObject1 = new OracleConnectionPoolDataSource();
/*     */     }
/* 124 */     else if (str1.equals("oracle.jdbc.pool.OracleOCIConnectionPool")) {
/* 125 */       localObject1 = new OracleOCIConnectionPool();
/*     */ 
/* 127 */       localObject2 = null;
/* 128 */       str2 = null;
/* 129 */       localObject3 = null;
/* 130 */       String str3 = null;
/* 131 */       String str4 = null;
/* 132 */       String str5 = null;
/* 133 */       String str6 = null;
/* 134 */       StringRefAddr localStringRefAddr = null;
/*     */ 
/* 136 */       Object localObject4 = null;
/* 137 */       String str7 = null;
/*     */ 
/* 141 */       if ((localStringRefAddr = (StringRefAddr)localReference.get("connpool_min_limit")) != null)
/*     */       {
/* 143 */         localObject2 = (String)localStringRefAddr.getContent();
/*     */       }
/*     */ 
/* 146 */       if ((localStringRefAddr = (StringRefAddr)localReference.get("connpool_max_limit")) != null)
/*     */       {
/* 148 */         str2 = (String)localStringRefAddr.getContent();
/*     */       }
/*     */ 
/* 151 */       if ((localStringRefAddr = (StringRefAddr)localReference.get("connpool_increment")) != null)
/*     */       {
/* 153 */         localObject3 = (String)localStringRefAddr.getContent();
/*     */       }
/*     */ 
/* 156 */       if ((localStringRefAddr = (StringRefAddr)localReference.get("connpool_active_size")) != null)
/*     */       {
/* 158 */         str3 = (String)localStringRefAddr.getContent();
/*     */       }
/*     */ 
/* 161 */       if ((localStringRefAddr = (StringRefAddr)localReference.get("connpool_pool_size")) != null)
/*     */       {
/* 163 */         str4 = (String)localStringRefAddr.getContent();
/*     */       }
/*     */ 
/* 166 */       if ((localStringRefAddr = (StringRefAddr)localReference.get("connpool_timeout")) != null)
/*     */       {
/* 168 */         str5 = (String)localStringRefAddr.getContent();
/*     */       }
/*     */ 
/* 171 */       if ((localStringRefAddr = (StringRefAddr)localReference.get("connpool_nowait")) != null)
/*     */       {
/* 173 */         str6 = (String)localStringRefAddr.getContent();
/*     */       }
/*     */ 
/* 176 */       if ((localStringRefAddr = (StringRefAddr)localReference.get("transactions_distributed")) != null)
/*     */       {
/* 178 */         str7 = (String)localStringRefAddr.getContent();
/*     */       }
/*     */ 
/* 183 */       localProperties.put("connpool_min_limit", localObject2);
/* 184 */       localProperties.put("connpool_max_limit", str2);
/* 185 */       localProperties.put("connpool_increment", localObject3);
/* 186 */       localProperties.put("connpool_active_size", str3);
/*     */ 
/* 188 */       localProperties.put("connpool_pool_size", str4);
/* 189 */       localProperties.put("connpool_timeout", str5);
/*     */ 
/* 191 */       if (str6 == "true") {
/* 192 */         localProperties.put("connpool_nowait", str6);
/*     */       }
/*     */ 
/* 195 */       if (str7 == "true") {
/* 196 */         localProperties.put("transactions_distributed", str7);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 203 */       return null;
/*     */     }
/*     */ 
/* 206 */     if (localObject1 != null)
/*     */     {
/* 208 */       localObject2 = null;
/*     */ 
/* 210 */       if ((localObject2 = (StringRefAddr)localReference.get("url")) != null)
/*     */       {
/* 212 */         ((OracleDataSource)localObject1).setURL((String)((StringRefAddr)localObject2).getContent());
/*     */       }
/*     */ 
/* 215 */       if (((localObject2 = (StringRefAddr)localReference.get("userName")) != null) || ((localObject2 = (StringRefAddr)localReference.get("u")) != null) || ((localObject2 = (StringRefAddr)localReference.get("user")) != null))
/*     */       {
/* 218 */         ((OracleDataSource)localObject1).setUser((String)((StringRefAddr)localObject2).getContent());
/*     */       }
/*     */ 
/* 221 */       if (((localObject2 = (StringRefAddr)localReference.get("passWord")) != null) || ((localObject2 = (StringRefAddr)localReference.get("password")) != null))
/*     */       {
/* 223 */         ((OracleDataSource)localObject1).setPassword((String)((StringRefAddr)localObject2).getContent());
/*     */       }
/*     */ 
/* 226 */       if (((localObject2 = (StringRefAddr)localReference.get("description")) != null) || ((localObject2 = (StringRefAddr)localReference.get("describe")) != null))
/*     */       {
/* 228 */         ((OracleDataSource)localObject1).setDescription((String)((StringRefAddr)localObject2).getContent());
/*     */       }
/*     */ 
/* 231 */       if (((localObject2 = (StringRefAddr)localReference.get("driverType")) != null) || ((localObject2 = (StringRefAddr)localReference.get("driver")) != null))
/*     */       {
/* 233 */         ((OracleDataSource)localObject1).setDriverType((String)((StringRefAddr)localObject2).getContent());
/*     */       }
/*     */ 
/* 236 */       if (((localObject2 = (StringRefAddr)localReference.get("serverName")) != null) || ((localObject2 = (StringRefAddr)localReference.get("host")) != null))
/*     */       {
/* 238 */         ((OracleDataSource)localObject1).setServerName((String)((StringRefAddr)localObject2).getContent());
/*     */       }
/*     */ 
/* 241 */       if (((localObject2 = (StringRefAddr)localReference.get("databaseName")) != null) || ((localObject2 = (StringRefAddr)localReference.get("sid")) != null))
/*     */       {
/* 243 */         ((OracleDataSource)localObject1).setDatabaseName((String)((StringRefAddr)localObject2).getContent());
/*     */       }
/*     */ 
/* 246 */       if ((localObject2 = (StringRefAddr)localReference.get("serviceName")) != null) {
/* 247 */         ((OracleDataSource)localObject1).setServiceName((String)((StringRefAddr)localObject2).getContent());
/*     */       }
/*     */ 
/* 250 */       if (((localObject2 = (StringRefAddr)localReference.get("networkProtocol")) != null) || ((localObject2 = (StringRefAddr)localReference.get("protocol")) != null))
/*     */       {
/* 252 */         ((OracleDataSource)localObject1).setNetworkProtocol((String)((StringRefAddr)localObject2).getContent());
/*     */       }
/*     */ 
/* 255 */       if (((localObject2 = (StringRefAddr)localReference.get("portNumber")) != null) || ((localObject2 = (StringRefAddr)localReference.get("port")) != null))
/*     */       {
/* 257 */         str2 = (String)((StringRefAddr)localObject2).getContent();
/*     */ 
/* 259 */         ((OracleDataSource)localObject1).setPortNumber(Integer.parseInt(str2));
/*     */       }
/*     */ 
/* 262 */       if (((localObject2 = (StringRefAddr)localReference.get("tnsentryname")) != null) || ((localObject2 = (StringRefAddr)localReference.get("tns")) != null))
/*     */       {
/* 264 */         ((OracleDataSource)localObject1).setTNSEntryName((String)((StringRefAddr)localObject2).getContent());
/*     */       }
/* 266 */       else if (str1.equals("oracle.jdbc.pool.OracleOCIConnectionPool"))
/*     */       {
/* 281 */         str2 = null;
/*     */ 
/* 283 */         if ((localObject2 = (StringRefAddr)localReference.get("connpool_is_poolcreated")) != null)
/*     */         {
/* 285 */           str2 = (String)((StringRefAddr)localObject2).getContent();
/*     */         }
/*     */ 
/* 288 */         if (str2.equals(String.valueOf("true"))) {
/* 289 */           ((OracleOCIConnectionPool)localObject1).setPoolConfig(localProperties);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 294 */     return localObject1;
/*     */   }
/*     */ 
/*     */   private Properties extractConnectionCacheProperties(String paramString)
/*     */     throws SQLException
/*     */   {
/* 315 */     Properties localProperties = new Properties();
/*     */ 
/* 318 */     paramString = paramString.substring(1, paramString.length() - 1);
/*     */ 
/* 321 */     int i = paramString.indexOf("AttributeWeights", 0);
/*     */     String str1;
/*     */     String str3;
/* 323 */     if (i >= 0)
/*     */     {
/* 332 */       if ((paramString.charAt(i + 16) != '=') || ((i > 0) && (paramString.charAt(i - 1) != ' ')))
/*     */       {
/* 336 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 139);
/*     */ 
/* 338 */         ((SQLException)localObject1).fillInStackTrace();
/* 339 */         throw ((Throwable)localObject1);
/*     */       }
/*     */ 
/* 343 */       localObject1 = new Properties();
/* 344 */       int j = paramString.indexOf("}", i);
/* 345 */       str1 = paramString.substring(i, j);
/*     */ 
/* 348 */       String str2 = str1.substring(18);
/*     */ 
/* 350 */       StringTokenizer localStringTokenizer = new StringTokenizer(str2, ", ");
/*     */ 
/* 353 */       synchronized (localStringTokenizer)
/*     */       {
/* 355 */         while (localStringTokenizer.hasMoreTokens())
/*     */         {
/* 357 */           str3 = localStringTokenizer.nextToken();
/* 358 */           int n = str3.length();
/* 359 */           int i1 = str3.indexOf("=");
/*     */ 
/* 361 */           String str4 = str3.substring(0, i1);
/* 362 */           String str5 = str3.substring(i1 + 1, n);
/*     */ 
/* 364 */           ((Properties)localObject1).setProperty(str4, str5);
/*     */         }
/*     */       }
/*     */ 
/* 368 */       localProperties.put("AttributeWeights", localObject1);
/*     */ 
/* 371 */       if ((i > 0) && (j + 1 == paramString.length()))
/*     */       {
/* 373 */         paramString = paramString.substring(0, i - 2);
/*     */       }
/* 375 */       else if ((i > 0) && (j + 1 < paramString.length()))
/*     */       {
/* 377 */         ??? = paramString.substring(0, i - 2);
/* 378 */         str3 = paramString.substring(j + 1, paramString.length());
/*     */ 
/* 380 */         paramString = ((String)???).concat(str3);
/*     */       }
/*     */       else
/*     */       {
/* 384 */         paramString = paramString.substring(j + 2, paramString.length());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 389 */     Object localObject1 = new StringTokenizer(paramString, ", ");
/*     */ 
/* 391 */     synchronized (localObject1)
/*     */     {
/* 393 */       while (((StringTokenizer)localObject1).hasMoreTokens())
/*     */       {
/* 395 */         str1 = ((StringTokenizer)localObject1).nextToken();
/* 396 */         int k = str1.length();
/* 397 */         int m = str1.indexOf("=");
/*     */ 
/* 399 */         ??? = str1.substring(0, m);
/* 400 */         str3 = str1.substring(m + 1, k);
/*     */ 
/* 402 */         localProperties.setProperty((String)???, str3);
/*     */       }
/*     */     }
/* 405 */     return localProperties;
/*     */   }
/*     */ 
/*     */   private Properties extractConnectionProperties(String paramString)
/*     */     throws SQLException
/*     */   {
/* 414 */     Properties localProperties = new Properties();
/*     */ 
/* 417 */     paramString = paramString.substring(1, paramString.length() - 1);
/*     */ 
/* 419 */     String[] arrayOfString1 = paramString.split(";");
/*     */ 
/* 421 */     for (String str1 : arrayOfString1) {
/* 422 */       int k = str1.length();
/* 423 */       int m = str1.indexOf("=");
/*     */ 
/* 425 */       if ((k == 0) || (m <= 0))
/*     */       {
/* 427 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 190);
/*     */ 
/* 429 */         ((SQLException)localObject).fillInStackTrace();
/* 430 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 434 */       Object localObject = str1.substring(0, m);
/* 435 */       String str2 = str1.substring(m + 1, k);
/*     */ 
/* 437 */       localProperties.setProperty(((String)localObject).trim(), str2.trim());
/*     */     }
/* 439 */     return localProperties;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 454 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.pool.OracleDataSourceFactory
 * JD-Core Version:    0.6.2
 */