/*      */ package oracle.jdbc.pool;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.io.ObjectOutputStream;
/*      */ import java.io.PrintWriter;
/*      */ import java.io.Serializable;
/*      */ import java.sql.Connection;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLWarning;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Properties;
/*      */ import javax.naming.NamingException;
/*      */ import javax.naming.Reference;
/*      */ import javax.naming.Referenceable;
/*      */ import javax.naming.StringRefAddr;
/*      */ import javax.sql.DataSource;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.driver.OracleDriver;
/*      */ 
/*      */ public class OracleDataSource
/*      */   implements DataSource, Serializable, Referenceable
/*      */ {
/*      */   static final long serialVersionUID = 3349652938965166731L;
/*   50 */   protected PrintWriter logWriter = null;
/*   51 */   protected int loginTimeout = 0;
/*      */ 
/*   54 */   protected String databaseName = null;
/*   55 */   protected String serviceName = null;
/*   56 */   protected String dataSourceName = "OracleDataSource";
/*   57 */   protected String description = null;
/*   58 */   protected String networkProtocol = "tcp";
/*   59 */   protected int portNumber = 0;
/*   60 */   protected String user = null;
/*   61 */   protected String password = null;
/*   62 */   protected String serverName = null;
/*   63 */   protected String url = null;
/*   64 */   protected String driverType = null;
/*   65 */   protected String tnsEntry = null;
/*   66 */   protected int maxStatements = 0;
/*   67 */   protected boolean implicitCachingEnabled = false;
/*   68 */   protected boolean explicitCachingEnabled = false;
/*      */ 
/*   70 */   protected transient OracleImplicitConnectionCache odsCache = null;
/*   71 */   protected transient OracleConnectionCacheManager cacheManager = null;
/*   72 */   protected String connCacheName = null;
/*   73 */   protected Properties connCacheProperties = null;
/*   74 */   protected Properties connectionProperties = null;
/*   75 */   protected boolean connCachingEnabled = false;
/*   76 */   protected boolean fastConnFailover = false;
/*   77 */   protected String onsConfigStr = null;
/*   78 */   public boolean isOracleDataSource = true;
/*      */ 
/*   97 */   private static final boolean fastConnectionFailoverSysProperty = "true".equalsIgnoreCase(OracleDriver.getSystemPropertyFastConnectionFailover("false"));
/*      */ 
/*  101 */   private boolean urlExplicit = false;
/*  102 */   private boolean useDefaultConnection = false;
/*  103 */   protected transient OracleDriver driver = new OracleDriver();
/*      */   private static final String spawnNewThreadToCancelProperty = "oracle.jdbc.spawnNewThreadToCancel";
/* 1923 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public OracleDataSource()
/*      */     throws SQLException
/*      */   {
/*  113 */     processFastConnectionFailoverSysProperty();
/*      */   }
/*      */ 
/*      */   void processFastConnectionFailoverSysProperty()
/*      */   {
/*  121 */     if ((this.isOracleDataSource) && (fastConnectionFailoverSysProperty))
/*      */     {
/*  125 */       this.connCachingEnabled = true;
/*      */ 
/*  128 */       if (this.cacheManager == null)
/*      */       {
/*      */         try
/*      */         {
/*  132 */           this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
/*      */         }
/*      */         catch (SQLException localSQLException)
/*      */         {
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  142 */       this.fastConnFailover = true;
/*  143 */       setSpawnNewThreadToCancel(true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Connection getConnection()
/*      */     throws SQLException
/*      */   {
/*  162 */     String str1 = null;
/*  163 */     String str2 = null;
/*  164 */     synchronized (this)
/*      */     {
/*  166 */       str1 = this.user;
/*  167 */       str2 = this.password;
/*      */     }
/*  169 */     return getConnection(str1, str2);
/*      */   }
/*      */ 
/*      */   public Connection getConnection(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/*  191 */     Connection localConnection = null;
/*  192 */     Properties localProperties = null;
/*  193 */     if (this.connCachingEnabled)
/*      */     {
/*  196 */       localConnection = getConnection(paramString1, paramString2, null);
/*      */     }
/*      */     else
/*      */     {
/*  200 */       synchronized (this)
/*      */       {
/*  202 */         makeURL();
/*      */ 
/*  204 */         localProperties = this.connectionProperties == null ? new Properties() : (Properties)this.connectionProperties.clone();
/*      */ 
/*  211 */         if (this.url != null)
/*  212 */           localProperties.setProperty("connection_url", this.url);
/*  213 */         if (paramString1 != null)
/*  214 */           localProperties.setProperty("user", paramString1);
/*  215 */         if (paramString2 != null)
/*  216 */           localProperties.setProperty("password", paramString2);
/*  217 */         if (this.loginTimeout != 0) {
/*  218 */           localProperties.setProperty("LoginTimeout", "" + this.loginTimeout);
/*      */         }
/*  220 */         if (this.maxStatements != 0) {
/*  221 */           localProperties.setProperty("stmt_cache_size", "" + this.maxStatements);
/*      */         }
/*      */       }
/*  224 */       localConnection = getPhysicalConnection(localProperties);
/*  225 */       if (localConnection == null)
/*      */       {
/*  227 */         ??? = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 67);
/*  228 */         ((SQLException)???).fillInStackTrace();
/*  229 */         throw ((Throwable)???);
/*      */       }
/*      */     }
/*  232 */     return localConnection;
/*      */   }
/*      */ 
/*      */   protected Connection getPhysicalConnection(Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  240 */     Connection localConnection = null;
/*  241 */     Properties localProperties = paramProperties;
/*  242 */     String str1 = paramProperties.getProperty("connection_url");
/*  243 */     String str2 = paramProperties.getProperty("user");
/*  244 */     String str3 = localProperties.getProperty("password");
/*  245 */     String str4 = null;
/*  246 */     boolean bool1 = false;
/*      */ 
/*  250 */     synchronized (this)
/*      */     {
/*  256 */       if (this.connectionProperties != null)
/*      */       {
/*  258 */         localProperties = (Properties)this.connectionProperties.clone();
/*      */ 
/*  260 */         if (str2 != null) {
/*  261 */           localProperties.put("user", str2);
/*      */         }
/*  263 */         if (str3 != null)
/*  264 */           localProperties.put("password", str3);
/*      */       }
/*  266 */       if ((str2 == null) && (this.user != null))
/*  267 */         localProperties.put("user", this.user);
/*  268 */       if ((str3 == null) && (this.password != null)) {
/*  269 */         localProperties.put("password", this.password);
/*      */       }
/*  271 */       if (str1 == null) {
/*  272 */         str1 = this.url;
/*      */       }
/*  274 */       String str5 = paramProperties.getProperty("LoginTimeout");
/*      */ 
/*  276 */       if (str5 != null) {
/*  277 */         localProperties.put("oracle.net.CONNECT_TIMEOUT", "" + Integer.parseInt(str5) * 1000);
/*      */       }
/*      */ 
/*  280 */       bool1 = this.useDefaultConnection;
/*      */ 
/*  282 */       if (this.driver == null) {
/*  283 */         this.driver = new OracleDriver();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  291 */     if (bool1)
/*      */     {
/*  293 */       localConnection = this.driver.defaultConnection();
/*      */     }
/*      */     else
/*      */     {
/*  297 */       localConnection = this.driver.connect(str1, localProperties);
/*      */     }
/*      */ 
/*  300 */     if (localConnection == null)
/*      */     {
/*  302 */       ??? = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 67);
/*  303 */       ((SQLException)???).fillInStackTrace();
/*  304 */       throw ((Throwable)???);
/*      */     }
/*      */ 
/*  309 */     str4 = paramProperties.getProperty("stmt_cache_size");
/*      */ 
/*  311 */     int i = 0;
/*  312 */     if (str4 != null) {
/*  313 */       ((oracle.jdbc.OracleConnection)localConnection).setStatementCacheSize(i = Integer.parseInt(str4));
/*      */     }
/*      */ 
/*  316 */     boolean bool2 = false;
/*  317 */     str4 = paramProperties.getProperty("ExplicitStatementCachingEnabled");
/*      */ 
/*  319 */     if (str4 != null) {
/*  320 */       ((oracle.jdbc.OracleConnection)localConnection).setExplicitCachingEnabled(bool2 = str4.equals("true"));
/*      */     }
/*      */ 
/*  323 */     boolean bool3 = false;
/*  324 */     str4 = paramProperties.getProperty("ImplicitStatementCachingEnabled");
/*      */ 
/*  326 */     if (str4 != null)
/*      */     {
/*  328 */       ((oracle.jdbc.OracleConnection)localConnection).setImplicitCachingEnabled(bool3 = str4.equals("true"));
/*      */     }
/*      */ 
/*  333 */     if ((i > 0) && (!bool2) && (!bool3))
/*      */     {
/*  337 */       ((oracle.jdbc.OracleConnection)localConnection).setImplicitCachingEnabled(true);
/*  338 */       ((oracle.jdbc.OracleConnection)localConnection).setExplicitCachingEnabled(true);
/*      */     }
/*  340 */     return localConnection;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Connection getConnection(Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  364 */     String str1 = null;
/*  365 */     String str2 = null;
/*  366 */     synchronized (this)
/*      */     {
/*  368 */       if (!this.connCachingEnabled)
/*      */       {
/*  371 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 137);
/*      */ 
/*  373 */         localSQLException.fillInStackTrace();
/*  374 */         throw localSQLException;
/*      */       }
/*      */ 
/*  377 */       str1 = this.user;
/*  378 */       str2 = this.password;
/*      */     }
/*      */ 
/*  381 */     ??? = getConnection(str1, str2, paramProperties);
/*      */ 
/*  383 */     return ???;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Connection getConnection(String paramString1, String paramString2, Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  406 */     if (!this.connCachingEnabled)
/*      */     {
/*  409 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 137);
/*  410 */       ((SQLException)localObject).fillInStackTrace();
/*  411 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/*  419 */     if (this.odsCache == null) {
/*  420 */       cacheInitialize();
/*      */     }
/*  422 */     Object localObject = this.odsCache.getConnection(paramString1, paramString2, paramProperties);
/*      */ 
/*  424 */     return localObject;
/*      */   }
/*      */ 
/*      */   private synchronized void cacheInitialize()
/*      */     throws SQLException
/*      */   {
/*  436 */     if (this.odsCache == null)
/*      */     {
/*  438 */       if (this.connCacheName != null)
/*  439 */         this.cacheManager.createCache(this.connCacheName, this, this.connCacheProperties);
/*      */       else
/*  441 */         this.connCacheName = this.cacheManager.createCache(this, this.connCacheProperties);
/*      */     }
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public synchronized void close()
/*      */     throws SQLException
/*      */   {
/*  463 */     if ((this.connCachingEnabled) && (this.odsCache != null))
/*      */     {
/*  465 */       this.cacheManager.removeCache(this.odsCache.cacheName, 0L);
/*      */ 
/*  467 */       this.odsCache = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public synchronized void setConnectionCachingEnabled(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  490 */     if (this.isOracleDataSource)
/*      */     {
/*  492 */       if (paramBoolean)
/*      */       {
/*  494 */         this.connCachingEnabled = true;
/*      */ 
/*  496 */         if (this.cacheManager == null)
/*      */         {
/*  498 */           this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
/*      */         }
/*      */ 
/*      */       }
/*  507 */       else if (this.odsCache == null)
/*      */       {
/*  509 */         this.connCachingEnabled = false;
/*  510 */         this.fastConnFailover = false;
/*  511 */         setSpawnNewThreadToCancel(false);
/*  512 */         this.connCacheName = null;
/*  513 */         this.connCacheProperties = null;
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  526 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 137);
/*  527 */       localSQLException.fillInStackTrace();
/*  528 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean getConnectionCachingEnabled()
/*      */     throws SQLException
/*      */   {
/*  552 */     return this.connCachingEnabled;
/*      */   }
/*      */ 
/*      */   public synchronized void setConnectionCacheName(String paramString)
/*      */     throws SQLException
/*      */   {
/*  572 */     if (paramString == null)
/*      */     {
/*  575 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 138);
/*  576 */       localSQLException.fillInStackTrace();
/*  577 */       throw localSQLException;
/*      */     }
/*      */ 
/*  582 */     this.connCacheName = paramString;
/*      */   }
/*      */ 
/*      */   public String getConnectionCacheName()
/*      */     throws SQLException
/*      */   {
/*  605 */     if ((this.connCachingEnabled) && (this.odsCache != null)) {
/*  606 */       return this.odsCache.cacheName;
/*      */     }
/*  608 */     return this.connCacheName;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public synchronized void setConnectionCacheProperties(Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  694 */     this.connCacheProperties = paramProperties;
/*      */   }
/*      */ 
/*      */   public Properties getConnectionCacheProperties()
/*      */     throws SQLException
/*      */   {
/*  716 */     if ((this.connCachingEnabled) && (this.odsCache != null)) {
/*  717 */       return this.odsCache.getConnectionCacheProperties();
/*      */     }
/*  719 */     return this.connCacheProperties;
/*      */   }
/*      */ 
/*      */   public synchronized void setFastConnectionFailoverEnabled(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  749 */     if (!this.fastConnFailover)
/*      */     {
/*  751 */       this.fastConnFailover = paramBoolean;
/*  752 */       setSpawnNewThreadToCancel(paramBoolean);
/*  753 */     } else if (!paramBoolean)
/*      */     {
/*  757 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 255);
/*  758 */       localSQLException.fillInStackTrace();
/*  759 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean getFastConnectionFailoverEnabled()
/*      */     throws SQLException
/*      */   {
/*  782 */     return this.fastConnFailover;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public String getONSConfiguration()
/*      */     throws SQLException
/*      */   {
/*  804 */     return this.onsConfigStr;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public synchronized void setONSConfiguration(String paramString)
/*      */     throws SQLException
/*      */   {
/*  841 */     this.onsConfigStr = paramString;
/*      */   }
/*      */ 
/*      */   public synchronized int getLoginTimeout()
/*      */   {
/*  865 */     return this.loginTimeout;
/*      */   }
/*      */ 
/*      */   public synchronized void setLoginTimeout(int paramInt)
/*      */   {
/*  888 */     this.loginTimeout = paramInt;
/*      */   }
/*      */ 
/*      */   public synchronized void setLogWriter(PrintWriter paramPrintWriter)
/*      */   {
/*  917 */     this.logWriter = paramPrintWriter;
/*      */   }
/*      */ 
/*      */   public synchronized PrintWriter getLogWriter()
/*      */   {
/*  946 */     return this.logWriter;
/*      */   }
/*      */ 
/*      */   public synchronized void setTNSEntryName(String paramString)
/*      */   {
/*  966 */     this.tnsEntry = paramString;
/*      */   }
/*      */ 
/*      */   public synchronized String getTNSEntryName()
/*      */   {
/*  985 */     return this.tnsEntry;
/*      */   }
/*      */ 
/*      */   public synchronized void setDataSourceName(String paramString)
/*      */   {
/* 1005 */     this.dataSourceName = paramString;
/*      */   }
/*      */ 
/*      */   public synchronized String getDataSourceName()
/*      */   {
/* 1024 */     return this.dataSourceName;
/*      */   }
/*      */ 
/*      */   public synchronized String getDatabaseName()
/*      */   {
/* 1041 */     return this.databaseName;
/*      */   }
/*      */ 
/*      */   public synchronized void setDatabaseName(String paramString)
/*      */   {
/* 1060 */     this.databaseName = paramString;
/*      */   }
/*      */ 
/*      */   public synchronized void setServiceName(String paramString)
/*      */   {
/* 1083 */     this.serviceName = paramString;
/*      */   }
/*      */ 
/*      */   public synchronized String getServiceName()
/*      */   {
/* 1105 */     return this.serviceName;
/*      */   }
/*      */ 
/*      */   public synchronized void setServerName(String paramString)
/*      */   {
/* 1123 */     this.serverName = paramString;
/*      */   }
/*      */ 
/*      */   public synchronized String getServerName()
/*      */   {
/* 1140 */     return this.serverName;
/*      */   }
/*      */ 
/*      */   public synchronized void setURL(String paramString)
/*      */   {
/* 1159 */     this.url = paramString;
/*      */ 
/* 1161 */     if (this.url != null) {
/* 1162 */       this.urlExplicit = true;
/*      */     }
/* 1164 */     if ((this.connCachingEnabled) && (this.odsCache != null) && (this.odsCache.connectionPoolDS != null))
/*      */     {
/* 1166 */       this.odsCache.connectionPoolDS.url = paramString;
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized String getURL()
/*      */     throws SQLException
/*      */   {
/* 1186 */     if (!this.urlExplicit)
/* 1187 */       makeURL();
/* 1188 */     return this.url;
/*      */   }
/*      */ 
/*      */   public synchronized void setUser(String paramString)
/*      */   {
/* 1205 */     this.user = paramString;
/*      */   }
/*      */ 
/*      */   public String getUser()
/*      */   {
/* 1221 */     return this.user;
/*      */   }
/*      */ 
/*      */   public synchronized void setPassword(String paramString)
/*      */   {
/* 1239 */     this.password = paramString;
/*      */   }
/*      */ 
/*      */   protected String getPassword()
/*      */   {
/* 1246 */     return this.password;
/*      */   }
/*      */ 
/*      */   public synchronized String getDescription()
/*      */   {
/* 1263 */     return this.description;
/*      */   }
/*      */ 
/*      */   public synchronized void setDescription(String paramString)
/*      */   {
/* 1280 */     this.description = paramString;
/*      */   }
/*      */ 
/*      */   public synchronized String getDriverType()
/*      */   {
/* 1298 */     return this.driverType;
/*      */   }
/*      */ 
/*      */   public synchronized void setDriverType(String paramString)
/*      */   {
/* 1323 */     this.driverType = paramString;
/*      */   }
/*      */ 
/*      */   public synchronized String getNetworkProtocol()
/*      */   {
/* 1341 */     return this.networkProtocol;
/*      */   }
/*      */ 
/*      */   public synchronized void setNetworkProtocol(String paramString)
/*      */   {
/* 1360 */     this.networkProtocol = paramString;
/*      */   }
/*      */ 
/*      */   public synchronized void setPortNumber(int paramInt)
/*      */   {
/* 1378 */     this.portNumber = paramInt;
/*      */   }
/*      */ 
/*      */   public synchronized int getPortNumber()
/*      */   {
/* 1395 */     return this.portNumber;
/*      */   }
/*      */ 
/*      */   public synchronized Reference getReference()
/*      */     throws NamingException
/*      */   {
/* 1410 */     Reference localReference = new Reference(getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
/*      */ 
/* 1412 */     addRefProperties(localReference);
/* 1413 */     return localReference;
/*      */   }
/*      */ 
/*      */   protected void addRefProperties(Reference paramReference)
/*      */   {
/* 1421 */     if (this.url != null) {
/* 1422 */       paramReference.add(new StringRefAddr("url", this.url));
/*      */     }
/* 1424 */     if (this.user != null) {
/* 1425 */       paramReference.add(new StringRefAddr("userName", this.user));
/*      */     }
/* 1427 */     if (this.password != null) {
/* 1428 */       paramReference.add(new StringRefAddr("passWord", this.password));
/*      */     }
/* 1430 */     if (this.description != null) {
/* 1431 */       paramReference.add(new StringRefAddr("description", this.description));
/*      */     }
/* 1433 */     if (this.driverType != null) {
/* 1434 */       paramReference.add(new StringRefAddr("driverType", this.driverType));
/*      */     }
/* 1436 */     if (this.serverName != null) {
/* 1437 */       paramReference.add(new StringRefAddr("serverName", this.serverName));
/*      */     }
/* 1439 */     if (this.databaseName != null) {
/* 1440 */       paramReference.add(new StringRefAddr("databaseName", this.databaseName));
/*      */     }
/* 1442 */     if (this.serviceName != null) {
/* 1443 */       paramReference.add(new StringRefAddr("serviceName", this.serviceName));
/*      */     }
/* 1445 */     if (this.networkProtocol != null) {
/* 1446 */       paramReference.add(new StringRefAddr("networkProtocol", this.networkProtocol));
/*      */     }
/* 1448 */     if (this.portNumber != 0) {
/* 1449 */       paramReference.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
/*      */     }
/* 1451 */     if (this.tnsEntry != null) {
/* 1452 */       paramReference.add(new StringRefAddr("tnsentryname", this.tnsEntry));
/*      */     }
/* 1454 */     if (this.maxStatements != 0) {
/* 1455 */       paramReference.add(new StringRefAddr("maxStatements", Integer.toString(this.maxStatements)));
/*      */     }
/*      */ 
/* 1458 */     if (this.implicitCachingEnabled) {
/* 1459 */       paramReference.add(new StringRefAddr("implicitCachingEnabled", "true"));
/*      */     }
/* 1461 */     if (this.explicitCachingEnabled) {
/* 1462 */       paramReference.add(new StringRefAddr("explicitCachingEnabled", "true"));
/*      */     }
/*      */ 
/* 1466 */     if (this.connCachingEnabled) {
/* 1467 */       paramReference.add(new StringRefAddr("connectionCachingEnabled", "true"));
/*      */     }
/* 1469 */     if (this.connCacheName != null) {
/* 1470 */       paramReference.add(new StringRefAddr("connectionCacheName", this.connCacheName));
/*      */     }
/* 1472 */     if (this.connCacheProperties != null) {
/* 1473 */       paramReference.add(new StringRefAddr("connectionCacheProperties", this.connCacheProperties.toString()));
/*      */     }
/*      */ 
/* 1476 */     if (this.fastConnFailover) {
/* 1477 */       paramReference.add(new StringRefAddr("fastConnectionFailoverEnabled", "true"));
/*      */     }
/* 1479 */     if (this.onsConfigStr != null)
/* 1480 */       paramReference.add(new StringRefAddr("onsConfigStr", this.onsConfigStr));
/*      */   }
/*      */ 
/*      */   void makeURL()
/*      */     throws SQLException
/*      */   {
/* 1490 */     if (this.urlExplicit)
/*      */       return;
/*      */     SQLException localSQLException;
/* 1494 */     if ((this.driverType == null) || ((!this.driverType.equals("oci8")) && (!this.driverType.equals("oci")) && (!this.driverType.equals("thin")) && (!this.driverType.equals("kprb"))))
/*      */     {
/* 1498 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 67, "OracleDataSource.makeURL");
/* 1499 */       localSQLException.fillInStackTrace();
/* 1500 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1505 */     if (this.driverType.equals("kprb"))
/*      */     {
/* 1507 */       this.useDefaultConnection = true;
/* 1508 */       this.url = "jdbc:oracle:kprb:@";
/*      */ 
/* 1511 */       return;
/*      */     }
/*      */ 
/* 1516 */     if (((this.driverType.equals("oci8")) || (this.driverType.equals("oci"))) && (this.networkProtocol != null) && (this.networkProtocol.equals("ipc")))
/*      */     {
/* 1519 */       this.url = "jdbc:oracle:oci:@";
/*      */ 
/* 1522 */       return;
/*      */     }
/*      */ 
/* 1526 */     if (this.tnsEntry != null)
/*      */     {
/* 1528 */       this.url = ("jdbc:oracle:" + this.driverType + ":@" + this.tnsEntry);
/*      */ 
/* 1531 */       return;
/*      */     }
/*      */ 
/* 1535 */     if (this.serviceName != null)
/*      */     {
/* 1537 */       this.url = ("jdbc:oracle:" + this.driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.networkProtocol + ")(PORT=" + this.portNumber + ")(HOST=" + this.serverName + "))(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")))");
/*      */     }
/*      */     else
/*      */     {
/* 1543 */       this.url = ("jdbc:oracle:" + this.driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.networkProtocol + ")(PORT=" + this.portNumber + ")(HOST=" + this.serverName + "))(CONNECT_DATA=(SID=" + this.databaseName + ")))");
/*      */ 
/* 1550 */       DatabaseError.addSqlWarning(null, new SQLWarning("URL with SID jdbc:subprotocol:@host:port:sid will be deprecated in 10i\nPlease use URL with SERVICE_NAME as jdbc:subprotocol:@//host:port/service_name"));
/*      */ 
/* 1560 */       if (this.fastConnFailover)
/*      */       {
/* 1563 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 67, "OracleDataSource.makeURL");
/* 1564 */         localSQLException.fillInStackTrace();
/* 1565 */         throw localSQLException;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void trace(String paramString)
/*      */   {
/* 1579 */     if (this.logWriter != null);
/*      */   }
/*      */ 
/*      */   protected void copy(OracleDataSource paramOracleDataSource)
/*      */     throws SQLException
/*      */   {
/* 1589 */     paramOracleDataSource.setUser(this.user);
/* 1590 */     paramOracleDataSource.setPassword(this.password);
/* 1591 */     paramOracleDataSource.setTNSEntryName(this.tnsEntry);
/* 1592 */     makeURL();
/* 1593 */     paramOracleDataSource.setURL(this.url);
/* 1594 */     if (this.loginTimeout > 0)
/* 1595 */       paramOracleDataSource.setLoginTimeout(this.loginTimeout);
/* 1596 */     paramOracleDataSource.connectionProperties = this.connectionProperties;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public void setMaxStatements(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1626 */     this.maxStatements = paramInt;
/*      */   }
/*      */ 
/*      */   public int getMaxStatements()
/*      */     throws SQLException
/*      */   {
/* 1643 */     return this.maxStatements;
/*      */   }
/*      */ 
/*      */   public void setImplicitCachingEnabled(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1666 */     this.implicitCachingEnabled = paramBoolean;
/*      */   }
/*      */ 
/*      */   public boolean getImplicitCachingEnabled()
/*      */     throws SQLException
/*      */   {
/* 1683 */     return this.implicitCachingEnabled;
/*      */   }
/*      */ 
/*      */   public void setExplicitCachingEnabled(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1707 */     this.explicitCachingEnabled = paramBoolean;
/*      */   }
/*      */ 
/*      */   public boolean getExplicitCachingEnabled()
/*      */     throws SQLException
/*      */   {
/* 1724 */     return this.explicitCachingEnabled;
/*      */   }
/*      */ 
/*      */   public void setConnectionProperties(Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/* 1750 */     if (paramProperties == null) this.connectionProperties = paramProperties; else
/* 1751 */       this.connectionProperties = ((Properties)paramProperties.clone());
/* 1752 */     setSpawnNewThreadToCancel(this.fastConnFailover);
/*      */   }
/*      */ 
/*      */   public Properties getConnectionProperties()
/*      */     throws SQLException
/*      */   {
/* 1769 */     return filterConnectionProperties(this.connectionProperties);
/*      */   }
/*      */ 
/*      */   public static final Properties filterConnectionProperties(Properties paramProperties)
/*      */   {
/* 1781 */     Properties localProperties = null;
/*      */ 
/* 1784 */     if (paramProperties != null)
/*      */     {
/* 1786 */       localProperties = (Properties)paramProperties.clone();
/* 1787 */       Enumeration localEnumeration = localProperties.propertyNames();
/* 1788 */       Object localObject = null;
/* 1789 */       while (localEnumeration.hasMoreElements())
/*      */       {
/* 1791 */         String str = (String)localEnumeration.nextElement();
/* 1792 */         if ((str != null) && (str.matches(".*[P,p][A,a][S,s][S,s][W,w][O,o][R,r][D,d].*")))
/*      */         {
/* 1794 */           localProperties.remove(str);
/*      */         }
/*      */       }
/* 1797 */       paramProperties.remove("oracle.jdbc.spawnNewThreadToCancel");
/*      */     }
/* 1799 */     return localProperties;
/*      */   }
/*      */ 
/*      */   private void setSpawnNewThreadToCancel(boolean paramBoolean)
/*      */   {
/* 1807 */     if (paramBoolean) {
/* 1808 */       if (this.connectionProperties == null) this.connectionProperties = new Properties();
/*      */ 
/* 1810 */       this.connectionProperties.setProperty("oracle.jdbc.spawnNewThreadToCancel", "true");
/*      */     }
/* 1812 */     else if (this.connectionProperties != null) {
/* 1813 */       this.connectionProperties.remove("oracle.jdbc.spawnNewThreadToCancel");
/*      */     }
/*      */   }
/*      */ 
/*      */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*      */     throws IOException
/*      */   {
/* 1826 */     paramObjectOutputStream.defaultWriteObject();
/*      */   }
/*      */ 
/*      */   private void readObject(ObjectInputStream paramObjectInputStream)
/*      */     throws IOException, ClassNotFoundException, SQLException
/*      */   {
/* 1842 */     paramObjectInputStream.defaultReadObject();
/*      */ 
/* 1846 */     if (this.connCachingEnabled)
/* 1847 */       setConnectionCachingEnabled(this.connCachingEnabled);
/*      */   }
/*      */ 
/*      */   public boolean isWrapperFor(Class<?> paramClass)
/*      */     throws SQLException
/*      */   {
/* 1868 */     if (paramClass.isInterface()) return paramClass.isInstance(this);
/*      */ 
/* 1870 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 1871 */     localSQLException.fillInStackTrace();
/* 1872 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public <T> T unwrap(Class<T> paramClass)
/*      */     throws SQLException
/*      */   {
/* 1894 */     if ((paramClass.isInterface()) && (paramClass.isInstance(this))) return this;
/*      */ 
/* 1896 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 1897 */     localSQLException.fillInStackTrace();
/* 1898 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1918 */     return null;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.pool.OracleDataSource
 * JD-Core Version:    0.6.2
 */