/*     */ package oracle.jdbc.pool;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Properties;
/*     */ import javax.sql.ConnectionPoolDataSource;
/*     */ import javax.sql.PooledConnection;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ public class OracleConnectionPoolDataSource extends OracleDataSource
/*     */   implements ConnectionPoolDataSource
/*     */ {
/* 169 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleConnectionPoolDataSource()
/*     */     throws SQLException
/*     */   {
/*  45 */     this.dataSourceName = "OracleConnectionPoolDataSource";
/*  46 */     this.isOracleDataSource = false;
/*     */ 
/*  49 */     this.connCachingEnabled = false;
/*     */ 
/*  52 */     this.fastConnFailover = false;
/*     */   }
/*     */ 
/*     */   public PooledConnection getPooledConnection()
/*     */     throws SQLException
/*     */   {
/*  72 */     String str1 = null;
/*  73 */     String str2 = null;
/*  74 */     synchronized (this)
/*     */     {
/*  76 */       str1 = this.user;
/*  77 */       str2 = this.password;
/*     */     }
/*  79 */     return getPooledConnection(str1, str2);
/*     */   }
/*     */ 
/*     */   public PooledConnection getPooledConnection(String paramString1, String paramString2)
/*     */     throws SQLException
/*     */   {
/* 102 */     Connection localConnection = getPhysicalConnection(paramString1, paramString2);
/* 103 */     OraclePooledConnection localOraclePooledConnection = new OraclePooledConnection(localConnection);
/*     */ 
/* 106 */     if (paramString2 == null)
/* 107 */       paramString2 = this.password;
/* 108 */     localOraclePooledConnection.setUserName(!paramString1.startsWith("\"") ? paramString1.toLowerCase() : paramString1, paramString2);
/*     */ 
/* 111 */     return localOraclePooledConnection;
/*     */   }
/*     */ 
/*     */   PooledConnection getPooledConnection(Properties paramProperties)
/*     */     throws SQLException
/*     */   {
/* 119 */     Connection localConnection = getPhysicalConnection(paramProperties);
/* 120 */     OraclePooledConnection localOraclePooledConnection = new OraclePooledConnection(localConnection);
/*     */ 
/* 122 */     String str1 = paramProperties.getProperty("user");
/* 123 */     if (str1 == null)
/* 124 */       str1 = ((OracleConnection)localConnection).getUserName();
/* 125 */     String str2 = paramProperties.getProperty("password");
/* 126 */     if (str2 == null)
/* 127 */       str2 = this.password;
/* 128 */     localOraclePooledConnection.setUserName(!str1.startsWith("\"") ? str1.toLowerCase() : str1, str2);
/*     */ 
/* 131 */     return localOraclePooledConnection;
/*     */   }
/*     */ 
/*     */   protected Connection getPhysicalConnection()
/*     */     throws SQLException
/*     */   {
/* 141 */     return super.getConnection(this.user, this.password);
/*     */   }
/*     */ 
/*     */   protected Connection getPhysicalConnection(String paramString1, String paramString2, String paramString3)
/*     */     throws SQLException
/*     */   {
/* 152 */     this.url = paramString1;
/* 153 */     return super.getConnection(paramString2, paramString3);
/*     */   }
/*     */ 
/*     */   protected Connection getPhysicalConnection(String paramString1, String paramString2)
/*     */     throws SQLException
/*     */   {
/* 164 */     return super.getConnection(paramString1, paramString2);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.pool.OracleConnectionPoolDataSource
 * JD-Core Version:    0.6.2
 */