/*      */ package oracle.jdbc.pool;
/*      */ 
/*      */ import java.io.UnsupportedEncodingException;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedActionException;
/*      */ import java.security.PrivilegedExceptionAction;
/*      */ import java.sql.SQLException;
/*      */ import java.util.Collection;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Properties;
/*      */ import java.util.Set;
/*      */ import java.util.StringTokenizer;
/*      */ import java.util.concurrent.atomic.AtomicInteger;
/*      */ import javax.sql.ConnectionPoolDataSource;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.ons.ONS;
/*      */ import oracle.ons.ONSException;
/*      */ 
/*      */ /** @deprecated */
/*      */ public class OracleConnectionCacheManager
/*      */ {
/*   57 */   private static OracleConnectionCacheManager cacheManagerInstance = null;
/*      */ 
/*   59 */   protected Hashtable m_connCache = null;
/*      */   public static final int REFRESH_INVALID_CONNECTIONS = 4096;
/*      */   public static final int REFRESH_ALL_CONNECTIONS = 8192;
/*      */   public static final String PHYSICAL_CONNECTION_CREATED_COUNT = "PhysicalConnectionCreatedCount";
/*      */   public static final String PHYSICAL_CONNECTION_CLOSED_COUNT = "PhysicalConnectionClosedCount";
/*      */   protected static final int FAILOVER_EVENT_TYPE_SERVICE = 256;
/*      */   protected static final int FAILOVER_EVENT_TYPE_HOST = 512;
/*      */   protected static final String EVENT_DELIMITER = "{} =";
/*   81 */   protected OracleFailoverEventHandlerThread failoverEventHandlerThread = null;
/*      */ 
/*   86 */   private static boolean isONSInitializedForRemoteSubscription = false;
/*      */   static final int ORAERROR_END_OF_FILE_ON_COM_CHANNEL = 3113;
/*      */   static final int ORAERROR_NOT_CONNECTED_TO_ORACLE = 3114;
/*      */   static final int ORAERROR_INIT_SHUTDOWN_IN_PROGRESS = 1033;
/*      */   static final int ORAERROR_ORACLE_NOT_AVAILABLE = 1034;
/*      */   static final int ORAERROR_IMMEDIATE_SHUTDOWN_IN_PROGRESS = 1089;
/*      */   static final int ORAERROR_SHUTDOWN_IN_PROGRESS_NO_CONN = 1090;
/*      */   static final int ORAERROR_NET_IO_EXCEPTION = 17002;
/*   99 */   protected int[] fatalErrorCodes = null;
/*  100 */   protected int failoverEnabledCacheCount = 0;
/*      */   protected static AtomicInteger UNNAMED_CACHE_COUNT;
/* 1387 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   private OracleConnectionCacheManager()
/*      */   {
/*  112 */     this.m_connCache = new Hashtable();
/*      */ 
/*  115 */     UNNAMED_CACHE_COUNT = new AtomicInteger();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static synchronized OracleConnectionCacheManager getConnectionCacheManagerInstance()
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/*  136 */       if (cacheManagerInstance == null) {
/*  137 */         cacheManagerInstance = new OracleConnectionCacheManager();
/*      */       }
/*      */     }
/*      */     catch (RuntimeException localRuntimeException)
/*      */     {
/*      */     }
/*  143 */     return cacheManagerInstance;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public String createCache(OracleDataSource paramOracleDataSource, Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  169 */     String str = null;
/*      */ 
/*  171 */     if ((paramOracleDataSource == null) || (!paramOracleDataSource.getConnectionCachingEnabled()))
/*      */     {
/*  174 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 137);
/*  175 */       localSQLException.fillInStackTrace();
/*  176 */       throw localSQLException;
/*      */     }
/*      */ 
/*  184 */     if (paramOracleDataSource.connCacheName != null)
/*      */     {
/*  186 */       str = paramOracleDataSource.connCacheName;
/*      */     }
/*      */     else
/*      */     {
/*  190 */       str = paramOracleDataSource.dataSourceName + "#0x" + Integer.toHexString(UNNAMED_CACHE_COUNT.getAndIncrement());
/*      */     }
/*      */ 
/*  195 */     createCache(str, paramOracleDataSource, paramProperties);
/*      */ 
/*  197 */     return str;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public void createCache(String paramString, OracleDataSource paramOracleDataSource, Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException1;
/*  224 */     if ((paramOracleDataSource == null) || (!paramOracleDataSource.getConnectionCachingEnabled()))
/*      */     {
/*  227 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 137);
/*  228 */       localSQLException1.fillInStackTrace();
/*  229 */       throw localSQLException1;
/*      */     }
/*      */ 
/*  233 */     if (paramString == null)
/*      */     {
/*  236 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 138);
/*  237 */       localSQLException1.fillInStackTrace();
/*  238 */       throw localSQLException1;
/*      */     }
/*      */ 
/*  243 */     if (this.m_connCache.containsKey(paramString))
/*      */     {
/*  246 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 140);
/*  247 */       localSQLException1.fillInStackTrace();
/*  248 */       throw localSQLException1;
/*      */     }
/*      */ 
/*  252 */     boolean bool = paramOracleDataSource.getFastConnectionFailoverEnabled();
/*      */ 
/*  260 */     if ((bool) && (this.failoverEventHandlerThread == null))
/*      */     {
/*  264 */       localObject1 = paramOracleDataSource.getONSConfiguration();
/*      */ 
/*  268 */       if ((localObject1 != null) && (!((String)localObject1).equals("")))
/*      */       {
/*  276 */         synchronized (this)
/*      */         {
/*  278 */           if (!isONSInitializedForRemoteSubscription)
/*      */           {
/*      */             try
/*      */             {
/*  283 */               AccessController.doPrivileged(new PrivilegedExceptionAction()
/*      */               {
/*      */                 public Object run()
/*      */                   throws ONSException
/*      */                 {
/*  291 */                   ONS localONS = new ONS(this.val$onsConfigStr);
/*  292 */                   return null;
/*      */                 }
/*      */ 
/*      */               });
/*      */             }
/*      */             catch (PrivilegedActionException localPrivilegedActionException)
/*      */             {
/*  299 */               SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 175, localPrivilegedActionException);
/*  300 */               localSQLException2.fillInStackTrace();
/*  301 */               throw localSQLException2;
/*      */             }
/*      */ 
/*  305 */             isONSInitializedForRemoteSubscription = true;
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*  310 */       this.failoverEventHandlerThread = new OracleFailoverEventHandlerThread();
/*      */     }
/*      */ 
/*  314 */     Object localObject1 = new OracleImplicitConnectionCache(paramOracleDataSource, paramProperties);
/*      */ 
/*  317 */     ((OracleImplicitConnectionCache)localObject1).cacheName = paramString;
/*  318 */     paramOracleDataSource.odsCache = ((OracleImplicitConnectionCache)localObject1);
/*      */ 
/*  321 */     this.m_connCache.put(paramString, localObject1);
/*      */ 
/*  329 */     if (bool)
/*      */     {
/*  334 */       checkAndStartThread(this.failoverEventHandlerThread);
/*      */     }
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public void removeCache(String paramString, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  370 */     OracleImplicitConnectionCache localOracleImplicitConnectionCache = paramString != null ? (OracleImplicitConnectionCache)this.m_connCache.remove(paramString) : null;
/*      */ 
/*  373 */     if (localOracleImplicitConnectionCache != null)
/*      */     {
/*  375 */       localOracleImplicitConnectionCache.disableConnectionCache();
/*      */ 
/*  378 */       if (paramLong > 0L)
/*      */       {
/*      */         try
/*      */         {
/*  382 */           Thread.currentThread(); Thread.sleep(paramLong * 1000L);
/*      */         }
/*      */         catch (InterruptedException localInterruptedException)
/*      */         {
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  391 */       if (localOracleImplicitConnectionCache.cacheEnabledDS.getFastConnectionFailoverEnabled()) {
/*  392 */         cleanupFCFThreads(localOracleImplicitConnectionCache);
/*      */       }
/*      */ 
/*  395 */       localOracleImplicitConnectionCache.closeConnectionCache(paramLong < 0L ? 32 : 1);
/*      */ 
/*  397 */       localOracleImplicitConnectionCache = null;
/*      */     }
/*      */     else
/*      */     {
/*  402 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 141);
/*  403 */       localSQLException.fillInStackTrace();
/*  404 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public void reinitializeCache(String paramString, Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  430 */     Object localObject = paramString != null ? (OracleImplicitConnectionCache)this.m_connCache.get(paramString) : null;
/*      */ 
/*  433 */     if (localObject != null)
/*      */     {
/*  435 */       disableCache(paramString);
/*  436 */       localObject.reinitializeCacheConnections(paramProperties);
/*  437 */       enableCache(paramString);
/*      */     }
/*      */     else
/*      */     {
/*  442 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 141);
/*  443 */       localSQLException.fillInStackTrace();
/*  444 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public boolean existsCache(String paramString)
/*      */     throws SQLException
/*      */   {
/*  467 */     return this.m_connCache.containsKey(paramString);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public void enableCache(String paramString)
/*      */     throws SQLException
/*      */   {
/*  489 */     Object localObject = paramString != null ? (OracleImplicitConnectionCache)this.m_connCache.get(paramString) : null;
/*      */ 
/*  492 */     if (localObject != null)
/*      */     {
/*  494 */       localObject.enableConnectionCache();
/*      */     }
/*      */     else
/*      */     {
/*  499 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 141);
/*  500 */       localSQLException.fillInStackTrace();
/*  501 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public void disableCache(String paramString)
/*      */     throws SQLException
/*      */   {
/*  525 */     Object localObject = paramString != null ? (OracleImplicitConnectionCache)this.m_connCache.get(paramString) : null;
/*      */ 
/*  528 */     if (localObject != null)
/*      */     {
/*  530 */       localObject.disableConnectionCache();
/*      */     }
/*      */     else
/*      */     {
/*  535 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 141);
/*  536 */       localSQLException.fillInStackTrace();
/*  537 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public void refreshCache(String paramString, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  566 */     Object localObject = paramString != null ? (OracleImplicitConnectionCache)this.m_connCache.get(paramString) : null;
/*      */     SQLException localSQLException;
/*  569 */     if (localObject != null)
/*      */     {
/*  571 */       switch (paramInt)
/*      */       {
/*      */       case 4096:
/*      */       case 8192:
/*  575 */         localObject.refreshCacheConnections(paramInt);
/*  576 */         break;
/*      */       default:
/*  580 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  581 */         localSQLException.fillInStackTrace();
/*  582 */         throw localSQLException;
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  589 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 141);
/*  590 */       localSQLException.fillInStackTrace();
/*  591 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public void purgeCache(String paramString, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  618 */     Object localObject = paramString != null ? (OracleImplicitConnectionCache)this.m_connCache.get(paramString) : null;
/*      */ 
/*  621 */     if (localObject != null)
/*      */     {
/*  623 */       localObject.purgeCacheConnections(paramBoolean, 1);
/*      */     }
/*      */     else
/*      */     {
/*  629 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 141);
/*  630 */       localSQLException.fillInStackTrace();
/*  631 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Properties getCacheProperties(String paramString)
/*      */     throws SQLException
/*      */   {
/*  656 */     Object localObject = paramString != null ? (OracleImplicitConnectionCache)this.m_connCache.get(paramString) : null;
/*      */ 
/*  659 */     if (localObject != null)
/*      */     {
/*  661 */       return localObject.getConnectionCacheProperties();
/*      */     }
/*      */ 
/*  666 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 141);
/*  667 */     localSQLException.fillInStackTrace();
/*  668 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public String[] getCacheNameList()
/*      */     throws SQLException
/*      */   {
/*  691 */     String[] arrayOfString = (String[])this.m_connCache.keySet().toArray(new String[this.m_connCache.size()]);
/*      */ 
/*  693 */     return arrayOfString;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public int getNumberOfAvailableConnections(String paramString)
/*      */     throws SQLException
/*      */   {
/*  716 */     Object localObject = paramString != null ? (OracleImplicitConnectionCache)this.m_connCache.get(paramString) : null;
/*      */ 
/*  719 */     if (localObject != null)
/*      */     {
/*  721 */       return localObject.cacheSize;
/*      */     }
/*      */ 
/*  726 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 141);
/*  727 */     localSQLException.fillInStackTrace();
/*  728 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public int getNumberOfActiveConnections(String paramString)
/*      */     throws SQLException
/*      */   {
/*  752 */     Object localObject = paramString != null ? (OracleImplicitConnectionCache)this.m_connCache.get(paramString) : null;
/*      */ 
/*  755 */     if (localObject != null)
/*      */     {
/*  757 */       return localObject.getNumberOfCheckedOutConnections();
/*      */     }
/*      */ 
/*  762 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 141);
/*  763 */     localSQLException.fillInStackTrace();
/*  764 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public synchronized void setConnectionPoolDataSource(String paramString, ConnectionPoolDataSource paramConnectionPoolDataSource)
/*      */     throws SQLException
/*      */   {
/*  797 */     Object localObject = paramString != null ? (OracleImplicitConnectionCache)this.m_connCache.get(paramString) : null;
/*      */     SQLException localSQLException;
/*  800 */     if (localObject != null)
/*      */     {
/*  802 */       if (localObject.cacheSize > 0)
/*      */       {
/*  805 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 78);
/*  806 */         localSQLException.fillInStackTrace();
/*  807 */         throw localSQLException;
/*      */       }
/*      */ 
/*  812 */       ((OracleConnectionPoolDataSource)paramConnectionPoolDataSource).makeURL();
/*  813 */       ((OracleConnectionPoolDataSource)paramConnectionPoolDataSource).setURL(((OracleConnectionPoolDataSource)paramConnectionPoolDataSource).url);
/*      */ 
/*  815 */       localObject.connectionPoolDS = ((OracleConnectionPoolDataSource)paramConnectionPoolDataSource);
/*      */     }
/*      */     else
/*      */     {
/*  821 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 141);
/*  822 */       localSQLException.fillInStackTrace();
/*  823 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void verifyAndHandleEvent(int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  845 */     Object localObject1 = null;
/*  846 */     String str1 = null;
/*  847 */     String str2 = null;
/*  848 */     String str3 = null;
/*  849 */     Object localObject2 = null;
/*      */ 
/*  851 */     int i = 0;
/*  852 */     StringTokenizer localStringTokenizer = null;
/*      */ 
/*  854 */     int j = 1;
/*      */     try
/*      */     {
/*  858 */       localStringTokenizer = new StringTokenizer(new String(paramArrayOfByte, "UTF-8"), "{} =", true);
/*      */     }
/*      */     catch (UnsupportedEncodingException localUnsupportedEncodingException)
/*      */     {
/*      */     }
/*      */ 
/*  865 */     String str4 = null;
/*  866 */     String str5 = null;
/*  867 */     String str6 = null;
/*      */ 
/*  871 */     while (localStringTokenizer.hasMoreTokens())
/*      */     {
/*  873 */       str5 = null;
/*  874 */       str4 = localStringTokenizer.nextToken();
/*  875 */       if ((str4.equals("=")) && (localStringTokenizer.hasMoreTokens()))
/*      */       {
/*  877 */         str5 = localStringTokenizer.nextToken();
/*      */       }
/*      */       else
/*      */       {
/*  881 */         str6 = str4;
/*      */       }
/*      */ 
/*  884 */       if ((str6.equalsIgnoreCase("version")) && (str5 != null) && (!str5.startsWith("1.")))
/*      */       {
/*  887 */         j = 0;
/*      */       }
/*      */ 
/*  891 */       if ((str6.equalsIgnoreCase("service")) && (str5 != null)) {
/*  892 */         localObject1 = str5;
/*      */       }
/*  894 */       if ((str6.equalsIgnoreCase("instance")) && (str5 != null) && (!str5.equals(" ")))
/*      */       {
/*  897 */         str1 = str5.toLowerCase().intern();
/*      */       }
/*      */ 
/*  900 */       if ((str6.equalsIgnoreCase("database")) && (str5 != null)) {
/*  901 */         str2 = str5.toLowerCase().intern();
/*      */       }
/*  903 */       if ((str6.equalsIgnoreCase("host")) && (str5 != null)) {
/*  904 */         str3 = str5.toLowerCase().intern();
/*      */       }
/*  906 */       if ((str6.equalsIgnoreCase("status")) && (str5 != null)) {
/*  907 */         localObject2 = str5;
/*      */       }
/*  909 */       if ((str6.equalsIgnoreCase("card")) && (str5 != null))
/*      */       {
/*      */         try
/*      */         {
/*  913 */           i = Integer.parseInt(str5);
/*      */         }
/*      */         catch (NumberFormatException localNumberFormatException)
/*      */         {
/*  917 */           j = 0;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  923 */     if (j != 0) {
/*  924 */       invokeFailoverProcessingThreads(paramInt, localObject1, str1, str2, str3, localObject2, i);
/*      */     }
/*      */     else
/*      */     {
/*  929 */       localStringTokenizer = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   private void invokeFailoverProcessingThreads(int paramInt1, String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  946 */     OracleImplicitConnectionCache localOracleImplicitConnectionCache = null;
/*  947 */     int i = 0;
/*  948 */     int j = 0;
/*      */ 
/*  950 */     if (paramInt1 == 256) {
/*  951 */       i = 1;
/*      */     }
/*  953 */     if (paramInt1 == 512) {
/*  954 */       j = 1;
/*      */     }
/*  956 */     Iterator localIterator = this.m_connCache.values().iterator();
/*      */ 
/*  958 */     while (localIterator.hasNext())
/*      */     {
/*  960 */       localOracleImplicitConnectionCache = (OracleImplicitConnectionCache)localIterator.next();
/*      */ 
/*  970 */       if (((i != 0) && (paramString1.equalsIgnoreCase(localOracleImplicitConnectionCache.dataSourceServiceName))) || (j != 0))
/*      */       {
/*  974 */         OracleFailoverWorkerThread localOracleFailoverWorkerThread = new OracleFailoverWorkerThread(localOracleImplicitConnectionCache, paramInt1, paramString2, paramString3, paramString4, paramString5, paramInt2);
/*      */ 
/*  978 */         checkAndStartThread(localOracleFailoverWorkerThread);
/*      */ 
/*  980 */         localOracleImplicitConnectionCache.failoverWorkerThread = localOracleFailoverWorkerThread;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void checkAndStartThread(Thread paramThread)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/*  998 */       if (!paramThread.isAlive())
/*      */       {
/* 1000 */         paramThread.setDaemon(true);
/* 1001 */         paramThread.start();
/*      */       }
/*      */     }
/*      */     catch (IllegalThreadStateException localIllegalThreadStateException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   protected boolean failoverEnabledCacheExists()
/*      */   {
/* 1019 */     if (this.failoverEnabledCacheCount > 0) {
/* 1020 */       return true;
/*      */     }
/* 1022 */     return false;
/*      */   }
/*      */ 
/*      */   protected void parseRuntimeLoadBalancingEvent(String paramString, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1035 */     OracleImplicitConnectionCache localOracleImplicitConnectionCache = null;
/* 1036 */     Enumeration localEnumeration = this.m_connCache.elements();
/*      */ 
/* 1038 */     while (localEnumeration.hasMoreElements())
/*      */     {
/*      */       try
/*      */       {
/* 1042 */         localOracleImplicitConnectionCache = (OracleImplicitConnectionCache)localEnumeration.nextElement();
/* 1043 */         if (paramString.equalsIgnoreCase(localOracleImplicitConnectionCache.dataSourceServiceName))
/*      */         {
/* 1045 */           if (paramArrayOfByte == null)
/* 1046 */             localOracleImplicitConnectionCache.zapRLBInfo();
/*      */           else
/* 1048 */             retrieveServiceMetrics(localOracleImplicitConnectionCache, paramArrayOfByte);
/*      */         }
/*      */       }
/*      */       catch (Exception localException)
/*      */       {
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void retrieveServiceMetrics(OracleImplicitConnectionCache paramOracleImplicitConnectionCache, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1071 */     StringTokenizer localStringTokenizer = null;
/* 1072 */     String str1 = null;
/* 1073 */     String str2 = null;
/* 1074 */     int i = 0;
/* 1075 */     int j = 0;
/* 1076 */     int k = 0;
/*      */     try
/*      */     {
/* 1080 */       localStringTokenizer = new StringTokenizer(new String(paramArrayOfByte, "UTF-8"), "{} =", true);
/*      */     }
/*      */     catch (UnsupportedEncodingException localUnsupportedEncodingException)
/*      */     {
/*      */     }
/*      */ 
/* 1088 */     String str3 = null;
/* 1089 */     String str4 = null;
/* 1090 */     String str5 = null;
/*      */ 
/* 1092 */     while (localStringTokenizer.hasMoreTokens())
/*      */     {
/* 1094 */       str4 = null;
/* 1095 */       str3 = localStringTokenizer.nextToken();
/*      */ 
/* 1097 */       if ((str3.equals("=")) && (localStringTokenizer.hasMoreTokens()))
/*      */       {
/* 1099 */         str4 = localStringTokenizer.nextToken();
/*      */       } else {
/* 1101 */         if (str3.equals("}"))
/*      */         {
/* 1104 */           if (k == 0)
/*      */             continue;
/* 1106 */           paramOracleImplicitConnectionCache.updateDatabaseInstance(str2, str1, i, j);
/* 1107 */           k = 0; continue;
/*      */         }
/*      */ 
/* 1111 */         if ((str3.equals("{")) || (str3.equals(" ")))
/*      */         {
/*      */           continue;
/*      */         }
/*      */ 
/* 1117 */         str5 = str3;
/* 1118 */         k = 1;
/*      */       }
/*      */ 
/* 1121 */       if ((str5.equalsIgnoreCase("version")) && (str4 != null))
/*      */       {
/* 1123 */         if (!str4.equals("1.0"))
/*      */         {
/* 1126 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 146);
/* 1127 */           localSQLException.fillInStackTrace();
/* 1128 */           throw localSQLException;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1133 */       if ((str5.equalsIgnoreCase("database")) && (str4 != null)) {
/* 1134 */         str2 = str4.toLowerCase().intern();
/*      */       }
/* 1136 */       if ((str5.equalsIgnoreCase("instance")) && (str4 != null)) {
/* 1137 */         str1 = str4.toLowerCase().intern();
/*      */       }
/* 1139 */       if ((str5.equalsIgnoreCase("percent")) && (str4 != null))
/*      */       {
/*      */         try
/*      */         {
/* 1143 */           i = Integer.parseInt(str4);
/* 1144 */           if (i == 0) i = 1;
/*      */         }
/*      */         catch (NumberFormatException localNumberFormatException)
/*      */         {
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1152 */       if ((str5.equalsIgnoreCase("flag")) && (str4 != null))
/*      */       {
/* 1154 */         if (str4.equalsIgnoreCase("good"))
/* 1155 */           j = 1;
/* 1156 */         else if (str4.equalsIgnoreCase("violating"))
/* 1157 */           j = 3;
/* 1158 */         else if (str4.equalsIgnoreCase("NO_DATA"))
/* 1159 */           j = 4;
/* 1160 */         else if (str4.equalsIgnoreCase("UNKNOWN"))
/* 1161 */           j = 2;
/* 1162 */         else if (str4.equalsIgnoreCase("BLOCKED")) {
/* 1163 */           j = 5;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1168 */     paramOracleImplicitConnectionCache.processDatabaseInstances();
/*      */   }
/*      */ 
/*      */   protected void cleanupFCFThreads(OracleImplicitConnectionCache paramOracleImplicitConnectionCache)
/*      */     throws SQLException
/*      */   {
/* 1181 */     cleanupFCFWorkerThread(paramOracleImplicitConnectionCache);
/* 1182 */     paramOracleImplicitConnectionCache.cleanupRLBThreads();
/*      */ 
/* 1185 */     if (this.failoverEnabledCacheCount <= 0) {
/* 1186 */       cleanupFCFEventHandlerThread();
/*      */     }
/*      */ 
/* 1189 */     this.failoverEnabledCacheCount -= 1;
/*      */   }
/*      */ 
/*      */   protected void cleanupFCFWorkerThread(OracleImplicitConnectionCache paramOracleImplicitConnectionCache)
/*      */     throws SQLException
/*      */   {
/* 1204 */     if (paramOracleImplicitConnectionCache.failoverWorkerThread != null)
/*      */     {
/*      */       try
/*      */       {
/* 1208 */         if (paramOracleImplicitConnectionCache.failoverWorkerThread.isAlive()) {
/* 1209 */           paramOracleImplicitConnectionCache.failoverWorkerThread.join();
/*      */         }
/*      */       }
/*      */       catch (InterruptedException localInterruptedException)
/*      */       {
/*      */       }
/*      */ 
/* 1216 */       paramOracleImplicitConnectionCache.failoverWorkerThread = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void cleanupFCFEventHandlerThread()
/*      */     throws SQLException
/*      */   {
/* 1234 */     if (this.failoverEventHandlerThread != null)
/*      */     {
/*      */       try
/*      */       {
/* 1238 */         this.failoverEventHandlerThread.interrupt();
/*      */       }
/*      */       catch (Exception localException)
/*      */       {
/*      */       }
/*      */ 
/* 1245 */       this.failoverEventHandlerThread = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isFatalConnectionError(SQLException paramSQLException)
/*      */   {
/* 1268 */     boolean bool = false;
/* 1269 */     int i = paramSQLException.getErrorCode();
/*      */ 
/* 1272 */     if ((i == 3113) || (i == 3114) || (i == 1033) || (i == 1034) || (i == 1089) || (i == 1090) || (i == 17002))
/*      */     {
/* 1280 */       bool = true;
/*      */     }
/*      */ 
/* 1284 */     if ((!bool) && (this.fatalErrorCodes != null))
/*      */     {
/* 1286 */       for (int j = 0; j < this.fatalErrorCodes.length; j++)
/* 1287 */         if (i == this.fatalErrorCodes[j])
/*      */         {
/* 1289 */           bool = true;
/* 1290 */           break;
/*      */         }
/*      */     }
/* 1293 */     return bool;
/*      */   }
/*      */ 
/*      */   public synchronized void setConnectionErrorCodes(int[] paramArrayOfInt)
/*      */     throws SQLException
/*      */   {
/* 1313 */     if (paramArrayOfInt != null)
/* 1314 */       this.fatalErrorCodes = paramArrayOfInt;
/*      */   }
/*      */ 
/*      */   public int[] getConnectionErrorCodes()
/*      */     throws SQLException
/*      */   {
/* 1334 */     return this.fatalErrorCodes;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Map getStatistics(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1360 */     Map localMap = null;
/* 1361 */     OracleImplicitConnectionCache localOracleImplicitConnectionCache = null;
/*      */ 
/* 1363 */     if ((this.m_connCache != null) && ((localOracleImplicitConnectionCache = (OracleImplicitConnectionCache)this.m_connCache.get(paramString)) != null))
/*      */     {
/* 1365 */       localMap = localOracleImplicitConnectionCache.getStatistics();
/*      */     }
/* 1367 */     return localMap;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1382 */     return null;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.pool.OracleConnectionCacheManager
 * JD-Core Version:    0.6.2
 */