/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ public class Util
/*     */ {
/* 259 */   private static int[] ldsRoundTable = { 0, 1, 0, 2, 0, 0, 0, 3, 0 };
/*     */ 
/* 345 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   static void checkNextByte(InputStream paramInputStream, byte paramByte)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/*  35 */       if (paramInputStream.read() != paramByte)
/*     */       {
/*  37 */         SQLException localSQLException1 = DatabaseError.createSqlException(null, 47, "parseTDS");
/*  38 */         localSQLException1.fillInStackTrace();
/*  39 */         throw localSQLException1;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/*  45 */       SQLException localSQLException2 = DatabaseError.createSqlException(null, localIOException);
/*  46 */       localSQLException2.fillInStackTrace();
/*  47 */       throw localSQLException2;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static int[] toJavaUnsignedBytes(byte[] paramArrayOfByte)
/*     */   {
/*  64 */     int[] arrayOfInt = new int[paramArrayOfByte.length];
/*     */ 
/*  66 */     for (int i = 0; i < paramArrayOfByte.length; i++) {
/*  67 */       paramArrayOfByte[i] &= 255;
/*     */     }
/*  69 */     return arrayOfInt;
/*     */   }
/*     */ 
/*     */   static byte[] readBytes(InputStream paramInputStream, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  76 */     byte[] arrayOfByte = new byte[paramInt];
/*     */     try
/*     */     {
/*  80 */       int i = paramInputStream.read(arrayOfByte);
/*     */ 
/*  82 */       if (i != paramInt)
/*     */       {
/*  84 */         localObject = new byte[i];
/*     */ 
/*  86 */         System.arraycopy(arrayOfByte, 0, localObject, 0, i);
/*     */ 
/*  88 */         return localObject;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/*  94 */       Object localObject = DatabaseError.createSqlException(null, localIOException);
/*  95 */       ((SQLException)localObject).fillInStackTrace();
/*  96 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 100 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   static void writeBytes(OutputStream paramOutputStream, byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 109 */       paramOutputStream.write(paramArrayOfByte);
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 114 */       SQLException localSQLException = DatabaseError.createSqlException(null, localIOException);
/* 115 */       localSQLException.fillInStackTrace();
/* 116 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   static void skipBytes(InputStream paramInputStream, int paramInt)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 127 */       paramInputStream.skip(paramInt);
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 132 */       SQLException localSQLException = DatabaseError.createSqlException(null, localIOException);
/* 133 */       localSQLException.fillInStackTrace();
/* 134 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   static long readLong(InputStream paramInputStream)
/*     */     throws SQLException
/*     */   {
/* 143 */     byte[] arrayOfByte = new byte[4];
/*     */     try
/*     */     {
/* 147 */       paramInputStream.read(arrayOfByte);
/*     */ 
/* 149 */       return (((arrayOfByte[0] & 0xFF) * 256 + (arrayOfByte[1] & 0xFF)) * 256 + (arrayOfByte[2] & 0xFF)) * 256 + (arrayOfByte[3] & 0xFF);
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 155 */       SQLException localSQLException = DatabaseError.createSqlException(null, localIOException);
/* 156 */       localSQLException.fillInStackTrace();
/* 157 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   static short readShort(InputStream paramInputStream)
/*     */     throws SQLException
/*     */   {
/* 167 */     byte[] arrayOfByte = new byte[2];
/*     */     try
/*     */     {
/* 171 */       paramInputStream.read(arrayOfByte);
/*     */ 
/* 173 */       return (short)((arrayOfByte[0] & 0xFF) * 256 + (arrayOfByte[1] & 0xFF));
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 178 */       SQLException localSQLException = DatabaseError.createSqlException(null, localIOException);
/* 179 */       localSQLException.fillInStackTrace();
/* 180 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   static byte readByte(InputStream paramInputStream)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 192 */       return (byte)paramInputStream.read();
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 197 */       SQLException localSQLException = DatabaseError.createSqlException(null, localIOException);
/* 198 */       localSQLException.fillInStackTrace();
/* 199 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   static byte fdoGetSize(byte[] paramArrayOfByte, int paramInt)
/*     */   {
/* 212 */     int i = fdoGetEntry(paramArrayOfByte, paramInt);
/*     */ 
/* 215 */     return (byte)(i >> 3 & 0x1F);
/*     */   }
/*     */ 
/*     */   static byte fdoGetAlign(byte[] paramArrayOfByte, int paramInt)
/*     */   {
/* 225 */     int i = fdoGetEntry(paramArrayOfByte, paramInt);
/*     */ 
/* 228 */     return (byte)(i & 0x7);
/*     */   }
/*     */ 
/*     */   static int ldsRound(int paramInt1, int paramInt2)
/*     */   {
/* 240 */     int i = ldsRoundTable[paramInt2];
/*     */ 
/* 242 */     return (paramInt1 >> i) + 1 << i;
/*     */   }
/*     */ 
/*     */   private static byte fdoGetEntry(byte[] paramArrayOfByte, int paramInt)
/*     */   {
/* 252 */     int i = getUnsignedByte(paramArrayOfByte[5]);
/* 253 */     byte b = paramArrayOfByte[(6 + i + paramInt)];
/*     */ 
/* 255 */     return b;
/*     */   }
/*     */ 
/*     */   public static short getUnsignedByte(byte paramByte)
/*     */   {
/* 267 */     return (short)(paramByte & 0xFF);
/*     */   }
/*     */ 
/*     */   public static byte[] serializeObject(Object paramObject)
/*     */     throws IOException
/*     */   {
/* 274 */     if (paramObject == null) {
/* 275 */       return null;
/*     */     }
/* 277 */     ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream();
/* 278 */     ObjectOutputStream localObjectOutputStream = new ObjectOutputStream(localByteArrayOutputStream);
/*     */ 
/* 280 */     localObjectOutputStream.writeObject(paramObject);
/* 281 */     localObjectOutputStream.flush();
/*     */ 
/* 283 */     return localByteArrayOutputStream.toByteArray();
/*     */   }
/*     */ 
/*     */   public static Object deserializeObject(byte[] paramArrayOfByte)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 291 */     if (paramArrayOfByte == null) {
/* 292 */       return null;
/*     */     }
/* 294 */     ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(paramArrayOfByte);
/*     */ 
/* 296 */     return new ObjectInputStream(localByteArrayInputStream).readObject();
/*     */   }
/*     */ 
/*     */   public static void printByteArray(byte[] paramArrayOfByte)
/*     */   {
/* 304 */     System.out.println("DONT CALL THIS -- oracle.jdbc.oracore.Util.printByteArray");
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 318 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.Util
 * JD-Core Version:    0.6.2
 */