/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public final class UnpickleContext
/*     */ {
/*     */   byte[] image;
/*     */   int absoluteOffset;
/*     */   int beginOffset;
/*     */   int markedOffset;
/*     */   Vector patches;
/*     */   long[] ldsOffsets;
/*     */   boolean[] nullIndicators;
/*     */   boolean bigEndian;
/* 288 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public UnpickleContext()
/*     */   {
/*     */   }
/*     */ 
/*     */   public UnpickleContext(byte[] paramArrayOfByte, int paramInt, boolean[] paramArrayOfBoolean, long[] paramArrayOfLong, boolean paramBoolean)
/*     */   {
/*  35 */     this.image = paramArrayOfByte;
/*  36 */     this.beginOffset = paramInt;
/*  37 */     this.absoluteOffset = paramInt;
/*  38 */     this.bigEndian = paramBoolean;
/*  39 */     this.nullIndicators = paramArrayOfBoolean;
/*  40 */     this.patches = null;
/*  41 */     this.ldsOffsets = paramArrayOfLong;
/*     */   }
/*     */ 
/*     */   public byte readByte()
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/*  50 */       return this.image[this.absoluteOffset];
/*     */     }
/*     */     finally
/*     */     {
/*  54 */       this.absoluteOffset += 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte[] readVarNumBytes()
/*     */     throws SQLException
/*     */   {
/*  63 */     byte[] arrayOfByte = new byte[this.image[this.absoluteOffset] & 0xFF];
/*     */     try
/*     */     {
/*  67 */       System.arraycopy(this.image, this.absoluteOffset + 1, arrayOfByte, 0, arrayOfByte.length);
/*     */     }
/*     */     finally
/*     */     {
/*  72 */       this.absoluteOffset += 22;
/*     */     }
/*     */ 
/*  75 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public byte[] readPtrBytes()
/*     */     throws SQLException
/*     */   {
/*  83 */     byte[] arrayOfByte = new byte[(this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[(this.absoluteOffset + 1)] & 0xFF) + 2];
/*     */ 
/*  86 */     System.arraycopy(this.image, this.absoluteOffset, arrayOfByte, 0, arrayOfByte.length);
/*     */ 
/*  88 */     this.absoluteOffset += arrayOfByte.length;
/*     */ 
/*  90 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public void skipPtrBytes()
/*     */     throws SQLException
/*     */   {
/*  98 */     this.absoluteOffset += (this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[(this.absoluteOffset + 1)] & 0xFF) + 2;
/*     */   }
/*     */ 
/*     */   public byte[] readBytes(int paramInt)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 109 */       byte[] arrayOfByte1 = new byte[paramInt];
/*     */ 
/* 111 */       System.arraycopy(this.image, this.absoluteOffset, arrayOfByte1, 0, paramInt);
/*     */ 
/* 113 */       return arrayOfByte1;
/*     */     }
/*     */     finally
/*     */     {
/* 117 */       this.absoluteOffset += paramInt;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long readLong()
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 128 */       return (((this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[(this.absoluteOffset + 1)] & 0xFF)) * 256 + (this.image[(this.absoluteOffset + 2)] & 0xFF)) * 256 + (this.image[(this.absoluteOffset + 3)] & 0xFF);
/*     */     }
/*     */     finally
/*     */     {
/* 133 */       this.absoluteOffset += 4;
/*     */     }
/*     */   }
/*     */ 
/*     */   public short readShort()
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 144 */       return (short)((this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[(this.absoluteOffset + 1)] & 0xFF));
/*     */     }
/*     */     finally
/*     */     {
/* 149 */       this.absoluteOffset += 2;
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte[] readLengthBytes()
/*     */     throws SQLException
/*     */   {
/* 158 */     long l = readLong();
/*     */ 
/* 160 */     return readBytes((int)l);
/*     */   }
/*     */ 
/*     */   public void skipLengthBytes()
/*     */     throws SQLException
/*     */   {
/* 168 */     long l = readLong();
/*     */ 
/* 170 */     this.absoluteOffset = ((int)(this.absoluteOffset + l));
/*     */   }
/*     */ 
/*     */   public void skipTo(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 180 */     if (paramLong > this.absoluteOffset - this.beginOffset)
/* 181 */       this.absoluteOffset = (this.beginOffset + (int)paramLong);
/*     */   }
/*     */ 
/*     */   public void skipTo(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 188 */     if (paramInt > this.absoluteOffset - this.beginOffset)
/* 189 */       this.absoluteOffset = (this.beginOffset + paramInt);
/*     */   }
/*     */ 
/*     */   public void mark()
/*     */     throws SQLException
/*     */   {
/* 197 */     this.markedOffset = this.absoluteOffset;
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */     throws SQLException
/*     */   {
/* 205 */     this.absoluteOffset = this.markedOffset;
/*     */   }
/*     */ 
/*     */   public void markAndSkip()
/*     */     throws SQLException
/*     */   {
/* 213 */     this.markedOffset = (this.absoluteOffset + 4);
/* 214 */     this.absoluteOffset = (this.beginOffset + (int)readLong());
/*     */   }
/*     */ 
/*     */   public void markAndSkip(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 222 */     this.markedOffset = this.absoluteOffset;
/* 223 */     this.absoluteOffset = (this.beginOffset + (int)paramLong);
/*     */   }
/*     */ 
/*     */   public void skipBytes(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 231 */     if (paramInt >= 0)
/* 232 */       this.absoluteOffset += paramInt;
/*     */   }
/*     */ 
/*     */   public boolean isNull(int paramInt)
/*     */   {
/* 240 */     return this.nullIndicators[paramInt];
/*     */   }
/*     */ 
/*     */   public int absoluteOffset()
/*     */     throws SQLException
/*     */   {
/* 248 */     return this.absoluteOffset;
/*     */   }
/*     */ 
/*     */   public int offset()
/*     */     throws SQLException
/*     */   {
/* 256 */     return this.absoluteOffset - this.beginOffset;
/*     */   }
/*     */ 
/*     */   public byte[] image()
/*     */     throws SQLException
/*     */   {
/* 264 */     return this.image;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.UnpickleContext
 * JD-Core Version:    0.6.2
 */