/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.util.Vector;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ public class TDSReader
/*     */ {
/*     */   static final int KOPT_NONE_FINAL_TYPE = 1;
/*     */   static final int KOPT_JAVA_OBJECT = 2;
/*     */   long fixedDataSize;
/*     */   Vector patches;
/*     */   byte[] tds;
/*     */   int beginIndex;
/*     */   int index;
/* 323 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   TDSReader(byte[] paramArrayOfByte, long paramLong)
/*     */   {
/*  42 */     this.fixedDataSize = 0L;
/*  43 */     this.patches = null;
/*     */ 
/*  45 */     this.tds = paramArrayOfByte;
/*  46 */     this.beginIndex = ((int)paramLong);
/*  47 */     this.index = ((int)paramLong);
/*     */   }
/*     */ 
/*     */   void skipBytes(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  61 */     this.index += paramInt;
/*     */   }
/*     */ 
/*     */   void checkNextByte(byte paramByte)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/*  75 */       if (paramByte != this.tds[this.index])
/*     */       {
/*  77 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 47, "parseTDS");
/*  78 */         localSQLException.fillInStackTrace();
/*  79 */         throw localSQLException;
/*     */       }
/*     */ 
/*     */     }
/*     */     finally
/*     */     {
/*  86 */       this.index += 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   byte readByte()
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 101 */       return this.tds[this.index];
/*     */     }
/*     */     finally
/*     */     {
/* 107 */       this.index += 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   int readUnsignedByte()
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 122 */       return this.tds[this.index] & 0xFF;
/*     */     }
/*     */     finally
/*     */     {
/* 128 */       this.index += 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   int readUB2()
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 144 */       return ((this.tds[this.index] & 0xFF) << 8) + (this.tds[(this.index + 1)] & 0xFF);
/*     */     }
/*     */     finally
/*     */     {
/* 150 */       this.index += 2;
/*     */     }
/*     */   }
/*     */ 
/*     */   long readLong()
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 167 */       return (((this.tds[this.index] & 0xFF) * 256 + (this.tds[(this.index + 1)] & 0xFF)) * 256 + (this.tds[(this.index + 2)] & 0xFF)) * 256 + (this.tds[(this.index + 3)] & 0xFF);
/*     */     }
/*     */     finally
/*     */     {
/* 174 */       this.index += 4;
/*     */     }
/*     */   }
/*     */ 
/*     */   void addNormalPatch(long paramLong, byte paramByte, OracleType paramOracleType)
/*     */     throws SQLException
/*     */   {
/* 192 */     addPatch(new TDSPatch(0, paramOracleType, paramLong, paramByte));
/*     */   }
/*     */ 
/*     */   void addSimplePatch(long paramLong, OracleType paramOracleType)
/*     */     throws SQLException
/*     */   {
/* 205 */     addPatch(new TDSPatch(1, paramOracleType, paramLong, 0));
/*     */   }
/*     */ 
/*     */   void addPatch(TDSPatch paramTDSPatch)
/*     */     throws SQLException
/*     */   {
/* 212 */     if (this.patches == null) {
/* 213 */       this.patches = new Vector(5);
/*     */     }
/* 215 */     this.patches.addElement(paramTDSPatch);
/*     */   }
/*     */ 
/*     */   long moveToPatchPos(TDSPatch paramTDSPatch)
/*     */     throws SQLException
/*     */   {
/* 222 */     long l = paramTDSPatch.getPosition();
/*     */ 
/* 224 */     if (this.beginIndex + l > this.tds.length)
/*     */     {
/* 226 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 47, "parseTDS");
/* 227 */       localSQLException.fillInStackTrace();
/* 228 */       throw localSQLException;
/*     */     }
/*     */ 
/* 231 */     skip_to(l);
/*     */ 
/* 233 */     return l;
/*     */   }
/*     */ 
/*     */   TDSPatch getNextPatch()
/*     */     throws SQLException
/*     */   {
/* 243 */     TDSPatch localTDSPatch = null;
/*     */ 
/* 245 */     if (this.patches != null)
/*     */     {
/* 247 */       if (this.patches.size() > 0)
/*     */       {
/* 249 */         localTDSPatch = (TDSPatch)this.patches.firstElement();
/*     */ 
/* 251 */         this.patches.removeElementAt(0);
/*     */       }
/*     */     }
/*     */ 
/* 255 */     return localTDSPatch;
/*     */   }
/*     */ 
/*     */   void skip_to(long paramLong)
/*     */   {
/* 263 */     this.index = (this.beginIndex + (int)paramLong);
/*     */   }
/*     */ 
/*     */   long offset()
/*     */     throws SQLException
/*     */   {
/* 271 */     return this.index - this.beginIndex;
/*     */   }
/*     */ 
/*     */   long absoluteOffset()
/*     */     throws SQLException
/*     */   {
/* 278 */     return this.index;
/*     */   }
/*     */ 
/*     */   byte[] tds()
/*     */     throws SQLException
/*     */   {
/* 285 */     return this.tds;
/*     */   }
/*     */ 
/*     */   boolean isJavaObject(int paramInt, byte paramByte)
/*     */   {
/* 294 */     return (paramInt >= 3) && ((paramByte & 0x2) != 0);
/*     */   }
/*     */ 
/*     */   boolean isFinalType(int paramInt, byte paramByte)
/*     */   {
/* 302 */     return (paramInt >= 3) && ((paramByte & 0x1) == 0);
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 318 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.TDSReader
 * JD-Core Version:    0.6.2
 */