/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ public class TDSPatch
/*     */ {
/*     */   static final int S_NORMAL_PATCH = 0;
/*     */   static final int S_SIMPLE_PATCH = 1;
/*     */   int typeId;
/*     */   OracleType owner;
/*     */   long position;
/*     */   int uptCode;
/* 151 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public TDSPatch(int paramInt1, OracleType paramOracleType, long paramLong, int paramInt2)
/*     */     throws SQLException
/*     */   {
/*  31 */     this.typeId = paramInt1;
/*  32 */     this.owner = paramOracleType;
/*  33 */     this.position = paramLong;
/*  34 */     this.uptCode = paramInt2;
/*     */   }
/*     */ 
/*     */   int getType()
/*     */     throws SQLException
/*     */   {
/*  41 */     return this.typeId;
/*     */   }
/*     */ 
/*     */   OracleNamedType getOwner()
/*     */     throws SQLException
/*     */   {
/*  48 */     return (OracleNamedType)this.owner;
/*     */   }
/*     */ 
/*     */   long getPosition()
/*     */     throws SQLException
/*     */   {
/*  55 */     return this.position;
/*     */   }
/*     */ 
/*     */   byte getUptTypeCode()
/*     */     throws SQLException
/*     */   {
/*  62 */     return (byte)this.uptCode;
/*     */   }
/*     */ 
/*     */   void apply(OracleType paramOracleType)
/*     */     throws SQLException
/*     */   {
/*  69 */     apply(paramOracleType, -1);
/*     */   }
/*     */ 
/*     */   void apply(OracleType paramOracleType, int paramInt)
/*     */     throws SQLException
/*     */   {
/*     */     Object localObject;
/*     */     OracleNamedType localOracleNamedType;
/*  76 */     if (this.typeId == 0)
/*     */     {
/*  80 */       localObject = (OracleTypeUPT)this.owner;
/*     */ 
/*  82 */       ((OracleTypeUPT)localObject).realType = ((OracleTypeADT)paramOracleType);
/*     */ 
/*  85 */       if ((paramOracleType instanceof OracleNamedType))
/*     */       {
/*  87 */         localOracleNamedType = (OracleNamedType)paramOracleType;
/*     */ 
/*  89 */         localOracleNamedType.setParent(((OracleTypeUPT)localObject).getParent());
/*  90 */         localOracleNamedType.setOrder(((OracleTypeUPT)localObject).getOrder());
/*     */       }
/*     */     }
/*  93 */     else if (this.typeId == 1)
/*     */     {
/*  97 */       localObject = (OracleTypeCOLLECTION)this.owner;
/*     */ 
/*  99 */       ((OracleTypeCOLLECTION)localObject).opcode = paramInt;
/* 100 */       ((OracleTypeCOLLECTION)localObject).elementType = paramOracleType;
/*     */ 
/* 103 */       if ((paramOracleType instanceof OracleNamedType))
/*     */       {
/* 105 */         localOracleNamedType = (OracleNamedType)paramOracleType;
/*     */ 
/* 107 */         localOracleNamedType.setParent((OracleTypeADT)localObject);
/* 108 */         localOracleNamedType.setOrder(1);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 113 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/* 114 */       ((SQLException)localObject).fillInStackTrace();
/* 115 */       throw ((Throwable)localObject);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 131 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.TDSPatch
 * JD-Core Version:    0.6.2
 */