/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import oracle.sql.Datum;
/*     */ 
/*     */ class SINT32 extends Datum
/*     */ {
/*     */   boolean isBigEndian;
/*     */ 
/*     */   private SINT32()
/*     */   {
/*     */   }
/*     */ 
/*     */   private SINT32(byte[] paramArrayOfByte, boolean paramBoolean)
/*     */   {
/* 233 */     setBytes(paramArrayOfByte);
/* 234 */     this.isBigEndian = paramBoolean;
/*     */   }
/*     */   public boolean isConvertibleTo(Class paramClass) {
/* 237 */     return false;
/*     */   }
/*     */   public Object toJdbc() {
/* 240 */     return Integer.valueOf(bytesToInt(shareBytes(), this.isBigEndian));
/*     */   }
/*     */ 
/*     */   public Object makeJdbcArray(int paramInt) {
/* 244 */     return new SINT32[paramInt];
/*     */   }
/*     */   static SINT32[] createArray(int paramInt) {
/* 247 */     return new SINT32[paramInt];
/*     */   }
/*     */ 
/*     */   static int bytesToInt(byte[] paramArrayOfByte, boolean paramBoolean)
/*     */   {
/* 252 */     int i = 0;
/* 253 */     int j = paramBoolean ? 0 : paramArrayOfByte.length - 1;
/* 254 */     for (int n : paramArrayOfByte) {
/* 255 */       i |= (n & 0xFF) << j * 8;
/* 256 */       j += (paramBoolean ? 1 : -1);
/*     */     }
/* 258 */     return i;
/*     */   }
/*     */ 
/*     */   static SINT32 valueOf(int paramInt, boolean paramBoolean)
/*     */   {
/* 265 */     byte[] arrayOfByte = new byte[4];
/* 266 */     int i = paramBoolean ? 0 : arrayOfByte.length - 1;
/* 267 */     for (int j = 0; j < 4; j++) {
/* 268 */       arrayOfByte[j] = ((byte)(paramInt >> i * 8 & 0xFF));
/* 269 */       i += (paramBoolean ? 1 : -1);
/*     */     }
/* 271 */     return new SINT32(arrayOfByte, paramBoolean);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.SINT32
 * JD-Core Version:    0.6.2
 */