/*      */ package oracle.jdbc.oracore;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.sql.SQLException;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ 
/*      */ public final class PickleContext
/*      */ {
/*      */   private PickleOutputStream outStream;
/*      */   byte[] image;
/*      */   int imageOffset;
/*      */   private byte[] lengthBuffer;
/*   43 */   static short KOPI20_LN_ELNL = 255;
/*   44 */   static short KOPI20_LN_5BLN = 254;
/*   45 */   static short KOPI20_LN_ATMN = 253;
/*   46 */   static short KOPI20_LN_IEMN = 252;
/*   47 */   static short KOPI20_LN_MAXV = 245;
/*      */ 
/*   53 */   static short KOPI20_IF_IS81 = 128;
/*   54 */   static short KOPI20_IF_CMSB = 64;
/*   55 */   static short KOPI20_IF_CLSB = 32;
/*   56 */   static short KOPI20_IF_DEGN = 16;
/*   57 */   static short KOPI20_IF_COLL = 8;
/*   58 */   static short KOPI20_IF_NOPS = 4;
/*   59 */   static short KOPI20_IF_ANY = 2;
/*   60 */   static short KOPI20_IF_NONL = 1;
/*      */ 
/*   67 */   static short KOPI20_CF_CMSB = 64;
/*   68 */   static short KOPI20_CF_CLSB = 32;
/*   69 */   static short KOPI20_CF_INDX = 16;
/*   70 */   static short KOPI20_CF_NOLN = 8;
/*      */ 
/*   72 */   static short KOPI20_VERSION = 1;
/*      */   static final byte KOPUP_INLINE_COLL = 1;
/*      */   static final byte KOPUP_TYPEINFO_NONE = 0;
/*      */   static final byte KOPUP_TYPEINFO_TOID = 4;
/*      */   static final byte KOPUP_TYPEINFO_TOBJN = 8;
/*      */   static final byte KOPUP_TYPEINFO_TDS = 12;
/*      */   static final byte KOPUP_VSN_PRESENT = 16;
/* 1066 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public PickleContext()
/*      */   {
/*   90 */     this.lengthBuffer = new byte[5];
/*      */   }
/*      */ 
/*      */   public PickleContext(byte[] paramArrayOfByte)
/*      */   {
/*   97 */     this.lengthBuffer = new byte[5];
/*   98 */     this.image = paramArrayOfByte;
/*   99 */     this.imageOffset = 0;
/*      */   }
/*      */ 
/*      */   public PickleContext(byte[] paramArrayOfByte, long paramLong)
/*      */   {
/*  106 */     this.lengthBuffer = new byte[5];
/*  107 */     this.image = paramArrayOfByte;
/*  108 */     this.imageOffset = ((int)paramLong);
/*      */   }
/*      */ 
/*      */   public void initStream(int paramInt)
/*      */   {
/*  119 */     this.outStream = new PickleOutputStream(paramInt);
/*      */   }
/*      */ 
/*      */   public void initStream()
/*      */   {
/*  129 */     this.outStream = new PickleOutputStream();
/*      */   }
/*      */ 
/*      */   public int lengthInBytes(int paramInt)
/*      */   {
/*  141 */     return paramInt <= KOPI20_LN_MAXV ? 1 : 5;
/*      */   }
/*      */ 
/*      */   public int writeElementNull()
/*      */     throws SQLException
/*      */   {
/*  152 */     this.outStream.write(KOPI20_LN_ELNL);
/*      */ 
/*  154 */     return 1;
/*      */   }
/*      */ 
/*      */   public int writeAtomicNull()
/*      */     throws SQLException
/*      */   {
/*  165 */     this.outStream.write(KOPI20_LN_ATMN);
/*      */ 
/*  167 */     return 1;
/*      */   }
/*      */ 
/*      */   public int writeImmediatelyEmbeddedElementNull(byte paramByte)
/*      */     throws SQLException
/*      */   {
/*  181 */     this.lengthBuffer[0] = ((byte)KOPI20_LN_IEMN);
/*  182 */     this.lengthBuffer[1] = paramByte;
/*      */ 
/*  184 */     this.outStream.write(this.lengthBuffer, 0, 2);
/*      */ 
/*  186 */     return 2;
/*      */   }
/*      */ 
/*      */   public int writeSB2(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  198 */     this.lengthBuffer[0] = ((byte)(paramInt >> 8 & 0xFF));
/*  199 */     this.lengthBuffer[1] = ((byte)(paramInt & 0xFF));
/*  200 */     this.outStream.write(this.lengthBuffer, 0, 2);
/*      */ 
/*  202 */     return 2;
/*      */   }
/*      */ 
/*      */   public int writeLength(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  213 */     if (paramInt <= KOPI20_LN_MAXV)
/*      */     {
/*  215 */       this.outStream.write((byte)paramInt);
/*      */ 
/*  217 */       return 1;
/*      */     }
/*      */ 
/*  221 */     this.lengthBuffer[0] = ((byte)KOPI20_LN_5BLN);
/*  222 */     this.lengthBuffer[1] = ((byte)(paramInt >> 24));
/*  223 */     paramInt &= 16777215;
/*  224 */     this.lengthBuffer[2] = ((byte)(paramInt >> 16));
/*  225 */     paramInt &= 65535;
/*  226 */     this.lengthBuffer[3] = ((byte)(paramInt >> 8));
/*  227 */     paramInt &= 255;
/*  228 */     this.lengthBuffer[4] = ((byte)paramInt);
/*      */     try
/*      */     {
/*  232 */       this.outStream.write(this.lengthBuffer);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  239 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  240 */       localSQLException.fillInStackTrace();
/*  241 */       throw localSQLException;
/*      */     }
/*      */ 
/*  245 */     return 5;
/*      */   }
/*      */ 
/*      */   public int writeLength(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  257 */     if (!paramBoolean)
/*  258 */       return writeLength(paramInt);
/*  259 */     if (paramInt <= KOPI20_LN_MAXV - 1)
/*      */     {
/*  261 */       this.outStream.write((byte)paramInt + 1);
/*      */ 
/*  263 */       return 1;
/*      */     }
/*      */ 
/*  267 */     paramInt += 5;
/*  268 */     this.lengthBuffer[0] = ((byte)KOPI20_LN_5BLN);
/*  269 */     this.lengthBuffer[1] = ((byte)(paramInt >> 24));
/*  270 */     paramInt &= 16777215;
/*  271 */     this.lengthBuffer[2] = ((byte)(paramInt >> 16));
/*  272 */     paramInt &= 65535;
/*  273 */     this.lengthBuffer[3] = ((byte)(paramInt >> 8));
/*  274 */     paramInt &= 255;
/*  275 */     this.lengthBuffer[4] = ((byte)paramInt);
/*      */     try
/*      */     {
/*  279 */       this.outStream.write(this.lengthBuffer);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  286 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  287 */       localSQLException.fillInStackTrace();
/*  288 */       throw localSQLException;
/*      */     }
/*      */ 
/*  292 */     return 5;
/*      */   }
/*      */ 
/*      */   public byte[] to5bLengthBytes_pctx(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  304 */     this.lengthBuffer[0] = ((byte)KOPI20_LN_5BLN);
/*  305 */     this.lengthBuffer[1] = ((byte)(paramInt >> 24));
/*  306 */     paramInt &= 16777215;
/*  307 */     this.lengthBuffer[2] = ((byte)(paramInt >> 16));
/*  308 */     paramInt &= 65535;
/*  309 */     this.lengthBuffer[3] = ((byte)(paramInt >> 8));
/*  310 */     paramInt &= 255;
/*  311 */     this.lengthBuffer[4] = ((byte)paramInt);
/*      */ 
/*  313 */     return this.lengthBuffer;
/*      */   }
/*      */ 
/*      */   public int writeData(byte paramByte)
/*      */     throws SQLException
/*      */   {
/*  324 */     this.outStream.write(paramByte);
/*      */ 
/*  326 */     return 1;
/*      */   }
/*      */ 
/*      */   public int writeData(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/*  338 */       this.outStream.write(paramArrayOfByte);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  345 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  346 */       localSQLException.fillInStackTrace();
/*  347 */       throw localSQLException;
/*      */     }
/*      */ 
/*  351 */     return paramArrayOfByte.length;
/*      */   }
/*      */ 
/*      */   public void patchImageLen(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  361 */     byte[] arrayOfByte = to5bLengthBytes_pctx(paramInt2);
/*      */ 
/*  363 */     this.outStream.overwrite(paramInt1, arrayOfByte, 0, arrayOfByte.length);
/*      */   }
/*      */ 
/*      */   public int writeImageHeader(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  376 */     return writeImageHeader(KOPI20_LN_MAXV + 1, paramBoolean);
/*      */   }
/*      */ 
/*      */   public int writeOpaqueImageHeader(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  391 */     int i = 2;
/*      */ 
/*  393 */     this.lengthBuffer[0] = ((byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS | KOPI20_IF_NONL));
/*  394 */     this.lengthBuffer[1] = ((byte)KOPI20_VERSION);
/*      */ 
/*  396 */     this.outStream.write(this.lengthBuffer, 0, 2);
/*      */ 
/*  398 */     i += writeLength(paramInt + 2, true);
/*      */ 
/*  400 */     return i;
/*      */   }
/*      */ 
/*      */   public int writeImageHeader(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  415 */     int i = 2;
/*      */ 
/*  417 */     if (paramBoolean)
/*  418 */       this.lengthBuffer[0] = ((byte)KOPI20_IF_IS81);
/*      */     else {
/*  420 */       this.lengthBuffer[0] = ((byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS));
/*      */     }
/*  422 */     this.lengthBuffer[1] = ((byte)KOPI20_VERSION);
/*      */ 
/*  424 */     this.outStream.write(this.lengthBuffer, 0, 2);
/*      */ 
/*  426 */     i += writeLength(paramInt);
/*      */ 
/*  428 */     return i;
/*      */   }
/*      */ 
/*      */   public int writeCollImageHeader(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  441 */     return writeCollImageHeader(KOPI20_LN_MAXV + 1, paramInt1, paramInt2);
/*      */   }
/*      */ 
/*      */   public int writeCollImageHeader(int paramInt1, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/*  457 */     int i = 5;
/*      */ 
/*  459 */     this.lengthBuffer[0] = ((byte)(KOPI20_IF_IS81 | KOPI20_IF_COLL));
/*  460 */     this.lengthBuffer[1] = ((byte)KOPI20_VERSION);
/*      */ 
/*  462 */     this.outStream.write(this.lengthBuffer, 0, 2);
/*      */ 
/*  464 */     i += writeLength(paramInt1);
/*      */ 
/*  466 */     this.lengthBuffer[0] = 1;
/*      */ 
/*  468 */     this.lengthBuffer[1] = 17;
/*      */ 
/*  470 */     if (paramInt3 > KOPI20_LN_MAXV)
/*      */     {
/*      */       int tmp77_76 = 0;
/*      */       byte[] tmp77_73 = this.lengthBuffer; tmp77_73[tmp77_76] = ((byte)(tmp77_73[tmp77_76] + 5));
/*  473 */       i += 5;
/*      */ 
/*  476 */       this.outStream.write(this.lengthBuffer, 0, 2);
/*  477 */       writeLength(paramInt3);
/*      */     }
/*      */     else
/*      */     {
/*      */       int tmp113_112 = 0;
/*      */       byte[] tmp113_109 = this.lengthBuffer; tmp113_109[tmp113_112] = ((byte)(tmp113_109[tmp113_112] + 2));
/*  482 */       i += 2;
/*      */ 
/*  484 */       this.outStream.write(this.lengthBuffer, 0, 2);
/*  485 */       writeSB2(paramInt3);
/*      */     }
/*      */ 
/*  488 */     this.lengthBuffer[0] = 0;
/*      */ 
/*  490 */     this.outStream.write(this.lengthBuffer, 0, 1);
/*      */ 
/*  492 */     i += writeLength(paramInt2);
/*      */ 
/*  494 */     return i;
/*      */   }
/*      */ 
/*      */   public int writeCollImageHeader(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  501 */     return writeCollImageHeader(KOPI20_LN_MAXV + 1, paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public int writeCollImageHeader(int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  509 */     int i = paramArrayOfByte.length;
/*      */ 
/*  512 */     int j = 3 + i;
/*      */ 
/*  514 */     this.lengthBuffer[0] = ((byte)(KOPI20_IF_IS81 | KOPI20_IF_DEGN));
/*  515 */     this.lengthBuffer[1] = ((byte)KOPI20_VERSION);
/*      */ 
/*  517 */     this.outStream.write(this.lengthBuffer, 0, 2);
/*      */ 
/*  519 */     j += writeLength(paramInt);
/*  520 */     j += writeLength(i + 1);
/*      */ 
/*  522 */     this.lengthBuffer[0] = 0;
/*      */ 
/*  524 */     this.outStream.write(this.lengthBuffer, 0, 1);
/*  525 */     this.outStream.write(paramArrayOfByte, 0, i);
/*      */ 
/*  527 */     return j;
/*      */   }
/*      */ 
/*      */   public byte[] stream2Bytes()
/*      */     throws SQLException
/*      */   {
/*  537 */     return this.outStream.toByteArray();
/*      */   }
/*      */ 
/*      */   public byte readByte()
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/*  551 */       return this.image[this.imageOffset];
/*      */     }
/*      */     finally
/*      */     {
/*  555 */       this.imageOffset += 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean readAndCheckVersion()
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/*  570 */       return (this.image[this.imageOffset] & 0xFF) <= KOPI20_VERSION;
/*      */     }
/*      */     finally
/*      */     {
/*  574 */       this.imageOffset += 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public int readLength()
/*      */     throws SQLException
/*      */   {
/*  591 */     int i = this.image[this.imageOffset] & 0xFF;
/*      */ 
/*  593 */     if (i > KOPI20_LN_MAXV)
/*      */     {
/*  595 */       if (i == KOPI20_LN_ELNL)
/*      */       {
/*  598 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Invalid null flag read");
/*  599 */         localSQLException.fillInStackTrace();
/*  600 */         throw localSQLException;
/*      */       }
/*      */ 
/*  617 */       i = (((this.image[(this.imageOffset + 1)] & 0xFF) * 256 + (this.image[(this.imageOffset + 2)] & 0xFF)) * 256 + (this.image[(this.imageOffset + 3)] & 0xFF)) * 256 + (this.image[(this.imageOffset + 4)] & 0xFF);
/*      */ 
/*  621 */       this.imageOffset += 5;
/*      */     }
/*      */     else
/*      */     {
/*  625 */       this.imageOffset += 1;
/*  626 */     }return i;
/*      */   }
/*      */ 
/*      */   public void skipLength()
/*      */     throws SQLException
/*      */   {
/*  633 */     int i = this.image[this.imageOffset] & 0xFF;
/*      */ 
/*  635 */     if (i > KOPI20_LN_MAXV)
/*  636 */       this.imageOffset += 5;
/*      */     else
/*  638 */       this.imageOffset += 1;
/*      */   }
/*      */ 
/*      */   public int readRestOfLength(byte paramByte)
/*      */     throws SQLException
/*      */   {
/*  650 */     if ((paramByte & 0xFF) != KOPI20_LN_5BLN) {
/*  651 */       return paramByte & 0xFF;
/*      */     }
/*      */     try
/*      */     {
/*  655 */       return (((this.image[this.imageOffset] & 0xFF) * 256 + (this.image[(this.imageOffset + 1)] & 0xFF)) * 256 + (this.image[(this.imageOffset + 2)] & 0xFF)) * 256 + (this.image[(this.imageOffset + 3)] & 0xFF);
/*      */     }
/*      */     finally
/*      */     {
/*  660 */       this.imageOffset += 4;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void skipRestOfLength(byte paramByte)
/*      */     throws SQLException
/*      */   {
/*  668 */     if ((paramByte & 0xFF) > KOPI20_LN_MAXV)
/*      */     {
/*  670 */       if ((paramByte & 0xFF) == KOPI20_LN_5BLN) {
/*  671 */         this.imageOffset += 4;
/*      */       }
/*      */       else {
/*  674 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Invalid first length byte");
/*  675 */         localSQLException.fillInStackTrace();
/*  676 */         throw localSQLException;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int readLength(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  687 */     int i = this.image[this.imageOffset] & 0xFF;
/*      */ 
/*  689 */     if (i > KOPI20_LN_MAXV)
/*      */     {
/*  706 */       i = (((this.image[(this.imageOffset + 1)] & 0xFF) * 256 + (this.image[(this.imageOffset + 2)] & 0xFF)) * 256 + (this.image[(this.imageOffset + 3)] & 0xFF)) * 256 + (this.image[(this.imageOffset + 4)] & 0xFF);
/*      */ 
/*  710 */       if (paramBoolean) {
/*  711 */         i -= 5;
/*      */       }
/*  713 */       this.imageOffset += 5;
/*      */     }
/*      */     else
/*      */     {
/*  718 */       if (paramBoolean) {
/*  719 */         i--;
/*      */       }
/*  721 */       this.imageOffset += 1;
/*      */     }
/*      */ 
/*  724 */     return i;
/*      */   }
/*      */ 
/*      */   public byte[] readPrefixSegment()
/*      */     throws SQLException
/*      */   {
/*  735 */     byte[] arrayOfByte = new byte[readLength()];
/*      */ 
/*  737 */     System.arraycopy(this.image, this.imageOffset, arrayOfByte, 0, arrayOfByte.length);
/*      */ 
/*  739 */     this.imageOffset += arrayOfByte.length;
/*  740 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public byte[] readDataValue()
/*      */     throws SQLException
/*      */   {
/*  752 */     int i = this.image[this.imageOffset] & 0xFF;
/*      */ 
/*  755 */     if (i == KOPI20_LN_ELNL)
/*      */     {
/*  757 */       this.imageOffset += 1;
/*      */ 
/*  759 */       return null;
/*      */     }
/*      */ 
/*  762 */     if (i > KOPI20_LN_MAXV)
/*      */     {
/*  764 */       i = (((this.image[(this.imageOffset + 1)] & 0xFF) * 256 + (this.image[(this.imageOffset + 2)] & 0xFF)) * 256 + (this.image[(this.imageOffset + 3)] & 0xFF)) * 256 + (this.image[(this.imageOffset + 4)] & 0xFF);
/*      */ 
/*  768 */       this.imageOffset += 5;
/*      */     }
/*      */     else {
/*  771 */       this.imageOffset += 1;
/*      */     }
/*      */ 
/*  774 */     byte[] arrayOfByte = new byte[i];
/*      */ 
/*  776 */     System.arraycopy(this.image, this.imageOffset, arrayOfByte, 0, arrayOfByte.length);
/*      */ 
/*  778 */     this.imageOffset += arrayOfByte.length;
/*      */ 
/*  780 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public byte[] readBytes(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  787 */     byte[] arrayOfByte = new byte[paramInt];
/*      */ 
/*  789 */     System.arraycopy(this.image, this.imageOffset, arrayOfByte, 0, paramInt);
/*      */ 
/*  791 */     this.imageOffset += paramInt;
/*  792 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public byte[] read1ByteDataValue()
/*      */     throws SQLException
/*      */   {
/*  805 */     if ((this.image[this.imageOffset] & 0xFF) == KOPI20_LN_ELNL) {
/*  806 */       return null;
/*      */     }
/*      */ 
/*  810 */     byte[] arrayOfByte = new byte[this.image[this.imageOffset] & 0xFF];
/*      */ 
/*  812 */     System.arraycopy(this.image, this.imageOffset + 1, arrayOfByte, 0, arrayOfByte.length);
/*      */ 
/*  814 */     this.imageOffset += arrayOfByte.length + 1;
/*  815 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public byte[] readDataValue(byte paramByte)
/*      */     throws SQLException
/*      */   {
/*  827 */     byte[] arrayOfByte = new byte[readRestOfLength(paramByte)];
/*      */ 
/*  829 */     System.arraycopy(this.image, this.imageOffset, arrayOfByte, 0, arrayOfByte.length);
/*      */ 
/*  831 */     this.imageOffset += arrayOfByte.length;
/*      */ 
/*  833 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public byte[] readDataValue(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  843 */     byte[] arrayOfByte = new byte[paramInt];
/*      */ 
/*  845 */     System.arraycopy(this.image, this.imageOffset, arrayOfByte, 0, paramInt);
/*      */ 
/*  847 */     this.imageOffset += paramInt;
/*  848 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public long readUB4()
/*      */     throws SQLException
/*      */   {
/*  856 */     long l = this.image[(this.imageOffset++)] << 24 & 0xFF000000 | this.image[(this.imageOffset++)] << 16 & 0xFF0000 | this.image[(this.imageOffset++)] << 8 & 0xFF00 | this.image[(this.imageOffset++)] & 0xFF;
/*      */ 
/*  860 */     return l;
/*      */   }
/*      */ 
/*      */   public int readUB2()
/*      */     throws SQLException
/*      */   {
/*  867 */     int i = this.image[(this.imageOffset++)] << 8 & 0xFF00 | this.image[(this.imageOffset++)] & 0xFF;
/*      */ 
/*  869 */     return i;
/*      */   }
/*      */ 
/*      */   public void skipDataValue()
/*      */     throws SQLException
/*      */   {
/*  883 */     if ((this.image[this.imageOffset] & 0xFF) == KOPI20_LN_ELNL)
/*  884 */       this.imageOffset += 1;
/*      */     else
/*  886 */       skipBytes(readLength());
/*      */   }
/*      */ 
/*      */   public void skipDataValue(byte paramByte)
/*      */     throws SQLException
/*      */   {
/*  898 */     skipBytes(readRestOfLength(paramByte));
/*      */   }
/*      */ 
/*      */   public void skipBytes(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  905 */     if (paramInt > 0)
/*  906 */       this.imageOffset += paramInt;
/*      */   }
/*      */ 
/*      */   public int offset()
/*      */     throws SQLException
/*      */   {
/*  913 */     if (this.outStream != null) {
/*  914 */       return this.outStream.offset();
/*      */     }
/*  916 */     return this.imageOffset;
/*      */   }
/*      */ 
/*      */   public int absoluteOffset()
/*      */     throws SQLException
/*      */   {
/*  923 */     return this.imageOffset;
/*      */   }
/*      */ 
/*      */   public void skipTo(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  930 */     if (paramLong > this.imageOffset)
/*  931 */       this.imageOffset = ((int)paramLong);
/*      */   }
/*      */ 
/*      */   public byte[] image()
/*      */     throws SQLException
/*      */   {
/*  938 */     return this.image;
/*      */   }
/*      */ 
/*      */   public static boolean is81format(byte paramByte)
/*      */     throws SQLException
/*      */   {
/*  952 */     return (paramByte & 0xFF & KOPI20_IF_IS81) != 0;
/*      */   }
/*      */ 
/*      */   public static boolean isCollectionImage_pctx(byte paramByte)
/*      */     throws SQLException
/*      */   {
/*  963 */     return (paramByte & 0xFF & KOPI20_IF_COLL) != 0;
/*      */   }
/*      */ 
/*      */   public static boolean isDegenerateImage_pctx(byte paramByte)
/*      */     throws SQLException
/*      */   {
/*  974 */     return (paramByte & 0xFF & KOPI20_IF_DEGN) != 0;
/*      */   }
/*      */ 
/*      */   public static boolean hasPrefix(byte paramByte)
/*      */     throws SQLException
/*      */   {
/*  985 */     return (paramByte & 0xFF & KOPI20_IF_NOPS) == 0;
/*      */   }
/*      */ 
/*      */   public static boolean isAtomicNull(byte paramByte)
/*      */     throws SQLException
/*      */   {
/*  995 */     return (paramByte & 0xFF) == KOPI20_LN_ATMN;
/*      */   }
/*      */ 
/*      */   public static boolean isImmediatelyEmbeddedNull(byte paramByte)
/*      */     throws SQLException
/*      */   {
/* 1005 */     return (paramByte & 0xFF) == KOPI20_LN_IEMN;
/*      */   }
/*      */ 
/*      */   public static boolean isElementNull(byte paramByte)
/*      */     throws SQLException
/*      */   {
/* 1015 */     return (paramByte & 0xFF) == KOPI20_LN_ELNL;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1030 */     return null;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.PickleContext
 * JD-Core Version:    0.6.2
 */