/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.Serializable;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.ARRAY;
/*     */ import oracle.sql.ArrayDescriptor;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.OPAQUE;
/*     */ import oracle.sql.STRUCT;
/*     */ import oracle.sql.StructDescriptor;
/*     */ 
/*     */ public class OracleTypeUPT extends OracleTypeADT
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = -1994358478872378695L;
/*     */   static final byte KOPU_UPT_ADT = -6;
/*     */   static final byte KOPU_UPT_COLL = -5;
/*     */   static final byte KOPU_UPT_REFCUR = 102;
/*     */   static final byte KOTTCOPQ = 58;
/*  48 */   byte uptCode = 0;
/*  49 */   OracleNamedType realType = null;
/*     */ 
/* 565 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected OracleTypeUPT()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleTypeUPT(String paramString, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  65 */     super(paramString, paramOracleConnection);
/*     */   }
/*     */ 
/*     */   public OracleTypeUPT(OracleTypeADT paramOracleTypeADT, int paramInt, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  73 */     super(paramOracleTypeADT, paramInt, paramOracleConnection);
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  90 */     if (paramObject != null) {
/*  91 */       return this.realType.toDatum(paramObject, paramOracleConnection);
/*     */     }
/*  93 */     return null;
/*     */   }
/*     */ 
/*     */   public Datum[] toDatumArray(Object paramObject, OracleConnection paramOracleConnection, long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 107 */     if (paramObject != null) {
/* 108 */       return this.realType.toDatumArray(paramObject, paramOracleConnection, paramLong, paramInt);
/*     */     }
/* 110 */     return null;
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */     throws SQLException
/*     */   {
/* 121 */     switch (this.uptCode)
/*     */     {
/*     */     case -6:
/* 125 */       return this.realType.getTypeCode();
/*     */     case -5:
/* 128 */       return 2003;
/*     */     case 58:
/* 131 */       return 2007;
/*     */     }
/*     */ 
/* 135 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Invalid type code");
/* 136 */     localSQLException.fillInStackTrace();
/* 137 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public boolean isInHierarchyOf(OracleType paramOracleType)
/*     */     throws SQLException
/*     */   {
/* 151 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isInHierarchyOf(StructDescriptor paramStructDescriptor)
/*     */     throws SQLException
/*     */   {
/* 159 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isObjectType()
/*     */   {
/* 166 */     return false;
/*     */   }
/*     */ 
/*     */   public void parseTDSrec(TDSReader paramTDSReader)
/*     */     throws SQLException
/*     */   {
/* 178 */     long l = paramTDSReader.readLong();
/*     */ 
/* 180 */     this.uptCode = paramTDSReader.readByte();
/*     */ 
/* 182 */     paramTDSReader.addNormalPatch(l, this.uptCode, this);
/*     */   }
/*     */ 
/*     */   protected int pickle81(PickleContext paramPickleContext, Datum paramDatum)
/*     */     throws SQLException
/*     */   {
/* 197 */     int i = 0;
/*     */ 
/* 199 */     if (paramDatum == null)
/*     */     {
/* 201 */       i += paramPickleContext.writeElementNull();
/*     */     }
/*     */     else
/*     */     {
/* 205 */       int j = paramPickleContext.offset();
/*     */ 
/* 207 */       i += paramPickleContext.writeLength(PickleContext.KOPI20_LN_MAXV + 1);
/*     */ 
/* 209 */       int k = 0;
/*     */ 
/* 212 */       if ((this.uptCode == -6) && (!((OracleTypeADT)this.realType).isFinalType()))
/*     */       {
/* 214 */         if ((paramDatum instanceof STRUCT))
/*     */         {
/* 216 */           k = ((STRUCT)paramDatum).getDescriptor().getOracleTypeADT().pickle81(paramPickleContext, paramDatum);
/*     */         }
/*     */         else
/*     */         {
/* 222 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "invalid upt state");
/* 223 */           localSQLException.fillInStackTrace();
/* 224 */           throw localSQLException;
/*     */         }
/*     */       }
/*     */       else {
/* 228 */         k = this.realType.pickle81(paramPickleContext, paramDatum);
/*     */       }
/* 230 */       i += k;
/*     */ 
/* 232 */       paramPickleContext.patchImageLen(j, k);
/*     */     }
/*     */ 
/* 235 */     return i;
/*     */   }
/*     */ 
/*     */   protected Object unpickle81rec(PickleContext paramPickleContext, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 252 */     byte b = paramPickleContext.readByte();
/*     */ 
/* 254 */     if (PickleContext.isElementNull(b))
/*     */     {
/* 256 */       return null;
/*     */     }
/* 258 */     if (paramInt == 9)
/*     */     {
/* 260 */       paramPickleContext.skipBytes(paramPickleContext.readRestOfLength(b));
/*     */ 
/* 262 */       return null;
/*     */     }
/*     */ 
/* 266 */     paramPickleContext.skipRestOfLength(b);
/*     */ 
/* 268 */     return unpickle81UPT(paramPickleContext, paramInt, paramMap);
/*     */   }
/*     */ 
/*     */   protected Object unpickle81rec(PickleContext paramPickleContext, byte paramByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 282 */     long l = paramPickleContext.readRestOfLength(paramByte);
/*     */ 
/* 284 */     if (paramInt == 9)
/*     */     {
/* 286 */       paramPickleContext.skipBytes((int)l);
/*     */ 
/* 288 */       return null;
/*     */     }
/*     */ 
/* 291 */     return unpickle81UPT(paramPickleContext, paramInt, paramMap);
/*     */   }
/*     */ 
/*     */   private Object unpickle81UPT(PickleContext paramPickleContext, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/*     */     SQLException localSQLException;
/* 300 */     switch (this.uptCode)
/*     */     {
/*     */     case -6:
/* 305 */       switch (paramInt)
/*     */       {
/*     */       case 1:
/* 309 */         return ((OracleTypeADT)this.realType).unpickle81(paramPickleContext, (STRUCT)null, 3, paramInt, paramMap);
/*     */       case 2:
/* 313 */         localObject = ((OracleTypeADT)this.realType).unpickle81(paramPickleContext, (STRUCT)null, 1, paramInt, paramMap);
/*     */ 
/* 316 */         return localObject == null ? localObject : ((STRUCT)localObject).toJdbc(paramMap);
/*     */       case 9:
/* 319 */         return ((OracleTypeADT)this.realType).unpickle81(paramPickleContext, (STRUCT)null, 9, 1, paramMap);
/*     */       }
/*     */ 
/* 324 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/* 325 */       localSQLException.fillInStackTrace();
/* 326 */       throw localSQLException;
/*     */     case -5:
/* 333 */       return ((OracleTypeCOLLECTION)this.realType).unpickle81(paramPickleContext, (ARRAY)null, paramInt == 9 ? paramInt : 3, paramInt, paramMap);
/*     */     case 58:
/* 339 */       switch (paramInt)
/*     */       {
/*     */       case 1:
/*     */       case 9:
/* 344 */         return ((OracleTypeOPAQUE)this.realType).unpickle81(paramPickleContext, (OPAQUE)null, paramInt, paramMap);
/*     */       case 2:
/* 348 */         localObject = ((OracleTypeOPAQUE)this.realType).unpickle81(paramPickleContext, (OPAQUE)null, paramInt, paramMap);
/*     */ 
/* 351 */         return localObject == null ? localObject : ((OPAQUE)localObject).toJdbc(paramMap);
/*     */       }
/*     */ 
/* 355 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/* 356 */       localSQLException.fillInStackTrace();
/* 357 */       throw localSQLException;
/*     */     }
/*     */ 
/* 364 */     Object localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Unrecognized UPT code");
/* 365 */     ((SQLException)localObject).fillInStackTrace();
/* 366 */     throw ((Throwable)localObject);
/*     */   }
/*     */ 
/*     */   protected Datum unpickle81datumAsNull(PickleContext paramPickleContext, byte paramByte1, byte paramByte2)
/*     */     throws SQLException
/*     */   {
/* 378 */     return null;
/*     */   }
/*     */ 
/*     */   StructDescriptor createStructDescriptor()
/*     */     throws SQLException
/*     */   {
/* 390 */     StructDescriptor localStructDescriptor = null;
/*     */ 
/* 392 */     if (this.sqlName == null)
/* 393 */       localStructDescriptor = new StructDescriptor((OracleTypeADT)this.realType, this.connection);
/*     */     else {
/* 395 */       localStructDescriptor = StructDescriptor.createDescriptor(this.sqlName, this.connection);
/*     */     }
/* 397 */     return localStructDescriptor;
/*     */   }
/*     */ 
/*     */   ArrayDescriptor createArrayDescriptor()
/*     */     throws SQLException
/*     */   {
/* 405 */     ArrayDescriptor localArrayDescriptor = null;
/*     */ 
/* 407 */     if (this.sqlName == null)
/* 408 */       localArrayDescriptor = new ArrayDescriptor((OracleTypeCOLLECTION)this.realType, this.connection);
/*     */     else {
/* 410 */       localArrayDescriptor = ArrayDescriptor.createDescriptor(this.sqlName, this.connection);
/*     */     }
/* 412 */     return localArrayDescriptor;
/*     */   }
/*     */ 
/*     */   public OracleType getRealType()
/*     */     throws SQLException
/*     */   {
/* 419 */     return this.realType;
/*     */   }
/*     */ 
/*     */   public int getNumAttrs()
/*     */     throws SQLException
/*     */   {
/* 426 */     return ((OracleTypeADT)this.realType).getNumAttrs();
/*     */   }
/*     */ 
/*     */   public OracleType getAttrTypeAt(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 433 */     return ((OracleTypeADT)this.realType).getAttrTypeAt(paramInt);
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/* 444 */     paramObjectOutputStream.writeByte(this.uptCode);
/* 445 */     paramObjectOutputStream.writeObject(this.realType);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 453 */     this.uptCode = paramObjectInputStream.readByte();
/* 454 */     this.realType = ((OracleNamedType)paramObjectInputStream.readObject());
/*     */   }
/*     */ 
/*     */   public void setConnection(OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 462 */     this.connection = paramOracleConnection;
/*     */ 
/* 464 */     this.realType.setConnection(paramOracleConnection);
/*     */   }
/*     */ 
/*     */   public void initChildNamesRecursively(Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 471 */     if (this.realType != null)
/*     */     {
/* 473 */       this.realType.setSqlName(this.sqlName);
/* 474 */       this.realType.initChildNamesRecursively(paramMap);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void initMetadataRecursively()
/*     */     throws SQLException
/*     */   {
/* 482 */     initMetadata(this.connection);
/* 483 */     if (this.realType != null) this.realType.initMetadataRecursively();
/*     */   }
/*     */ 
/*     */   public void cacheDescriptor()
/*     */     throws SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void printXML(PrintWriter paramPrintWriter, int paramInt, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 498 */     for (int i = 0; i < paramInt; i++) paramPrintWriter.print("  ");
/* 499 */     paramPrintWriter.println("<OracleTypeUPT sqlName=\"" + this.sqlName + "\" " + " toid=\"" + this.toid + "\" " + ">");
/*     */ 
/* 503 */     if (this.realType != null)
/* 504 */       this.realType.printXML(paramPrintWriter, paramInt + 1, paramBoolean);
/* 505 */     for (i = 0; i < paramInt; i++) paramPrintWriter.print("  ");
/* 506 */     paramPrintWriter.println("</OracleTypeUPT>");
/*     */   }
/*     */ 
/*     */   public void printXML(PrintWriter paramPrintWriter, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 513 */     printXML(paramPrintWriter, paramInt, false);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeUPT
 * JD-Core Version:    0.6.2
 */