/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.Date;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.DATE;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.TIMESTAMPTZ;
/*     */ 
/*     */ public class OracleTypeTIMESTAMPTZ extends OracleType
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = 5643686037837085645L;
/*  58 */   int precision = 0;
/*     */   transient OracleConnection connection;
/* 252 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected OracleTypeTIMESTAMPTZ()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleTypeTIMESTAMPTZ(OracleConnection paramOracleConnection)
/*     */   {
/*  79 */     this.connection = paramOracleConnection;
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */   {
/*  90 */     return -101;
/*     */   }
/*     */ 
/*     */   public void parseTDSrec(TDSReader paramTDSReader)
/*     */     throws SQLException
/*     */   {
/*  98 */     this.precision = paramTDSReader.readByte();
/*     */   }
/*     */ 
/*     */   public int getScale()
/*     */     throws SQLException
/*     */   {
/* 105 */     return 0;
/*     */   }
/*     */ 
/*     */   public int getPrecision()
/*     */     throws SQLException
/*     */   {
/* 112 */     return this.precision;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 121 */     this.precision = paramObjectInputStream.readByte();
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/* 129 */     paramObjectOutputStream.writeByte(this.precision);
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 137 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 138 */       return null;
/*     */     }
/* 140 */     switch (paramInt)
/*     */     {
/*     */     case 1:
/* 144 */       return new TIMESTAMPTZ(paramArrayOfByte);
/*     */     case 2:
/* 147 */       return TIMESTAMPTZ.toTimestamp(this.connection, paramArrayOfByte);
/*     */     case 3:
/* 150 */       return paramArrayOfByte;
/*     */     }
/*     */ 
/* 154 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 155 */     localSQLException.fillInStackTrace();
/* 156 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 175 */     TIMESTAMPTZ localTIMESTAMPTZ = null;
/*     */ 
/* 177 */     if (paramObject != null)
/*     */     {
/*     */       try
/*     */       {
/* 181 */         if ((paramObject instanceof TIMESTAMPTZ)) {
/* 182 */           localTIMESTAMPTZ = (TIMESTAMPTZ)paramObject;
/* 183 */         } else if ((paramObject instanceof byte[])) {
/* 184 */           localTIMESTAMPTZ = new TIMESTAMPTZ((byte[])paramObject);
/* 185 */         } else if ((paramObject instanceof Timestamp)) {
/* 186 */           localTIMESTAMPTZ = new TIMESTAMPTZ(paramOracleConnection, (Timestamp)paramObject);
/* 187 */         } else if ((paramObject instanceof DATE)) {
/* 188 */           localTIMESTAMPTZ = new TIMESTAMPTZ(paramOracleConnection, (DATE)paramObject);
/* 189 */         } else if ((paramObject instanceof String)) {
/* 190 */           localTIMESTAMPTZ = new TIMESTAMPTZ(paramOracleConnection, (String)paramObject);
/* 191 */         } else if ((paramObject instanceof Date)) {
/* 192 */           localTIMESTAMPTZ = new TIMESTAMPTZ(paramOracleConnection, (Date)paramObject);
/* 193 */         } else if ((paramObject instanceof Time)) {
/* 194 */           localTIMESTAMPTZ = new TIMESTAMPTZ(paramOracleConnection, (Time)paramObject);
/*     */         }
/*     */         else {
/* 197 */           SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/* 198 */           localSQLException1.fillInStackTrace();
/* 199 */           throw localSQLException1;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Exception localException)
/*     */       {
/* 205 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/* 206 */         localSQLException2.fillInStackTrace();
/* 207 */         throw localSQLException2;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 212 */     return localTIMESTAMPTZ;
/*     */   }
/*     */ 
/*     */   protected Object unpickle81rec(UnpickleContext paramUnpickleContext, int paramInt1, int paramInt2, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 226 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90);
/* 227 */     localSQLException.fillInStackTrace();
/* 228 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 244 */     return this.connection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeTIMESTAMPTZ
 * JD-Core Version:    0.6.2
 */