/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.Date;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.DATE;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.TIMESTAMPLTZ;
/*     */ 
/*     */ public class OracleTypeTIMESTAMPLTZ extends OracleType
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = 1615519855865602397L;
/*  58 */   int precision = 0;
/*     */   transient OracleConnection connection;
/* 247 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected OracleTypeTIMESTAMPLTZ()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleTypeTIMESTAMPLTZ(OracleConnection paramOracleConnection)
/*     */   {
/*  79 */     this.connection = paramOracleConnection;
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */   {
/*  90 */     return -102;
/*     */   }
/*     */ 
/*     */   public void parseTDSrec(TDSReader paramTDSReader)
/*     */     throws SQLException
/*     */   {
/*  98 */     this.precision = paramTDSReader.readByte();
/*     */   }
/*     */ 
/*     */   public int getScale()
/*     */     throws SQLException
/*     */   {
/* 105 */     return 0;
/*     */   }
/*     */ 
/*     */   public int getPrecision()
/*     */     throws SQLException
/*     */   {
/* 112 */     return this.precision;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 121 */     this.precision = paramObjectInputStream.readByte();
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/* 129 */     paramObjectOutputStream.writeByte(this.precision);
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 137 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 138 */       return null;
/*     */     }
/* 140 */     switch (paramInt)
/*     */     {
/*     */     case 1:
/* 144 */       return new TIMESTAMPLTZ(paramArrayOfByte);
/*     */     case 2:
/* 147 */       return TIMESTAMPLTZ.toTimestamp(this.connection, paramArrayOfByte);
/*     */     case 3:
/* 150 */       return paramArrayOfByte;
/*     */     }
/*     */ 
/* 154 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 155 */     localSQLException.fillInStackTrace();
/* 156 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 174 */     TIMESTAMPLTZ localTIMESTAMPLTZ = null;
/*     */ 
/* 176 */     if (paramObject != null)
/*     */     {
/*     */       try
/*     */       {
/* 180 */         if ((paramObject instanceof TIMESTAMPLTZ)) {
/* 181 */           localTIMESTAMPLTZ = (TIMESTAMPLTZ)paramObject;
/* 182 */         } else if ((paramObject instanceof byte[])) {
/* 183 */           localTIMESTAMPLTZ = new TIMESTAMPLTZ((byte[])paramObject);
/* 184 */         } else if ((paramObject instanceof Timestamp)) {
/* 185 */           localTIMESTAMPLTZ = new TIMESTAMPLTZ(paramOracleConnection, (Timestamp)paramObject);
/* 186 */         } else if ((paramObject instanceof DATE)) {
/* 187 */           localTIMESTAMPLTZ = new TIMESTAMPLTZ(paramOracleConnection, (DATE)paramObject);
/* 188 */         } else if ((paramObject instanceof String)) {
/* 189 */           localTIMESTAMPLTZ = new TIMESTAMPLTZ(paramOracleConnection, (String)paramObject);
/* 190 */         } else if ((paramObject instanceof Date)) {
/* 191 */           localTIMESTAMPLTZ = new TIMESTAMPLTZ(paramOracleConnection, (Date)paramObject);
/* 192 */         } else if ((paramObject instanceof Time)) {
/* 193 */           localTIMESTAMPLTZ = new TIMESTAMPLTZ(paramOracleConnection, (Time)paramObject);
/*     */         }
/*     */         else {
/* 196 */           SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/* 197 */           localSQLException1.fillInStackTrace();
/* 198 */           throw localSQLException1;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Exception localException)
/*     */       {
/* 204 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/* 205 */         localSQLException2.fillInStackTrace();
/* 206 */         throw localSQLException2;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 211 */     return localTIMESTAMPLTZ;
/*     */   }
/*     */ 
/*     */   protected Object unpickle81rec(UnpickleContext paramUnpickleContext, int paramInt1, int paramInt2, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 224 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90);
/* 225 */     localSQLException.fillInStackTrace();
/* 226 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 242 */     return this.connection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeTIMESTAMPLTZ
 * JD-Core Version:    0.6.2
 */