/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.Date;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.DATE;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.TIMESTAMP;
/*     */ 
/*     */ public class OracleTypeTIMESTAMP extends OracleType
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = 3948043338303602796L;
/*  55 */   int precision = 0;
/*     */ 
/* 230 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected OracleTypeTIMESTAMP()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleTypeTIMESTAMP(OracleConnection paramOracleConnection)
/*     */   {
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */   {
/*  84 */     return 93;
/*     */   }
/*     */ 
/*     */   public void parseTDSrec(TDSReader paramTDSReader)
/*     */     throws SQLException
/*     */   {
/*  92 */     this.precision = paramTDSReader.readByte();
/*     */   }
/*     */ 
/*     */   public int getScale()
/*     */     throws SQLException
/*     */   {
/*  99 */     return 0;
/*     */   }
/*     */ 
/*     */   public int getPrecision()
/*     */     throws SQLException
/*     */   {
/* 106 */     return this.precision;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 115 */     this.precision = paramObjectInputStream.readByte();
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/* 123 */     paramObjectOutputStream.writeByte(this.precision);
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 131 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 132 */       return null;
/*     */     }
/* 134 */     switch (paramInt)
/*     */     {
/*     */     case 1:
/* 138 */       return new TIMESTAMP(paramArrayOfByte);
/*     */     case 2:
/* 141 */       return TIMESTAMP.toTimestamp(paramArrayOfByte);
/*     */     case 3:
/* 144 */       return paramArrayOfByte;
/*     */     }
/*     */ 
/* 148 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 149 */     localSQLException.fillInStackTrace();
/* 150 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 168 */     TIMESTAMP localTIMESTAMP = null;
/*     */ 
/* 170 */     if (paramObject != null)
/*     */     {
/*     */       try
/*     */       {
/* 174 */         if ((paramObject instanceof TIMESTAMP)) {
/* 175 */           localTIMESTAMP = (TIMESTAMP)paramObject;
/* 176 */         } else if ((paramObject instanceof byte[])) {
/* 177 */           localTIMESTAMP = new TIMESTAMP((byte[])paramObject);
/* 178 */         } else if ((paramObject instanceof Timestamp)) {
/* 179 */           localTIMESTAMP = new TIMESTAMP((Timestamp)paramObject);
/* 180 */         } else if ((paramObject instanceof DATE)) {
/* 181 */           localTIMESTAMP = new TIMESTAMP((DATE)paramObject);
/* 182 */         } else if ((paramObject instanceof String)) {
/* 183 */           localTIMESTAMP = new TIMESTAMP((String)paramObject);
/* 184 */         } else if ((paramObject instanceof Date)) {
/* 185 */           localTIMESTAMP = new TIMESTAMP((Date)paramObject);
/* 186 */         } else if ((paramObject instanceof Time)) {
/* 187 */           localTIMESTAMP = new TIMESTAMP((Time)paramObject);
/*     */         }
/*     */         else {
/* 190 */           SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/* 191 */           localSQLException1.fillInStackTrace();
/* 192 */           throw localSQLException1;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Exception localException)
/*     */       {
/* 198 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/* 199 */         localSQLException2.fillInStackTrace();
/* 200 */         throw localSQLException2;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 205 */     return localTIMESTAMP;
/*     */   }
/*     */ 
/*     */   protected Object unpickle81rec(UnpickleContext paramUnpickleContext, int paramInt1, int paramInt2, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 219 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90);
/* 220 */     localSQLException.fillInStackTrace();
/* 221 */     throw localSQLException;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeTIMESTAMP
 * JD-Core Version:    0.6.2
 */