/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.math.BigDecimal;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.NUMBER;
/*     */ 
/*     */ public class OracleTypeSINT32 extends OracleType
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = -5465988397261455848L;
/*  38 */   boolean isBigEndian = false;
/*     */ 
/* 213 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected OracleTypeSINT32(boolean paramBoolean)
/*     */   {
/*  44 */     this.isBigEndian = paramBoolean;
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  58 */     return OracleTypeNUMBER.toNUMBER(paramObject, paramOracleConnection);
/*     */   }
/*     */ 
/*     */   public Datum[] toDatumArray(Object paramObject, OracleConnection paramOracleConnection, long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  72 */     return OracleTypeNUMBER.toNUMBERArray(paramObject, paramOracleConnection, paramLong, paramInt);
/*     */   }
/*     */ 
/*     */   public Datum toDatumInternal(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  85 */     int i = 0;
/*  86 */     if (paramObject == null) {
/*  87 */       return null;
/*     */     }
/*  89 */     if ((paramObject instanceof Number)) {
/*  90 */       i = ((Number)paramObject).intValue();
/*     */     }
/*     */     else
/*     */     {
/*     */       NUMBER localNUMBER;
/*  92 */       if ((paramObject instanceof NUMBER)) {
/*  93 */         localNUMBER = (NUMBER)paramObject;
/*  94 */         i = localNUMBER.intValue();
/*     */       }
/*     */       else {
/*  97 */         localNUMBER = new NUMBER(paramObject);
/*  98 */         i = localNUMBER.intValue();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 103 */     return SINT32.valueOf(i, this.isBigEndian);
/*     */   }
/*     */ 
/*     */   public Datum[] toDatumArrayInternal(Object paramObject, OracleConnection paramOracleConnection, long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 115 */     if (paramObject == null) {
/* 116 */       return null;
/*     */     }
/*     */ 
/* 119 */     Object[] arrayOfObject = (Object[])paramObject;
/* 120 */     SINT32[] arrayOfSINT32 = SINT32.createArray(paramInt);
/* 121 */     long l = paramLong + paramInt;
/*     */ 
/* 124 */     for (int i = 0; paramLong < l; paramLong += 1L) {
/* 125 */       arrayOfSINT32[i] = toDatumInternal(arrayOfObject[((int)paramLong)], paramOracleConnection);
/*     */ 
/* 124 */       i++;
/*     */     }
/*     */ 
/* 128 */     return arrayOfSINT32;
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */   {
/* 138 */     return 2;
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 164 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 165 */       return null;
/*     */     }
/* 167 */     int i = SINT32.bytesToInt(paramArrayOfByte, this.isBigEndian);
/*     */ 
/* 169 */     Object localObject = null;
/* 170 */     switch (paramInt) {
/*     */     case 1:
/* 172 */       localObject = new NUMBER(i);
/* 173 */       break;
/*     */     case 2:
/* 176 */       localObject = new BigDecimal(i);
/* 177 */       break;
/*     */     case 3:
/* 180 */       localObject = NUMBER.toBytes(i);
/*     */     default:
/* 184 */       SQLException localSQLException = DatabaseError.createSqlException(null, 23);
/* 185 */       localSQLException.fillInStackTrace();
/* 186 */       throw localSQLException;
/*     */     }
/*     */ 
/* 190 */     return localObject;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeSINT32
 * JD-Core Version:    0.6.2
 */