/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.REF;
/*     */ import oracle.sql.StructDescriptor;
/*     */ 
/*     */ public class OracleTypeREF extends OracleNamedType
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = 3186448715463064573L;
/* 206 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected OracleTypeREF()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleTypeREF(String paramString, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  39 */     super(paramString, paramOracleConnection);
/*     */   }
/*     */ 
/*     */   public OracleTypeREF(OracleTypeADT paramOracleTypeADT, int paramInt, OracleConnection paramOracleConnection)
/*     */   {
/*  46 */     super(paramOracleTypeADT, paramInt, paramOracleConnection);
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  61 */     REF localREF = null;
/*     */ 
/*  63 */     if (paramObject != null)
/*     */     {
/*  65 */       if ((paramObject instanceof REF)) {
/*  66 */         localREF = (REF)paramObject;
/*     */       }
/*     */       else {
/*  69 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/*  70 */         localSQLException.fillInStackTrace();
/*  71 */         throw localSQLException;
/*     */       }
/*     */     }
/*     */ 
/*  75 */     return localREF;
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */   {
/*  89 */     return 2006;
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 110 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 111 */       return null;
/*     */     }
/* 113 */     if ((paramInt == 1) || (paramInt == 2))
/*     */     {
/* 115 */       localObject = createStructDescriptor();
/*     */ 
/* 117 */       return new REF((StructDescriptor)localObject, this.connection, paramArrayOfByte);
/*     */     }
/* 119 */     if (paramInt == 3)
/*     */     {
/* 121 */       return paramArrayOfByte;
/*     */     }
/*     */ 
/* 125 */     Object localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramArrayOfByte);
/* 126 */     ((SQLException)localObject).fillInStackTrace();
/* 127 */     throw ((Throwable)localObject);
/*     */   }
/*     */ 
/*     */   StructDescriptor createStructDescriptor()
/*     */     throws SQLException
/*     */   {
/* 136 */     if (this.descriptor == null)
/*     */     {
/* 138 */       if ((this.sqlName == null) && (getFullName(false) == null))
/*     */       {
/* 140 */         OracleTypeADT localOracleTypeADT = new OracleTypeADT(getParent(), getOrder(), this.connection);
/*     */ 
/* 142 */         this.descriptor = new StructDescriptor(localOracleTypeADT, this.connection);
/*     */       }
/*     */       else
/*     */       {
/* 146 */         this.descriptor = StructDescriptor.createDescriptor(this.sqlName, this.connection);
/*     */       }
/*     */     }
/* 149 */     return (StructDescriptor)this.descriptor;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeREF
 * JD-Core Version:    0.6.2
 */