/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.RAW;
/*     */ 
/*     */ public class OracleTypeRAW extends OracleType
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = -6083664758336974576L;
/*     */   int length;
/* 272 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleTypeRAW()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleTypeRAW(int paramInt)
/*     */   {
/*  40 */     super(paramInt);
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  55 */     RAW localRAW = null;
/*     */ 
/*  57 */     if (paramObject != null)
/*     */     {
/*     */       try
/*     */       {
/*  61 */         if ((paramObject instanceof RAW))
/*  62 */           localRAW = (RAW)paramObject;
/*     */         else {
/*  64 */           localRAW = new RAW(paramObject);
/*     */         }
/*     */       }
/*     */       catch (SQLException localSQLException1)
/*     */       {
/*  69 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/*  70 */         localSQLException2.fillInStackTrace();
/*  71 */         throw localSQLException2;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  76 */     return localRAW;
/*     */   }
/*     */ 
/*     */   public Datum[] toDatumArray(Object paramObject, OracleConnection paramOracleConnection, long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  90 */     Datum[] arrayOfDatum = null;
/*     */ 
/*  92 */     if (paramObject != null)
/*     */     {
/*     */       Object localObject;
/*  94 */       if ((paramObject instanceof char[][]))
/*     */       {
/*  96 */         localObject = (char[][])paramObject;
/*  97 */         int i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 100 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 102 */         for (int j = 0; j < i; j++)
/* 103 */           arrayOfDatum[j] = toDatum(new String(localObject[((int)paramLong + j - 1)]), paramOracleConnection);
/*     */       }
/*     */       else {
/* 106 */         if ((paramObject instanceof Object[]))
/*     */         {
/* 108 */           return super.toDatumArray(paramObject, paramOracleConnection, paramLong, paramInt);
/*     */         }
/*     */ 
/* 112 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/* 113 */         ((SQLException)localObject).fillInStackTrace();
/* 114 */         throw ((Throwable)localObject);
/*     */       }
/*     */     }
/*     */ 
/* 118 */     return arrayOfDatum;
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */   {
/* 128 */     return -2;
/*     */   }
/*     */ 
/*     */   public void parseTDSrec(TDSReader paramTDSReader)
/*     */     throws SQLException
/*     */   {
/* 141 */     super.parseTDSrec(paramTDSReader);
/*     */ 
/* 145 */     this.length = paramTDSReader.readUB2();
/*     */   }
/*     */ 
/*     */   protected int pickle81(PickleContext paramPickleContext, Datum paramDatum)
/*     */     throws SQLException
/*     */   {
/* 168 */     if (paramDatum.getLength() > this.length)
/*     */     {
/* 170 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 72, this);
/* 171 */       localSQLException.fillInStackTrace();
/* 172 */       throw localSQLException;
/*     */     }
/*     */ 
/* 175 */     int i = paramPickleContext.writeLength((int)paramDatum.getLength());
/*     */ 
/* 177 */     i += paramPickleContext.writeData(paramDatum.shareBytes());
/*     */ 
/* 179 */     return i;
/*     */   }
/*     */ 
/*     */   public int getLength()
/*     */   {
/* 190 */     return this.length;
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 199 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 200 */       return null;
/*     */     }
/* 202 */     switch (paramInt)
/*     */     {
/*     */     case 1:
/* 206 */       return new RAW(paramArrayOfByte);
/*     */     case 2:
/*     */     case 3:
/* 211 */       return paramArrayOfByte;
/*     */     }
/*     */ 
/* 215 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramArrayOfByte);
/* 216 */     localSQLException.fillInStackTrace();
/* 217 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/* 231 */     paramObjectOutputStream.writeInt(this.length);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 239 */     this.length = paramObjectInputStream.readInt();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeRAW
 * JD-Core Version:    0.6.2
 */