/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.OPAQUE;
/*     */ import oracle.sql.OpaqueDescriptor;
/*     */ import oracle.sql.SQLName;
/*     */ import oracle.sql.StructDescriptor;
/*     */ import oracle.sql.TypeDescriptor;
/*     */ import oracle.xdb.XMLType;
/*     */ 
/*     */ public class OracleTypeOPAQUE extends OracleTypeADT
/*     */   implements Serializable
/*     */ {
/*     */   static final long KOLOFLLB = 1L;
/*     */   static final long KOLOFLCL = 2L;
/*     */   static final long KOLOFLUB = 4L;
/*     */   static final long KOLOFLFX = 8L;
/*     */   static final long serialVersionUID = -7279638692691669378L;
/*     */   long flagBits;
/*     */   long maxLen;
/* 430 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleTypeOPAQUE(byte[] paramArrayOfByte, int paramInt1, int paramInt2, short paramShort, String paramString, long paramLong)
/*     */     throws SQLException
/*     */   {
/*  49 */     super(paramArrayOfByte, paramInt1, paramInt2, paramShort, paramString);
/*     */ 
/*  51 */     this.flagBits = paramLong;
/*  52 */     this.flattenedAttrNum = 1;
/*     */   }
/*     */ 
/*     */   public OracleTypeOPAQUE(String paramString, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  59 */     super(paramString, paramOracleConnection);
/*     */   }
/*     */ 
/*     */   public OracleTypeOPAQUE(OracleTypeADT paramOracleTypeADT, int paramInt, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  67 */     super(paramOracleTypeADT, paramInt, paramOracleConnection);
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  82 */     if (paramObject != null)
/*     */     {
/*  84 */       if ((paramObject instanceof OPAQUE)) {
/*  85 */         return (OPAQUE)paramObject;
/*     */       }
/*     */ 
/*  88 */       OpaqueDescriptor localOpaqueDescriptor = createOpaqueDescriptor();
/*     */ 
/*  90 */       return new OPAQUE(localOpaqueDescriptor, this.connection, paramObject);
/*     */     }
/*     */ 
/*  94 */     return null;
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */   {
/* 106 */     return 2007;
/*     */   }
/*     */ 
/*     */   public boolean isInHierarchyOf(OracleType paramOracleType)
/*     */     throws SQLException
/*     */   {
/* 117 */     if (paramOracleType == null)
/* 118 */       return false;
/* 119 */     if (!(paramOracleType instanceof OracleTypeOPAQUE)) {
/* 120 */       return false;
/*     */     }
/* 122 */     OpaqueDescriptor localOpaqueDescriptor = (OpaqueDescriptor)paramOracleType.getTypeDescriptor();
/*     */ 
/* 125 */     return this.descriptor.isInHierarchyOf(localOpaqueDescriptor.getName());
/*     */   }
/*     */ 
/*     */   public boolean isInHierarchyOf(StructDescriptor paramStructDescriptor)
/*     */     throws SQLException
/*     */   {
/* 133 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isObjectType()
/*     */   {
/* 140 */     return false;
/*     */   }
/*     */ 
/*     */   public void parseTDSrec(TDSReader paramTDSReader)
/*     */     throws SQLException
/*     */   {
/* 152 */     paramTDSReader.skipBytes(5);
/*     */ 
/* 154 */     this.flagBits = paramTDSReader.readLong();
/* 155 */     this.maxLen = paramTDSReader.readLong();
/*     */   }
/*     */ 
/*     */   public Datum unlinearize(byte[] paramArrayOfByte, long paramLong, Datum paramDatum, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 167 */     if (paramArrayOfByte == null) {
/* 168 */       return null;
/*     */     }
/* 170 */     if ((paramArrayOfByte[0] & 0x80) > 0)
/*     */     {
/* 172 */       PickleContext localPickleContext = new PickleContext(paramArrayOfByte, paramLong);
/*     */ 
/* 174 */       return unpickle81(localPickleContext, (OPAQUE)paramDatum, paramInt, paramMap);
/*     */     }
/*     */ 
/* 180 */     return null;
/*     */   }
/*     */ 
/*     */   public byte[] linearize(Datum paramDatum)
/*     */     throws SQLException
/*     */   {
/* 192 */     return pickle81(paramDatum);
/*     */   }
/*     */ 
/*     */   protected int pickle81(PickleContext paramPickleContext, Datum paramDatum)
/*     */     throws SQLException
/*     */   {
/* 203 */     OPAQUE localOPAQUE = (OPAQUE)paramDatum;
/* 204 */     byte[] arrayOfByte = localOPAQUE.getBytesValue();
/* 205 */     int i = 0;
/*     */ 
/* 207 */     i += paramPickleContext.writeOpaqueImageHeader(arrayOfByte.length);
/* 208 */     i += paramPickleContext.writeData(arrayOfByte);
/*     */ 
/* 210 */     return i;
/*     */   }
/*     */ 
/*     */   OPAQUE unpickle81(PickleContext paramPickleContext, OPAQUE paramOPAQUE, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 222 */     return unpickle81datum(paramPickleContext, paramOPAQUE, paramInt);
/*     */   }
/*     */ 
/*     */   protected Object unpickle81rec(PickleContext paramPickleContext, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 230 */     byte b = paramPickleContext.readByte();
/* 231 */     Object localObject = null;
/*     */ 
/* 233 */     if (PickleContext.isElementNull(b)) {
/* 234 */       return null;
/*     */     }
/* 236 */     paramPickleContext.skipRestOfLength(b);
/*     */ 
/* 238 */     switch (paramInt)
/*     */     {
/*     */     case 1:
/* 242 */       localObject = unpickle81datum(paramPickleContext, null);
/* 243 */       break;
/*     */     case 2:
/* 246 */       localObject = unpickle81datum(paramPickleContext, null).toJdbc();
/* 247 */       break;
/*     */     case 3:
/* 250 */       localObject = new OPAQUE(createOpaqueDescriptor(), paramPickleContext.readDataValue(), this.connection);
/*     */ 
/* 254 */       break;
/*     */     case 9:
/* 256 */       paramPickleContext.skipDataValue();
/* 257 */       break;
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*     */     case 7:
/*     */     case 8:
/*     */     default:
/* 261 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/* 262 */       localSQLException.fillInStackTrace();
/* 263 */       throw localSQLException;
/*     */     }
/*     */ 
/* 267 */     return localObject;
/*     */   }
/*     */ 
/*     */   private OPAQUE unpickle81datum(PickleContext paramPickleContext, OPAQUE paramOPAQUE)
/*     */     throws SQLException
/*     */   {
/* 280 */     return unpickle81datum(paramPickleContext, paramOPAQUE, 1);
/*     */   }
/*     */ 
/*     */   private OPAQUE unpickle81datum(PickleContext paramPickleContext, OPAQUE paramOPAQUE, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 289 */     paramPickleContext.skipBytes(2);
/*     */ 
/* 291 */     long l = paramPickleContext.readLength(true) - 2;
/*     */ 
/* 295 */     if (paramOPAQUE == null) {
/* 296 */       OPAQUE localOPAQUE = new OPAQUE(createOpaqueDescriptor(), this.connection, paramPickleContext.readBytes((int)l));
/*     */ 
/* 299 */       if (this.typeNameByUser != null ? this.typeNameByUser.equals("SYS.XMLTYPE") : (this.sqlName != null) && (this.sqlName.getName().equals("SYS.XMLTYPE")))
/*     */       {
/* 302 */         return XMLType.createXML(localOPAQUE);
/*     */       }
/*     */ 
/* 305 */       return localOPAQUE;
/*     */     }
/*     */ 
/* 325 */     paramOPAQUE.setValue(paramPickleContext.readBytes((int)l));
/*     */ 
/* 327 */     return paramOPAQUE;
/*     */   }
/*     */ 
/*     */   OpaqueDescriptor createOpaqueDescriptor()
/*     */     throws SQLException
/*     */   {
/* 335 */     if (this.sqlName == null) {
/* 336 */       return new OpaqueDescriptor(this, this.connection);
/*     */     }
/* 338 */     return OpaqueDescriptor.createDescriptor(this.sqlName, this.connection);
/*     */   }
/*     */ 
/*     */   public long getMaxLength()
/*     */     throws SQLException
/*     */   {
/* 345 */     return this.maxLen;
/*     */   }
/*     */ 
/*     */   public boolean isTrustedLibrary()
/*     */     throws SQLException
/*     */   {
/* 352 */     return (this.flagBits & 1L) != 0L;
/*     */   }
/*     */ 
/*     */   public boolean isModeledInC()
/*     */     throws SQLException
/*     */   {
/* 359 */     return (this.flagBits & 0x2) != 0L;
/*     */   }
/*     */ 
/*     */   public boolean isUnboundedSized()
/*     */     throws SQLException
/*     */   {
/* 366 */     return (this.flagBits & 0x4) != 0L;
/*     */   }
/*     */ 
/*     */   public boolean isFixedSized()
/*     */     throws SQLException
/*     */   {
/* 373 */     return (this.flagBits & 0x8) != 0L;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setConnection(OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 397 */     this.connection = paramOracleConnection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeOPAQUE
 * JD-Core Version:    0.6.2
 */