/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.NUMBER;
/*     */ 
/*     */ public class OracleTypeNUMBER extends OracleType
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = -7182242886677299812L;
/*     */   int precision;
/*     */   int scale;
/* 489 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected OracleTypeNUMBER()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected OracleTypeNUMBER(int paramInt)
/*     */   {
/*  41 */     super(paramInt);
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  57 */     return toNUMBER(paramObject, paramOracleConnection);
/*     */   }
/*     */ 
/*     */   public Datum[] toDatumArray(Object paramObject, OracleConnection paramOracleConnection, long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  71 */     return toNUMBERArray(paramObject, paramOracleConnection, paramLong, paramInt);
/*     */   }
/*     */ 
/*     */   public void parseTDSrec(TDSReader paramTDSReader)
/*     */     throws SQLException
/*     */   {
/*  82 */     this.precision = paramTDSReader.readUnsignedByte();
/*     */ 
/*  85 */     this.scale = paramTDSReader.readByte();
/*     */   }
/*     */ 
/*     */   protected static Object unpickle81NativeArray(PickleContext paramPickleContext, long paramLong, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/*  97 */     for (int i = 1; (i < paramLong) && (paramInt1 > 0); i++) {
/*  98 */       paramPickleContext.skipDataValue();
/*     */     }
/* 100 */     byte[] arrayOfByte = null;
/*     */     int j;
/* 102 */     switch (paramInt2)
/*     */     {
/*     */     case 4:
/* 111 */       localObject = new int[paramInt1];
/*     */ 
/* 113 */       for (j = 0; j < paramInt1; j++)
/*     */       {
/* 133 */         if ((arrayOfByte = paramPickleContext.readDataValue()) != null) {
/* 134 */           localObject[j] = NUMBER.toInt(arrayOfByte);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 139 */       return localObject;
/*     */     case 5:
/* 144 */       localObject = new double[paramInt1];
/*     */ 
/* 146 */       for (j = 0; j < paramInt1; j++)
/*     */       {
/* 148 */         if ((arrayOfByte = paramPickleContext.readDataValue()) != null) {
/* 149 */           localObject[j] = NUMBER.toDouble(arrayOfByte);
/*     */         }
/*     */       }
/* 152 */       return localObject;
/*     */     case 7:
/* 157 */       localObject = new long[paramInt1];
/*     */ 
/* 159 */       for (j = 0; j < paramInt1; j++)
/*     */       {
/* 161 */         if ((arrayOfByte = paramPickleContext.readDataValue()) != null) {
/* 162 */           localObject[j] = NUMBER.toLong(arrayOfByte);
/*     */         }
/*     */       }
/* 165 */       return localObject;
/*     */     case 6:
/* 170 */       localObject = new float[paramInt1];
/*     */ 
/* 172 */       for (j = 0; j < paramInt1; j++)
/*     */       {
/* 174 */         if ((arrayOfByte = paramPickleContext.readDataValue()) != null) {
/* 175 */           localObject[j] = NUMBER.toFloat(arrayOfByte);
/*     */         }
/*     */       }
/* 178 */       return localObject;
/*     */     case 8:
/* 183 */       localObject = new short[paramInt1];
/*     */ 
/* 185 */       for (j = 0; j < paramInt1; j++)
/*     */       {
/* 187 */         if ((arrayOfByte = paramPickleContext.readDataValue()) != null) {
/* 188 */           localObject[j] = NUMBER.toShort(arrayOfByte);
/*     */         }
/*     */       }
/* 191 */       return localObject;
/*     */     }
/*     */ 
/* 196 */     Object localObject = DatabaseError.createSqlException(null, 23);
/* 197 */     ((SQLException)localObject).fillInStackTrace();
/* 198 */     throw ((Throwable)localObject);
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 212 */     return toNumericObject(paramArrayOfByte, paramInt, paramMap);
/*     */   }
/*     */ 
/*     */   static Object toNumericObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 220 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 221 */       return null;
/*     */     }
/* 223 */     switch (paramInt)
/*     */     {
/*     */     case 1:
/* 227 */       return new NUMBER(paramArrayOfByte);
/*     */     case 2:
/* 230 */       return NUMBER.toBigDecimal(paramArrayOfByte);
/*     */     case 3:
/* 233 */       return paramArrayOfByte;
/*     */     }
/*     */ 
/* 237 */     SQLException localSQLException = DatabaseError.createSqlException(null, 23);
/* 238 */     localSQLException.fillInStackTrace();
/* 239 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public static NUMBER toNUMBER(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 253 */     NUMBER localNUMBER = null;
/*     */ 
/* 255 */     if (paramObject != null)
/*     */     {
/*     */       try
/*     */       {
/* 259 */         if ((paramObject instanceof NUMBER))
/* 260 */           localNUMBER = (NUMBER)paramObject;
/*     */         else {
/* 262 */           localNUMBER = new NUMBER(paramObject);
/*     */         }
/*     */       }
/*     */       catch (SQLException localSQLException1)
/*     */       {
/* 267 */         SQLException localSQLException2 = DatabaseError.createSqlException(null, 59, paramObject);
/* 268 */         localSQLException2.fillInStackTrace();
/* 269 */         throw localSQLException2;
/*     */       }
/*     */     }
/*     */ 
/* 273 */     return localNUMBER;
/*     */   }
/*     */ 
/*     */   public static Datum[] toNUMBERArray(Object paramObject, OracleConnection paramOracleConnection, long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 288 */     Datum[] arrayOfDatum = null;
/*     */ 
/* 290 */     if (paramObject != null)
/*     */     {
/* 292 */       if (((paramObject instanceof Object[])) && (!(paramObject instanceof char[][])))
/*     */       {
/* 294 */         Object[] arrayOfObject = (Object[])paramObject;
/*     */ 
/* 296 */         int i = (int)(paramInt == -1 ? arrayOfObject.length : Math.min(arrayOfObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 299 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 301 */         for (int j = 0; j < i; j++)
/* 302 */           arrayOfDatum[j] = toNUMBER(arrayOfObject[((int)paramLong + j - 1)], paramOracleConnection);
/*     */       }
/*     */       else {
/* 305 */         arrayOfDatum = cArrayToNUMBERArray(paramObject, paramOracleConnection, paramLong, paramInt);
/*     */       }
/*     */     }
/* 307 */     return arrayOfDatum;
/*     */   }
/*     */ 
/*     */   static Datum[] cArrayToNUMBERArray(Object paramObject, OracleConnection paramOracleConnection, long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 323 */     Datum[] arrayOfDatum = null;
/*     */ 
/* 325 */     if (paramObject != null)
/*     */     {
/*     */       Object localObject;
/*     */       int i;
/*     */       int j;
/* 327 */       if ((paramObject instanceof short[]))
/*     */       {
/* 329 */         localObject = (short[])paramObject;
/* 330 */         i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 333 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 335 */         for (j = 0; j < i; j++)
/* 336 */           arrayOfDatum[j] = new NUMBER(localObject[((int)paramLong + j - 1)]);
/*     */       }
/* 338 */       else if ((paramObject instanceof int[]))
/*     */       {
/* 340 */         localObject = (int[])paramObject;
/* 341 */         i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 344 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 346 */         for (j = 0; j < i; j++)
/* 347 */           arrayOfDatum[j] = new NUMBER(localObject[((int)paramLong + j - 1)]);
/*     */       }
/* 349 */       else if ((paramObject instanceof long[]))
/*     */       {
/* 351 */         localObject = (long[])paramObject;
/* 352 */         i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 355 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 357 */         for (j = 0; j < i; j++)
/* 358 */           arrayOfDatum[j] = new NUMBER(localObject[((int)paramLong + j - 1)]);
/*     */       }
/* 360 */       else if ((paramObject instanceof float[]))
/*     */       {
/* 362 */         localObject = (float[])paramObject;
/* 363 */         i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 366 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 368 */         for (j = 0; j < i; j++)
/* 369 */           arrayOfDatum[j] = new NUMBER(localObject[((int)paramLong + j - 1)]);
/*     */       }
/* 371 */       else if ((paramObject instanceof double[]))
/*     */       {
/* 373 */         localObject = (double[])paramObject;
/* 374 */         i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 377 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 379 */         for (j = 0; j < i; j++)
/* 380 */           arrayOfDatum[j] = new NUMBER(localObject[((int)paramLong + j - 1)]);
/*     */       }
/* 382 */       else if ((paramObject instanceof boolean[]))
/*     */       {
/* 384 */         localObject = (boolean[])paramObject;
/* 385 */         i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 388 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 390 */         for (j = 0; j < i; j++) {
/* 391 */           arrayOfDatum[j] = new NUMBER(Boolean.valueOf(localObject[((int)paramLong + j - 1)]));
/*     */         }
/*     */       }
/* 394 */       else if ((paramObject instanceof char[][]))
/*     */       {
/* 396 */         localObject = (char[][])paramObject;
/* 397 */         i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 400 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 402 */         for (j = 0; j < i; j++) {
/* 403 */           arrayOfDatum[j] = new NUMBER(new String(localObject[((int)paramLong + j - 1)]));
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 409 */         localObject = DatabaseError.createSqlException(null, 59, paramObject);
/* 410 */         ((SQLException)localObject).fillInStackTrace();
/* 411 */         throw ((Throwable)localObject);
/*     */       }
/*     */     }
/*     */ 
/* 415 */     return arrayOfDatum;
/*     */   }
/*     */ 
/*     */   public int getPrecision()
/*     */   {
/* 422 */     return this.precision;
/*     */   }
/*     */ 
/*     */   public int getScale()
/*     */   {
/* 429 */     return this.scale;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/* 440 */     paramObjectOutputStream.writeInt(this.scale);
/* 441 */     paramObjectOutputStream.writeInt(this.precision);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 449 */     this.scale = paramObjectInputStream.readInt();
/* 450 */     this.precision = paramObjectInputStream.readInt();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeNUMBER
 * JD-Core Version:    0.6.2
 */