/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.INTERVALDS;
/*     */ import oracle.sql.INTERVALYM;
/*     */ 
/*     */ public class OracleTypeINTERVAL extends OracleType
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = 1394800182554224957L;
/*     */   static final int LDIINTYEARMONTH = 7;
/*     */   static final int LDIINTDAYSECOND = 10;
/*     */   static final int SIZE_INTERVAL_YM = 5;
/*     */   static final int SIZE_INTERVAL_DS = 11;
/*  65 */   byte typeId = 0;
/*  66 */   int scale = 0;
/*  67 */   int precision = 0;
/*     */ 
/* 249 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected OracleTypeINTERVAL()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleTypeINTERVAL(OracleConnection paramOracleConnection)
/*     */   {
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */   {
/*  96 */     if (this.typeId == 7)
/*  97 */       return -103;
/*  98 */     if (this.typeId == 10) {
/*  99 */       return -104;
/*     */     }
/* 101 */     return 1111;
/*     */   }
/*     */ 
/*     */   public void parseTDSrec(TDSReader paramTDSReader)
/*     */     throws SQLException
/*     */   {
/* 109 */     this.typeId = paramTDSReader.readByte();
/* 110 */     this.precision = paramTDSReader.readByte();
/* 111 */     this.scale = paramTDSReader.readByte();
/*     */   }
/*     */ 
/*     */   public int getScale()
/*     */     throws SQLException
/*     */   {
/* 118 */     return this.scale;
/*     */   }
/*     */ 
/*     */   public int getPrecision()
/*     */     throws SQLException
/*     */   {
/* 125 */     return this.precision;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 134 */     this.typeId = paramObjectInputStream.readByte();
/* 135 */     this.precision = paramObjectInputStream.readByte();
/* 136 */     this.scale = paramObjectInputStream.readByte();
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/* 144 */     paramObjectOutputStream.writeByte(this.typeId);
/* 145 */     paramObjectOutputStream.writeByte(this.precision);
/* 146 */     paramObjectOutputStream.writeByte(this.scale);
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 153 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 154 */       return null;
/*     */     }
/*     */ 
/* 157 */     switch (paramInt) {
/*     */     case 1:
/*     */     case 2:
/* 160 */       if (paramArrayOfByte.length == 5) {
/* 161 */         return new INTERVALYM(paramArrayOfByte);
/*     */       }
/* 163 */       if (paramArrayOfByte.length == 11) {
/* 164 */         return new INTERVALDS(paramArrayOfByte);
/*     */       }
/*     */ 
/*     */       break;
/*     */     case 3:
/* 169 */       return paramArrayOfByte;
/*     */     default:
/* 173 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 174 */       localSQLException.fillInStackTrace();
/* 175 */       throw localSQLException;
/*     */     }
/*     */ 
/* 179 */     return null;
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 194 */     Object localObject = null;
/*     */ 
/* 196 */     if (paramObject != null)
/*     */     {
/* 198 */       if (((paramObject instanceof INTERVALYM)) || ((paramObject instanceof INTERVALDS)))
/*     */       {
/* 200 */         localObject = (Datum)paramObject;
/* 201 */       } else if ((paramObject instanceof String))
/*     */       {
/*     */         try
/*     */         {
/* 208 */           localObject = new INTERVALDS((String)paramObject);
/*     */         }
/*     */         catch (StringIndexOutOfBoundsException localStringIndexOutOfBoundsException)
/*     */         {
/* 212 */           localObject = new INTERVALYM((String)paramObject);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 217 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/* 218 */         localSQLException.fillInStackTrace();
/* 219 */         throw localSQLException;
/*     */       }
/*     */     }
/*     */ 
/* 223 */     return localObject;
/*     */   }
/*     */ 
/*     */   protected Object unpickle81rec(UnpickleContext paramUnpickleContext, int paramInt1, int paramInt2, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 237 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90);
/* 238 */     localSQLException.fillInStackTrace();
/* 239 */     throw localSQLException;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeINTERVAL
 * JD-Core Version:    0.6.2
 */