/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.Datum;
/*     */ 
/*     */ public class OracleTypeFLOAT extends OracleType
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = 4088841548269771109L;
/*     */   int precision;
/* 188 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  48 */     return OracleTypeNUMBER.toNUMBER(paramObject, paramOracleConnection);
/*     */   }
/*     */ 
/*     */   public Datum[] toDatumArray(Object paramObject, OracleConnection paramOracleConnection, long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  62 */     return OracleTypeNUMBER.toNUMBERArray(paramObject, paramOracleConnection, paramLong, paramInt);
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */   {
/*  72 */     return 6;
/*     */   }
/*     */ 
/*     */   public void parseTDSrec(TDSReader paramTDSReader)
/*     */     throws SQLException
/*     */   {
/*  87 */     this.precision = paramTDSReader.readUnsignedByte();
/*     */   }
/*     */ 
/*     */   public int getScale()
/*     */   {
/* 100 */     return -127;
/*     */   }
/*     */ 
/*     */   public int getPrecision()
/*     */   {
/* 107 */     return this.precision;
/*     */   }
/*     */ 
/*     */   protected static Object unpickle81NativeArray(PickleContext paramPickleContext, long paramLong, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 121 */     return OracleTypeNUMBER.unpickle81NativeArray(paramPickleContext, paramLong, paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 134 */     return OracleTypeNUMBER.toNumericObject(paramArrayOfByte, paramInt, paramMap);
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/* 146 */     paramObjectOutputStream.writeInt(this.precision);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 155 */     this.precision = paramObjectInputStream.readInt();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeFLOAT
 * JD-Core Version:    0.6.2
 */