/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.DATE;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.TIMESTAMP;
/*     */ 
/*     */ public class OracleTypeDATE extends OracleType
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = -5858803341118747965L;
/* 213 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleTypeDATE()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleTypeDATE(int paramInt)
/*     */   {
/*  39 */     super(paramInt);
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  54 */     DATE localDATE = null;
/*     */ 
/*  56 */     if (paramObject != null)
/*     */     {
/*     */       try
/*     */       {
/*  60 */         if ((paramObject instanceof DATE))
/*  61 */           localDATE = (DATE)paramObject;
/*  62 */         else if ((paramObject instanceof TIMESTAMP))
/*  63 */           localDATE = new DATE(((TIMESTAMP)paramObject).timestampValue());
/*     */         else {
/*  65 */           localDATE = new DATE(paramObject);
/*     */         }
/*     */       }
/*     */       catch (SQLException localSQLException1)
/*     */       {
/*  70 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/*  71 */         localSQLException2.fillInStackTrace();
/*  72 */         throw localSQLException2;
/*     */       }
/*     */     }
/*     */ 
/*  76 */     return localDATE;
/*     */   }
/*     */ 
/*     */   public Datum[] toDatumArray(Object paramObject, OracleConnection paramOracleConnection, long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  90 */     Datum[] arrayOfDatum = null;
/*     */ 
/*  92 */     if (paramObject != null)
/*     */     {
/*     */       Object localObject;
/*  94 */       if ((paramObject instanceof char[][]))
/*     */       {
/*  96 */         localObject = (char[][])paramObject;
/*  97 */         int i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 100 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 102 */         for (int j = 0; j < i; j++)
/* 103 */           arrayOfDatum[j] = toDatum(new String(localObject[((int)paramLong + j - 1)]), paramOracleConnection);
/*     */       }
/*     */       else {
/* 106 */         if ((paramObject instanceof Object[]))
/*     */         {
/* 108 */           return super.toDatumArray(paramObject, paramOracleConnection, paramLong, paramInt);
/*     */         }
/*     */ 
/* 112 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/* 113 */         ((SQLException)localObject).fillInStackTrace();
/* 114 */         throw ((Throwable)localObject);
/*     */       }
/*     */     }
/* 117 */     return arrayOfDatum;
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */   {
/* 127 */     return 91;
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 150 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 151 */       return null;
/*     */     }
/* 153 */     if (paramInt == 1)
/* 154 */       return new DATE(paramArrayOfByte);
/* 155 */     if (paramInt == 2)
/* 156 */       return DATE.toTimestamp(paramArrayOfByte);
/* 157 */     if (paramInt == 3) {
/* 158 */       return paramArrayOfByte;
/*     */     }
/*     */ 
/* 161 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramArrayOfByte);
/* 162 */     localSQLException.fillInStackTrace();
/* 163 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeDATE
 * JD-Core Version:    0.6.2
 */