/*      */ package oracle.jdbc.oracore;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.io.ObjectOutputStream;
/*      */ import java.io.PrintWriter;
/*      */ import java.io.Serializable;
/*      */ import java.sql.CallableStatement;
/*      */ import java.sql.PreparedStatement;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.SQLException;
/*      */ import java.util.Map;
/*      */ import oracle.jdbc.OracleCallableStatement;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.sql.ARRAY;
/*      */ import oracle.sql.ArrayDescriptor;
/*      */ import oracle.sql.Datum;
/*      */ import oracle.sql.SQLName;
/*      */ import oracle.sql.StructDescriptor;
/*      */ import oracle.sql.TypeDescriptor;
/*      */ 
/*      */ public class OracleTypeCOLLECTION extends OracleTypeADT
/*      */   implements Serializable
/*      */ {
/*      */   static final long serialVersionUID = -7279638692691669378L;
/*      */   public static final int TYPE_PLSQL_INDEX_TABLE = 1;
/*      */   public static final int TYPE_NESTED_TABLE = 2;
/*      */   public static final int TYPE_VARRAY = 3;
/*   57 */   int userCode = 0;
/*   58 */   long maxSize = 0L;
/*   59 */   OracleType elementType = null;
/*      */   static final int CURRENT_USER_OBJECT = 0;
/*      */   static final int CURRENT_USER_SYNONYM = 1;
/*      */   static final int CURRENT_USER_SYNONYM_10g = 2;
/*      */   static final int CURRENT_USER_PUBLIC_SYNONYM = 3;
/*      */   static final int CURRENT_USER_PUBLIC_SYNONYM_10g = 4;
/*      */   static final int POSSIBLY_OTHER_USER_OBJECT = 5;
/*      */   static final int POSSIBLY_OTHER_USER_OBJECT_10g = 6;
/*      */   static final int OTHER_USER_OBJECT = 7;
/*      */   static final int OTHER_USER_SYNONYM = 8;
/*      */   static final int PUBLIC_SYNONYM = 9;
/*      */   static final int PUBLIC_SYNONYM_10g = 10;
/*      */   static final int BREAK = 11;
/*  697 */   static final String[] sqlString = { "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME = :1", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME in (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :1 CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :1 FROM DUAL) ", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME in (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :1 CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :1 FROM DUAL) ", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :tname CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :tname FROM DUAL)", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :tname CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :tname FROM DUAL)", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE OWNER = :1 AND TYPE_NAME = :2", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE OWNER = (SELECT TABLE_OWNER FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:1) AND TYPE_NAME = (SELECT TABLE_NAME FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:2) ", "DECLARE   the_owner VARCHAR2(100);   the_type  VARCHAR2(100); begin  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;", "DECLARE   the_owner VARCHAR2(100);   the_type  VARCHAR2(100); begin  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;" };
/*      */ 
/* 1178 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public OracleTypeCOLLECTION(String paramString, OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*   68 */     super(paramString, paramOracleConnection);
/*      */   }
/*      */ 
/*      */   public OracleTypeCOLLECTION(OracleTypeADT paramOracleTypeADT, int paramInt, OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*   76 */     super(paramOracleTypeADT, paramInt, paramOracleConnection);
/*      */   }
/*      */ 
/*      */   public OracleTypeCOLLECTION(SQLName paramSQLName, byte[] paramArrayOfByte1, int paramInt, byte[] paramArrayOfByte2, OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*   87 */     super(paramSQLName, paramArrayOfByte1, paramInt, paramArrayOfByte2, paramOracleConnection);
/*      */   }
/*      */ 
/*      */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*  103 */     if (paramObject != null)
/*      */     {
/*  105 */       if ((paramObject instanceof ARRAY)) {
/*  106 */         return (ARRAY)paramObject;
/*      */       }
/*      */ 
/*  109 */       ArrayDescriptor localArrayDescriptor = createArrayDescriptor();
/*      */ 
/*  111 */       return new ARRAY(localArrayDescriptor, this.connection, paramObject);
/*      */     }
/*      */ 
/*  115 */     return null;
/*      */   }
/*      */ 
/*      */   public int getTypeCode()
/*      */   {
/*  127 */     return 2003;
/*      */   }
/*      */ 
/*      */   public boolean isInHierarchyOf(OracleType paramOracleType)
/*      */     throws SQLException
/*      */   {
/*  138 */     if (paramOracleType == null) {
/*  139 */       return false;
/*      */     }
/*  141 */     if (paramOracleType == this) {
/*  142 */       return true;
/*      */     }
/*  144 */     if (paramOracleType.getClass() != getClass()) {
/*  145 */       return false;
/*      */     }
/*  147 */     return paramOracleType.getTypeDescriptor().getName().equals(this.descriptor.getName());
/*      */   }
/*      */ 
/*      */   public boolean isInHierarchyOf(StructDescriptor paramStructDescriptor)
/*      */     throws SQLException
/*      */   {
/*  156 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean isObjectType()
/*      */   {
/*  163 */     return false;
/*      */   }
/*      */ 
/*      */   public void parseTDSrec(TDSReader paramTDSReader)
/*      */     throws SQLException
/*      */   {
/*  177 */     long l = paramTDSReader.readLong();
/*      */ 
/*  181 */     this.maxSize = paramTDSReader.readLong();
/*      */ 
/*  187 */     this.userCode = paramTDSReader.readByte();
/*      */ 
/*  190 */     paramTDSReader.addSimplePatch(l, this);
/*      */   }
/*      */ 
/*      */   public Datum unlinearize(byte[] paramArrayOfByte, long paramLong, Datum paramDatum, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  202 */     return unlinearize(paramArrayOfByte, paramLong, paramDatum, 1L, -1, paramInt, paramMap);
/*      */   }
/*      */ 
/*      */   public Datum unlinearize(byte[] paramArrayOfByte, long paramLong1, Datum paramDatum, long paramLong2, int paramInt1, int paramInt2, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  211 */     OracleConnection localOracleConnection = getConnection();
/*  212 */     Datum localDatum = null;
/*      */ 
/*  217 */     if (localOracleConnection == null)
/*      */     {
/*  219 */       localDatum = unlinearizeInternal(paramArrayOfByte, paramLong1, paramDatum, paramLong2, paramInt1, paramInt2, paramMap);
/*      */     }
/*      */     else
/*      */     {
/*  224 */       synchronized (localOracleConnection)
/*      */       {
/*  226 */         localDatum = unlinearizeInternal(paramArrayOfByte, paramLong1, paramDatum, paramLong2, paramInt1, paramInt2, paramMap);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  231 */     return localDatum;
/*      */   }
/*      */ 
/*      */   public synchronized Datum unlinearizeInternal(byte[] paramArrayOfByte, long paramLong1, Datum paramDatum, long paramLong2, int paramInt1, int paramInt2, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  243 */     if (paramArrayOfByte == null) {
/*  244 */       return null;
/*      */     }
/*      */ 
/*  247 */     PickleContext localPickleContext = new PickleContext(paramArrayOfByte, paramLong1);
/*      */ 
/*  249 */     return unpickle81(localPickleContext, (ARRAY)paramDatum, paramLong2, paramInt1, 1, paramInt2, paramMap);
/*      */   }
/*      */ 
/*      */   public synchronized boolean isInlineImage(byte[] paramArrayOfByte, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  260 */     if (paramArrayOfByte == null) {
/*  261 */       return false;
/*      */     }
/*      */ 
/*  265 */     if (PickleContext.isCollectionImage_pctx(paramArrayOfByte[paramInt]))
/*  266 */       return true;
/*  267 */     if (PickleContext.isDegenerateImage_pctx(paramArrayOfByte[paramInt])) {
/*  268 */       return false;
/*      */     }
/*      */ 
/*  271 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Image is not a collection image");
/*  272 */     localSQLException.fillInStackTrace();
/*  273 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   protected int pickle81(PickleContext paramPickleContext, Datum paramDatum)
/*      */     throws SQLException
/*      */   {
/*  287 */     ARRAY localARRAY = (ARRAY)paramDatum;
/*      */ 
/*  289 */     boolean bool = localARRAY.hasDataSeg();
/*  290 */     int i = 0;
/*  291 */     int j = paramPickleContext.offset() + 2;
/*      */ 
/*  293 */     if (bool)
/*      */     {
/*  295 */       if (!this.metaDataInitialized) {
/*  296 */         copy_properties((OracleTypeCOLLECTION)localARRAY.getDescriptor().getPickler());
/*      */       }
/*  298 */       Datum[] arrayOfDatum = localARRAY.getOracleArray();
/*      */ 
/*  301 */       if (this.userCode == 3)
/*      */       {
/*  303 */         if (arrayOfDatum.length > this.maxSize)
/*      */         {
/*  305 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 71, null);
/*  306 */           localSQLException.fillInStackTrace();
/*  307 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*  311 */       i += paramPickleContext.writeCollImageHeader(arrayOfDatum.length, this.typeVersion);
/*      */ 
/*  313 */       for (int k = 0; k < arrayOfDatum.length; k++)
/*      */       {
/*  315 */         if (arrayOfDatum[k] == null)
/*  316 */           i += paramPickleContext.writeElementNull();
/*      */         else {
/*  318 */           i += this.elementType.pickle81(paramPickleContext, arrayOfDatum[k]);
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  325 */       i += paramPickleContext.writeCollImageHeader(localARRAY.getLocator());
/*      */     }
/*      */ 
/*  328 */     paramPickleContext.patchImageLen(j, i);
/*      */ 
/*  330 */     return i;
/*      */   }
/*      */ 
/*      */   ARRAY unpickle81(PickleContext paramPickleContext, ARRAY paramARRAY, int paramInt1, int paramInt2, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  341 */     return unpickle81(paramPickleContext, paramARRAY, 1L, -1, paramInt1, paramInt2, paramMap);
/*      */   }
/*      */ 
/*      */   ARRAY unpickle81(PickleContext paramPickleContext, ARRAY paramARRAY, long paramLong, int paramInt1, int paramInt2, int paramInt3, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  355 */     ARRAY localARRAY = paramARRAY;
/*      */ 
/*  357 */     if (localARRAY == null)
/*      */     {
/*  359 */       ArrayDescriptor localArrayDescriptor = createArrayDescriptor();
/*      */ 
/*  361 */       localARRAY = new ARRAY(localArrayDescriptor, (byte[])null, this.connection);
/*      */     }
/*      */ 
/*  364 */     if (unpickle81ImgHeader(paramPickleContext, localARRAY, paramInt2, paramInt3))
/*      */     {
/*  366 */       if ((paramLong == 1L) && (paramInt1 == -1))
/*  367 */         unpickle81ImgBody(paramPickleContext, localARRAY, paramInt3, paramMap);
/*      */       else {
/*  369 */         unpickle81ImgBody(paramPickleContext, localARRAY, paramLong, paramInt1, paramInt3, paramMap);
/*      */       }
/*      */     }
/*      */ 
/*  373 */     return localARRAY;
/*      */   }
/*      */ 
/*      */   boolean unpickle81ImgHeader(PickleContext paramPickleContext, ARRAY paramARRAY, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  381 */     int i = 1;
/*      */ 
/*  383 */     if (paramInt1 == 3)
/*      */     {
/*  385 */       paramARRAY.setImage(paramPickleContext.image(), paramPickleContext.absoluteOffset(), 0L);
/*      */     }
/*      */ 
/*  388 */     byte b = paramPickleContext.readByte();
/*      */     SQLException localSQLException;
/*  390 */     if (!PickleContext.is81format(b))
/*      */     {
/*  392 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Image is not in 8.1 format");
/*  393 */       localSQLException.fillInStackTrace();
/*  394 */       throw localSQLException;
/*      */     }
/*      */ 
/*  397 */     if (!PickleContext.hasPrefix(b))
/*      */     {
/*  399 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Image has no prefix segment");
/*  400 */       localSQLException.fillInStackTrace();
/*  401 */       throw localSQLException;
/*      */     }
/*      */ 
/*  404 */     if (PickleContext.isCollectionImage_pctx(b)) {
/*  405 */       i = 1;
/*  406 */     } else if (PickleContext.isDegenerateImage_pctx(b)) {
/*  407 */       i = 0;
/*      */     }
/*      */     else {
/*  410 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Image is not a collection image");
/*  411 */       localSQLException.fillInStackTrace();
/*  412 */       throw localSQLException;
/*      */     }
/*      */ 
/*  416 */     paramPickleContext.readByte();
/*      */ 
/*  419 */     if (paramInt1 == 9)
/*      */     {
/*  421 */       paramPickleContext.skipBytes(paramPickleContext.readLength(true) - 2);
/*      */ 
/*  423 */       return false;
/*      */     }
/*  425 */     if (paramInt1 == 3)
/*      */     {
/*  427 */       long l = paramPickleContext.readLength();
/*      */ 
/*  429 */       paramARRAY.setImageLength(l);
/*  430 */       paramPickleContext.skipTo(paramARRAY.getImageOffset() + l);
/*      */ 
/*  432 */       return false;
/*      */     }
/*      */ 
/*  435 */     paramPickleContext.skipLength();
/*      */ 
/*  438 */     int j = paramPickleContext.readLength();
/*      */ 
/*  443 */     paramARRAY.setPrefixFlag(paramPickleContext.readByte());
/*      */ 
/*  445 */     if (paramARRAY.isInline())
/*      */     {
/*  452 */       paramPickleContext.readDataValue(j - 1);
/*      */     }
/*      */     else
/*      */     {
/*  456 */       paramARRAY.setLocator(paramPickleContext.readDataValue(j - 1));
/*      */     }
/*      */ 
/*  459 */     return paramARRAY.isInline();
/*      */   }
/*      */ 
/*      */   void unpickle81ImgBody(PickleContext paramPickleContext, ARRAY paramARRAY, long paramLong, int paramInt1, int paramInt2, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  471 */     paramPickleContext.readByte();
/*      */ 
/*  474 */     int i = paramPickleContext.readLength();
/*      */ 
/*  476 */     paramARRAY.setLength(i);
/*      */ 
/*  478 */     if (paramInt2 == 0) {
/*  479 */       return;
/*      */     }
/*      */ 
/*  483 */     int j = (int)getAccessLength(i, paramLong, paramInt1);
/*  484 */     int k = ArrayDescriptor.getCacheStyle(paramARRAY) == 1 ? 1 : 0;
/*      */ 
/*  489 */     if ((paramLong > 1L) && (j > 0))
/*      */     {
/*  491 */       long l1 = paramARRAY.getLastIndex();
/*      */       long l2;
/*  493 */       if (l1 < paramLong)
/*      */       {
/*  495 */         if (l1 > 0L)
/*  496 */           paramPickleContext.skipTo(paramARRAY.getLastOffset());
/*      */         else {
/*  498 */           l1 = 1L;
/*      */         }
/*  500 */         if (k != 0)
/*      */         {
/*  502 */           for (l2 = l1; l2 < paramLong; l2 += 1L)
/*      */           {
/*  504 */             paramARRAY.setIndexOffset(l2, paramPickleContext.offset());
/*  505 */             this.elementType.unpickle81rec(paramPickleContext, 9, null);
/*      */           }
/*      */         }
/*      */         else
/*      */         {
/*  510 */           for (l2 = l1; l2 < paramLong; l2 += 1L)
/*  511 */             this.elementType.unpickle81rec(paramPickleContext, 9, null);
/*      */         }
/*      */       }
/*  514 */       else if (l1 > paramLong)
/*      */       {
/*  516 */         l2 = paramARRAY.getOffset(paramLong);
/*      */ 
/*  518 */         if (l2 != -1L)
/*      */         {
/*  520 */           paramPickleContext.skipTo(l2);
/*      */         }
/*      */         else
/*      */         {
/*      */           int m;
/*  524 */           if (k != 0)
/*      */           {
/*  526 */             for (m = 1; m < paramLong; m++)
/*      */             {
/*  528 */               paramARRAY.setIndexOffset(m, paramPickleContext.offset());
/*  529 */               this.elementType.unpickle81rec(paramPickleContext, 9, null);
/*      */             }
/*      */           }
/*      */           else
/*      */           {
/*  534 */             for (m = 1; m < paramLong; m++)
/*  535 */               this.elementType.unpickle81rec(paramPickleContext, 9, null);
/*      */           }
/*      */         }
/*      */       }
/*      */       else {
/*  540 */         paramPickleContext.skipTo(paramARRAY.getLastOffset());
/*      */       }
/*  542 */       paramARRAY.setLastIndexOffset(paramLong, paramPickleContext.offset());
/*      */     }
/*      */ 
/*  546 */     unpickle81ImgBodyElements(paramPickleContext, paramARRAY, (int)paramLong, j, paramInt2, paramMap);
/*      */   }
/*      */ 
/*      */   void unpickle81ImgBody(PickleContext paramPickleContext, ARRAY paramARRAY, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  558 */     paramPickleContext.readByte();
/*      */ 
/*  561 */     int i = paramPickleContext.readLength();
/*      */ 
/*  563 */     paramARRAY.setLength(i);
/*      */ 
/*  565 */     if (paramInt == 0) {
/*  566 */       return;
/*      */     }
/*      */ 
/*  570 */     unpickle81ImgBodyElements(paramPickleContext, paramARRAY, 1, i, paramInt, paramMap);
/*      */   }
/*      */ 
/*      */   private void unpickle81ImgBodyElements(PickleContext paramPickleContext, ARRAY paramARRAY, int paramInt1, int paramInt2, int paramInt3, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  581 */     int i = ArrayDescriptor.getCacheStyle(paramARRAY) == 1 ? 1 : 0;
/*      */     Object localObject;
/*      */     int j;
/*  585 */     switch (paramInt3)
/*      */     {
/*      */     case 1:
/*  590 */       localObject = new Datum[paramInt2];
/*      */ 
/*  592 */       if (i != 0)
/*      */       {
/*  594 */         for (j = 0; j < paramInt2; j++)
/*      */         {
/*  596 */           paramARRAY.setIndexOffset(paramInt1 + j, paramPickleContext.offset());
/*      */ 
/*  598 */           localObject[j] = ((Datum)this.elementType.unpickle81rec(paramPickleContext, paramInt3, paramMap));
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  604 */         for (j = 0; j < paramInt2; j++) {
/*  605 */           localObject[j] = ((Datum)this.elementType.unpickle81rec(paramPickleContext, paramInt3, paramMap));
/*      */         }
/*      */       }
/*      */ 
/*  609 */       paramARRAY.setDatumArray((Datum[])localObject);
/*      */ 
/*  612 */       break;
/*      */     case 2:
/*  616 */       localObject = ArrayDescriptor.makeJavaArray(paramInt2, this.elementType.getTypeCode());
/*      */ 
/*  619 */       if (i != 0)
/*      */       {
/*  621 */         for (j = 0; j < paramInt2; j++)
/*      */         {
/*  623 */           paramARRAY.setIndexOffset(paramInt1 + j, paramPickleContext.offset());
/*      */ 
/*  625 */           localObject[j] = this.elementType.unpickle81rec(paramPickleContext, paramInt3, paramMap);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  630 */         for (j = 0; j < paramInt2; j++) {
/*  631 */           localObject[j] = this.elementType.unpickle81rec(paramPickleContext, paramInt3, paramMap);
/*      */         }
/*      */       }
/*  634 */       paramARRAY.setObjArray(localObject);
/*      */ 
/*  637 */       break;
/*      */     case 4:
/*      */     case 5:
/*      */     case 6:
/*      */     case 7:
/*      */     case 8:
/*  649 */       if (((this.elementType instanceof OracleTypeNUMBER)) || ((this.elementType instanceof OracleTypeFLOAT)))
/*      */       {
/*  652 */         paramARRAY.setObjArray(OracleTypeNUMBER.unpickle81NativeArray(paramPickleContext, 1L, paramInt2, paramInt3));
/*      */       }
/*      */       else
/*      */       {
/*  657 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23, "This feature is limited to numeric collection");
/*  658 */         ((SQLException)localObject).fillInStackTrace();
/*  659 */         throw ((Throwable)localObject);
/*      */       }
/*      */ 
/*      */       break;
/*      */     case 3:
/*      */     default:
/*  667 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "Invalid conversion type " + this.elementType);
/*  668 */       ((SQLException)localObject).fillInStackTrace();
/*  669 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/*  674 */     paramARRAY.setLastIndexOffset(paramInt1 + paramInt2, paramPickleContext.offset());
/*      */   }
/*      */ 
/*      */   private void initCollElemTypeName()
/*      */     throws SQLException
/*      */   {
/*  803 */     if (this.connection == null)
/*  804 */       return;
/*  805 */     synchronized (this.connection) {
/*  806 */       if (this.sqlName == null) {
/*  807 */         getFullName();
/*      */       }
/*  809 */       CallableStatement localCallableStatement = null;
/*  810 */       PreparedStatement localPreparedStatement = null;
/*  811 */       ResultSet localResultSet = null;
/*      */ 
/*  813 */       this.connection.beginNonRequestCalls();
/*      */       try {
/*  815 */         int i = this.sqlName.getSchema().equalsIgnoreCase(this.connection.getDefaultSchemaNameForNamedTypes()) ? 0 : 7;
/*      */ 
/*  818 */         while (i != 11)
/*      */         {
/*  820 */           switch (i)
/*      */           {
/*      */           case 0:
/*  824 */             localPreparedStatement = this.connection.prepareStatement(getSqlHint() + sqlString[i]);
/*  825 */             localPreparedStatement.setString(1, this.sqlName.getSimpleName());
/*  826 */             localPreparedStatement.setFetchSize(1);
/*  827 */             localResultSet = localPreparedStatement.executeQuery();
/*  828 */             i = 1;
/*  829 */             break;
/*      */           case 1:
/*  832 */             if (this.connection.getVersionNumber() >= 10000)
/*      */             {
/*  834 */               i = 2;
/*      */             }
/*      */ 
/*      */           case 2:
/*  839 */             localPreparedStatement = this.connection.prepareStatement(getSqlHint() + sqlString[i]);
/*  840 */             localPreparedStatement.setString(1, this.sqlName.getSimpleName());
/*  841 */             localPreparedStatement.setString(2, this.sqlName.getSimpleName());
/*  842 */             localPreparedStatement.setFetchSize(1);
/*  843 */             localResultSet = localPreparedStatement.executeQuery();
/*  844 */             i = 3;
/*  845 */             break;
/*      */           case 3:
/*  848 */             if (this.connection.getVersionNumber() >= 10000)
/*      */             {
/*  850 */               i = 4;
/*      */             }
/*      */ 
/*      */           case 4:
/*  855 */             localPreparedStatement = this.connection.prepareStatement(getSqlHint() + sqlString[i]);
/*  856 */             localPreparedStatement.setString(1, this.sqlName.getSimpleName());
/*  857 */             localPreparedStatement.setString(2, this.sqlName.getSimpleName());
/*  858 */             localPreparedStatement.setFetchSize(1);
/*  859 */             localResultSet = localPreparedStatement.executeQuery();
/*  860 */             i = 5;
/*  861 */             break;
/*      */           case 5:
/*  864 */             if (this.connection.getVersionNumber() >= 10000)
/*      */             {
/*  866 */               i = 6;
/*      */             }
/*      */ 
/*      */           case 6:
/*  871 */             localPreparedStatement = this.connection.prepareStatement(getSqlHint() + sqlString[i]);
/*  872 */             localPreparedStatement.setString(1, this.sqlName.getSimpleName());
/*  873 */             localPreparedStatement.setString(2, this.sqlName.getSimpleName());
/*  874 */             localPreparedStatement.setFetchSize(1);
/*  875 */             localResultSet = localPreparedStatement.executeQuery();
/*  876 */             i = 8;
/*  877 */             break;
/*      */           case 7:
/*  881 */             localPreparedStatement = this.connection.prepareStatement(getSqlHint() + sqlString[i]);
/*  882 */             localPreparedStatement.setString(1, this.sqlName.getSchema());
/*  883 */             localPreparedStatement.setString(2, this.sqlName.getSimpleName());
/*  884 */             localPreparedStatement.setFetchSize(1);
/*  885 */             localResultSet = localPreparedStatement.executeQuery();
/*  886 */             i = 8;
/*  887 */             break;
/*      */           case 8:
/*  891 */             localPreparedStatement = this.connection.prepareStatement(getSqlHint() + sqlString[i]);
/*  892 */             localPreparedStatement.setString(1, this.sqlName.getSimpleName());
/*  893 */             localPreparedStatement.setString(2, this.sqlName.getSimpleName());
/*  894 */             localPreparedStatement.setFetchSize(1);
/*  895 */             localResultSet = localPreparedStatement.executeQuery();
/*  896 */             i = 9;
/*  897 */             break;
/*      */           case 9:
/*  900 */             if (this.connection.getVersionNumber() >= 10000)
/*      */             {
/*  902 */               i = 10;
/*      */             }
/*      */ 
/*      */           case 10:
/*  907 */             localCallableStatement = this.connection.prepareCall(getSqlHint() + sqlString[i]);
/*  908 */             localCallableStatement.setString(1, this.sqlName.getSimpleName());
/*  909 */             localCallableStatement.registerOutParameter(2, -10);
/*  910 */             localCallableStatement.execute();
/*  911 */             localResultSet = ((OracleCallableStatement)localCallableStatement).getCursor(2);
/*  912 */             i = 11;
/*      */           }
/*      */ 
/*  916 */           if (localResultSet.next()) {
/*  917 */             if (this.attrTypeNames == null) {
/*  918 */               this.attrTypeNames = new String[1];
/*      */             }
/*  920 */             this.attrTypeNames[0] = (localResultSet.getString(2) + "." + localResultSet.getString(1));
/*  921 */             i = 11;
/*      */           }
/*  923 */           else if (i == 11)
/*      */           {
/*  925 */             SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/*  926 */             localSQLException.fillInStackTrace();
/*  927 */             throw localSQLException;
/*      */           }
/*      */         }
/*  930 */         while (i != 11);
/*      */       }
/*      */       finally {
/*  933 */         if (localResultSet != null)
/*  934 */           localResultSet.close();
/*  935 */         if (localPreparedStatement != null)
/*  936 */           localPreparedStatement.close();
/*  937 */         if (localCallableStatement != null) {
/*  938 */           localCallableStatement.close();
/*      */         }
/*      */ 
/*  944 */         this.connection.endNonRequestCalls();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public String getAttributeName(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  954 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/*  955 */     localSQLException.fillInStackTrace();
/*  956 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public String getAttributeName(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  964 */     return getAttributeName(paramInt);
/*      */   }
/*      */ 
/*      */   public String getAttributeType(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  977 */     if (paramInt != 1)
/*      */     {
/*  979 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  980 */       localSQLException.fillInStackTrace();
/*  981 */       throw localSQLException;
/*      */     }
/*      */ 
/*  984 */     if (this.sqlName == null) {
/*  985 */       getFullName();
/*      */     }
/*  987 */     if (this.attrTypeNames == null) {
/*  988 */       initCollElemTypeName();
/*      */     }
/*  990 */     return this.attrTypeNames[0];
/*      */   }
/*      */ 
/*      */   public String getAttributeType(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  997 */     if (paramBoolean) {
/*  998 */       return getAttributeType(paramInt);
/*      */     }
/*      */ 
/* 1001 */     if (paramInt != 1)
/*      */     {
/* 1003 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 1004 */       localSQLException.fillInStackTrace();
/* 1005 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1008 */     if ((this.sqlName != null) && (this.attrTypeNames != null)) {
/* 1009 */       return this.attrTypeNames[0];
/*      */     }
/* 1011 */     return null;
/*      */   }
/*      */ 
/*      */   public int getNumAttrs()
/*      */     throws SQLException
/*      */   {
/* 1019 */     return 0;
/*      */   }
/*      */ 
/*      */   public OracleType getAttrTypeAt(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1026 */     return null;
/*      */   }
/*      */ 
/*      */   ArrayDescriptor createArrayDescriptor()
/*      */     throws SQLException
/*      */   {
/* 1033 */     return new ArrayDescriptor(this, this.connection);
/*      */   }
/*      */ 
/*      */   ArrayDescriptor createArrayDescriptorWithItsOwnTree()
/*      */     throws SQLException
/*      */   {
/* 1040 */     if (this.descriptor == null)
/*      */     {
/* 1042 */       if ((this.sqlName == null) && (getFullName(false) == null))
/*      */       {
/* 1044 */         this.descriptor = new ArrayDescriptor(this, this.connection);
/*      */       }
/*      */       else
/*      */       {
/* 1048 */         this.descriptor = ArrayDescriptor.createDescriptor(this.sqlName, this.connection);
/*      */       }
/*      */     }
/*      */ 
/* 1052 */     return (ArrayDescriptor)this.descriptor;
/*      */   }
/*      */ 
/*      */   public OracleType getElementType()
/*      */     throws SQLException
/*      */   {
/* 1059 */     return this.elementType;
/*      */   }
/*      */ 
/*      */   public int getUserCode()
/*      */     throws SQLException
/*      */   {
/* 1066 */     return this.userCode;
/*      */   }
/*      */ 
/*      */   public long getMaxLength()
/*      */     throws SQLException
/*      */   {
/* 1073 */     return this.maxSize;
/*      */   }
/*      */ 
/*      */   private long getAccessLength(long paramLong1, long paramLong2, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1081 */     if (paramLong2 > paramLong1) {
/* 1082 */       return 0L;
/*      */     }
/* 1084 */     if (paramInt < 0)
/*      */     {
/* 1086 */       return paramLong1 - paramLong2 + 1L;
/*      */     }
/*      */ 
/* 1090 */     return Math.min(paramLong1 - paramLong2 + 1L, paramInt);
/*      */   }
/*      */ 
/*      */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*      */     throws IOException
/*      */   {
/* 1102 */     paramObjectOutputStream.writeInt(this.userCode);
/* 1103 */     paramObjectOutputStream.writeLong(this.maxSize);
/* 1104 */     paramObjectOutputStream.writeObject(this.elementType);
/*      */   }
/*      */ 
/*      */   private void readObject(ObjectInputStream paramObjectInputStream)
/*      */     throws IOException, ClassNotFoundException
/*      */   {
/* 1112 */     this.userCode = paramObjectInputStream.readInt();
/* 1113 */     this.maxSize = paramObjectInputStream.readLong();
/* 1114 */     this.elementType = ((OracleType)paramObjectInputStream.readObject());
/*      */   }
/*      */ 
/*      */   public void setConnection(OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/* 1121 */     this.connection = paramOracleConnection;
/*      */ 
/* 1123 */     this.elementType.setConnection(paramOracleConnection);
/*      */   }
/*      */ 
/*      */   public void initMetadataRecursively()
/*      */     throws SQLException
/*      */   {
/* 1130 */     initMetadata(this.connection);
/* 1131 */     if (this.elementType != null) this.elementType.initMetadataRecursively();
/*      */   }
/*      */ 
/*      */   public void initChildNamesRecursively(Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1138 */     TypeTreeElement localTypeTreeElement = (TypeTreeElement)paramMap.get(this.sqlName);
/*      */ 
/* 1140 */     if (this.elementType != null)
/*      */     {
/* 1142 */       this.elementType.setNames(localTypeTreeElement.getChildSchemaName(0), localTypeTreeElement.getChildTypeName(0));
/* 1143 */       this.elementType.initChildNamesRecursively(paramMap);
/* 1144 */       this.elementType.cacheDescriptor();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void cacheDescriptor()
/*      */     throws SQLException
/*      */   {
/* 1152 */     this.descriptor = ArrayDescriptor.createDescriptor(this);
/*      */   }
/*      */ 
/*      */   public void printXML(PrintWriter paramPrintWriter, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1159 */     printXML(paramPrintWriter, paramInt, false);
/*      */   }
/*      */ 
/*      */   public void printXML(PrintWriter paramPrintWriter, int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1166 */     for (int i = 0; i < paramInt; i++) paramPrintWriter.print("  ");
/* 1167 */     paramPrintWriter.println("<OracleTypeCOLLECTION sqlName=\"" + this.sqlName + "\" " + ">");
/*      */ 
/* 1170 */     if (this.elementType != null)
/* 1171 */       this.elementType.printXML(paramPrintWriter, paramInt + 1, paramBoolean);
/* 1172 */     for (i = 0; i < paramInt; i++) paramPrintWriter.print("  ");
/* 1173 */     paramPrintWriter.println("</OracleTypeCOLLECTION>");
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeCOLLECTION
 * JD-Core Version:    0.6.2
 */