/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.CLOB;
/*     */ import oracle.sql.Datum;
/*     */ 
/*     */ public class OracleTypeCLOB extends OracleType
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = 1122821330765834411L;
/*  32 */   static int fixedDataSize = 86;
/*     */   transient OracleConnection connection;
/*     */   int form;
/* 225 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected OracleTypeCLOB()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleTypeCLOB(OracleConnection paramOracleConnection)
/*     */   {
/*  47 */     this.connection = paramOracleConnection;
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  61 */     CLOB localCLOB = null;
/*     */ 
/*  63 */     if (paramObject != null)
/*     */     {
/*  65 */       if ((paramObject instanceof CLOB)) {
/*  66 */         localCLOB = (CLOB)paramObject;
/*     */       }
/*     */       else {
/*  69 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/*  70 */         localSQLException.fillInStackTrace();
/*  71 */         throw localSQLException;
/*     */       }
/*     */     }
/*     */ 
/*  75 */     return localCLOB;
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */   {
/*  85 */     return this.form == 2 ? 2011 : 2005;
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 111 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 112 */       return null;
/*     */     }
/* 114 */     if ((paramInt == 1) || (paramInt == 2)) {
/* 115 */       return this.connection.createClobWithUnpickledBytes(paramArrayOfByte);
/*     */     }
/*     */ 
/* 119 */     if (paramInt == 3) {
/* 120 */       return paramArrayOfByte;
/*     */     }
/*     */ 
/* 123 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramArrayOfByte);
/* 124 */     localSQLException.fillInStackTrace();
/* 125 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setConnection(OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 151 */     this.connection = paramOracleConnection;
/*     */   }
/*     */ 
/*     */   public boolean isNCHAR()
/*     */     throws SQLException
/*     */   {
/* 163 */     return this.form == 2;
/*     */   }
/*     */ 
/*     */   public void setForm(int paramInt)
/*     */   {
/* 170 */     this.form = paramInt;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 185 */     return this.connection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeCLOB
 * JD-Core Version:    0.6.2
 */