/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.CHAR;
/*     */ import oracle.sql.CharacterSet;
/*     */ import oracle.sql.Datum;
/*     */ 
/*     */ public class OracleTypeCHAR extends OracleType
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = -6899444518695804629L;
/*     */   int form;
/*     */   int charset;
/*     */   int length;
/*     */   int characterSemantic;
/*     */   private transient OracleConnection connection;
/*     */   private short pickleCharaterSetId;
/*     */   private transient CharacterSet pickleCharacterSet;
/*     */   private short pickleNcharCharacterSet;
/* 614 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected OracleTypeCHAR()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleTypeCHAR(OracleConnection paramOracleConnection)
/*     */   {
/*  68 */     this.form = 0;
/*  69 */     this.charset = 0;
/*  70 */     this.length = 0;
/*  71 */     this.connection = paramOracleConnection;
/*  72 */     this.pickleCharaterSetId = 0;
/*  73 */     this.pickleNcharCharacterSet = 0;
/*  74 */     this.pickleCharacterSet = null;
/*     */     try
/*     */     {
/*  78 */       this.pickleCharaterSetId = this.connection.getStructAttrCsId();
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/*  83 */       this.pickleCharaterSetId = -1;
/*     */     }
/*     */ 
/*  86 */     this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
/*     */   }
/*     */ 
/*     */   protected OracleTypeCHAR(OracleConnection paramOracleConnection, int paramInt)
/*     */   {
/*  92 */     super(paramInt);
/*     */ 
/*  94 */     this.form = 0;
/*  95 */     this.charset = 0;
/*  96 */     this.length = 0;
/*  97 */     this.connection = paramOracleConnection;
/*  98 */     this.pickleCharaterSetId = 0;
/*  99 */     this.pickleNcharCharacterSet = 0;
/* 100 */     this.pickleCharacterSet = null;
/*     */     try
/*     */     {
/* 104 */       this.pickleCharaterSetId = this.connection.getStructAttrCsId();
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 110 */       this.pickleCharaterSetId = -1;
/*     */     }
/*     */ 
/* 113 */     this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 139 */     if (paramObject == null) {
/* 140 */       return null;
/*     */     }
/* 142 */     CHAR localCHAR = (paramObject instanceof CHAR) ? (CHAR)paramObject : new CHAR(paramObject, this.pickleCharacterSet);
/*     */ 
/* 144 */     return localCHAR;
/*     */   }
/*     */ 
/*     */   public Datum[] toDatumArray(Object paramObject, OracleConnection paramOracleConnection, long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 166 */     Datum[] arrayOfDatum = null;
/*     */ 
/* 168 */     if (paramObject != null)
/*     */     {
/* 170 */       if (((paramObject instanceof Object[])) && (!(paramObject instanceof char[][]))) {
/* 171 */         return super.toDatumArray(paramObject, paramOracleConnection, paramLong, paramInt);
/*     */       }
/* 173 */       arrayOfDatum = cArrayToDatumArray(paramObject, paramOracleConnection, paramLong, paramInt);
/*     */     }
/*     */ 
/* 176 */     return arrayOfDatum;
/*     */   }
/*     */ 
/*     */   public void parseTDSrec(TDSReader paramTDSReader)
/*     */     throws SQLException
/*     */   {
/* 191 */     super.parseTDSrec(paramTDSReader);
/*     */     try
/*     */     {
/* 196 */       this.length = paramTDSReader.readUB2();
/* 197 */       this.form = paramTDSReader.readByte();
/* 198 */       this.characterSemantic = (this.form & 0x80);
/* 199 */       this.form &= 127;
/* 200 */       this.charset = paramTDSReader.readUB2();
/* 201 */       if (this.form == 2) {
/* 202 */         switch (this.typeCode)
/*     */         {
/*     */         case 12:
/* 205 */           this.typeCode = -9;
/* 206 */           break;
/*     */         case 1:
/* 208 */           this.typeCode = -15;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (SQLException localSQLException1)
/*     */     {
/* 216 */       SQLException localSQLException3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 47, "parseTDS");
/* 217 */       localSQLException3.fillInStackTrace();
/* 218 */       throw localSQLException3;
/*     */     }
/*     */ 
/* 222 */     if ((this.form != 2) || (this.pickleNcharCharacterSet != 0)) {
/* 223 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 231 */       this.pickleNcharCharacterSet = this.connection.getStructAttrNCsId();
/*     */     }
/*     */     catch (SQLException localSQLException2)
/*     */     {
/* 237 */       this.pickleNcharCharacterSet = 2000;
/*     */     }
/*     */ 
/* 240 */     this.pickleCharaterSetId = this.pickleNcharCharacterSet;
/* 241 */     this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
/*     */   }
/*     */ 
/*     */   protected int pickle81(PickleContext paramPickleContext, Datum paramDatum)
/*     */     throws SQLException
/*     */   {
/* 267 */     CHAR localCHAR = getDbCHAR(paramDatum);
/*     */     SQLException localSQLException;
/* 269 */     if ((this.characterSemantic != 0) && (this.form != 2))
/*     */     {
/* 273 */       if (localCHAR.getStringWithReplacement().length() > this.length)
/*     */       {
/* 275 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 72, "\"" + localCHAR.getStringWithReplacement() + "\"");
/* 276 */         localSQLException.fillInStackTrace();
/* 277 */         throw localSQLException;
/*     */       }
/*     */ 
/*     */     }
/* 284 */     else if (localCHAR.getLength() > this.length)
/*     */     {
/* 286 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 72, "\"" + localCHAR.getStringWithReplacement() + "\"");
/* 287 */       localSQLException.fillInStackTrace();
/* 288 */       throw localSQLException;
/*     */     }
/*     */ 
/* 292 */     return super.pickle81(paramPickleContext, localCHAR);
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 304 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 305 */       return null;
/*     */     }
/*     */ 
/* 309 */     CHAR localCHAR = null;
/*     */ 
/* 311 */     switch (this.form)
/*     */     {
/*     */     case 1:
/*     */     case 2:
/* 319 */       localCHAR = new CHAR(paramArrayOfByte, this.pickleCharacterSet);
/*     */ 
/* 321 */       break;
/*     */     case 3:
/*     */     case 4:
/*     */     case 5:
/* 328 */       localCHAR = new CHAR(paramArrayOfByte, null);
/*     */     }
/*     */ 
/* 333 */     if (paramInt == 1)
/* 334 */       return localCHAR;
/* 335 */     if (paramInt == 2)
/* 336 */       return localCHAR.stringValue();
/* 337 */     if (paramInt == 3) {
/* 338 */       return paramArrayOfByte;
/*     */     }
/*     */ 
/* 341 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramArrayOfByte);
/* 342 */     localSQLException.fillInStackTrace();
/* 343 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   private CHAR getDbCHAR(Datum paramDatum)
/*     */   {
/* 357 */     CHAR localCHAR1 = (CHAR)paramDatum;
/* 358 */     CHAR localCHAR2 = null;
/*     */ 
/* 360 */     if (localCHAR1.getCharacterSet().getOracleId() == this.pickleCharaterSetId)
/*     */     {
/* 362 */       localCHAR2 = localCHAR1;
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 368 */         localCHAR2 = new CHAR(localCHAR1.toString(), this.pickleCharacterSet);
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/* 374 */         localCHAR2 = localCHAR1;
/*     */       }
/*     */     }
/* 377 */     return localCHAR2;
/*     */   }
/*     */ 
/*     */   private Datum[] cArrayToDatumArray(Object paramObject, OracleConnection paramOracleConnection, long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 390 */     Datum[] arrayOfDatum = null;
/*     */ 
/* 392 */     if (paramObject != null)
/*     */     {
/*     */       Object localObject;
/*     */       int i;
/*     */       int j;
/* 394 */       if ((paramObject instanceof char[][]))
/*     */       {
/* 396 */         localObject = (char[][])paramObject;
/* 397 */         i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 400 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 402 */         for (j = 0; j < i; j++) {
/* 403 */           arrayOfDatum[j] = new CHAR(new String(localObject[((int)paramLong + j - 1)]), this.pickleCharacterSet);
/*     */         }
/*     */       }
/* 406 */       else if ((paramObject instanceof boolean[]))
/*     */       {
/* 408 */         localObject = (boolean[])paramObject;
/* 409 */         i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 412 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 414 */         for (j = 0; j < i; j++) {
/* 415 */           arrayOfDatum[j] = new CHAR(Boolean.valueOf(localObject[((int)paramLong + j - 1)]), this.pickleCharacterSet);
/*     */         }
/*     */       }
/* 418 */       else if ((paramObject instanceof short[]))
/*     */       {
/* 420 */         localObject = (short[])paramObject;
/* 421 */         i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 424 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 428 */         for (j = 0; j < i; j++) {
/* 429 */           arrayOfDatum[j] = new CHAR(Integer.valueOf(localObject[((int)paramLong + j - 1)]), this.pickleCharacterSet);
/*     */         }
/*     */ 
/*     */       }
/* 433 */       else if ((paramObject instanceof int[]))
/*     */       {
/* 435 */         localObject = (int[])paramObject;
/* 436 */         i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 439 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 441 */         for (j = 0; j < i; j++) {
/* 442 */           arrayOfDatum[j] = new CHAR(Integer.valueOf(localObject[((int)paramLong + j - 1)]), this.pickleCharacterSet);
/*     */         }
/*     */       }
/* 445 */       else if ((paramObject instanceof long[]))
/*     */       {
/* 447 */         localObject = (long[])paramObject;
/* 448 */         i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 451 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 453 */         for (j = 0; j < i; j++) {
/* 454 */           arrayOfDatum[j] = new CHAR(new Long(localObject[((int)paramLong + j - 1)]), this.pickleCharacterSet);
/*     */         }
/*     */       }
/* 457 */       else if ((paramObject instanceof float[]))
/*     */       {
/* 459 */         localObject = (float[])paramObject;
/* 460 */         i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 463 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 465 */         for (j = 0; j < i; j++) {
/* 466 */           arrayOfDatum[j] = new CHAR(new Float(localObject[((int)paramLong + j - 1)]), this.pickleCharacterSet);
/*     */         }
/*     */       }
/* 469 */       else if ((paramObject instanceof double[]))
/*     */       {
/* 471 */         localObject = (double[])paramObject;
/* 472 */         i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 475 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 477 */         for (j = 0; j < i; j++) {
/* 478 */           arrayOfDatum[j] = new CHAR(new Double(localObject[((int)paramLong + j - 1)]), this.pickleCharacterSet);
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 484 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/* 485 */         ((SQLException)localObject).fillInStackTrace();
/* 486 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 491 */     return arrayOfDatum;
/*     */   }
/*     */ 
/*     */   public int getLength()
/*     */   {
/* 498 */     return this.length;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/* 509 */     paramObjectOutputStream.writeInt(this.form);
/* 510 */     paramObjectOutputStream.writeInt(this.charset);
/* 511 */     paramObjectOutputStream.writeInt(this.length);
/* 512 */     paramObjectOutputStream.writeInt(this.characterSemantic);
/* 513 */     paramObjectOutputStream.writeShort(this.pickleCharaterSetId);
/* 514 */     paramObjectOutputStream.writeShort(this.pickleNcharCharacterSet);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 522 */     this.form = paramObjectInputStream.readInt();
/* 523 */     this.charset = paramObjectInputStream.readInt();
/* 524 */     this.length = paramObjectInputStream.readInt();
/* 525 */     this.characterSemantic = paramObjectInputStream.readInt();
/* 526 */     this.pickleCharaterSetId = paramObjectInputStream.readShort();
/* 527 */     this.pickleNcharCharacterSet = paramObjectInputStream.readShort();
/*     */ 
/* 529 */     if (this.pickleNcharCharacterSet != 0)
/* 530 */       this.pickleCharacterSet = CharacterSet.make(this.pickleNcharCharacterSet);
/*     */     else
/* 532 */       this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
/*     */   }
/*     */ 
/*     */   public void setConnection(OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 539 */     this.connection = paramOracleConnection;
/*     */   }
/*     */ 
/*     */   public boolean isNCHAR()
/*     */     throws SQLException
/*     */   {
/* 553 */     return this.form == 2;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 568 */     return this.connection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeCHAR
 * JD-Core Version:    0.6.2
 */