/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.BLOB;
/*     */ import oracle.sql.Datum;
/*     */ 
/*     */ public class OracleTypeBLOB extends OracleType
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = -2311211431562030662L;
/*  31 */   static int fixedDataSize = 86;
/*     */   transient OracleConnection connection;
/* 208 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected OracleTypeBLOB()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleTypeBLOB(OracleConnection paramOracleConnection)
/*     */   {
/*  46 */     this.connection = paramOracleConnection;
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  60 */     BLOB localBLOB = null;
/*     */ 
/*  62 */     if (paramObject != null)
/*     */     {
/*  64 */       if ((paramObject instanceof BLOB)) {
/*  65 */         localBLOB = (BLOB)paramObject;
/*     */       }
/*     */       else {
/*  68 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/*  69 */         localSQLException.fillInStackTrace();
/*  70 */         throw localSQLException;
/*     */       }
/*     */     }
/*     */ 
/*  74 */     return localBLOB;
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */   {
/*  84 */     return 2004;
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 109 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 110 */       return null;
/*     */     }
/* 112 */     switch (paramInt)
/*     */     {
/*     */     case 1:
/*     */     case 2:
/* 120 */       return this.connection.createBlobWithUnpickledBytes(paramArrayOfByte);
/*     */     case 3:
/* 124 */       return paramArrayOfByte;
/*     */     }
/*     */ 
/* 128 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramArrayOfByte);
/* 129 */     localSQLException.fillInStackTrace();
/* 130 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setConnection(OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 156 */     this.connection = paramOracleConnection;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 171 */     return this.connection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeBLOB
 * JD-Core Version:    0.6.2
 */