/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.BINARY_FLOAT;
/*     */ import oracle.sql.Datum;
/*     */ 
/*     */ public class OracleTypeBINARY_FLOAT extends OracleType
/*     */   implements Serializable
/*     */ {
/* 171 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  45 */     BINARY_FLOAT localBINARY_FLOAT = null;
/*     */ 
/*  47 */     if (paramObject != null)
/*     */     {
/*  49 */       if ((paramObject instanceof BINARY_FLOAT)) {
/*  50 */         localBINARY_FLOAT = (BINARY_FLOAT)paramObject;
/*  51 */       } else if ((paramObject instanceof Float)) {
/*  52 */         localBINARY_FLOAT = new BINARY_FLOAT((Float)paramObject);
/*  53 */       } else if ((paramObject instanceof byte[])) {
/*  54 */         localBINARY_FLOAT = new BINARY_FLOAT((byte[])paramObject);
/*     */       }
/*     */       else {
/*  57 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/*  58 */         localSQLException.fillInStackTrace();
/*  59 */         throw localSQLException;
/*     */       }
/*     */     }
/*     */ 
/*  63 */     return localBINARY_FLOAT;
/*     */   }
/*     */ 
/*     */   public Datum[] toDatumArray(Object paramObject, OracleConnection paramOracleConnection, long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  77 */     Datum[] arrayOfDatum = null;
/*     */ 
/*  79 */     if (paramObject != null)
/*     */     {
/*  81 */       if ((paramObject instanceof Object[]))
/*     */       {
/*  83 */         Object[] arrayOfObject = (Object[])paramObject;
/*     */ 
/*  85 */         int i = (int)(paramInt == -1 ? arrayOfObject.length : Math.min(arrayOfObject.length - paramLong + 1L, paramInt));
/*     */ 
/*  88 */         arrayOfDatum = new Datum[i];
/*     */ 
/*  90 */         for (int j = 0; j < i; j++)
/*     */         {
/*  92 */           Object localObject = arrayOfObject[((int)paramLong + j - 1)];
/*     */ 
/*  94 */           if (localObject != null)
/*     */           {
/*  96 */             if ((localObject instanceof Float)) {
/*  97 */               arrayOfDatum[j] = new BINARY_FLOAT(((Float)localObject).floatValue());
/*     */             }
/*  99 */             else if ((localObject instanceof BINARY_FLOAT)) {
/* 100 */               arrayOfDatum[j] = ((BINARY_FLOAT)localObject);
/*     */             }
/*     */             else {
/* 103 */               SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 104 */               localSQLException.fillInStackTrace();
/* 105 */               throw localSQLException;
/*     */             }
/*     */ 
/*     */           }
/*     */           else
/*     */           {
/* 111 */             arrayOfDatum[j] = null;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 117 */     return arrayOfDatum;
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */   {
/* 127 */     return 100;
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 153 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 154 */       return null;
/*     */     }
/* 156 */     if (paramInt == 1)
/* 157 */       return new BINARY_FLOAT(paramArrayOfByte);
/* 158 */     if (paramInt == 2)
/* 159 */       return new BINARY_FLOAT(paramArrayOfByte).toJdbc();
/* 160 */     if (paramInt == 3) {
/* 161 */       return paramArrayOfByte;
/*     */     }
/*     */ 
/* 164 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramArrayOfByte);
/* 165 */     localSQLException.fillInStackTrace();
/* 166 */     throw localSQLException;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeBINARY_FLOAT
 * JD-Core Version:    0.6.2
 */