/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.BINARY_DOUBLE;
/*     */ import oracle.sql.Datum;
/*     */ 
/*     */ public class OracleTypeBINARY_DOUBLE extends OracleType
/*     */   implements Serializable
/*     */ {
/* 173 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  46 */     BINARY_DOUBLE localBINARY_DOUBLE = null;
/*     */ 
/*  48 */     if (paramObject != null)
/*     */     {
/*  50 */       if ((paramObject instanceof BINARY_DOUBLE)) {
/*  51 */         localBINARY_DOUBLE = (BINARY_DOUBLE)paramObject;
/*  52 */       } else if ((paramObject instanceof Double)) {
/*  53 */         localBINARY_DOUBLE = new BINARY_DOUBLE((Double)paramObject);
/*  54 */       } else if ((paramObject instanceof byte[])) {
/*  55 */         localBINARY_DOUBLE = new BINARY_DOUBLE((byte[])paramObject);
/*     */       }
/*     */       else {
/*  58 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/*  59 */         localSQLException.fillInStackTrace();
/*  60 */         throw localSQLException;
/*     */       }
/*     */     }
/*     */ 
/*  64 */     return localBINARY_DOUBLE;
/*     */   }
/*     */ 
/*     */   public Datum[] toDatumArray(Object paramObject, OracleConnection paramOracleConnection, long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  80 */     Datum[] arrayOfDatum = null;
/*     */ 
/*  82 */     if (paramObject != null)
/*     */     {
/*  84 */       if ((paramObject instanceof Object[]))
/*     */       {
/*  86 */         Object[] arrayOfObject = (Object[])paramObject;
/*     */ 
/*  88 */         int i = (int)(paramInt == -1 ? arrayOfObject.length : Math.min(arrayOfObject.length - paramLong + 1L, paramInt));
/*     */ 
/*  91 */         arrayOfDatum = new Datum[i];
/*     */ 
/*  93 */         for (int j = 0; j < i; j++)
/*     */         {
/*  95 */           Object localObject = arrayOfObject[((int)paramLong + j - 1)];
/*     */ 
/*  97 */           if (localObject != null)
/*     */           {
/*  99 */             if ((localObject instanceof Double)) {
/* 100 */               arrayOfDatum[j] = new BINARY_DOUBLE(((Double)localObject).doubleValue());
/*     */             }
/* 102 */             else if ((localObject instanceof BINARY_DOUBLE)) {
/* 103 */               arrayOfDatum[j] = ((BINARY_DOUBLE)localObject);
/*     */             }
/*     */             else {
/* 106 */               SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 107 */               localSQLException.fillInStackTrace();
/* 108 */               throw localSQLException;
/*     */             }
/*     */ 
/*     */           }
/*     */           else
/*     */           {
/* 114 */             arrayOfDatum[j] = null;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 120 */     return arrayOfDatum;
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */   {
/* 130 */     return 101;
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 155 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 156 */       return null;
/*     */     }
/* 158 */     if (paramInt == 1)
/* 159 */       return new BINARY_DOUBLE(paramArrayOfByte);
/* 160 */     if (paramInt == 2)
/* 161 */       return new BINARY_DOUBLE(paramArrayOfByte).toJdbc();
/* 162 */     if (paramInt == 3) {
/* 163 */       return paramArrayOfByte;
/*     */     }
/*     */ 
/* 166 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramArrayOfByte);
/* 167 */     localSQLException.fillInStackTrace();
/* 168 */     throw localSQLException;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeBINARY_DOUBLE
 * JD-Core Version:    0.6.2
 */