/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.BFILE;
/*     */ import oracle.sql.Datum;
/*     */ 
/*     */ public class OracleTypeBFILE extends OracleType
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = -707073491109554687L;
/*  28 */   static int fixedDataSize = 530;
/*     */   transient OracleConnection connection;
/* 192 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleTypeBFILE()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleTypeBFILE(OracleConnection paramOracleConnection)
/*     */   {
/*  42 */     this.connection = paramOracleConnection;
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  56 */     BFILE localBFILE = null;
/*     */ 
/*  58 */     if (paramObject != null)
/*     */     {
/*  60 */       if ((paramObject instanceof BFILE)) {
/*  61 */         localBFILE = (BFILE)paramObject;
/*     */       }
/*     */       else {
/*  64 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/*  65 */         localSQLException.fillInStackTrace();
/*  66 */         throw localSQLException;
/*     */       }
/*     */     }
/*     */ 
/*  70 */     return localBFILE;
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */   {
/*  80 */     return -13;
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 104 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 105 */       return null;
/*     */     }
/* 107 */     if ((paramInt == 1) || (paramInt == 2)) {
/* 108 */       return this.connection.createBfile(paramArrayOfByte);
/*     */     }
/*     */ 
/* 111 */     if (paramInt == 3) {
/* 112 */       return paramArrayOfByte;
/*     */     }
/*     */ 
/* 115 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramArrayOfByte);
/* 116 */     localSQLException.fillInStackTrace();
/* 117 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setConnection(OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 142 */     this.connection = paramOracleConnection;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 157 */     return this.connection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeBFILE
 * JD-Core Version:    0.6.2
 */