/*      */ package oracle.jdbc.oracore;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.io.ObjectOutputStream;
/*      */ import java.io.PrintWriter;
/*      */ import java.io.Serializable;
/*      */ import java.io.StringWriter;
/*      */ import java.sql.Blob;
/*      */ import java.sql.CallableStatement;
/*      */ import java.sql.Connection;
/*      */ import java.sql.PreparedStatement;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.SQLData;
/*      */ import java.sql.SQLException;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Map;
/*      */ import java.util.Vector;
/*      */ import oracle.jdbc.OracleCallableStatement;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.ObjectData;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.sql.AttributeDescriptor;
/*      */ import oracle.sql.BLOB;
/*      */ import oracle.sql.Datum;
/*      */ import oracle.sql.JAVA_STRUCT;
/*      */ import oracle.sql.NUMBER;
/*      */ import oracle.sql.SQLName;
/*      */ import oracle.sql.STRUCT;
/*      */ import oracle.sql.StructDescriptor;
/*      */ import oracle.sql.TypeDescriptor;
/*      */ 
/*      */ public class OracleTypeADT extends OracleNamedType
/*      */   implements Serializable
/*      */ {
/*      */   static final long serialVersionUID = 3031304012507165702L;
/*      */   static final int S_TOP = 1;
/*      */   static final int S_EMBEDDED = 2;
/*      */   static final int S_UPT_ADT = 4;
/*      */   static final int S_JAVA_OBJECT = 16;
/*      */   static final int S_FINAL_TYPE = 32;
/*      */   static final int S_SUB_TYPE = 64;
/*      */   static final int S_ATTR_TDS = 128;
/*      */   static final int S_HAS_METADATA = 256;
/*      */   static final int S_TDS_PARSED = 512;
/*   60 */   private int statusBits = 1;
/*      */ 
/*   67 */   int tdsVersion = -9999;
/*      */   static final int KOPT_V80 = 1;
/*      */   static final int KOPT_V81 = 2;
/*      */   static final int KOPT_VNFT = 3;
/*      */   static final int KOPT_VERSION = 3;
/*   77 */   boolean endOfAdt = false;
/*      */ 
/*   79 */   int typeVersion = 1;
/*      */ 
/*   82 */   long fixedDataSize = -1L;
/*   83 */   int alignmentRequirement = -1;
/*      */ 
/*   86 */   OracleType[] attrTypes = null;
/*      */   String[] attrNames;
/*      */   String[] attrTypeNames;
/*   90 */   public long tdoCState = 0L;
/*      */ 
/*   92 */   byte[] toid = null;
/*      */   int charSetId;
/*      */   int charSetForm;
/*      */   int flattenedAttrNum;
/*      */   transient int opcode;
/*  101 */   transient int idx = 1;
/*      */ 
/*  108 */   boolean isTransient = false;
/*      */   static final int CURRENT_USER_OBJECT = 0;
/*      */   static final int CURRENT_USER_SYNONYM = 1;
/*      */   static final int CURRENT_USER_SYNONYM_10g = 2;
/*      */   static final int CURRENT_USER_PUBLIC_SYNONYM = 3;
/*      */   static final int CURRENT_USER_PUBLIC_SYNONYM_10g = 4;
/*      */   static final int POSSIBLY_OTHER_USER_OBJECT = 5;
/*      */   static final int POSSIBLY_OTHER_USER_OBJECT_10g = 6;
/*      */   static final int OTHER_USER_OBJECT = 7;
/*      */   static final int OTHER_USER_SYNONYM = 8;
/*      */   static final int PUBLIC_SYNONYM = 9;
/*      */   static final int PUBLIC_SYNONYM_10g = 10;
/*      */   static final int BREAK = 11;
/* 2275 */   static final String[] sqlString = { "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME = :1 ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME in (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :1 CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :1 FROM DUAL) ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME in (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :1 CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :1 FROM DUAL) ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ORDER BY ATTR_NO", "DECLARE CURSOR usyn_cur IS SELECT table_name, table_owner from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; l_syntown  user_synonyms.table_owner%TYPE; BEGIN SELECT TABLE_NAME, TABLE_OWNER BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name;   l_syntown :=  table_names(lastrow).table_owner; END IF; OPEN ? FOR SELECT  ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER   FROM ALL_TYPE_ATTRS  A   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?)  AND  A.OWNER = l_syntown   ORDER BY ATTR_NO; END;", "DECLARE CURSOR usyn_cur IS SELECT table_name, table_owner from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; l_syntown  user_synonyms.table_owner%TYPE; BEGIN SELECT TABLE_NAME, TABLE_OWNER BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY NOCYCLEPRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name;   l_syntown :=  table_names(lastrow).table_owner; END IF; OPEN ? FOR SELECT  ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER   FROM ALL_TYPE_ATTRS  A   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?)  AND  A.OWNER = l_syntown   ORDER BY ATTR_NO; END;", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS WHERE OWNER = :1 AND TYPE_NAME = :2 ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS WHERE OWNER = (SELECT TABLE_OWNER FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:1) AND TYPE_NAME = (SELECT TABLE_NAME FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:2) ORDER BY ATTR_NO", "DECLARE   the_owner VARCHAR2(100);   the_type  VARCHAR2(100); begin  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME,  ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;", "DECLARE   the_owner VARCHAR2(100);   the_type  VARCHAR2(100); begin  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME,  ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;" };
/*      */   static final int SEARCH_USER_TYPES = 0;
/*      */   static final int SEARCH_ALL_TYPES = 1;
/* 2616 */   static final String[] sqlStringTOID = { "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS a, USER_TYPES b WHERE b.TYPE_OID = :1 AND a.TYPE_NAME = b.TYPE_NAME ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS a, ALL_TYPES b WHERE b.TYPE_OID = :1 AND a.TYPE_NAME = b.TYPE_NAME AND a.OWNER = b.OWNER ORDER BY ATTR_NO" };
/*      */   Boolean isInstanciable;
/*      */   String superTypeName;
/* 3356 */   int numberOfLocalAttributes = -1;
/*      */   String[] subTypeNames;
/* 3394 */   final int LOCAL_TYPE = 0;
/* 3395 */   final int LOOK_FOR_USER_SYNONYM = 1;
/* 3396 */   final int LOOK_FOR_PUBLIC_SYNONYM = 2;
/* 3397 */   final String[] initMetaData1_9_0_SQL = { "SELECT INSTANTIABLE, supertype_owner, supertype_name, LOCAL_ATTRIBUTES FROM all_types WHERE type_name = :1 AND owner = :2 ", "DECLARE \n bind_synonym_name user_synonyms.synonym_name%type := :1; \n the_table_owner  user_synonyms.table_owner%type; \n the_table_name   user_synonyms.table_name%type; \n the_db_link      user_synonyms.db_link%type; \n sql_string       VARCHAR2(1000); \nBEGIN \n   SELECT TABLE_NAME, TABLE_OWNER, DB_LINK INTO  \n         the_table_name, the_table_owner, the_db_link \n         FROM USER_SYNONYMS WHERE \n         SYNONYM_NAME = bind_synonym_name; \n \n   sql_string := 'SELECT INSTANTIABLE, SUPERTYPE_OWNER,      SUPERTYPE_NAME, LOCAL_ATTRIBUTES FROM ALL_TYPES'; \n \n   IF the_db_link IS NOT NULL  \n   THEN \n     sql_string := sql_string || '@' || the_db_link; \n   END IF; \n   sql_string := sql_string       || ' WHERE TYPE_NAME = '''       || the_table_name   || ''' AND OWNER = '''       || the_table_owner  || ''''; \n   OPEN :2 FOR sql_string; \nEND;", "DECLARE \n bind_synonym_name user_synonyms.synonym_name%type := :1; \n the_table_owner  user_synonyms.table_owner%type; \n the_table_name   user_synonyms.table_name%type; \n the_db_link      user_synonyms.db_link%type; \n sql_string       VARCHAR2(1000); \nBEGIN \n   SELECT TABLE_NAME, TABLE_OWNER, DB_LINK INTO  \n         the_table_name, the_table_owner, the_db_link \n         FROM ALL_SYNONYMS WHERE \n         OWNER = 'PUBLIC' AND \n         SYNONYM_NAME = bind_synonym_name; \n \n   sql_string := 'SELECT INSTANTIABLE, SUPERTYPE_OWNER,      SUPERTYPE_NAME, LOCAL_ATTRIBUTES FROM ALL_TYPES'; \n \n   IF the_db_link IS NOT NULL  \n   THEN \n     sql_string := sql_string || '@' || the_db_link; \n   END IF; \n   sql_string := sql_string       || ' WHERE TYPE_NAME = '''       || the_table_name   || ''' AND OWNER = '''       || the_table_owner  || ''''; \n   OPEN :2 FOR sql_string; \nEND;" };
/*      */   static final int TDS_SIZE = 4;
/*      */   static final int TDS_NUMBER = 1;
/*      */   static final int KOPM_OTS_SQL_CHAR = 1;
/*      */   static final int KOPM_OTS_DATE = 2;
/*      */   static final int KOPM_OTS_DECIMAL = 3;
/*      */   static final int KOPM_OTS_DOUBLE = 4;
/*      */   static final int KOPM_OTS_FLOAT = 5;
/*      */   static final int KOPM_OTS_NUMBER = 6;
/*      */   static final int KOPM_OTS_SQL_VARCHAR2 = 7;
/*      */   static final int KOPM_OTS_SINT32 = 8;
/*      */   static final int KOPM_OTS_REF = 9;
/*      */   static final int KOPM_OTS_VARRAY = 10;
/*      */   static final int KOPM_OTS_UINT8 = 11;
/*      */   static final int KOPM_OTS_SINT8 = 12;
/*      */   static final int KOPM_OTS_UINT16 = 13;
/*      */   static final int KOPM_OTS_UINT32 = 14;
/*      */   static final int KOPM_OTS_LOB = 15;
/*      */   static final int KOPM_OTS_CANONICAL = 17;
/*      */   static final int KOPM_OTS_OCTET = 18;
/*      */   static final int KOPM_OTS_RAW = 19;
/*      */   static final int KOPM_OTS_ROWID = 20;
/*      */   static final int KOPM_OTS_STAMP = 21;
/*      */   static final int KOPM_OTS_TZSTAMP = 23;
/*      */   static final int KOPM_OTS_INTERVAL = 24;
/*      */   static final int KOPM_OTS_PTR = 25;
/*      */   static final int KOPM_OTS_SINT16 = 26;
/*      */   static final int KOPM_OTS_UPT = 27;
/*      */   static final int KOPM_OTS_COLLECTION = 28;
/*      */   static final int KOPM_OTS_CLOB = 29;
/*      */   static final int KOPM_OTS_BLOB = 30;
/*      */   static final int KOPM_OTS_BFILE = 31;
/*      */   static final int KOPM_OTS_BINARY_INTEGE = 32;
/*      */   static final int KOPM_OTS_IMPTZSTAMP = 33;
/*      */   static final int KOPM_OTS_BFLOAT = 37;
/*      */   static final int KOPM_OTS_BDOUBLE = 45;
/*      */   static final int KOTTCOPQ = 58;
/*      */   static final int KOPT_OP_STARTEMBADT = 39;
/*      */   static final int KOPT_OP_ENDEMBADT = 40;
/*      */   static final int KOPT_OP_STARTADT = 41;
/*      */   static final int KOPT_OP_ENDADT = 42;
/*      */   static final int KOPT_OP_SUBTYPE_MARKER = 43;
/*      */   static final int KOPT_OP_EMBADT_INFO = 44;
/*      */   static final int KOPT_OPCODE_START = 38;
/*      */   static final int KOPT_OP_VERSION = 38;
/*      */   static final int REGULAR_PATCH = 0;
/*      */   static final int SIMPLE_PATCH = 1;
/* 3894 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   protected OracleTypeADT()
/*      */   {
/*      */   }
/*      */ 
/*      */   public OracleTypeADT(byte[] paramArrayOfByte, int paramInt1, int paramInt2, short paramShort, String paramString)
/*      */     throws SQLException
/*      */   {
/*  128 */     this(paramString, (OracleConnection)null);
/*      */ 
/*  130 */     this.toid = paramArrayOfByte;
/*  131 */     this.typeVersion = paramInt1;
/*  132 */     this.charSetId = paramInt2;
/*  133 */     this.charSetForm = paramShort;
/*      */   }
/*      */ 
/*      */   public OracleTypeADT(String paramString, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  142 */     super(paramString, (OracleConnection)paramConnection);
/*  143 */     this.typeNameByUser = paramString;
/*      */   }
/*      */ 
/*      */   public OracleTypeADT(OracleTypeADT paramOracleTypeADT, int paramInt, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  155 */     super(paramOracleTypeADT, paramInt, (OracleConnection)paramConnection);
/*      */   }
/*      */ 
/*      */   public OracleTypeADT(SQLName paramSQLName, byte[] paramArrayOfByte1, int paramInt, byte[] paramArrayOfByte2, OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*  169 */     this.sqlName = paramSQLName;
/*  170 */     init(paramArrayOfByte2, paramOracleConnection);
/*  171 */     this.toid = paramArrayOfByte1;
/*  172 */     this.typeVersion = paramInt;
/*      */   }
/*      */ 
/*      */   public OracleTypeADT(AttributeDescriptor[] paramArrayOfAttributeDescriptor, OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*  192 */     setConnectionInternal(paramOracleConnection);
/*  193 */     this.isTransient = true;
/*  194 */     this.flattenedAttrNum = paramArrayOfAttributeDescriptor.length;
/*  195 */     this.attrTypes = new OracleType[this.flattenedAttrNum];
/*  196 */     this.attrNames = new String[this.flattenedAttrNum];
/*  197 */     for (int i = 0; i < this.flattenedAttrNum; i++)
/*  198 */       this.attrNames[i] = paramArrayOfAttributeDescriptor[i].getAttributeName();
/*  199 */     this.statusBits |= 256;
/*      */ 
/*  205 */     for (i = 0; i < this.flattenedAttrNum; i++)
/*      */     {
/*  207 */       TypeDescriptor localTypeDescriptor = paramArrayOfAttributeDescriptor[i].getTypeDescriptor();
/*  208 */       switch (localTypeDescriptor.getInternalTypeCode())
/*      */       {
/*      */       case 12:
/*  211 */         this.attrTypes[i] = new OracleTypeDATE();
/*  212 */         break;
/*      */       case 9:
/*  214 */         this.attrTypes[i] = new OracleTypeCHAR(this.connection, 12);
/*  215 */         ((OracleTypeCHAR)this.attrTypes[i]).length = ((int)localTypeDescriptor.getPrecision());
/*  216 */         ((OracleTypeCHAR)this.attrTypes[i]).form = 1;
/*  217 */         break;
/*      */       case 96:
/*  219 */         this.attrTypes[i] = new OracleTypeCHAR(this.connection, 1);
/*  220 */         ((OracleTypeCHAR)this.attrTypes[i]).length = ((int)localTypeDescriptor.getPrecision());
/*  221 */         ((OracleTypeCHAR)this.attrTypes[i]).form = 1;
/*  222 */         break;
/*      */       case 108:
/*  224 */         this.attrTypes[i] = ((OracleTypeADT)localTypeDescriptor.getPickler());
/*  225 */         ((OracleTypeADT)this.attrTypes[i]).setEmbeddedADT();
/*  226 */         break;
/*      */       case 2:
/*  228 */         this.attrTypes[i] = new OracleTypeNUMBER(2);
/*  229 */         ((OracleTypeNUMBER)this.attrTypes[i]).precision = ((int)localTypeDescriptor.getPrecision());
/*  230 */         ((OracleTypeNUMBER)this.attrTypes[i]).scale = localTypeDescriptor.getScale();
/*  231 */         break;
/*      */       case 7:
/*  233 */         this.attrTypes[i] = new OracleTypeNUMBER(3);
/*  234 */         ((OracleTypeNUMBER)this.attrTypes[i]).precision = ((int)localTypeDescriptor.getPrecision());
/*  235 */         ((OracleTypeNUMBER)this.attrTypes[i]).scale = localTypeDescriptor.getScale();
/*  236 */         break;
/*      */       case 22:
/*  238 */         this.attrTypes[i] = new OracleTypeNUMBER(8);
/*  239 */         ((OracleTypeNUMBER)this.attrTypes[i]).precision = ((int)localTypeDescriptor.getPrecision());
/*  240 */         ((OracleTypeNUMBER)this.attrTypes[i]).scale = localTypeDescriptor.getScale();
/*  241 */         break;
/*      */       case 4:
/*  243 */         this.attrTypes[i] = new OracleTypeFLOAT();
/*  244 */         ((OracleTypeFLOAT)this.attrTypes[i]).precision = ((int)localTypeDescriptor.getPrecision());
/*  245 */         break;
/*      */       case 100:
/*  247 */         this.attrTypes[i] = new OracleTypeBINARY_FLOAT();
/*  248 */         break;
/*      */       case 101:
/*  250 */         this.attrTypes[i] = new OracleTypeBINARY_DOUBLE();
/*  251 */         break;
/*      */       case 29:
/*  253 */         this.attrTypes[i] = new OracleTypeSINT32(false);
/*  254 */         break;
/*      */       case 110:
/*  256 */         this.attrTypes[i] = new OracleTypeREF(this, i, this.connection);
/*  257 */         break;
/*      */       case 114:
/*  259 */         this.attrTypes[i] = new OracleTypeBFILE(this.connection);
/*  260 */         break;
/*      */       case 95:
/*  262 */         this.attrTypes[i] = new OracleTypeRAW();
/*  263 */         break;
/*      */       case 112:
/*  265 */         this.attrTypes[i] = new OracleTypeCLOB(this.connection);
/*  266 */         break;
/*      */       case 113:
/*  268 */         this.attrTypes[i] = new OracleTypeBLOB(this.connection);
/*  269 */         break;
/*      */       case 187:
/*  271 */         this.attrTypes[i] = new OracleTypeTIMESTAMP(this.connection);
/*  272 */         ((OracleTypeTIMESTAMP)this.attrTypes[i]).precision = ((int)localTypeDescriptor.getPrecision());
/*  273 */         break;
/*      */       case 188:
/*  275 */         this.attrTypes[i] = new OracleTypeTIMESTAMPTZ(this.connection);
/*  276 */         ((OracleTypeTIMESTAMPTZ)this.attrTypes[i]).precision = ((int)localTypeDescriptor.getPrecision());
/*  277 */         break;
/*      */       case 232:
/*  279 */         this.attrTypes[i] = new OracleTypeTIMESTAMPLTZ(this.connection);
/*  280 */         ((OracleTypeTIMESTAMPLTZ)this.attrTypes[i]).precision = ((int)localTypeDescriptor.getPrecision());
/*  281 */         break;
/*      */       case 189:
/*  283 */         this.attrTypes[i] = new OracleTypeINTERVAL(this.connection);
/*  284 */         ((OracleTypeINTERVAL)this.attrTypes[i]).typeId = 7;
/*  285 */         ((OracleTypeINTERVAL)this.attrTypes[i]).precision = ((int)localTypeDescriptor.getPrecision());
/*  286 */         ((OracleTypeINTERVAL)this.attrTypes[i]).scale = localTypeDescriptor.getScale();
/*  287 */         break;
/*      */       case 190:
/*  289 */         this.attrTypes[i] = new OracleTypeINTERVAL(this.connection);
/*  290 */         ((OracleTypeINTERVAL)this.attrTypes[i]).typeId = 10;
/*  291 */         ((OracleTypeINTERVAL)this.attrTypes[i]).precision = ((int)localTypeDescriptor.getPrecision());
/*  292 */         ((OracleTypeINTERVAL)this.attrTypes[i]).scale = localTypeDescriptor.getScale();
/*  293 */         break;
/*      */       case 122:
/*  295 */         this.attrTypes[i] = new OracleTypeCOLLECTION(this, i, this.connection);
/*  296 */         break;
/*      */       default:
/*  299 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 48, "type: " + localTypeDescriptor.getInternalTypeCode());
/*  300 */         localSQLException.fillInStackTrace();
/*  301 */         throw localSQLException;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*  319 */     if (paramObject != null)
/*      */     {
/*  321 */       if ((paramObject instanceof STRUCT))
/*      */       {
/*  323 */         return (STRUCT)paramObject;
/*      */       }
/*  325 */       if (((paramObject instanceof SQLData)) || ((paramObject instanceof ObjectData)))
/*      */       {
/*  328 */         return STRUCT.toSTRUCT(paramObject, paramOracleConnection);
/*      */       }
/*  330 */       if ((paramObject instanceof Object[]))
/*      */       {
/*  332 */         localObject = createStructDescriptor();
/*  333 */         STRUCT localSTRUCT = createObjSTRUCT((StructDescriptor)localObject, (Object[])paramObject);
/*  334 */         return localSTRUCT;
/*      */       }
/*      */ 
/*  338 */       Object localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/*  339 */       ((SQLException)localObject).fillInStackTrace();
/*  340 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/*  344 */     return null;
/*      */   }
/*      */ 
/*      */   public Datum[] toDatumArray(Object paramObject, OracleConnection paramOracleConnection, long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  358 */     Datum[] arrayOfDatum = null;
/*      */ 
/*  360 */     if (paramObject != null)
/*      */     {
/*      */       Object localObject;
/*  362 */       if ((paramObject instanceof Object[]))
/*      */       {
/*  364 */         localObject = (Object[])paramObject;
/*      */ 
/*  366 */         int i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*      */ 
/*  369 */         arrayOfDatum = new Datum[i];
/*      */ 
/*  371 */         for (int j = 0; j < i; j++)
/*  372 */           arrayOfDatum[j] = toDatum(localObject[((int)paramLong + j - 1)], paramOracleConnection);
/*      */       }
/*      */       else
/*      */       {
/*  376 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/*  377 */         ((SQLException)localObject).fillInStackTrace();
/*  378 */         throw ((Throwable)localObject);
/*      */       }
/*      */     }
/*      */ 
/*  382 */     return arrayOfDatum;
/*      */   }
/*      */ 
/*      */   public int getTypeCode()
/*      */     throws SQLException
/*      */   {
/*  392 */     if ((getStatus() & 0x10) != 0) {
/*  393 */       return 2008;
/*      */     }
/*  395 */     return 2002;
/*      */   }
/*      */ 
/*      */   public OracleType[] getAttrTypes()
/*      */     throws SQLException
/*      */   {
/*  402 */     if (this.attrTypes == null) {
/*  403 */       init(this.connection);
/*      */     }
/*  405 */     return this.attrTypes;
/*      */   }
/*      */ 
/*      */   public boolean isInHierarchyOf(OracleType paramOracleType)
/*      */     throws SQLException
/*      */   {
/*  416 */     if (paramOracleType == null) {
/*  417 */       return false;
/*      */     }
/*  419 */     if (!paramOracleType.isObjectType()) {
/*  420 */       return false;
/*      */     }
/*  422 */     StructDescriptor localStructDescriptor = (StructDescriptor)paramOracleType.getTypeDescriptor();
/*      */ 
/*  425 */     return this.descriptor.isInHierarchyOf(localStructDescriptor.getName());
/*      */   }
/*      */ 
/*      */   public boolean isInHierarchyOf(StructDescriptor paramStructDescriptor)
/*      */     throws SQLException
/*      */   {
/*  434 */     if (paramStructDescriptor == null) {
/*  435 */       return false;
/*      */     }
/*  437 */     return this.descriptor.isInHierarchyOf(paramStructDescriptor.getName());
/*      */   }
/*      */ 
/*      */   public boolean isObjectType()
/*      */   {
/*  444 */     return true;
/*      */   }
/*      */ 
/*      */   public TypeDescriptor getTypeDescriptor()
/*      */   {
/*  451 */     return this.descriptor;
/*      */   }
/*      */ 
/*      */   public void init(OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*  467 */     synchronized (paramOracleConnection)
/*      */     {
/*  469 */       byte[] arrayOfByte = initMetadata(paramOracleConnection);
/*  470 */       init(arrayOfByte, paramOracleConnection);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void init(byte[] paramArrayOfByte, OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*  484 */     synchronized (paramOracleConnection)
/*      */     {
/*  486 */       this.statusBits = 1;
/*  487 */       this.connection = paramOracleConnection;
/*      */ 
/*  489 */       if (paramArrayOfByte != null) parseTDS(paramArrayOfByte, 0L);
/*  490 */       setStatusBits(256);
/*      */     }
/*      */   }
/*      */ 
/*      */   public byte[] initMetadata(OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*  504 */     int i = paramOracleConnection.getVersionNumber();
/*  505 */     byte[] arrayOfByte = null;
/*  506 */     if (i >= 12000)
/*  507 */       arrayOfByte = initMetadata12(paramOracleConnection);
/*      */     else
/*  509 */       arrayOfByte = initMetadata11_2(paramOracleConnection);
/*  510 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   private byte[] initMetadata12(OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*  516 */     synchronized (this.connection)
/*      */     {
/*  518 */       byte[] arrayOfByte = null;
/*  519 */       if ((this.statusBits & 0x100) != 0) {
/*  520 */         return null;
/*      */       }
/*      */ 
/*  523 */       if ((this.statusBits & 0x100) == 0) {
/*  524 */         CallableStatement localCallableStatement = null;
/*      */ 
/*  526 */         this.connection.beginNonRequestCalls();
/*      */         try
/*      */         {
/*  546 */           String str1 = "begin :1 := dbms_pickler.get_type_shape(:2,:3,:4,:5,:6,:7,:8,:9,:10); end;";
/*      */ 
/*  550 */           String str2 = this.typeNameByUser == null ? getFullName() : this.typeNameByUser;
/*  551 */           localCallableStatement = this.connection.prepareCall(str1);
/*      */ 
/*  553 */           localCallableStatement.registerOutParameter(1, 2);
/*  554 */           localCallableStatement.setString(2, str2);
/*      */ 
/*  557 */           localCallableStatement.registerOutParameter(2, 12, 256);
/*  558 */           localCallableStatement.registerOutParameter(3, -3, 16);
/*  559 */           localCallableStatement.registerOutParameter(4, 4);
/*  560 */           localCallableStatement.registerOutParameter(5, -4);
/*  561 */           localCallableStatement.registerOutParameter(6, 12, 5);
/*  562 */           localCallableStatement.registerOutParameter(7, 12, 256);
/*  563 */           localCallableStatement.registerOutParameter(8, 12, 256);
/*  564 */           localCallableStatement.registerOutParameter(9, -10);
/*  565 */           localCallableStatement.registerOutParameter(10, -10);
/*      */ 
/*  569 */           localCallableStatement.execute();
/*      */ 
/*  571 */           int i = 0;
/*      */ 
/*  573 */           int j = localCallableStatement.getInt(1);
/*  574 */           if (j != 0)
/*      */           {
/*  577 */             if (j != 24331)
/*      */             {
/*  579 */               localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 74, this.typeNameByUser);
/*  580 */               ((SQLException)localObject1).fillInStackTrace();
/*  581 */               throw ((Throwable)localObject1);
/*      */             }
/*      */ 
/*  584 */             if (j == 24331) {
/*  585 */               i = 1;
/*  586 */               localCallableStatement.registerOutParameter(5, 2004);
/*      */ 
/*  590 */               localCallableStatement.execute();
/*      */ 
/*  593 */               j = localCallableStatement.getInt(1);
/*  594 */               if (j != 0)
/*      */               {
/*  596 */                 localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 74, this.typeNameByUser);
/*  597 */                 ((SQLException)localObject1).fillInStackTrace();
/*  598 */                 throw ((Throwable)localObject1);
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*  605 */           this.toid = localCallableStatement.getBytes(3);
/*  606 */           this.typeVersion = NUMBER.toInt(localCallableStatement.getBytes(4));
/*  607 */           if (i == 0) {
/*  608 */             arrayOfByte = localCallableStatement.getBytes(5);
/*      */           }
/*      */           else {
/*      */             try
/*      */             {
/*  613 */               Blob localBlob = ((OracleCallableStatement)localCallableStatement).getBlob(5);
/*  614 */               localObject1 = localBlob.getBinaryStream();
/*  615 */               arrayOfByte = new byte[(int)localBlob.length()];
/*  616 */               ((InputStream)localObject1).read(arrayOfByte);
/*  617 */               ((InputStream)localObject1).close();
/*  618 */               ((BLOB)localBlob).freeTemporary();
/*      */             }
/*      */             catch (IOException localIOException)
/*      */             {
/*  622 */               localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  623 */               ((SQLException)localObject2).fillInStackTrace();
/*  624 */               throw ((Throwable)localObject2);
/*      */             }
/*      */           }
/*      */ 
/*  628 */           this.metaDataInitialized = true;
/*  629 */           this.isInstanciable = Boolean.valueOf("YES".equalsIgnoreCase(localCallableStatement.getString(6)));
/*      */ 
/*  631 */           Object localObject1 = localCallableStatement.getString(8);
/*  632 */           if (localObject1 != null) {
/*  633 */             localObject1 = localCallableStatement.getString(7) + (String)localObject1;
/*      */           }
/*      */ 
/*  636 */           ResultSet localResultSet = null;
/*  637 */           Object localObject2 = null;
/*      */           try {
/*  639 */             localResultSet = (ResultSet)localCallableStatement.getObject(9);
/*      */             Object localObject3;
/*  640 */             if ((localResultSet != null) && (localResultSet.next())) {
/*  641 */               if (localResultSet.getInt(1) == 1)
/*      */               {
/*  642 */                 localObject3 = new ArrayList(5);
/*  643 */                 ArrayList localArrayList = new ArrayList(5);
/*      */                 Object localObject5;
/*      */                 do
/*      */                 {
/*  660 */                   ((ArrayList)localObject3).add(localResultSet.getString(2));
/*  661 */                   localObject4 = localResultSet.getString(5);
/*  662 */                   String str3 = localResultSet.getString(6);
/*  663 */                   localObject5 = "";
/*  664 */                   if (localObject4 != null) localObject5 = (String)localObject5 + (String)localObject4 + '.';
/*  665 */                   if (str3 != null) localObject5 = (String)localObject5 + str3 + '.';
/*  666 */                   localObject5 = (String)localObject5 + localResultSet.getString(4);
/*  667 */                   localArrayList.add(localObject5);
/*      */                 }
/*      */ 
/*  670 */                 while (localResultSet.next());
/*      */ 
/*  672 */                 Object localObject4 = ((ArrayList)localObject3).toArray();
/*  673 */                 this.attrNames = new String[((ArrayList)localObject3).size()];
/*  674 */                 int m = 0;
/*      */                 Object localObject6;
/*  675 */                 for (localObject6 : localObject4) {
/*  676 */                   this.attrNames[(m++)] = ((String)localObject6);
/*      */                 }
/*      */ 
/*  679 */                 localObject4 = localArrayList.toArray();
/*  680 */                 this.attrTypeNames = new String[localArrayList.size()];
/*  681 */                 m = 0;
/*  682 */                 for (localObject6 : localObject4) {
/*  683 */                   this.attrTypeNames[(m++)] = ((String)localObject6);
/*      */                 }
/*      */               }
/*      */               else
/*      */               {
/*  688 */                 localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Unknown image format");
/*  689 */                 ((SQLException)localObject3).fillInStackTrace();
/*  690 */                 throw ((Throwable)localObject3);
/*      */               }
/*      */             }
/*  693 */             localResultSet.close();
/*  694 */             localResultSet = null;
/*      */ 
/*  704 */             localObject2 = (ResultSet)localCallableStatement.getObject(10);
/*  705 */             if ((localObject2 != null) && (((ResultSet)localObject2).next()))
/*  706 */               if (((ResultSet)localObject2).getInt(1) == 1) {
/*  707 */                 localObject3 = new ArrayList(5);
/*      */                 do {
/*  709 */                   ((ArrayList)localObject3).add(((ResultSet)localObject2).getString(2) + "." + ((ResultSet)localObject2).getString(3));
/*      */                 }
/*      */ 
/*  712 */                 while (((ResultSet)localObject2).next());
/*      */ 
/*  714 */                 this.subTypeNames = new String[((ArrayList)localObject3).size()];
/*  715 */                 for (int k = 0; k < this.subTypeNames.length; k++) {
/*  716 */                   this.subTypeNames[k] = ((String)((ArrayList)localObject3).get(k));
/*      */                 }
/*      */               }
/*      */               else
/*      */               {
/*  721 */                 localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Unknown image format");
/*  722 */                 ((SQLException)localObject3).fillInStackTrace();
/*  723 */                 throw ((Throwable)localObject3);
/*      */               }
/*      */           }
/*      */           finally
/*      */           {
/*  728 */             if (localResultSet != null) localResultSet.close();
/*  729 */             if (localObject2 != null) ((ResultSet)localObject2).close();
/*      */ 
/*      */           }
/*      */ 
/*  736 */           this.flattenedAttrNum = (Util.getUnsignedByte(arrayOfByte[8]) * 256 + Util.getUnsignedByte(arrayOfByte[9]));
/*      */         }
/*      */         finally
/*      */         {
/*  740 */           if (localCallableStatement != null) localCallableStatement.close();
/*      */ 
/*  745 */           this.connection.endNonRequestCalls();
/*      */         }
/*      */       }
/*  748 */       setStatusBits(256);
/*  749 */       return arrayOfByte;
/*      */     }
/*      */   }
/*      */ 
/*      */   private byte[] initMetadata11_2(OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*  762 */     synchronized (this.connection)
/*      */     {
/*  764 */       byte[] arrayOfByte = null;
/*  765 */       if ((this.statusBits & 0x100) != 0) {
/*  766 */         return null;
/*      */       }
/*      */ 
/*  769 */       if (this.sqlName == null) getFullName();
/*      */ 
/*  772 */       if ((this.statusBits & 0x100) == 0) {
/*  773 */         CallableStatement localCallableStatement = null;
/*  774 */         this.connection.beginNonRequestCalls();
/*      */         try {
/*  776 */           if (this.tdoCState == 0L) this.tdoCState = this.connection.getTdoCState(this.sqlName.getSchema(), this.sqlName.getSimpleName());
/*      */ 
/*  780 */           String str = "begin :1 := dbms_pickler.get_type_shape(:2,:3,:4,:5,:6,:7); end;";
/*      */ 
/*  784 */           int i = 0;
/*  785 */           localCallableStatement = this.connection.prepareCall(str);
/*      */ 
/*  787 */           localCallableStatement.registerOutParameter(1, 2);
/*  788 */           localCallableStatement.registerOutParameter(4, -3, 16);
/*  789 */           localCallableStatement.registerOutParameter(5, 4);
/*  790 */           localCallableStatement.registerOutParameter(6, -4);
/*  791 */           localCallableStatement.registerOutParameter(7, -4);
/*  792 */           localCallableStatement.setString(2, this.sqlName.getSchema());
/*  793 */           localCallableStatement.setString(3, this.sqlName.getSimpleName());
/*      */ 
/*  797 */           localCallableStatement.execute();
/*      */ 
/*  800 */           int j = localCallableStatement.getInt(1);
/*      */           Object localObject1;
/*  801 */           if (j != 0)
/*      */           {
/*  803 */             if (j != 24331)
/*      */             {
/*  805 */               localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 74, this.sqlName.toString());
/*  806 */               ((SQLException)localObject1).fillInStackTrace();
/*  807 */               throw ((Throwable)localObject1);
/*      */             }
/*  809 */             if (j == 24331) {
/*  810 */               i = 1;
/*  811 */               localCallableStatement.registerOutParameter(6, 2004);
/*      */ 
/*  814 */               localCallableStatement.execute();
/*      */ 
/*  817 */               j = localCallableStatement.getInt(1);
/*  818 */               if (j != 0)
/*      */               {
/*  820 */                 localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 74, this.sqlName.toString());
/*  821 */                 ((SQLException)localObject1).fillInStackTrace();
/*  822 */                 throw ((Throwable)localObject1);
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*  829 */           this.toid = localCallableStatement.getBytes(4);
/*  830 */           this.typeVersion = NUMBER.toInt(localCallableStatement.getBytes(5));
/*  831 */           if (i == 0) {
/*  832 */             arrayOfByte = localCallableStatement.getBytes(6);
/*      */           }
/*      */           else {
/*      */             try
/*      */             {
/*  837 */               Blob localBlob = ((OracleCallableStatement)localCallableStatement).getBlob(6);
/*  838 */               localObject1 = localBlob.getBinaryStream();
/*  839 */               arrayOfByte = new byte[(int)localBlob.length()];
/*  840 */               ((InputStream)localObject1).read(arrayOfByte);
/*  841 */               ((InputStream)localObject1).close();
/*  842 */               ((BLOB)localBlob).freeTemporary();
/*      */             }
/*      */             catch (IOException localIOException)
/*      */             {
/*  846 */               SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  847 */               localSQLException.fillInStackTrace();
/*  848 */               throw localSQLException;
/*      */             }
/*      */           }
/*      */ 
/*  852 */           this.metaDataInitialized = true;
/*      */ 
/*  858 */           this.flattenedAttrNum = (Util.getUnsignedByte(arrayOfByte[8]) * 256 + Util.getUnsignedByte(arrayOfByte[9]));
/*      */ 
/*  860 */           localCallableStatement.getBytes(7);
/*      */         }
/*      */         finally
/*      */         {
/*  868 */           if (localCallableStatement != null) localCallableStatement.close();
/*      */ 
/*  873 */           this.connection.endNonRequestCalls();
/*      */         }
/*      */       }
/*  876 */       setStatusBits(256);
/*  877 */       return arrayOfByte;
/*      */     }
/*      */   }
/*      */ 
/*      */   TDSReader parseTDS(byte[] paramArrayOfByte, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  886 */     if (this.attrTypes != null) {
/*  887 */       return null;
/*      */     }
/*      */ 
/*  892 */     TDSReader localTDSReader = new TDSReader(paramArrayOfByte, paramLong);
/*      */ 
/*  895 */     long l1 = localTDSReader.readLong() + localTDSReader.offset();
/*      */ 
/*  899 */     localTDSReader.checkNextByte((byte)38);
/*      */ 
/*  902 */     this.tdsVersion = localTDSReader.readByte();
/*      */ 
/*  905 */     localTDSReader.skipBytes(2);
/*      */ 
/*  908 */     this.flattenedAttrNum = localTDSReader.readUB2();
/*      */ 
/*  911 */     if ((localTDSReader.readByte() & 0xFF) == 255) {
/*  912 */       setStatusBits(128);
/*      */     }
/*      */ 
/*  916 */     long l2 = localTDSReader.offset();
/*      */ 
/*  919 */     localTDSReader.checkNextByte((byte)41);
/*      */ 
/*  924 */     if (localTDSReader.readUB2() != 0)
/*      */     {
/*  926 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 47, "parseTDS");
/*  927 */       localSQLException.fillInStackTrace();
/*  928 */       throw localSQLException;
/*      */     }
/*      */ 
/*  933 */     long l3 = localTDSReader.readLong();
/*      */ 
/*  936 */     parseTDSrec(localTDSReader);
/*      */ 
/*  939 */     if (this.tdsVersion >= 3)
/*      */     {
/*  943 */       localTDSReader.skip_to(l2 + l3 + 2L);
/*      */ 
/*  946 */       localTDSReader.skipBytes(2 * this.flattenedAttrNum);
/*      */ 
/*  949 */       byte b = localTDSReader.readByte();
/*      */ 
/*  952 */       if (localTDSReader.isJavaObject(this.tdsVersion, b)) {
/*  953 */         setStatusBits(16);
/*      */       }
/*      */ 
/*  957 */       if (localTDSReader.isFinalType(this.tdsVersion, b)) {
/*  958 */         setStatusBits(32);
/*      */       }
/*      */ 
/*  962 */       if (localTDSReader.readByte() != 1)
/*  963 */         setStatusBits(64);
/*      */     }
/*      */     else
/*      */     {
/*  967 */       setStatusBits(32);
/*      */     }
/*      */ 
/*  970 */     localTDSReader.skip_to(l1);
/*  971 */     return localTDSReader;
/*      */   }
/*      */ 
/*      */   public void parseTDSrec(TDSReader paramTDSReader)
/*      */     throws SQLException
/*      */   {
/*  979 */     Vector localVector = new Vector(5);
/*  980 */     OracleType localOracleType = null;
/*      */ 
/*  990 */     this.idx = 1;
/*      */ 
/*  992 */     while ((localOracleType = getNextTypeObject(paramTDSReader)) != null)
/*      */     {
/*  994 */       localVector.addElement(localOracleType);
/*      */     }
/*      */ 
/*  998 */     if (this.opcode == 42)
/*      */     {
/* 1000 */       this.endOfAdt = true;
/*      */ 
/* 1002 */       applyTDSpatches(paramTDSReader);
/*      */     }
/*      */ 
/* 1005 */     this.attrTypes = new OracleType[localVector.size()];
/*      */ 
/* 1007 */     localVector.copyInto(this.attrTypes);
/*      */   }
/*      */ 
/*      */   private void applyTDSpatches(TDSReader paramTDSReader)
/*      */     throws SQLException
/*      */   {
/* 1017 */     TDSPatch localTDSPatch = paramTDSReader.getNextPatch();
/*      */ 
/* 1019 */     while (localTDSPatch != null)
/*      */     {
/* 1024 */       paramTDSReader.moveToPatchPos(localTDSPatch);
/*      */ 
/* 1026 */       int i = localTDSPatch.getType();
/*      */ 
/* 1028 */       if (i == 0)
/*      */       {
/* 1032 */         paramTDSReader.readByte();
/*      */ 
/* 1034 */         int j = localTDSPatch.getUptTypeCode();
/*      */         Object localObject2;
/*      */         Object localObject3;
/* 1036 */         switch (j)
/*      */         {
/*      */         case -6:
/* 1041 */           paramTDSReader.readLong();
/*      */         case -5:
/* 1048 */           localObject2 = localTDSPatch.getOwner();
/* 1049 */           localObject3 = null;
/*      */ 
/* 1051 */           if (((OracleNamedType)localObject2).hasName())
/*      */           {
/* 1053 */             localObject3 = new OracleTypeADT(((OracleNamedType)localObject2).getFullName(), this.connection);
/*      */           }
/*      */           else
/*      */           {
/* 1057 */             localObject3 = new OracleTypeADT(((OracleNamedType)localObject2).getParent(), ((OracleNamedType)localObject2).getOrder(), this.connection);
/*      */           }
/*      */ 
/* 1061 */           ((OracleTypeADT)localObject3).setUptADT();
/* 1062 */           TDSReader localTDSReader = ((OracleTypeADT)localObject3).parseTDS(paramTDSReader.tds(), paramTDSReader.absoluteOffset());
/*      */ 
/* 1064 */           paramTDSReader.skipBytes((int)localTDSReader.offset());
/* 1065 */           localTDSPatch.apply(((OracleTypeADT)localObject3).cleanup());
/*      */ 
/* 1068 */           break;
/*      */         case 58:
/* 1072 */           localObject2 = localTDSPatch.getOwner();
/* 1073 */           localObject3 = null;
/*      */ 
/* 1075 */           if (((OracleNamedType)localObject2).hasName())
/*      */           {
/* 1077 */             localObject3 = new OracleTypeOPAQUE(((OracleNamedType)localObject2).getFullName(), this.connection);
/*      */           }
/*      */           else
/*      */           {
/* 1081 */             localObject3 = new OracleTypeOPAQUE(((OracleNamedType)localObject2).getParent(), ((OracleNamedType)localObject2).getOrder(), this.connection);
/*      */           }
/*      */ 
/* 1085 */           ((OracleTypeOPAQUE)localObject3).parseTDSrec(paramTDSReader);
/* 1086 */           localTDSPatch.apply((OracleType)localObject3);
/*      */ 
/* 1089 */           break;
/*      */         default:
/* 1094 */           localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/* 1095 */           ((SQLException)localObject2).fillInStackTrace();
/* 1096 */           throw ((Throwable)localObject2);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*      */         Object localObject1;
/* 1101 */         if (i == 1)
/*      */         {
/* 1105 */           localObject1 = getNextTypeObject(paramTDSReader);
/*      */ 
/* 1109 */           localTDSPatch.apply((OracleType)localObject1, this.opcode);
/*      */         }
/*      */         else
/*      */         {
/* 1113 */           localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 47, "parseTDS");
/* 1114 */           ((SQLException)localObject1).fillInStackTrace();
/* 1115 */           throw ((Throwable)localObject1);
/*      */         }
/*      */       }
/* 1118 */       localTDSPatch = paramTDSReader.getNextPatch();
/*      */     }
/*      */   }
/*      */ 
/*      */   public OracleNamedType cleanup()
/*      */   {
/* 1129 */     synchronized (this.connection)
/*      */     {
/*      */       Object localObject1;
/* 1131 */       if ((this.attrTypes.length == 1) && ((this.attrTypes[0] instanceof OracleTypeCOLLECTION)))
/*      */       {
/* 1135 */         localObject1 = (OracleTypeCOLLECTION)this.attrTypes[0];
/*      */ 
/* 1138 */         ((OracleTypeCOLLECTION)localObject1).copy_properties(this);
/*      */ 
/* 1140 */         return localObject1;
/*      */       }
/* 1142 */       if ((this.attrTypes.length == 1) && ((this.statusBits & 0x80) != 0) && ((this.attrTypes[0] instanceof OracleTypeUPT)) && ((((OracleTypeUPT)this.attrTypes[0]).realType instanceof OracleTypeOPAQUE)))
/*      */       {
/* 1147 */         localObject1 = (OracleTypeOPAQUE)((OracleTypeUPT)this.attrTypes[0]).realType;
/*      */ 
/* 1150 */         ((OracleTypeOPAQUE)localObject1).copy_properties(this);
/*      */ 
/* 1152 */         return localObject1;
/*      */       }
/*      */ 
/* 1155 */       return this;
/*      */     }
/*      */   }
/*      */ 
/*      */   void copy_properties(OracleTypeADT paramOracleTypeADT)
/*      */   {
/* 1163 */     this.sqlName = paramOracleTypeADT.sqlName;
/* 1164 */     this.typeNameByUser = paramOracleTypeADT.typeNameByUser;
/* 1165 */     this.parent = paramOracleTypeADT.parent;
/* 1166 */     this.idx = paramOracleTypeADT.idx;
/* 1167 */     this.connection = paramOracleTypeADT.connection;
/* 1168 */     this.toid = paramOracleTypeADT.toid;
/* 1169 */     this.tdsVersion = paramOracleTypeADT.tdsVersion;
/* 1170 */     this.typeVersion = paramOracleTypeADT.typeVersion;
/* 1171 */     this.tdoCState = paramOracleTypeADT.tdoCState;
/* 1172 */     this.endOfAdt = paramOracleTypeADT.endOfAdt;
/* 1173 */     this.attrTypeNames = paramOracleTypeADT.attrTypeNames;
/*      */   }
/*      */ 
/*      */   OracleType getNextTypeObject(TDSReader paramTDSReader)
/*      */     throws SQLException
/*      */   {
/*      */     while (true)
/*      */     {
/* 1188 */       this.opcode = paramTDSReader.readByte();
/*      */ 
/* 1190 */       if (this.opcode != 43)
/*      */       {
/* 1196 */         if (this.opcode != 44)
/*      */         {
/*      */           break;
/*      */         }
/* 1200 */         byte b = paramTDSReader.readByte();
/*      */ 
/* 1202 */         if (paramTDSReader.isJavaObject(3, b)) {
/* 1203 */           setStatusBits(16);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1215 */     switch (this.opcode)
/*      */     {
/*      */     case 40:
/*      */     case 42:
/* 1222 */       return null;
/*      */     case 2:
/* 1227 */       localObject = new OracleTypeDATE();
/*      */ 
/* 1229 */       ((OracleTypeDATE)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1231 */       this.idx += 1;
/*      */ 
/* 1233 */       return localObject;
/*      */     case 7:
/* 1238 */       localObject = new OracleTypeCHAR(this.connection, 12);
/*      */ 
/* 1241 */       ((OracleTypeCHAR)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1243 */       this.idx += 1;
/*      */ 
/* 1245 */       return localObject;
/*      */     case 1:
/* 1250 */       localObject = new OracleTypeCHAR(this.connection, 1);
/*      */ 
/* 1252 */       ((OracleTypeCHAR)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1254 */       this.idx += 1;
/*      */ 
/* 1256 */       return localObject;
/*      */     case 39:
/* 1261 */       localObject = new OracleTypeADT(this, this.idx, this.connection);
/*      */ 
/* 1263 */       ((OracleTypeADT)localObject).setEmbeddedADT();
/* 1264 */       ((OracleTypeADT)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1266 */       this.idx += 1;
/*      */ 
/* 1268 */       return localObject;
/*      */     case 6:
/* 1273 */       localObject = new OracleTypeNUMBER(2);
/*      */ 
/* 1275 */       ((OracleTypeNUMBER)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1277 */       this.idx += 1;
/*      */ 
/* 1279 */       return localObject;
/*      */     case 3:
/* 1284 */       localObject = new OracleTypeNUMBER(3);
/*      */ 
/* 1286 */       ((OracleTypeNUMBER)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1288 */       this.idx += 1;
/*      */ 
/* 1290 */       return localObject;
/*      */     case 4:
/* 1295 */       localObject = new OracleTypeNUMBER(8);
/*      */ 
/* 1297 */       ((OracleTypeNUMBER)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1299 */       this.idx += 1;
/*      */ 
/* 1301 */       return localObject;
/*      */     case 5:
/* 1306 */       localObject = new OracleTypeFLOAT();
/*      */ 
/* 1308 */       ((OracleTypeFLOAT)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1310 */       this.idx += 1;
/*      */ 
/* 1312 */       return localObject;
/*      */     case 37:
/* 1317 */       localObject = new OracleTypeBINARY_FLOAT();
/*      */ 
/* 1319 */       ((OracleTypeBINARY_FLOAT)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1321 */       this.idx += 1;
/*      */ 
/* 1323 */       return localObject;
/*      */     case 45:
/* 1328 */       localObject = new OracleTypeBINARY_DOUBLE();
/*      */ 
/* 1330 */       ((OracleTypeBINARY_DOUBLE)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1332 */       this.idx += 1;
/*      */ 
/* 1334 */       return localObject;
/*      */     case 8:
/* 1339 */       localObject = new OracleTypeSINT32(false);
/*      */ 
/* 1341 */       ((OracleTypeSINT32)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1343 */       this.idx += 1;
/*      */ 
/* 1345 */       return localObject;
/*      */     case 9:
/* 1350 */       localObject = new OracleTypeREF(this, this.idx, this.connection);
/*      */ 
/* 1352 */       ((OracleTypeREF)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1354 */       this.idx += 1;
/*      */ 
/* 1356 */       return localObject;
/*      */     case 31:
/* 1361 */       localObject = new OracleTypeBFILE(this.connection);
/*      */ 
/* 1363 */       ((OracleTypeBFILE)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1365 */       this.idx += 1;
/*      */ 
/* 1367 */       return localObject;
/*      */     case 19:
/* 1372 */       localObject = new OracleTypeRAW();
/*      */ 
/* 1374 */       ((OracleTypeRAW)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1376 */       this.idx += 1;
/*      */ 
/* 1378 */       return localObject;
/*      */     case 29:
/* 1383 */       localObject = new OracleTypeCLOB(this.connection);
/*      */ 
/* 1385 */       ((OracleTypeCLOB)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1400 */       if ((this.attrTypeNames != null) && (this.attrTypeNames.length > this.idx - 1)) {
/* 1401 */         ((OracleTypeCLOB)localObject).form = ("NCLOB".equals(this.attrTypeNames[(this.idx - 1)]) ? 2 : 1);
/*      */       }
/* 1405 */       else if ((this.sqlName != null) && (!this.endOfAdt)) {
/* 1406 */         this.connection.getForm(this, (OracleTypeCLOB)localObject, this.idx);
/*      */       }
/*      */ 
/* 1410 */       this.idx += 1;
/*      */ 
/* 1413 */       return localObject;
/*      */     case 30:
/* 1418 */       localObject = new OracleTypeBLOB(this.connection);
/*      */ 
/* 1420 */       ((OracleTypeBLOB)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1422 */       this.idx += 1;
/*      */ 
/* 1424 */       return localObject;
/*      */     case 21:
/* 1429 */       localObject = new OracleTypeTIMESTAMP(this.connection);
/*      */ 
/* 1431 */       ((OracleTypeTIMESTAMP)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1433 */       this.idx += 1;
/*      */ 
/* 1435 */       return localObject;
/*      */     case 23:
/* 1440 */       localObject = new OracleTypeTIMESTAMPTZ(this.connection);
/*      */ 
/* 1442 */       ((OracleTypeTIMESTAMPTZ)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1444 */       this.idx += 1;
/*      */ 
/* 1446 */       return localObject;
/*      */     case 33:
/* 1451 */       localObject = new OracleTypeTIMESTAMPLTZ(this.connection);
/*      */ 
/* 1453 */       ((OracleTypeTIMESTAMPLTZ)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1455 */       this.idx += 1;
/*      */ 
/* 1457 */       return localObject;
/*      */     case 24:
/* 1462 */       localObject = new OracleTypeINTERVAL(this.connection);
/*      */ 
/* 1464 */       ((OracleTypeINTERVAL)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1466 */       this.idx += 1;
/*      */ 
/* 1468 */       return localObject;
/*      */     case 28:
/* 1473 */       localObject = new OracleTypeCOLLECTION(this, this.idx, this.connection);
/*      */ 
/* 1478 */       ((OracleTypeCOLLECTION)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1480 */       this.idx += 1;
/*      */ 
/* 1482 */       return localObject;
/*      */     case 27:
/* 1487 */       localObject = new OracleTypeUPT(this, this.idx, this.connection);
/*      */ 
/* 1492 */       ((OracleTypeUPT)localObject).parseTDSrec(paramTDSReader);
/*      */ 
/* 1494 */       this.idx += 1;
/*      */ 
/* 1496 */       return localObject;
/*      */     case 10:
/*      */     case 11:
/*      */     case 12:
/*      */     case 13:
/*      */     case 14:
/*      */     case 15:
/*      */     case 16:
/*      */     case 17:
/*      */     case 18:
/*      */     case 20:
/*      */     case 22:
/*      */     case 25:
/*      */     case 26:
/*      */     case 32:
/*      */     case 34:
/*      */     case 35:
/*      */     case 36:
/*      */     case 38:
/*      */     case 41:
/*      */     case 43:
/* 1514 */     case 44: } Object localObject = null;
/*      */ 
/* 1517 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 48, "get_next_type: " + this.opcode);
/* 1518 */     localSQLException.fillInStackTrace();
/* 1519 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public byte[] linearize(Datum paramDatum)
/*      */     throws SQLException
/*      */   {
/* 1538 */     synchronized (this.connection)
/*      */     {
/* 1540 */       return pickle81(paramDatum);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Datum unlinearize(byte[] paramArrayOfByte, long paramLong, Datum paramDatum, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1558 */     OracleConnection localOracleConnection = getConnection();
/* 1559 */     Datum localDatum = null;
/*      */ 
/* 1564 */     if (localOracleConnection == null)
/*      */     {
/* 1566 */       localDatum = _unlinearize(paramArrayOfByte, paramLong, paramDatum, paramInt, paramMap);
/*      */     }
/*      */     else
/*      */     {
/* 1570 */       synchronized (localOracleConnection) {
/* 1571 */         localDatum = _unlinearize(paramArrayOfByte, paramLong, paramDatum, paramInt, paramMap);
/*      */       }
/*      */     }
/*      */ 
/* 1575 */     return localDatum;
/*      */   }
/*      */ 
/*      */   public Datum _unlinearize(byte[] paramArrayOfByte, long paramLong, Datum paramDatum, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1586 */     synchronized (this.connection)
/*      */     {
/* 1588 */       if (paramArrayOfByte == null) {
/* 1589 */         return null;
/*      */       }
/*      */ 
/* 1592 */       PickleContext localPickleContext = new PickleContext(paramArrayOfByte, paramLong);
/*      */ 
/* 1594 */       return unpickle81(localPickleContext, (STRUCT)paramDatum, 1, paramInt, paramMap);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected STRUCT unpickle81(PickleContext paramPickleContext, STRUCT paramSTRUCT, int paramInt1, int paramInt2, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1616 */     STRUCT localSTRUCT = paramSTRUCT;
/* 1617 */     long l1 = paramPickleContext.offset();
/*      */ 
/* 1620 */     byte b = paramPickleContext.readByte();
/*      */     SQLException localSQLException;
/* 1622 */     if (!PickleContext.is81format(b))
/*      */     {
/* 1624 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Image is not in 8.1 format");
/* 1625 */       localSQLException.fillInStackTrace();
/* 1626 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1629 */     if (PickleContext.isCollectionImage_pctx(b))
/*      */     {
/* 1631 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Image is a collection image,expecting ADT");
/* 1632 */       localSQLException.fillInStackTrace();
/* 1633 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1638 */     if (!paramPickleContext.readAndCheckVersion())
/*      */     {
/* 1640 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Image version is not recognized");
/* 1641 */       localSQLException.fillInStackTrace();
/* 1642 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1645 */     switch (paramInt1)
/*      */     {
/*      */     case 9:
/* 1650 */       paramPickleContext.skipBytes(paramPickleContext.readLength(true) - 2);
/*      */ 
/* 1653 */       break;
/*      */     case 3:
/* 1657 */       long l2 = paramPickleContext.readLength();
/*      */ 
/* 1659 */       localSTRUCT = unpickle81Prefix(paramPickleContext, localSTRUCT, b);
/*      */ 
/* 1661 */       if (localSTRUCT == null)
/*      */       {
/* 1663 */         StructDescriptor localStructDescriptor = createStructDescriptor();
/*      */ 
/* 1665 */         localSTRUCT = createByteSTRUCT(localStructDescriptor, (byte[])null);
/*      */       }
/*      */ 
/* 1668 */       localSTRUCT.setImage(paramPickleContext.image(), l1, 0L);
/* 1669 */       localSTRUCT.setImageLength(l2);
/* 1670 */       paramPickleContext.skipTo(l1 + l2);
/*      */ 
/* 1673 */       break;
/*      */     default:
/* 1677 */       paramPickleContext.skipLength();
/*      */ 
/* 1680 */       localSTRUCT = unpickle81Prefix(paramPickleContext, localSTRUCT, b);
/*      */ 
/* 1682 */       if (localSTRUCT == null)
/*      */       {
/* 1684 */         localObject1 = createStructDescriptor();
/*      */ 
/* 1686 */         localSTRUCT = createByteSTRUCT((StructDescriptor)localObject1, (byte[])null);
/*      */       }
/*      */ 
/* 1690 */       Object localObject1 = localSTRUCT.getDescriptor().getOracleTypeADT().getAttrTypes();
/*      */       Object localObject2;
/*      */       int i;
/* 1693 */       switch (paramInt2)
/*      */       {
/*      */       case 1:
/* 1698 */         localObject2 = new Datum[localObject1.length];
/*      */ 
/* 1700 */         for (i = 0; i < localObject1.length; i++)
/*      */         {
/* 1702 */           localObject2[i] = ((Datum)localObject1[i].unpickle81rec(paramPickleContext, paramInt2, paramMap));
/*      */         }
/*      */ 
/* 1706 */         localSTRUCT.setDatumArray((Datum[])localObject2);
/*      */ 
/* 1709 */         break;
/*      */       case 2:
/* 1713 */         localObject2 = new Object[localObject1.length];
/*      */ 
/* 1715 */         for (i = 0; i < localObject1.length; i++)
/*      */         {
/* 1717 */           localObject2[i] = localObject1[i].unpickle81rec(paramPickleContext, paramInt2, paramMap);
/*      */         }
/*      */ 
/* 1720 */         localSTRUCT.setObjArray((Object[])localObject2);
/*      */ 
/* 1723 */         break;
/*      */       default:
/* 1728 */         localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/* 1729 */         ((SQLException)localObject2).fillInStackTrace();
/* 1730 */         throw ((Throwable)localObject2);
/*      */       }
/*      */ 
/*      */       break;
/*      */     }
/*      */ 
/* 1737 */     return localSTRUCT;
/*      */   }
/*      */ 
/*      */   protected STRUCT unpickle81Prefix(PickleContext paramPickleContext, STRUCT paramSTRUCT, byte paramByte)
/*      */     throws SQLException
/*      */   {
/* 1745 */     STRUCT localSTRUCT = paramSTRUCT;
/*      */ 
/* 1747 */     if (PickleContext.hasPrefix(paramByte))
/*      */     {
/* 1749 */       long l = paramPickleContext.readLength() + paramPickleContext.absoluteOffset();
/*      */ 
/* 1751 */       int i = paramPickleContext.readByte();
/*      */ 
/* 1758 */       int j = (byte)(i & 0xC);
/* 1759 */       int k = j == 0 ? 1 : 0;
/*      */ 
/* 1761 */       int m = j == 4 ? 1 : 0;
/*      */ 
/* 1763 */       int n = j == 8 ? 1 : 0;
/*      */ 
/* 1765 */       int i1 = j == 12 ? 1 : 0;
/*      */ 
/* 1768 */       int i2 = (i & 0x10) != 0 ? 1 : 0;
/*      */       Object localObject;
/* 1771 */       if (m != 0)
/*      */       {
/* 1773 */         localObject = paramPickleContext.readBytes(16);
/* 1774 */         String str = toid2typename(this.connection, (byte[])localObject);
/*      */ 
/* 1776 */         StructDescriptor localStructDescriptor = (StructDescriptor)TypeDescriptor.getTypeDescriptor(str, this.connection);
/*      */ 
/* 1780 */         if (localSTRUCT == null)
/* 1781 */           localSTRUCT = createByteSTRUCT(localStructDescriptor, (byte[])null);
/*      */         else {
/* 1783 */           localSTRUCT.setDescriptor(localStructDescriptor);
/*      */         }
/*      */       }
/* 1786 */       if (i2 != 0)
/*      */       {
/* 1788 */         paramPickleContext.readLength();
/*      */       }
/*      */ 
/* 1791 */       if ((n | i1) != 0)
/*      */       {
/* 1793 */         localObject = DatabaseError.createUnsupportedFeatureSqlException();
/* 1794 */         ((SQLException)localObject).fillInStackTrace();
/* 1795 */         throw ((Throwable)localObject);
/*      */       }
/*      */ 
/* 1798 */       paramPickleContext.skipTo(l);
/*      */     }
/*      */ 
/* 1801 */     return localSTRUCT;
/*      */   }
/*      */ 
/*      */   protected Object unpickle81rec(PickleContext paramPickleContext, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1814 */     byte b1 = paramPickleContext.readByte();
/* 1815 */     byte b2 = 0;
/*      */ 
/* 1817 */     if (PickleContext.isAtomicNull(b1))
/* 1818 */       return null;
/* 1819 */     if (PickleContext.isImmediatelyEmbeddedNull(b1)) {
/* 1820 */       b2 = paramPickleContext.readByte();
/*      */     }
/* 1822 */     STRUCT localSTRUCT = unpickle81datum(paramPickleContext, b1, b2);
/*      */ 
/* 1824 */     return toObject(localSTRUCT, paramInt, paramMap);
/*      */   }
/*      */ 
/*      */   protected Object unpickle81rec(PickleContext paramPickleContext, byte paramByte, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1833 */     STRUCT localSTRUCT = unpickle81datum(paramPickleContext, paramByte, (byte)0);
/*      */ 
/* 1835 */     return toObject(localSTRUCT, paramInt, paramMap);
/*      */   }
/*      */ 
/*      */   private STRUCT unpickle81datum(PickleContext paramPickleContext, byte paramByte1, byte paramByte2)
/*      */     throws SQLException
/*      */   {
/* 1843 */     int i = getNumAttrs();
/*      */ 
/* 1846 */     StructDescriptor localStructDescriptor = createStructDescriptor();
/* 1847 */     STRUCT localSTRUCT = createByteSTRUCT(localStructDescriptor, (byte[])null);
/* 1848 */     OracleType localOracleType = getAttrTypeAt(0);
/* 1849 */     Object localObject = null;
/*      */ 
/* 1853 */     if ((PickleContext.isImmediatelyEmbeddedNull(paramByte1)) && (paramByte2 == 1))
/* 1854 */       localObject = null;
/* 1855 */     else if (PickleContext.isImmediatelyEmbeddedNull(paramByte1)) {
/* 1856 */       localObject = ((OracleTypeADT)localOracleType).unpickle81datum(paramPickleContext, paramByte1, (byte)(paramByte2 - 1));
/*      */     }
/* 1858 */     else if (PickleContext.isElementNull(paramByte1))
/*      */     {
/* 1860 */       if ((localOracleType.getTypeCode() == 2002) || (localOracleType.getTypeCode() == 2008))
/*      */       {
/* 1862 */         localObject = localOracleType.unpickle81datumAsNull(paramPickleContext, paramByte1, paramByte2);
/*      */       }
/* 1864 */       else localObject = null;
/*      */     }
/*      */     else {
/* 1867 */       localObject = localOracleType.unpickle81rec(paramPickleContext, paramByte1, 1, null);
/*      */     }
/*      */ 
/* 1870 */     Datum[] arrayOfDatum = new Datum[i];
/*      */ 
/* 1872 */     arrayOfDatum[0] = ((Datum)localObject);
/*      */ 
/* 1874 */     for (int j = 1; j < i; j++)
/*      */     {
/* 1876 */       localOracleType = getAttrTypeAt(j);
/* 1877 */       arrayOfDatum[j] = ((Datum)localOracleType.unpickle81rec(paramPickleContext, 1, null));
/*      */     }
/*      */ 
/* 1880 */     localSTRUCT.setDatumArray(arrayOfDatum);
/*      */ 
/* 1882 */     return localSTRUCT;
/*      */   }
/*      */ 
/*      */   protected Datum unpickle81datumAsNull(PickleContext paramPickleContext, byte paramByte1, byte paramByte2)
/*      */     throws SQLException
/*      */   {
/* 1890 */     int i = getNumAttrs();
/*      */ 
/* 1893 */     StructDescriptor localStructDescriptor = createStructDescriptor();
/* 1894 */     STRUCT localSTRUCT = createByteSTRUCT(localStructDescriptor, (byte[])null);
/* 1895 */     Datum[] arrayOfDatum = new Datum[i];
/* 1896 */     int j = 0;
/* 1897 */     OracleType localOracleType = getAttrTypeAt(j);
/*      */ 
/* 1900 */     if ((localOracleType.getTypeCode() == 2002) || (localOracleType.getTypeCode() == 2008))
/*      */     {
/* 1902 */       arrayOfDatum[(j++)] = localOracleType.unpickle81datumAsNull(paramPickleContext, paramByte1, paramByte2);
/*      */     }
/* 1904 */     else arrayOfDatum[(j++)] = ((Datum)null);
/*      */ 
/* 1906 */     for (; j < i; j++)
/*      */     {
/* 1908 */       localOracleType = getAttrTypeAt(j);
/* 1909 */       if ((localOracleType.getTypeCode() == 2002) || (localOracleType.getTypeCode() == 2008))
/*      */       {
/* 1911 */         arrayOfDatum[j] = ((Datum)localOracleType.unpickle81rec(paramPickleContext, 1, null));
/*      */       }
/*      */       else
/* 1914 */         arrayOfDatum[j] = ((Datum)localOracleType.unpickle81rec(paramPickleContext, 1, null));
/*      */     }
/* 1916 */     localSTRUCT.setDatumArray(arrayOfDatum);
/* 1917 */     return localSTRUCT;
/*      */   }
/*      */ 
/*      */   public byte[] pickle81(Datum paramDatum)
/*      */     throws SQLException
/*      */   {
/* 1934 */     PickleContext localPickleContext = new PickleContext();
/*      */ 
/* 1936 */     localPickleContext.initStream();
/* 1937 */     pickle81(localPickleContext, paramDatum);
/*      */ 
/* 1939 */     byte[] arrayOfByte = localPickleContext.stream2Bytes();
/*      */ 
/* 1942 */     paramDatum.setShareBytes(arrayOfByte);
/*      */ 
/* 1944 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   protected int pickle81(PickleContext paramPickleContext, Datum paramDatum)
/*      */     throws SQLException
/*      */   {
/* 1951 */     int i = paramPickleContext.offset() + 2;
/* 1952 */     int j = 0;
/*      */ 
/* 1955 */     j += paramPickleContext.writeImageHeader(shouldHavePrefix());
/*      */ 
/* 1957 */     j += pickle81Prefix(paramPickleContext);
/* 1958 */     j += pickle81rec(paramPickleContext, paramDatum, 0);
/*      */ 
/* 1960 */     paramPickleContext.patchImageLen(i, j);
/*      */ 
/* 1962 */     return j;
/*      */   }
/*      */ 
/*      */   private boolean hasVersion()
/*      */   {
/* 1969 */     return this.typeVersion > 1;
/*      */   }
/*      */ 
/*      */   private boolean needsToid()
/*      */   {
/* 1976 */     if (this.isTransient)
/* 1977 */       return false;
/* 1978 */     return ((this.statusBits & 0x40) != 0) || ((this.statusBits & 0x20) == 0) || (hasVersion());
/*      */   }
/*      */ 
/*      */   private boolean shouldHavePrefix()
/*      */   {
/* 1986 */     if (this.isTransient) return false;
/* 1987 */     return (hasVersion()) || (needsToid());
/*      */   }
/*      */ 
/*      */   protected int pickle81Prefix(PickleContext paramPickleContext)
/*      */     throws SQLException
/*      */   {
/* 1994 */     if (shouldHavePrefix())
/*      */     {
/* 1996 */       int i = 0;
/* 1997 */       int j = 1;
/* 1998 */       int k = 1;
/*      */ 
/* 2000 */       if (needsToid())
/*      */       {
/* 2002 */         k += getTOID().length;
/* 2003 */         j |= 4;
/*      */       }
/*      */ 
/* 2006 */       if (hasVersion())
/*      */       {
/* 2008 */         j |= 16;
/*      */ 
/* 2010 */         if (this.typeVersion > PickleContext.KOPI20_LN_MAXV)
/* 2011 */           k += 5;
/*      */         else {
/* 2013 */           k += 2;
/*      */         }
/*      */       }
/* 2016 */       i = paramPickleContext.writeLength(k);
/*      */ 
/* 2018 */       i += paramPickleContext.writeData((byte)j);
/*      */ 
/* 2020 */       if (needsToid()) {
/* 2021 */         i += paramPickleContext.writeData(this.toid);
/*      */       }
/* 2023 */       if (hasVersion())
/*      */       {
/* 2025 */         if (this.typeVersion > PickleContext.KOPI20_LN_MAXV)
/* 2026 */           i += paramPickleContext.writeLength(this.typeVersion);
/*      */         else {
/* 2028 */           i += paramPickleContext.writeSB2(this.typeVersion);
/*      */         }
/*      */       }
/* 2031 */       return i;
/*      */     }
/*      */ 
/* 2034 */     return 0;
/*      */   }
/*      */ 
/*      */   private int pickle81rec(PickleContext paramPickleContext, Datum paramDatum, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2044 */     int i = 0;
/*      */ 
/* 2046 */     if (!this.metaDataInitialized) {
/* 2047 */       copy_properties((OracleTypeADT)((STRUCT)paramDatum).getDescriptor().getPickler());
/*      */     }
/* 2049 */     Datum[] arrayOfDatum = ((STRUCT)paramDatum).getOracleAttributes();
/* 2050 */     int j = arrayOfDatum.length;
/* 2051 */     int k = 0;
/* 2052 */     OracleType localOracleType = getAttrTypeAt(0);
/*      */ 
/* 2054 */     if (((localOracleType instanceof OracleTypeADT)) && (!(localOracleType instanceof OracleTypeCOLLECTION)) && (!(localOracleType instanceof OracleTypeUPT)))
/*      */     {
/* 2061 */       k = 1;
/*      */ 
/* 2063 */       if (arrayOfDatum[0] == null)
/*      */       {
/* 2065 */         if (paramInt > 0)
/* 2066 */           i += paramPickleContext.writeImmediatelyEmbeddedElementNull((byte)paramInt);
/*      */         else {
/* 2068 */           i += paramPickleContext.writeAtomicNull();
/*      */         }
/*      */       }
/*      */       else {
/* 2072 */         i += ((OracleTypeADT)localOracleType).pickle81rec(paramPickleContext, arrayOfDatum[0], paramInt + 1);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2077 */     for (; k < j; k++)
/*      */     {
/* 2079 */       localOracleType = getAttrTypeAt(k);
/*      */ 
/* 2082 */       if (arrayOfDatum[k] == null)
/*      */       {
/* 2084 */         if (((localOracleType instanceof OracleTypeADT)) && (!(localOracleType instanceof OracleTypeCOLLECTION)) && (!(localOracleType instanceof OracleTypeUPT)))
/*      */         {
/* 2090 */           i += paramPickleContext.writeAtomicNull();
/*      */         }
/*      */         else
/*      */         {
/* 2094 */           i += paramPickleContext.writeElementNull();
/*      */         }
/*      */ 
/*      */       }
/* 2099 */       else if (((localOracleType instanceof OracleTypeADT)) && (!(localOracleType instanceof OracleTypeCOLLECTION)) && (!(localOracleType instanceof OracleTypeUPT)))
/*      */       {
/* 2105 */         i += ((OracleTypeADT)localOracleType).pickle81rec(paramPickleContext, arrayOfDatum[k], 1);
/*      */       }
/*      */       else
/*      */       {
/* 2112 */         i += localOracleType.pickle81(paramPickleContext, arrayOfDatum[k]);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2117 */     return i;
/*      */   }
/*      */ 
/*      */   private Object toObject(STRUCT paramSTRUCT, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 2129 */     switch (paramInt)
/*      */     {
/*      */     case 1:
/* 2132 */       return paramSTRUCT;
/*      */     case 2:
/* 2135 */       if (paramSTRUCT != null) return paramSTRUCT.toJdbc(paramMap);
/*      */ 
/*      */       break;
/*      */     default:
/* 2142 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/* 2143 */       localSQLException.fillInStackTrace();
/* 2144 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2149 */     return null;
/*      */   }
/*      */ 
/*      */   public String getAttributeType(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2166 */     return getAttributeType(paramInt, true);
/*      */   }
/*      */ 
/*      */   public String getAttributeType(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 2178 */     if (paramBoolean) {
/* 2179 */       if (this.sqlName == null) getFullName();
/*      */ 
/* 2181 */       if (this.attrNames == null)
/*      */       {
/* 2183 */         initADTAttrNames();
/*      */       }
/*      */     }
/* 2186 */     if ((paramInt < 1) || ((this.attrTypeNames != null) && (paramInt > this.attrTypeNames.length)))
/*      */     {
/* 2188 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Invalid index");
/* 2189 */       localSQLException.fillInStackTrace();
/* 2190 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2193 */     if (this.attrTypeNames != null) {
/* 2194 */       return this.attrTypeNames[(paramInt - 1)];
/*      */     }
/*      */ 
/* 2197 */     return null;
/*      */   }
/*      */ 
/*      */   public String getAttributeName(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2211 */     if (this.attrNames == null) initADTAttrNames();
/*      */ 
/* 2213 */     String str = null;
/* 2214 */     if (this.attrNames != null) {
/* 2215 */       synchronized (this.connection) {
/* 2216 */         if ((paramInt < 1) || (paramInt > this.attrNames.length))
/*      */         {
/* 2218 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Invalid index");
/* 2219 */           localSQLException.fillInStackTrace();
/* 2220 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/* 2224 */       str = this.attrNames[(paramInt - 1)];
/*      */     }
/* 2226 */     return str;
/*      */   }
/*      */ 
/*      */   public String getAttributeName(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 2238 */     if ((paramBoolean) && (this.connection != null)) {
/* 2239 */       return getAttributeName(paramInt);
/*      */     }
/*      */ 
/* 2242 */     if ((paramInt < 1) || ((this.attrNames != null) && (paramInt > this.attrNames.length)))
/*      */     {
/* 2244 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Invalid index");
/* 2245 */       localSQLException.fillInStackTrace();
/* 2246 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2250 */     if (this.attrNames != null) {
/* 2251 */       return this.attrNames[(paramInt - 1)];
/*      */     }
/*      */ 
/* 2254 */     return null;
/*      */   }
/*      */ 
/*      */   private void initADTAttrNames()
/*      */     throws SQLException
/*      */   {
/* 2436 */     if (this.connection == null) return;
/* 2437 */     if (this.sqlName == null) getFullName();
/*      */ 
/* 2439 */     if (this.toid != null) {
/* 2440 */       initADTAttrNamesUsingTOID();
/* 2441 */       return;
/*      */     }
/*      */ 
/* 2444 */     synchronized (this.connection)
/*      */     {
/* 2446 */       Object localObject1 = null;
/* 2447 */       PreparedStatement localPreparedStatement = null;
/* 2448 */       ResultSet localResultSet = null;
/* 2449 */       String[] arrayOfString1 = new String[this.attrTypes.length];
/* 2450 */       String[] arrayOfString2 = new String[this.attrTypes.length];
/* 2451 */       int i = 0;
/* 2452 */       int j = 0;
/* 2453 */       if (this.attrNames == null)
/*      */       {
/* 2456 */         this.connection.beginNonRequestCalls();
/*      */         try
/*      */         {
/* 2459 */           i = this.sqlName.getSchema().equals(this.connection.getDefaultSchemaNameForNamedTypes()) ? 0 : 7;
/*      */ 
/* 2463 */           while (i != 11) {
/* 2464 */             switch (i)
/*      */             {
/*      */             case 0:
/* 2467 */               localPreparedStatement = this.connection.prepareStatement(getSqlHint() + sqlString[i]);
/* 2468 */               localPreparedStatement.setString(1, this.sqlName.getSimpleName());
/* 2469 */               localPreparedStatement.setFetchSize(this.idx);
/* 2470 */               localResultSet = localPreparedStatement.executeQuery();
/* 2471 */               i = 1;
/* 2472 */               break;
/*      */             case 1:
/* 2475 */               if (this.connection.getVersionNumber() >= 10000) {
/* 2476 */                 i = 2;
/*      */               }
/*      */ 
/*      */             case 2:
/* 2481 */               localPreparedStatement = this.connection.prepareStatement(getSqlHint() + sqlString[i]);
/* 2482 */               localPreparedStatement.setString(1, this.sqlName.getSimpleName());
/* 2483 */               localPreparedStatement.setString(2, this.sqlName.getSimpleName());
/* 2484 */               localPreparedStatement.setFetchSize(this.idx);
/* 2485 */               localResultSet = localPreparedStatement.executeQuery();
/* 2486 */               i = 3;
/* 2487 */               break;
/*      */             case 3:
/* 2490 */               if (this.connection.getVersionNumber() >= 10000) {
/* 2491 */                 i = 4;
/*      */               }
/*      */ 
/*      */             case 4:
/* 2496 */               localPreparedStatement = this.connection.prepareStatement(getSqlHint() + sqlString[i]);
/* 2497 */               localPreparedStatement.setString(1, this.sqlName.getSimpleName());
/* 2498 */               localPreparedStatement.setString(2, this.sqlName.getSimpleName());
/* 2499 */               localPreparedStatement.setFetchSize(this.idx);
/* 2500 */               localResultSet = localPreparedStatement.executeQuery();
/* 2501 */               i = 5;
/* 2502 */               break;
/*      */             case 5:
/* 2505 */               if (this.connection.getVersionNumber() >= 10000) {
/* 2506 */                 i = 6;
/*      */               }
/*      */ 
/*      */             case 6:
/* 2511 */               localObject1 = (OracleCallableStatement)this.connection.prepareCall(getSqlHint() + sqlString[i]);
/*      */ 
/* 2514 */               ((CallableStatement)localObject1).setString(1, this.sqlName.getSimpleName());
/* 2515 */               ((CallableStatement)localObject1).setString(3, this.sqlName.getSimpleName());
/* 2516 */               ((CallableStatement)localObject1).registerOutParameter(2, -10);
/* 2517 */               ((CallableStatement)localObject1).execute();
/* 2518 */               localResultSet = ((OracleCallableStatement)localObject1).getCursor(2);
/* 2519 */               localResultSet.setFetchSize(1);
/* 2520 */               i = 8;
/* 2521 */               break;
/*      */             case 7:
/* 2525 */               localPreparedStatement = this.connection.prepareStatement(getSqlHint() + sqlString[i]);
/* 2526 */               localPreparedStatement.setString(1, this.sqlName.getSchema());
/* 2527 */               localPreparedStatement.setString(2, this.sqlName.getSimpleName());
/* 2528 */               localPreparedStatement.setFetchSize(this.idx);
/* 2529 */               localResultSet = localPreparedStatement.executeQuery();
/* 2530 */               i = 8;
/* 2531 */               break;
/*      */             case 8:
/* 2535 */               localPreparedStatement = this.connection.prepareStatement(getSqlHint() + sqlString[i]);
/* 2536 */               localPreparedStatement.setString(1, this.sqlName.getSimpleName());
/* 2537 */               localPreparedStatement.setString(2, this.sqlName.getSimpleName());
/* 2538 */               localPreparedStatement.setFetchSize(this.idx);
/* 2539 */               localResultSet = localPreparedStatement.executeQuery();
/* 2540 */               i = 9;
/* 2541 */               break;
/*      */             case 9:
/* 2544 */               if (this.connection.getVersionNumber() >= 10000) {
/* 2545 */                 i = 10;
/*      */               }
/*      */ 
/*      */             case 10:
/* 2550 */               localObject1 = this.connection.prepareCall(getSqlHint() + sqlString[i]);
/* 2551 */               ((CallableStatement)localObject1).setString(1, this.sqlName.getSimpleName());
/* 2552 */               ((CallableStatement)localObject1).registerOutParameter(2, -10);
/* 2553 */               ((CallableStatement)localObject1).execute();
/* 2554 */               localResultSet = ((OracleCallableStatement)localObject1).getCursor(2);
/* 2555 */               i = 11;
/*      */             }
/*      */ 
/*      */             try
/*      */             {
/* 2560 */               for (j = 0; 
/* 2561 */                 (j < this.attrTypes.length) && (localResultSet.next()); 
/* 2562 */                 j++) {
/* 2563 */                 if (localResultSet.getInt(1) != j + 1)
/*      */                 {
/* 2565 */                   localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "inconsistent ADT attribute");
/* 2566 */                   ((SQLException)localObject2).fillInStackTrace();
/* 2567 */                   throw ((Throwable)localObject2);
/*      */                 }
/*      */ 
/* 2572 */                 arrayOfString1[j] = localResultSet.getString(2);
/*      */ 
/* 2575 */                 Object localObject2 = localResultSet.getString(4);
/* 2576 */                 arrayOfString2[j] = "";
/* 2577 */                 if (localObject2 != null)
/* 2578 */                   arrayOfString2[j] = ((String)localObject2 + ".");
/*      */                 int tmp1009_1007 = j;
/*      */                 String[] tmp1009_1005 = arrayOfString2; tmp1009_1005[tmp1009_1007] = (tmp1009_1005[tmp1009_1007] + localResultSet.getString(3));
/*      */               }
/*      */ 
/* 2583 */               if (j != 0) {
/* 2584 */                 this.attrTypeNames = arrayOfString2;
/*      */ 
/* 2586 */                 this.attrNames = arrayOfString1;
/* 2587 */                 i = 11;
/*      */               }
/*      */               else {
/* 2590 */                 if (localResultSet != null) localResultSet.close();
/* 2591 */                 if (localPreparedStatement != null) localPreparedStatement.close();
/* 2592 */                 if (localObject1 != null) ((CallableStatement)localObject1).close(); 
/*      */               }
/*      */             }
/*      */             finally
/*      */             {
/* 2596 */               if (localResultSet != null) localResultSet.close();
/* 2597 */               if (localPreparedStatement != null) localPreparedStatement.close();
/* 2598 */               if (localObject1 != null) ((CallableStatement)localObject1).close();
/*      */ 
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */         finally
/*      */         {
/* 2607 */           this.connection.endNonRequestCalls();
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void initADTAttrNamesUsingTOID()
/*      */     throws SQLException
/*      */   {
/* 2638 */     synchronized (this.connection)
/*      */     {
/* 2640 */       Object localObject1 = null;
/* 2641 */       PreparedStatement localPreparedStatement = null;
/* 2642 */       ResultSet localResultSet = null;
/* 2643 */       String[] arrayOfString1 = new String[this.attrTypes.length];
/* 2644 */       String[] arrayOfString2 = new String[this.attrTypes.length];
/* 2645 */       int i = 0;
/* 2646 */       int j = 0;
/* 2647 */       if (this.attrNames == null)
/*      */       {
/* 2650 */         this.connection.beginNonRequestCalls();
/*      */         try
/*      */         {
/* 2653 */           i = this.sqlName.getSchema().equals(this.connection.getDefaultSchemaNameForNamedTypes()) ? 0 : 1;
/*      */ 
/* 2657 */           while (i != 11) {
/* 2658 */             switch (i)
/*      */             {
/*      */             case 0:
/* 2661 */               localPreparedStatement = this.connection.prepareStatement(getSqlHint() + sqlStringTOID[i]);
/*      */ 
/* 2663 */               localPreparedStatement.setBytes(1, this.toid);
/* 2664 */               localPreparedStatement.setFetchSize(this.idx);
/* 2665 */               localResultSet = localPreparedStatement.executeQuery();
/* 2666 */               i = 1;
/* 2667 */               break;
/*      */             case 1:
/* 2671 */               localPreparedStatement = this.connection.prepareStatement(getSqlHint() + sqlStringTOID[i]);
/*      */ 
/* 2673 */               localPreparedStatement.setBytes(1, this.toid);
/* 2674 */               localPreparedStatement.setFetchSize(this.idx);
/* 2675 */               localResultSet = localPreparedStatement.executeQuery();
/* 2676 */               i = 11;
/*      */             }
/*      */ 
/*      */             try
/*      */             {
/* 2681 */               for (j = 0; 
/* 2682 */                 (j < this.attrTypes.length) && (localResultSet.next()); 
/* 2683 */                 j++) {
/* 2684 */                 if ((localResultSet.getInt(1) != j + 1) && (i == 1))
/*      */                 {
/* 2688 */                   localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "inconsistent ADT attribute");
/* 2689 */                   ((SQLException)localObject2).fillInStackTrace();
/* 2690 */                   throw ((Throwable)localObject2);
/*      */                 }
/*      */ 
/* 2695 */                 arrayOfString1[j] = localResultSet.getString(2);
/*      */ 
/* 2698 */                 Object localObject2 = localResultSet.getString(4);
/* 2699 */                 arrayOfString2[j] = "";
/* 2700 */                 if (localObject2 != null) arrayOfString2[j] = ((String)localObject2 + ".");
/*      */                 int tmp397_395 = j;
/*      */                 String[] tmp397_393 = arrayOfString2; tmp397_393[tmp397_395] = (tmp397_393[tmp397_395] + localResultSet.getString(3));
/*      */               }
/*      */ 
/* 2704 */               if (j != 0) {
/* 2705 */                 this.attrTypeNames = arrayOfString2;
/*      */ 
/* 2707 */                 this.attrNames = arrayOfString1;
/* 2708 */                 i = 11;
/*      */               }
/*      */               else {
/* 2711 */                 if (localResultSet != null) localResultSet.close();
/* 2712 */                 if (localPreparedStatement != null) localPreparedStatement.close(); 
/*      */               }
/*      */             }
/*      */             finally
/*      */             {
/* 2716 */               if (localResultSet != null) localResultSet.close();
/* 2717 */               if (localPreparedStatement != null) localPreparedStatement.close();
/* 2718 */               if (localObject1 != null) localObject1.close();
/*      */ 
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */         finally
/*      */         {
/* 2727 */           this.connection.endNonRequestCalls();
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   StructDescriptor createStructDescriptor()
/*      */     throws SQLException
/*      */   {
/* 2748 */     StructDescriptor localStructDescriptor = (StructDescriptor)this.descriptor;
/*      */ 
/* 2750 */     if ((this.typeNameByUser == null) && (this.parent != null) && (this.parent.getTypeCode() == 2003))
/*      */     {
/* 2753 */       this.typeNameByUser = this.parent.getAttributeType(1);
/*      */     }
/*      */ 
/* 2756 */     if (localStructDescriptor == null) {
/* 2757 */       localStructDescriptor = new StructDescriptor(this, this.connection);
/*      */     }
/*      */ 
/* 2760 */     return localStructDescriptor;
/*      */   }
/*      */ 
/*      */   STRUCT createObjSTRUCT(StructDescriptor paramStructDescriptor, Object[] paramArrayOfObject)
/*      */     throws SQLException
/*      */   {
/* 2768 */     if ((this.statusBits & 0x10) != 0) {
/* 2769 */       return new JAVA_STRUCT(paramStructDescriptor, this.connection, paramArrayOfObject);
/*      */     }
/* 2771 */     return new STRUCT(paramStructDescriptor, this.connection, paramArrayOfObject);
/*      */   }
/*      */ 
/*      */   STRUCT createByteSTRUCT(StructDescriptor paramStructDescriptor, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 2779 */     if ((this.statusBits & 0x10) != 0) {
/* 2780 */       return new JAVA_STRUCT(paramStructDescriptor, paramArrayOfByte, this.connection);
/*      */     }
/* 2782 */     return new STRUCT(paramStructDescriptor, paramArrayOfByte, this.connection);
/*      */   }
/*      */ 
/*      */   public static String getSubtypeName(Connection paramConnection, byte[] paramArrayOfByte, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2794 */     PickleContext localPickleContext = new PickleContext(paramArrayOfByte, paramLong);
/* 2795 */     byte b = localPickleContext.readByte();
/*      */ 
/* 2797 */     if ((!PickleContext.is81format(b)) || (PickleContext.isCollectionImage_pctx(b)) || (!PickleContext.hasPrefix(b)))
/*      */     {
/* 2799 */       return null;
/*      */     }
/*      */     Object localObject;
/* 2803 */     if (!localPickleContext.readAndCheckVersion())
/*      */     {
/* 2805 */       localObject = DatabaseError.createSqlException(null, 1, "Image version is not recognized");
/* 2806 */       ((SQLException)localObject).fillInStackTrace();
/* 2807 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 2812 */     localPickleContext.skipLength();
/*      */ 
/* 2815 */     localPickleContext.skipLength();
/*      */ 
/* 2817 */     b = localPickleContext.readByte();
/*      */ 
/* 2820 */     if ((b & 0x4) != 0)
/*      */     {
/* 2822 */       localObject = localPickleContext.readBytes(16);
/*      */ 
/* 2824 */       return toid2typename(paramConnection, (byte[])localObject);
/*      */     }
/*      */ 
/* 2833 */     return null;
/*      */   }
/*      */ 
/*      */   public static String toid2typename(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 2843 */     String str = (String)((OracleConnection)paramConnection).getDescriptor(paramArrayOfByte);
/*      */ 
/* 2845 */     if (str == null)
/*      */     {
/* 2847 */       PreparedStatement localPreparedStatement = null;
/* 2848 */       ResultSet localResultSet = null;
/*      */ 
/* 2850 */       ((OracleConnection)paramConnection).beginNonRequestCalls();
/*      */       try
/*      */       {
/* 2853 */         localPreparedStatement = paramConnection.prepareStatement("select owner, type_name from all_types where type_oid = :1");
/*      */ 
/* 2856 */         localPreparedStatement.setBytes(1, paramArrayOfByte);
/*      */ 
/* 2858 */         localResultSet = localPreparedStatement.executeQuery();
/*      */ 
/* 2860 */         if (localResultSet.next())
/*      */         {
/* 2862 */           str = localResultSet.getString(1) + "." + localResultSet.getString(2);
/*      */ 
/* 2864 */           ((OracleConnection)paramConnection).putDescriptor(paramArrayOfByte, str);
/*      */         }
/*      */         else
/*      */         {
/* 2868 */           SQLException localSQLException = DatabaseError.createSqlException(null, 1, "Invalid type oid");
/* 2869 */           localSQLException.fillInStackTrace();
/* 2870 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2875 */         if (localResultSet != null) {
/* 2876 */           localResultSet.close();
/*      */         }
/* 2878 */         if (localPreparedStatement != null) {
/* 2879 */           localPreparedStatement.close();
/*      */         }
/*      */ 
/* 2885 */         ((OracleConnection)paramConnection).endNonRequestCalls();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2890 */     return str;
/*      */   }
/*      */ 
/*      */   public int getTdsVersion()
/*      */   {
/* 2897 */     return this.tdsVersion;
/*      */   }
/*      */ 
/*      */   public void printDebug()
/*      */   {
/*      */   }
/*      */ 
/*      */   private String debugText()
/*      */   {
/* 2916 */     StringWriter localStringWriter = new StringWriter();
/* 2917 */     PrintWriter localPrintWriter = new PrintWriter(localStringWriter);
/*      */ 
/* 2919 */     localPrintWriter.println("OracleTypeADT = " + this);
/* 2920 */     localPrintWriter.println("sqlName = " + this.sqlName);
/*      */ 
/* 2922 */     localPrintWriter.println("OracleType[] : ");
/*      */ 
/* 2924 */     if (this.attrTypes != null)
/*      */     {
/* 2926 */       for (int i = 0; i < this.attrTypes.length; i++)
/* 2927 */         localPrintWriter.println("[" + i + "] = " + this.attrTypes[i]);
/*      */     }
/*      */     else {
/* 2930 */       localPrintWriter.println("null");
/*      */     }
/* 2932 */     localPrintWriter.println("toid : ");
/*      */ 
/* 2934 */     if (this.toid != null)
/* 2935 */       printUnsignedByteArray(this.toid, localPrintWriter);
/*      */     else {
/* 2937 */       localPrintWriter.println("null");
/*      */     }
/*      */ 
/* 2940 */     localPrintWriter.println("tds version : " + this.tdsVersion);
/* 2941 */     localPrintWriter.println("type version : " + this.typeVersion);
/* 2942 */     localPrintWriter.println("type version : " + this.typeVersion);
/* 2943 */     localPrintWriter.println("opcode : " + this.opcode);
/*      */ 
/* 2945 */     localPrintWriter.println("tdoCState : " + this.tdoCState);
/*      */ 
/* 2947 */     return localStringWriter.getBuffer().substring(0);
/*      */   }
/*      */ 
/*      */   public byte[] getTOID()
/*      */   {
/*      */     try
/*      */     {
/* 2963 */       if (this.toid == null)
/*      */       {
/* 2966 */         initMetadata(this.connection);
/*      */       }
/*      */     }
/*      */     catch (SQLException localSQLException) {
/*      */     }
/* 2971 */     return this.toid;
/*      */   }
/*      */ 
/*      */   public int getImageFormatVersion()
/*      */   {
/* 2978 */     return PickleContext.KOPI20_VERSION;
/*      */   }
/*      */ 
/*      */   public int getTypeVersion()
/*      */   {
/*      */     try
/*      */     {
/* 2987 */       if (this.typeVersion == -1)
/*      */       {
/* 2989 */         initMetadata(this.connection);
/*      */       }
/*      */     } catch (SQLException localSQLException) {
/*      */     }
/* 2993 */     return this.typeVersion;
/*      */   }
/*      */ 
/*      */   public int getCharSet()
/*      */   {
/* 3000 */     return this.charSetId;
/*      */   }
/*      */ 
/*      */   public int getCharSetForm()
/*      */   {
/* 3007 */     return this.charSetForm;
/*      */   }
/*      */ 
/*      */   public long getTdoCState()
/*      */   {
/* 3017 */     synchronized (this.connection)
/*      */     {
/*      */       try
/*      */       {
/* 3021 */         if (this.tdoCState == 0L)
/*      */         {
/* 3023 */           if ((this.connection.getVersionNumber() >= 12000) && (this.typeNameByUser != null)) {
/* 3024 */             this.tdoCState = this.connection.getTdoCState(this.typeNameByUser);
/*      */           }
/*      */           else {
/* 3027 */             getFullName();
/* 3028 */             this.tdoCState = this.connection.getTdoCState(this.sqlName.getSchema(), this.sqlName.getSimpleName());
/*      */           }
/*      */         }
/*      */       }
/*      */       catch (SQLException localSQLException) {
/*      */       }
/* 3034 */       return this.tdoCState;
/*      */     }
/*      */   }
/*      */ 
/*      */   public long getFIXED_DATA_SIZE()
/*      */   {
/*      */     try
/*      */     {
/* 3044 */       return getFixedDataSize();
/*      */     }
/*      */     catch (SQLException localSQLException) {
/*      */     }
/* 3048 */     return 0L;
/*      */   }
/*      */ 
/*      */   public long getFixedDataSize()
/*      */     throws SQLException
/*      */   {
/* 3055 */     return this.fixedDataSize;
/*      */   }
/*      */ 
/*      */   public int getAlignmentReq()
/*      */     throws SQLException
/*      */   {
/* 3062 */     return this.alignmentRequirement;
/*      */   }
/*      */ 
/*      */   public int getNumAttrs()
/*      */     throws SQLException
/*      */   {
/* 3069 */     if ((this.attrTypes == null) && (this.connection != null)) {
/* 3070 */       init(this.connection);
/*      */     }
/* 3072 */     return this.attrTypes.length;
/*      */   }
/*      */ 
/*      */   public OracleType getAttrTypeAt(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3079 */     if ((this.attrTypes == null) && (this.connection != null)) {
/* 3080 */       init(this.connection);
/*      */     }
/* 3082 */     return this.attrTypes[paramInt];
/*      */   }
/*      */ 
/*      */   public boolean isEmbeddedADT()
/*      */     throws SQLException
/*      */   {
/* 3089 */     return (this.statusBits & 0x2) != 0;
/*      */   }
/*      */ 
/*      */   public boolean isUptADT()
/*      */     throws SQLException
/*      */   {
/* 3096 */     return (this.statusBits & 0x4) != 0;
/*      */   }
/*      */ 
/*      */   public boolean isTopADT()
/*      */     throws SQLException
/*      */   {
/* 3103 */     return (this.statusBits & 0x1) != 0;
/*      */   }
/*      */ 
/*      */   public void setStatus(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3110 */     this.statusBits = paramInt;
/*      */   }
/*      */ 
/*      */   void setEmbeddedADT()
/*      */     throws SQLException
/*      */   {
/* 3117 */     maskAndSetStatusBits(-16, 2);
/*      */   }
/*      */ 
/*      */   void setUptADT()
/*      */     throws SQLException
/*      */   {
/* 3124 */     maskAndSetStatusBits(-16, 4);
/*      */   }
/*      */ 
/*      */   public boolean isSubType()
/*      */     throws SQLException
/*      */   {
/* 3131 */     return (this.statusBits & 0x40) != 0;
/*      */   }
/*      */ 
/*      */   public boolean isFinalType()
/*      */     throws SQLException
/*      */   {
/* 3140 */     return ((this.statusBits & 0x20) != 0 ? 1 : 0) | ((this.statusBits & 0x2) != 0 ? 1 : 0);
/*      */   }
/*      */ 
/*      */   public boolean isJavaObject()
/*      */     throws SQLException
/*      */   {
/* 3148 */     return (this.statusBits & 0x10) != 0;
/*      */   }
/*      */ 
/*      */   public int getStatus()
/*      */     throws SQLException
/*      */   {
/* 3157 */     if (((this.statusBits & 0x1) != 0) && ((this.statusBits & 0x100) == 0))
/* 3158 */       init(this.connection);
/* 3159 */     return this.statusBits;
/*      */   }
/*      */ 
/*      */   public static OracleTypeADT shallowClone(OracleTypeADT paramOracleTypeADT)
/*      */     throws SQLException
/*      */   {
/* 3167 */     OracleTypeADT localOracleTypeADT = new OracleTypeADT();
/* 3168 */     shallowCopy(paramOracleTypeADT, localOracleTypeADT);
/* 3169 */     return localOracleTypeADT;
/*      */   }
/*      */ 
/*      */   public static void shallowCopy(OracleTypeADT paramOracleTypeADT1, OracleTypeADT paramOracleTypeADT2)
/*      */     throws SQLException
/*      */   {
/* 3177 */     paramOracleTypeADT2.connection = paramOracleTypeADT1.connection;
/* 3178 */     paramOracleTypeADT2.sqlName = paramOracleTypeADT1.sqlName;
/* 3179 */     paramOracleTypeADT2.parent = paramOracleTypeADT1.parent;
/* 3180 */     paramOracleTypeADT2.idx = paramOracleTypeADT1.idx;
/* 3181 */     paramOracleTypeADT2.descriptor = paramOracleTypeADT1.descriptor;
/* 3182 */     paramOracleTypeADT2.statusBits = paramOracleTypeADT1.statusBits;
/*      */ 
/* 3184 */     paramOracleTypeADT2.typeCode = paramOracleTypeADT1.typeCode;
/* 3185 */     paramOracleTypeADT2.dbTypeCode = paramOracleTypeADT1.dbTypeCode;
/* 3186 */     paramOracleTypeADT2.tdsVersion = paramOracleTypeADT1.tdsVersion;
/* 3187 */     paramOracleTypeADT2.typeVersion = paramOracleTypeADT1.typeVersion;
/* 3188 */     paramOracleTypeADT2.fixedDataSize = paramOracleTypeADT1.fixedDataSize;
/* 3189 */     paramOracleTypeADT2.alignmentRequirement = paramOracleTypeADT1.alignmentRequirement;
/* 3190 */     paramOracleTypeADT2.attrTypes = paramOracleTypeADT1.attrTypes;
/* 3191 */     paramOracleTypeADT2.sqlName = paramOracleTypeADT1.sqlName;
/* 3192 */     paramOracleTypeADT2.tdoCState = paramOracleTypeADT1.tdoCState;
/* 3193 */     paramOracleTypeADT2.toid = paramOracleTypeADT1.toid;
/* 3194 */     paramOracleTypeADT2.charSetId = paramOracleTypeADT1.charSetId;
/* 3195 */     paramOracleTypeADT2.charSetForm = paramOracleTypeADT1.charSetForm;
/* 3196 */     paramOracleTypeADT2.flattenedAttrNum = paramOracleTypeADT1.flattenedAttrNum;
/* 3197 */     paramOracleTypeADT2.statusBits = paramOracleTypeADT1.statusBits;
/* 3198 */     paramOracleTypeADT2.attrNames = paramOracleTypeADT1.attrNames;
/* 3199 */     paramOracleTypeADT2.attrTypeNames = paramOracleTypeADT1.attrTypeNames;
/* 3200 */     paramOracleTypeADT2.opcode = paramOracleTypeADT1.opcode;
/* 3201 */     paramOracleTypeADT2.idx = paramOracleTypeADT1.idx;
/*      */   }
/*      */ 
/*      */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*      */     throws IOException
/*      */   {
/* 3212 */     paramObjectOutputStream.writeInt(this.statusBits);
/* 3213 */     paramObjectOutputStream.writeInt(this.tdsVersion);
/* 3214 */     paramObjectOutputStream.writeInt(this.typeVersion);
/* 3215 */     paramObjectOutputStream.writeObject(null);
/* 3216 */     paramObjectOutputStream.writeObject(null);
/* 3217 */     paramObjectOutputStream.writeLong(this.fixedDataSize);
/* 3218 */     paramObjectOutputStream.writeInt(this.alignmentRequirement);
/* 3219 */     paramObjectOutputStream.writeObject(this.attrTypes);
/* 3220 */     paramObjectOutputStream.writeObject(this.attrNames);
/* 3221 */     paramObjectOutputStream.writeObject(this.attrTypeNames);
/* 3222 */     paramObjectOutputStream.writeLong(this.tdoCState);
/* 3223 */     paramObjectOutputStream.writeObject(this.toid);
/* 3224 */     paramObjectOutputStream.writeObject(null);
/* 3225 */     paramObjectOutputStream.writeInt(this.charSetId);
/* 3226 */     paramObjectOutputStream.writeInt(this.charSetForm);
/* 3227 */     paramObjectOutputStream.writeBoolean(true);
/* 3228 */     paramObjectOutputStream.writeInt(this.flattenedAttrNum);
/*      */   }
/*      */ 
/*      */   private void readObject(ObjectInputStream paramObjectInputStream)
/*      */     throws IOException, ClassNotFoundException
/*      */   {
/* 3236 */     this.statusBits = paramObjectInputStream.readInt();
/* 3237 */     this.tdsVersion = paramObjectInputStream.readInt();
/* 3238 */     this.typeVersion = paramObjectInputStream.readInt();
/* 3239 */     paramObjectInputStream.readObject();
/* 3240 */     paramObjectInputStream.readObject();
/* 3241 */     paramObjectInputStream.readLong();
/* 3242 */     paramObjectInputStream.readInt();
/* 3243 */     this.attrTypes = ((OracleType[])paramObjectInputStream.readObject());
/* 3244 */     this.attrNames = ((String[])paramObjectInputStream.readObject());
/* 3245 */     this.attrTypeNames = ((String[])paramObjectInputStream.readObject());
/* 3246 */     paramObjectInputStream.readLong();
/* 3247 */     this.toid = ((byte[])paramObjectInputStream.readObject());
/* 3248 */     paramObjectInputStream.readObject();
/* 3249 */     this.charSetId = paramObjectInputStream.readInt();
/* 3250 */     this.charSetForm = paramObjectInputStream.readInt();
/* 3251 */     paramObjectInputStream.readBoolean();
/* 3252 */     this.flattenedAttrNum = paramObjectInputStream.readInt();
/*      */   }
/*      */ 
/*      */   public void setConnection(OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/* 3258 */     synchronized (paramOracleConnection)
/*      */     {
/* 3260 */       this.connection = paramOracleConnection;
/* 3261 */       for (int i = 0; i < this.attrTypes.length; i++)
/* 3262 */         this.attrTypes[i].setConnection(this.connection);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void setStatusBits(int paramInt)
/*      */   {
/* 3269 */     synchronized (this.connection)
/*      */     {
/* 3271 */       this.statusBits |= paramInt;
/*      */     }
/*      */   }
/*      */ 
/*      */   private void maskAndSetStatusBits(int paramInt1, int paramInt2)
/*      */   {
/* 3278 */     synchronized (this.connection)
/*      */     {
/* 3280 */       this.statusBits &= paramInt1;
/* 3281 */       this.statusBits |= paramInt2;
/*      */     }
/*      */   }
/*      */ 
/*      */   private void printUnsignedByteArray(byte[] paramArrayOfByte, PrintWriter paramPrintWriter)
/*      */   {
/* 3290 */     int i = paramArrayOfByte.length;
/*      */ 
/* 3293 */     int[] arrayOfInt = Util.toJavaUnsignedBytes(paramArrayOfByte);
/*      */ 
/* 3295 */     for (int j = 0; j < i; j++)
/*      */     {
/* 3297 */       paramPrintWriter.print("0x" + Integer.toHexString(arrayOfInt[j]) + " ");
/*      */     }
/*      */ 
/* 3300 */     paramPrintWriter.println();
/*      */ 
/* 3302 */     for (j = 0; j < i; j++)
/*      */     {
/* 3304 */       paramPrintWriter.print(arrayOfInt[j] + " ");
/*      */     }
/*      */ 
/* 3307 */     paramPrintWriter.println();
/*      */   }
/*      */ 
/*      */   public void initChildNamesRecursively(Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 3315 */     TypeTreeElement localTypeTreeElement = (TypeTreeElement)paramMap.get(this.sqlName);
/*      */ 
/* 3317 */     if ((this.attrTypes != null) && (this.attrTypes.length > 0))
/*      */     {
/* 3319 */       for (int i = 0; i < this.attrTypes.length; i++)
/*      */       {
/* 3321 */         OracleType localOracleType = this.attrTypes[i];
/* 3322 */         localOracleType.setNames(localTypeTreeElement.getChildSchemaName(i + 1), localTypeTreeElement.getChildTypeName(i + 1));
/* 3323 */         localOracleType.initChildNamesRecursively(paramMap);
/* 3324 */         localOracleType.cacheDescriptor();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void cacheDescriptor()
/*      */     throws SQLException
/*      */   {
/* 3333 */     this.descriptor = StructDescriptor.createDescriptor(this);
/*      */   }
/*      */ 
/*      */   private void initMetaData1()
/*      */     throws SQLException
/*      */   {
/* 3345 */     int i = this.connection.getVersionNumber();
/*      */ 
/* 3347 */     if (i >= 9000)
/* 3348 */       initMetaData1_9_0();
/*      */     else
/* 3350 */       initMetaData1_pre_9_0();
/*      */   }
/*      */ 
/*      */   public Boolean isInstanciable()
/*      */     throws SQLException
/*      */   {
/* 3361 */     if (this.isInstanciable == null) initMetaData1();
/* 3362 */     return this.isInstanciable;
/*      */   }
/*      */ 
/*      */   public String getSuperTypeName()
/*      */     throws SQLException
/*      */   {
/* 3369 */     if (this.superTypeName == null) initMetaData1();
/* 3370 */     return this.superTypeName;
/*      */   }
/*      */ 
/*      */   public int getNumberOfLocalAttributes()
/*      */     throws SQLException
/*      */   {
/* 3377 */     if (this.numberOfLocalAttributes == -1) initMetaData1();
/* 3378 */     return this.numberOfLocalAttributes;
/*      */   }
/*      */ 
/*      */   public String[] getSubtypeNames()
/*      */     throws SQLException
/*      */   {
/* 3385 */     if (this.subTypeNames == null) initMetaData1();
/* 3386 */     return this.subTypeNames;
/*      */   }
/*      */ 
/*      */   private void initMetaData1_9_0()
/*      */     throws SQLException
/*      */   {
/* 3465 */     if (getTOID() != null) {
/* 3466 */       initMetaData1_9_0UseToid();
/* 3467 */       return;
/*      */     }
/*      */ 
/* 3470 */     int i = 0;
/*      */ 
/* 3473 */     if (this.sqlName == null) {
/* 3474 */       getFullName();
/*      */     }
/* 3476 */     synchronized (this.connection)
/*      */     {
/* 3478 */       synchronized (this)
/*      */       {
/* 3480 */         if (this.numberOfLocalAttributes == -1)
/*      */         {
/* 3482 */           PreparedStatement localPreparedStatement = null;
/* 3483 */           OracleCallableStatement localOracleCallableStatement = null;
/* 3484 */           ResultSet localResultSet = null;
/* 3485 */           int j = -1;
/* 3486 */           this.connection.beginNonRequestCalls();
/*      */           try
/*      */           {
/*      */             while (true)
/*      */             {
/* 3492 */               switch (i)
/*      */               {
/*      */               case 0:
/* 3495 */                 localPreparedStatement = this.connection.prepareStatement(this.initMetaData1_9_0_SQL[i]);
/*      */ 
/* 3498 */                 localPreparedStatement.setString(1, this.sqlName.getSimpleName());
/* 3499 */                 localPreparedStatement.setString(2, this.sqlName.getSchema());
/*      */ 
/* 3501 */                 localPreparedStatement.setFetchSize(1);
/* 3502 */                 localResultSet = localPreparedStatement.executeQuery();
/*      */ 
/* 3504 */                 break;
/*      */               case 1:
/*      */               case 2:
/*      */                 try
/*      */                 {
/* 3510 */                   localOracleCallableStatement = (OracleCallableStatement)this.connection.prepareCall(this.initMetaData1_9_0_SQL[i]);
/*      */ 
/* 3513 */                   localOracleCallableStatement.setString(1, this.sqlName.getSimpleName());
/* 3514 */                   localOracleCallableStatement.registerOutParameter(2, -10);
/*      */ 
/* 3517 */                   localOracleCallableStatement.execute();
/*      */ 
/* 3519 */                   localResultSet = localOracleCallableStatement.getCursor(2);
/* 3520 */                   localResultSet.setFetchSize(1);
/*      */                 }
/*      */                 catch (SQLException localSQLException1) {
/* 3523 */                   if (localSQLException1.getErrorCode() == 1403)
/*      */                   {
/* 3525 */                     if (i == 1)
/*      */                     {
/* 3527 */                       localOracleCallableStatement.close();
/* 3528 */                       i++;
/*      */                     }
/*      */                     else
/*      */                     {
/* 3534 */                       SQLException localSQLException3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Inconsistent catalog view");
/* 3535 */                       localSQLException3.fillInStackTrace();
/* 3536 */                       throw localSQLException3;
/*      */                     }
/*      */                   }
/*      */                   else
/*      */                   {
/* 3541 */                     throw localSQLException1;
/*      */                   }
/*      */ 
/*      */                 }
/*      */ 
/*      */               default:
/* 3548 */                 if (localResultSet.next())
/*      */                 {
/* 3550 */                   this.isInstanciable = new Boolean(localResultSet.getString(1).equals("YES"));
/* 3551 */                   this.superTypeName = (localResultSet.getString(2) + "." + localResultSet.getString(3));
/* 3552 */                   j = localResultSet.getInt(4);
/*      */ 
/* 3554 */                   break label429;
/*      */                 }
/*      */ 
/* 3559 */                 if (i == 2)
/*      */                 {
/* 3563 */                   SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Inconsistent catalog view");
/* 3564 */                   localSQLException2.fillInStackTrace();
/* 3565 */                   throw localSQLException2;
/*      */                 }
/*      */ 
/* 3569 */                 localResultSet.close();
/* 3570 */                 if (localOracleCallableStatement != null)
/* 3571 */                   localOracleCallableStatement.close();
/* 3572 */                 i++;
/*      */               }
/*      */             }
/*      */ 
/*      */           }
/*      */           finally
/*      */           {
/* 3579 */             label429: if (localResultSet != null) {
/* 3580 */               localResultSet.close();
/*      */             }
/* 3582 */             if (localPreparedStatement != null) {
/* 3583 */               localPreparedStatement.close();
/*      */             }
/* 3585 */             if (localOracleCallableStatement != null) {
/* 3586 */               localOracleCallableStatement.close();
/*      */             }
/*      */ 
/* 3591 */             this.connection.endNonRequestCalls();
/*      */           }
/* 3593 */           this.numberOfLocalAttributes = j;
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void initMetaData1_9_0UseToid()
/*      */     throws SQLException
/*      */   {
/* 3604 */     String str = "SELECT INSTANTIABLE, supertype_owner, supertype_name, LOCAL_ATTRIBUTES, cursor(select owner, type_name from all_types WHERE supertype_name = t.type_name and supertype_owner = t.owner)  FROM all_types t WHERE TYPE_OID = :3";
/*      */ 
/* 3609 */     PreparedStatement localPreparedStatement = null;
/* 3610 */     ResultSet localResultSet1 = null;
/* 3611 */     ResultSet localResultSet2 = null;
/*      */ 
/* 3614 */     if (this.sqlName == null) {
/* 3615 */       getFullName();
/*      */     }
/*      */     try
/*      */     {
/* 3619 */       this.connection.beginNonRequestCalls();
/* 3620 */       localPreparedStatement = this.connection.prepareStatement(str);
/* 3621 */       localPreparedStatement.setBytes(1, getTOID());
/*      */ 
/* 3623 */       localPreparedStatement.setFetchSize(1);
/* 3624 */       localResultSet1 = localPreparedStatement.executeQuery();
/*      */       Object localObject1;
/* 3625 */       if (localResultSet1.next())
/*      */       {
/* 3628 */         if (localResultSet1.getString(1) == null)
/* 3629 */           this.isInstanciable = Boolean.valueOf(true);
/*      */         else {
/* 3631 */           this.isInstanciable = new Boolean(localResultSet1.getString(1).equals("YES"));
/*      */         }
/* 3633 */         this.superTypeName = (localResultSet1.getString(2) + "." + localResultSet1.getString(3));
/* 3634 */         this.numberOfLocalAttributes = localResultSet1.getInt(4);
/* 3635 */         localResultSet2 = (ResultSet)localResultSet1.getObject(5);
/*      */ 
/* 3638 */         localObject1 = new ArrayList(5);
/* 3639 */         while (localResultSet2.next()) {
/* 3640 */           ((ArrayList)localObject1).add(localResultSet2.getString(1) + "." + localResultSet2.getString(2));
/*      */         }
/* 3642 */         this.subTypeNames = new String[((ArrayList)localObject1).size()];
/* 3643 */         for (int i = 0; i < this.subTypeNames.length; i++) {
/* 3644 */           this.subTypeNames[i] = ((String)((ArrayList)localObject1).get(i));
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 3649 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Inconsistent catalog view");
/* 3650 */         ((SQLException)localObject1).fillInStackTrace();
/* 3651 */         throw ((Throwable)localObject1);
/*      */       }
/*      */     }
/*      */     finally {
/* 3655 */       if (localResultSet2 != null) localResultSet2.close();
/* 3656 */       if (localResultSet1 != null) localResultSet1.close();
/* 3657 */       if (localPreparedStatement != null) localPreparedStatement.close();
/*      */ 
/* 3662 */       this.connection.endNonRequestCalls();
/*      */     }
/*      */   }
/*      */ 
/*      */   private synchronized void initMetaData1_pre_9_0()
/*      */     throws SQLException
/*      */   {
/* 3674 */     this.isInstanciable = new Boolean(true);
/* 3675 */     this.superTypeName = "";
/* 3676 */     this.numberOfLocalAttributes = 0;
/*      */   }
/*      */ 
/*      */   private void initMetaData2()
/*      */     throws SQLException
/*      */   {
/* 3688 */     int i = this.connection.getVersionNumber();
/*      */ 
/* 3690 */     if (i >= 9000) {
/* 3691 */       initMetaData2_9_0();
/*      */     }
/*      */     else
/* 3694 */       initMetaData2_pre_9_0();
/*      */   }
/*      */ 
/*      */   private void initMetaData2_9_0()
/*      */     throws SQLException
/*      */   {
/* 3706 */     if (getTOID() != null) {
/* 3707 */       initMetaData1_9_0UseToid();
/* 3708 */       return;
/*      */     }
/*      */ 
/* 3712 */     if (this.sqlName == null) {
/* 3713 */       getFullName();
/*      */     }
/* 3715 */     synchronized (this.connection)
/*      */     {
/* 3717 */       synchronized (this)
/*      */       {
/* 3719 */         if (this.subTypeNames == null)
/*      */         {
/* 3721 */           PreparedStatement localPreparedStatement = null;
/* 3722 */           ResultSet localResultSet = null;
/* 3723 */           String[] arrayOfString = null;
/* 3724 */           this.connection.beginNonRequestCalls();
/*      */           try
/*      */           {
/* 3727 */             localPreparedStatement = this.connection.prepareStatement("select owner, type_name from all_types where supertype_name = :1 and supertype_owner = :2");
/*      */ 
/* 3730 */             localPreparedStatement.setString(1, this.sqlName.getSimpleName());
/* 3731 */             localPreparedStatement.setString(2, this.sqlName.getSchema());
/*      */ 
/* 3733 */             localResultSet = localPreparedStatement.executeQuery();
/*      */ 
/* 3735 */             Vector localVector = new Vector();
/*      */ 
/* 3737 */             while (localResultSet.next()) {
/* 3738 */               localVector.addElement(localResultSet.getString(1) + "." + localResultSet.getString(2));
/*      */             }
/* 3740 */             arrayOfString = new String[localVector.size()];
/*      */ 
/* 3742 */             for (int i = 0; i < arrayOfString.length; i++) {
/* 3743 */               arrayOfString[i] = ((String)localVector.elementAt(i));
/*      */             }
/* 3745 */             localVector.removeAllElements();
/*      */ 
/* 3747 */             localVector = null;
/*      */           }
/*      */           finally
/*      */           {
/* 3751 */             if (localResultSet != null) {
/* 3752 */               localResultSet.close();
/*      */             }
/* 3754 */             if (localPreparedStatement != null) {
/* 3755 */               localPreparedStatement.close();
/*      */             }
/*      */ 
/* 3760 */             this.connection.endNonRequestCalls();
/*      */           }
/* 3762 */           this.subTypeNames = arrayOfString;
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void initMetaData2_pre_9_0()
/*      */     throws SQLException
/*      */   {
/* 3780 */     this.subTypeNames = new String[0];
/*      */   }
/*      */ 
/*      */   public void printXML(PrintWriter paramPrintWriter, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3791 */     printXML(paramPrintWriter, paramInt, false);
/*      */   }
/*      */ 
/*      */   public void printXML(PrintWriter paramPrintWriter, int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 3801 */     for (int i = 0; i < paramInt; i++) paramPrintWriter.print("  ");
/* 3802 */     paramPrintWriter.print("<OracleTypeADT sqlName=\"" + this.sqlName + "\" ");
/*      */ 
/* 3804 */     paramPrintWriter.print(" typecode=\"" + this.typeCode + "\"");
/* 3805 */     if (this.tdsVersion != -9999)
/* 3806 */       paramPrintWriter.print(" tds_version=\"" + this.tdsVersion + "\"");
/* 3807 */     paramPrintWriter.println();
/* 3808 */     for (i = 0; i < paramInt + 4; i++) paramPrintWriter.print("  ");
/* 3809 */     paramPrintWriter.println(" is_embedded=\"" + isEmbeddedADT() + "\"" + " is_top_level=\"" + isTopADT() + "\"" + " is_upt=\"" + isUptADT() + "\"" + " finalType=\"" + isFinalType() + "\"" + " subtype=\"" + isSubType() + "\">");
/*      */ 
/* 3815 */     if ((this.attrTypes != null) && (this.attrTypes.length > 0))
/*      */     {
/* 3817 */       for (i = 0; i < paramInt + 1; i++) paramPrintWriter.print("  ");
/* 3818 */       paramPrintWriter.println("<attributes>");
/* 3819 */       for (i = 0; i < this.attrTypes.length; i++)
/*      */       {
/* 3821 */         for (int j = 0; j < paramInt + 2; j++) paramPrintWriter.print("  ");
/*      */ 
/* 3824 */         paramPrintWriter.println("<attribute name=\"" + getAttributeName(i + 1, paramBoolean) + "\" " + " type=\"" + getAttributeType(i + 1, false) + "\" >");
/*      */ 
/* 3827 */         this.attrTypes[i].printXML(paramPrintWriter, paramInt + 3, paramBoolean);
/* 3828 */         for (j = 0; j < paramInt + 2; j++) paramPrintWriter.print("  ");
/* 3829 */         paramPrintWriter.println("</attribute> ");
/*      */       }
/* 3831 */       for (i = 0; i < paramInt + 1; i++) paramPrintWriter.print("  ");
/* 3832 */       paramPrintWriter.println("</attributes>");
/*      */     }
/* 3834 */     for (i = 0; i < paramInt; i++) paramPrintWriter.print("  ");
/* 3835 */     paramPrintWriter.println("</OracleTypeADT>");
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleTypeADT
 * JD-Core Version:    0.6.2
 */