/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.Serializable;
/*     */ import java.io.StringWriter;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.StructDescriptor;
/*     */ import oracle.sql.TypeDescriptor;
/*     */ 
/*     */ public abstract class OracleType
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = -4124152314660261528L;
/*     */   public static final int STYLE_ARRAY_LENGTH = 0;
/*     */   public static final int STYLE_DATUM = 1;
/*     */   public static final int STYLE_JAVA = 2;
/*     */   public static final int STYLE_RAWBYTE = 3;
/*     */   public static final int STYLE_INT = 4;
/*     */   public static final int STYLE_DOUBLE = 5;
/*     */   public static final int STYLE_FLOAT = 6;
/*     */   public static final int STYLE_LONG = 7;
/*     */   public static final int STYLE_SHORT = 8;
/*     */   public static final int STYLE_SKIP = 9;
/*     */   static final int FORMAT_ADT_ATTR = 1;
/*     */   static final int FORMAT_COLL_ELEM = 2;
/*     */   static final int FORMAT_COLL_ELEM_NO_INDICATOR = 3;
/*     */   static final int SQLCS_IMPLICIT = 1;
/*     */   static final int SQLCS_NCHAR = 2;
/*     */   static final int SQLCS_EXPLICIT = 3;
/*     */   static final int SQLCS_FLEXIBLE = 4;
/*     */   static final int SQLCS_LIT_NULL = 5;
/*     */   int typeCode;
/*     */   int dbTypeCode;
/*  72 */   boolean metaDataInitialized = false;
/*     */ 
/* 489 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleType()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleType(int paramInt)
/*     */   {
/*  82 */     this();
/*     */ 
/*  84 */     this.typeCode = paramInt;
/*     */   }
/*     */ 
/*     */   public boolean isInHierarchyOf(OracleType paramOracleType)
/*     */     throws SQLException
/*     */   {
/*  94 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isInHierarchyOf(StructDescriptor paramStructDescriptor)
/*     */     throws SQLException
/*     */   {
/* 102 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isObjectType()
/*     */   {
/* 109 */     return false;
/*     */   }
/*     */ 
/*     */   public TypeDescriptor getTypeDescriptor()
/*     */   {
/* 116 */     return null;
/*     */   }
/*     */ 
/*     */   public abstract Datum toDatum(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException;
/*     */ 
/*     */   public Datum toDatumInternal(Object paramObject, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 142 */     return toDatum(paramObject, paramOracleConnection);
/*     */   }
/*     */ 
/*     */   public Datum[] toDatumArrayInternal(Object paramObject, OracleConnection paramOracleConnection, long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 148 */     return toDatumArray(paramObject, paramOracleConnection, paramLong, paramInt);
/*     */   }
/*     */ 
/*     */   public Datum[] toDatumArray(Object paramObject, OracleConnection paramOracleConnection, long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 162 */     Datum[] arrayOfDatum = null;
/*     */ 
/* 164 */     if (paramObject != null)
/*     */     {
/*     */       Object localObject;
/* 166 */       if ((paramObject instanceof Object[]))
/*     */       {
/* 168 */         localObject = (Object[])paramObject;
/*     */ 
/* 170 */         int i = (int)(paramInt == -1 ? localObject.length : Math.min(localObject.length - paramLong + 1L, paramInt));
/*     */ 
/* 173 */         arrayOfDatum = new Datum[i];
/*     */ 
/* 175 */         for (int j = 0; j < i; j++)
/* 176 */           arrayOfDatum[j] = toDatum(localObject[((int)paramLong + j - 1)], paramOracleConnection);
/*     */       }
/*     */       else
/*     */       {
/* 180 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/* 181 */         ((SQLException)localObject).fillInStackTrace();
/* 182 */         throw ((Throwable)localObject);
/*     */       }
/*     */     }
/* 185 */     return arrayOfDatum;
/*     */   }
/*     */ 
/*     */   public void setTypeCode(int paramInt)
/*     */   {
/* 192 */     this.typeCode = paramInt;
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */     throws SQLException
/*     */   {
/* 200 */     return this.typeCode;
/*     */   }
/*     */ 
/*     */   public void setDBTypeCode(int paramInt)
/*     */   {
/* 207 */     this.dbTypeCode = paramInt;
/*     */   }
/*     */ 
/*     */   public int getDBTypeCode()
/*     */     throws SQLException
/*     */   {
/* 214 */     return this.dbTypeCode;
/*     */   }
/*     */ 
/*     */   public void parseTDSrec(TDSReader paramTDSReader)
/*     */     throws SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected Object unpickle81rec(PickleContext paramPickleContext, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 245 */     if (paramInt == 9)
/*     */     {
/* 247 */       paramPickleContext.skipDataValue();
/*     */ 
/* 249 */       return null;
/*     */     }
/*     */ 
/* 253 */     byte[] arrayOfByte = paramPickleContext.readDataValue();
/*     */ 
/* 255 */     return toObject(arrayOfByte, paramInt, paramMap);
/*     */   }
/*     */ 
/*     */   protected Object unpickle81rec(PickleContext paramPickleContext, byte paramByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 265 */     if (paramInt == 9)
/*     */     {
/* 267 */       paramPickleContext.skipDataValue();
/*     */ 
/* 269 */       return null;
/*     */     }
/*     */ 
/* 273 */     byte[] arrayOfByte = paramPickleContext.readDataValue(paramByte);
/*     */ 
/* 275 */     return toObject(arrayOfByte, paramInt, paramMap);
/*     */   }
/*     */ 
/*     */   protected Datum unpickle81datumAsNull(PickleContext paramPickleContext, byte paramByte1, byte paramByte2)
/*     */     throws SQLException
/*     */   {
/* 285 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/* 286 */     localSQLException.fillInStackTrace();
/* 287 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   protected Object toObject(byte[] paramArrayOfByte, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 297 */     return null;
/*     */   }
/*     */ 
/*     */   protected int pickle81(PickleContext paramPickleContext, Datum paramDatum)
/*     */     throws SQLException
/*     */   {
/* 313 */     int i = paramPickleContext.writeLength((int)paramDatum.getLength());
/*     */ 
/* 315 */     i += paramPickleContext.writeData(paramDatum.shareBytes());
/*     */ 
/* 317 */     return i;
/*     */   }
/*     */ 
/*     */   void writeSerializedFields(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/* 324 */     writeObject(paramObjectOutputStream);
/*     */   }
/*     */ 
/*     */   void readSerializedFields(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 332 */     readObject(paramObjectInputStream);
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/* 342 */     paramObjectOutputStream.writeInt(0);
/* 343 */     paramObjectOutputStream.writeInt(0);
/* 344 */     paramObjectOutputStream.writeInt(0);
/* 345 */     paramObjectOutputStream.writeInt(0);
/* 346 */     paramObjectOutputStream.writeInt(this.typeCode);
/* 347 */     paramObjectOutputStream.writeInt(this.dbTypeCode);
/* 348 */     paramObjectOutputStream.writeBoolean(this.metaDataInitialized);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 356 */     int i = paramObjectInputStream.readInt();
/* 357 */     int j = paramObjectInputStream.readInt();
/* 358 */     int k = paramObjectInputStream.readInt();
/* 359 */     int m = paramObjectInputStream.readInt();
/* 360 */     this.typeCode = paramObjectInputStream.readInt();
/* 361 */     this.dbTypeCode = paramObjectInputStream.readInt();
/* 362 */     this.metaDataInitialized = paramObjectInputStream.readBoolean();
/*     */   }
/*     */ 
/*     */   public void setConnection(OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean isNCHAR()
/*     */     throws SQLException
/*     */   {
/* 375 */     return false;
/*     */   }
/*     */ 
/*     */   public int getPrecision()
/*     */     throws SQLException
/*     */   {
/* 383 */     return 0;
/*     */   }
/*     */ 
/*     */   public int getScale()
/*     */     throws SQLException
/*     */   {
/* 390 */     return 0;
/*     */   }
/*     */ 
/*     */   public void initMetadataRecursively()
/*     */     throws SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void initNamesRecursively()
/*     */     throws SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void initChildNamesRecursively(Map paramMap)
/*     */     throws SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void cacheDescriptor()
/*     */     throws SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setNames(String paramString1, String paramString2)
/*     */     throws SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   public String toXMLString()
/*     */     throws SQLException
/*     */   {
/* 433 */     StringWriter localStringWriter = new StringWriter();
/* 434 */     PrintWriter localPrintWriter = new PrintWriter(localStringWriter);
/* 435 */     printXMLHeader(localPrintWriter);
/* 436 */     printXML(localPrintWriter, 0);
/* 437 */     return localStringWriter.getBuffer().substring(0);
/*     */   }
/*     */ 
/*     */   public void printXML(PrintStream paramPrintStream)
/*     */     throws SQLException
/*     */   {
/* 444 */     PrintWriter localPrintWriter = new PrintWriter(paramPrintStream, true);
/* 445 */     printXMLHeader(localPrintWriter);
/* 446 */     printXML(localPrintWriter, 0);
/*     */   }
/*     */ 
/*     */   void printXMLHeader(PrintWriter paramPrintWriter)
/*     */     throws SQLException
/*     */   {
/* 453 */     paramPrintWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
/*     */   }
/*     */ 
/*     */   public void printXML(PrintWriter paramPrintWriter, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 460 */     printXML(paramPrintWriter, paramInt, false);
/*     */   }
/*     */ 
/*     */   public void printXML(PrintWriter paramPrintWriter, int paramInt, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 466 */     for (int i = 0; i < paramInt; i++) paramPrintWriter.print("  ");
/* 467 */     paramPrintWriter.println("<OracleType typecode=\"" + this.typeCode + "\"" + " />");
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 484 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleType
 * JD-Core Version:    0.6.2
 */