/*     */ package oracle.jdbc.oracore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.Serializable;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.SQLName;
/*     */ import oracle.sql.TypeDescriptor;
/*     */ 
/*     */ public abstract class OracleNamedType extends OracleType
/*     */   implements Serializable
/*     */ {
/*     */   transient OracleConnection connection;
/*  34 */   SQLName sqlName = null;
/*  35 */   transient OracleTypeADT parent = null;
/*     */   transient int idx;
/*  37 */   transient TypeDescriptor descriptor = null;
/*     */   String typeNameByUser;
/* 371 */   static String getUserTypeTreeSql = "select level depth, parent_type, child_type, ATTR_NO, child_type_owner from  (select TYPE_NAME parent_type, ELEM_TYPE_NAME child_type, 0 ATTR_NO,       ELEM_TYPE_OWNER child_type_owner     from USER_COLL_TYPES  union   select TYPE_NAME parent_type, ATTR_TYPE_NAME child_type, ATTR_NO,       ATTR_TYPE_OWNER child_type_owner     from USER_TYPE_ATTRS  ) start with parent_type  = ?  connect by prior  child_type = parent_type";
/*     */ 
/* 386 */   String sqlHint = null;
/*     */ 
/* 456 */   static String getAllTypeTreeSql = "select parent_type, parent_type_owner, child_type, ATTR_NO, child_type_owner from ( select TYPE_NAME parent_type,  OWNER parent_type_owner,     ELEM_TYPE_NAME child_type, 0 ATTR_NO,     ELEM_TYPE_OWNER child_type_owner   from ALL_COLL_TYPES union   select TYPE_NAME parent_type, OWNER parent_type_owner,     ATTR_TYPE_NAME child_type, ATTR_NO,     ATTR_TYPE_OWNER child_type_owner   from ALL_TYPE_ATTRS ) start with parent_type  = ?  and parent_type_owner = ? connect by prior child_type = parent_type   and ( child_type_owner = parent_type_owner or child_type_owner is null )";
/*     */ 
/* 581 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected OracleNamedType()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleNamedType(String paramString, OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  47 */     setConnectionInternal(paramOracleConnection);
/*  48 */     this.typeNameByUser = paramString;
/*  49 */     this.sqlName = new SQLName(paramString, paramOracleConnection);
/*     */   }
/*     */ 
/*     */   protected OracleNamedType(OracleTypeADT paramOracleTypeADT, int paramInt, OracleConnection paramOracleConnection)
/*     */   {
/*  58 */     setConnectionInternal(paramOracleConnection);
/*  59 */     this.parent = paramOracleTypeADT;
/*  60 */     this.idx = paramInt;
/*     */   }
/*     */ 
/*     */   public String getFullName()
/*     */     throws SQLException
/*     */   {
/*  70 */     return getFullName(false);
/*     */   }
/*     */ 
/*     */   public String getFullName(boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*  78 */     String str = null;
/*     */ 
/*  80 */     if ((paramBoolean) || (this.sqlName == null))
/*     */     {
/*  83 */       if ((this.parent != null) && ((str = this.parent.getAttributeType(this.idx)) != null))
/*     */       {
/*  86 */         this.sqlName = new SQLName(str, this.connection);
/*     */       }
/*     */       else
/*     */       {
/*  90 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Unable to resolve name");
/*  91 */         localSQLException.fillInStackTrace();
/*  92 */         throw localSQLException;
/*     */       }
/*     */     }
/*  95 */     return this.sqlName.getName();
/*     */   }
/*     */ 
/*     */   public String getSchemaName()
/*     */     throws SQLException
/*     */   {
/* 102 */     if (this.sqlName == null) getFullName();
/* 103 */     return this.sqlName.getSchema();
/*     */   }
/*     */ 
/*     */   public String getSimpleName()
/*     */     throws SQLException
/*     */   {
/* 110 */     if (this.sqlName == null) getFullName();
/* 111 */     return this.sqlName.getSimpleName();
/*     */   }
/*     */ 
/*     */   public boolean hasName()
/*     */     throws SQLException
/*     */   {
/* 118 */     return this.sqlName != null;
/*     */   }
/*     */ 
/*     */   public OracleTypeADT getParent()
/*     */     throws SQLException
/*     */   {
/* 125 */     return this.parent;
/*     */   }
/*     */ 
/*     */   public void setParent(OracleTypeADT paramOracleTypeADT)
/*     */     throws SQLException
/*     */   {
/* 132 */     this.parent = paramOracleTypeADT;
/*     */   }
/*     */ 
/*     */   public int getOrder()
/*     */     throws SQLException
/*     */   {
/* 139 */     return this.idx;
/*     */   }
/*     */ 
/*     */   public void setOrder(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 146 */     this.idx = paramInt;
/*     */   }
/*     */ 
/*     */   public OracleConnection getConnection()
/*     */     throws SQLException
/*     */   {
/* 160 */     return this.connection;
/*     */   }
/*     */ 
/*     */   public void setConnection(OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 175 */     setConnectionInternal(paramOracleConnection);
/*     */   }
/*     */ 
/*     */   public void setConnectionInternal(OracleConnection paramOracleConnection)
/*     */   {
/* 182 */     this.connection = paramOracleConnection;
/*     */   }
/*     */ 
/*     */   public Datum unlinearize(byte[] paramArrayOfByte, long paramLong, Datum paramDatum, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 201 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 202 */     localSQLException.fillInStackTrace();
/* 203 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public Datum unlinearize(byte[] paramArrayOfByte, long paramLong1, Datum paramDatum, long paramLong2, int paramInt1, int paramInt2, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 223 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 224 */     localSQLException.fillInStackTrace();
/* 225 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public byte[] linearize(Datum paramDatum)
/*     */     throws SQLException
/*     */   {
/* 238 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 239 */     localSQLException.fillInStackTrace();
/* 240 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public TypeDescriptor getDescriptor()
/*     */     throws SQLException
/*     */   {
/* 248 */     return this.descriptor;
/*     */   }
/*     */ 
/*     */   public void setDescriptor(TypeDescriptor paramTypeDescriptor)
/*     */     throws SQLException
/*     */   {
/* 255 */     this.descriptor = paramTypeDescriptor;
/*     */   }
/*     */ 
/*     */   public int getTypeVersion()
/*     */   {
/* 262 */     return 1;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 276 */       paramObjectOutputStream.writeUTF(getFullName());
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 281 */       IOException localIOException = DatabaseError.createIOException(localSQLException);
/* 282 */       localIOException.fillInStackTrace();
/* 283 */       throw localIOException;
/*     */     }
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 293 */     String str = paramObjectInputStream.readUTF();
/*     */     try { this.sqlName = new SQLName(str, null); } catch (SQLException localSQLException) {
/* 295 */     }this.parent = null;
/* 296 */     this.idx = -1;
/*     */   }
/*     */ 
/*     */   public void fixupConnection(OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 304 */     if (this.connection == null) setConnection(paramOracleConnection);
/*     */   }
/*     */ 
/*     */   public void printXML(PrintWriter paramPrintWriter, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 316 */     printXML(paramPrintWriter, paramInt, false);
/*     */   }
/*     */ 
/*     */   public void printXML(PrintWriter paramPrintWriter, int paramInt, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 322 */     for (int i = 0; i < paramInt; i++) paramPrintWriter.print("  ");
/* 323 */     paramPrintWriter.println("<OracleNamedType/>");
/*     */   }
/*     */ 
/*     */   public void initNamesRecursively()
/*     */     throws SQLException
/*     */   {
/* 330 */     Map localMap = createTypesTreeMap();
/* 331 */     if (localMap.size() > 0)
/* 332 */       initChildNamesRecursively(localMap);
/*     */   }
/*     */ 
/*     */   public void setNames(String paramString1, String paramString2)
/*     */     throws SQLException
/*     */   {
/* 339 */     this.sqlName = new SQLName(paramString1, paramString2, this.connection);
/*     */   }
/*     */ 
/*     */   public void setSqlName(SQLName paramSQLName)
/*     */   {
/* 346 */     this.sqlName = paramSQLName;
/*     */   }
/*     */ 
/*     */   public Map createTypesTreeMap()
/*     */     throws SQLException
/*     */   {
/* 360 */     Map localMap = null;
/* 361 */     String str = this.connection.getDefaultSchemaNameForNamedTypes();
/* 362 */     if (this.sqlName.getSchema().equals(str)) {
/* 363 */       localMap = getNodeMapFromUserTypes();
/*     */     }
/* 365 */     if (localMap == null)
/* 366 */       localMap = getNodeMapFromAllTypes();
/* 367 */     return localMap;
/*     */   }
/*     */ 
/*     */   String getSqlHint()
/*     */     throws SQLException
/*     */   {
/* 390 */     if (this.sqlHint == null)
/*     */     {
/* 392 */       if (this.connection.getVersionNumber() >= 11000)
/* 393 */         this.sqlHint = "";
/*     */       else
/* 395 */         this.sqlHint = "/*+RULE*/";
/*     */     }
/* 397 */     return this.sqlHint;
/*     */   }
/*     */ 
/*     */   Map getNodeMapFromUserTypes()
/*     */     throws SQLException
/*     */   {
/* 405 */     HashMap localHashMap = new HashMap();
/* 406 */     PreparedStatement localPreparedStatement = null;
/* 407 */     ResultSet localResultSet = null;
/* 408 */     this.connection.beginNonRequestCalls();
/*     */     try
/*     */     {
/* 411 */       localPreparedStatement = this.connection.prepareStatement(getSqlHint() + getUserTypeTreeSql);
/* 412 */       localPreparedStatement.setString(1, this.sqlName.getSimpleName());
/* 413 */       localResultSet = localPreparedStatement.executeQuery();
/*     */ 
/* 415 */       while (localResultSet.next())
/*     */       {
/* 417 */         int i = localResultSet.getInt(1);
/* 418 */         String str1 = localResultSet.getString(2);
/* 419 */         String str2 = localResultSet.getString(3);
/* 420 */         int j = localResultSet.getInt(4);
/* 421 */         String str3 = localResultSet.getString(5);
/* 422 */         if ((str3 != null) && (!str3.equals(this.sqlName.getSchema())))
/*     */         {
/* 424 */           localHashMap = null;
/* 425 */           break;
/*     */         }
/* 427 */         if (str1.length() > 0)
/*     */         {
/* 429 */           SQLName localSQLName = new SQLName(this.sqlName.getSchema(), str1, this.connection);
/* 430 */           TypeTreeElement localTypeTreeElement = null;
/* 431 */           if (localHashMap.containsKey(localSQLName)) {
/* 432 */             localTypeTreeElement = (TypeTreeElement)localHashMap.get(localSQLName);
/*     */           }
/*     */           else {
/* 435 */             localTypeTreeElement = new TypeTreeElement(this.sqlName.getSchema(), str1);
/* 436 */             localHashMap.put(localSQLName, localTypeTreeElement);
/*     */           }
/* 438 */           localTypeTreeElement.putChild(this.sqlName.getSchema(), str2, j);
/*     */         }
/*     */       }
/*     */     }
/*     */     finally {
/* 443 */       if (localResultSet != null) localResultSet.close();
/* 444 */       if (localPreparedStatement != null) localPreparedStatement.close();
/*     */ 
/* 449 */       this.connection.endNonRequestCalls();
/*     */     }
/* 451 */     return localHashMap;
/*     */   }
/*     */ 
/*     */   Map getNodeMapFromAllTypes()
/*     */     throws SQLException
/*     */   {
/* 474 */     HashMap localHashMap = new HashMap();
/* 475 */     PreparedStatement localPreparedStatement = null;
/* 476 */     ResultSet localResultSet = null;
/* 477 */     this.connection.beginNonRequestCalls();
/*     */     try
/*     */     {
/* 480 */       localPreparedStatement = this.connection.prepareStatement(getSqlHint() + getAllTypeTreeSql);
/* 481 */       localPreparedStatement.setString(1, this.sqlName.getSimpleName());
/* 482 */       localPreparedStatement.setString(2, this.sqlName.getSchema());
/* 483 */       localResultSet = localPreparedStatement.executeQuery();
/*     */ 
/* 485 */       while (localResultSet.next())
/*     */       {
/* 487 */         String str1 = localResultSet.getString(1);
/* 488 */         String str2 = localResultSet.getString(2);
/* 489 */         String str3 = localResultSet.getString(3);
/* 490 */         int i = localResultSet.getInt(4);
/* 491 */         String str4 = localResultSet.getString(5);
/* 492 */         if (str4 == null) str4 = "SYS";
/* 493 */         if (str1.length() > 0)
/*     */         {
/* 495 */           SQLName localSQLName = new SQLName(str2, str1, this.connection);
/* 496 */           TypeTreeElement localTypeTreeElement = null;
/* 497 */           if (localHashMap.containsKey(localSQLName)) {
/* 498 */             localTypeTreeElement = (TypeTreeElement)localHashMap.get(localSQLName);
/*     */           }
/*     */           else {
/* 501 */             localTypeTreeElement = new TypeTreeElement(str2, str1);
/* 502 */             localHashMap.put(localSQLName, localTypeTreeElement);
/*     */           }
/* 504 */           localTypeTreeElement.putChild(str4, str3, i);
/*     */         }
/*     */       }
/*     */     }
/*     */     finally {
/* 509 */       if (localResultSet != null) localResultSet.close();
/* 510 */       if (localPreparedStatement != null) localPreparedStatement.close();
/*     */ 
/* 515 */       this.connection.endNonRequestCalls();
/*     */     }
/* 517 */     return localHashMap;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 532 */     return this.connection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.oracore.OracleNamedType
 * JD-Core Version:    0.6.2
 */