/*     */ package oracle.jdbc.internal;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.util.EventListener;
/*     */ 
/*     */ public abstract interface OracleStatement extends oracle.jdbc.OracleStatement, ACProxyable
/*     */ {
/*     */   public static final int DEFAULT_RSET_TYPE = 1;
/*     */   public static final int CLOSED = 0;
/*     */   public static final int ACTIVE = 1;
/*     */   public static final int CACHED = 2;
/*     */   public static final int NON_CACHED = 3;
/*     */   public static final byte IS_UNINITIALIZED = 0;
/*     */   public static final byte IS_SELECT = 1;
/*     */   public static final byte IS_DELETE = 2;
/*     */   public static final byte IS_INSERT = 4;
/*     */   public static final byte IS_MERGE = 8;
/*     */   public static final byte IS_UPDATE = 16;
/*     */   public static final byte IS_PLSQL_BLOCK = 32;
/*     */   public static final byte IS_CALL_BLOCK = 64;
/*     */   public static final byte IS_OTHER = -128;
/*     */   public static final byte IS_DML = 30;
/*     */   public static final byte IS_PLSQL = 96;
/*     */ 
/*     */   public abstract void setFixedString(boolean paramBoolean);
/*     */ 
/*     */   public abstract boolean getFixedString();
/*     */ 
/*     */   public abstract int sendBatch()
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract boolean getserverCursor();
/*     */ 
/*     */   public abstract int getcacheState();
/*     */ 
/*     */   public abstract int getstatementType();
/*     */ 
/*     */   public abstract SqlKind getSqlKind()
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract long getChecksum()
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract void registerBindChecksumListener(BindChecksumListener paramBindChecksumListener)
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract void setSnapshotSCN(long paramLong)
/*     */     throws SQLException;
/*     */ 
/*     */   public static abstract interface BindChecksumListener extends EventListener
/*     */   {
/*     */     public abstract boolean shouldContinue(long paramLong);
/*     */   }
/*     */ 
/*     */   public static enum SqlKind
/*     */   {
/* 150 */     SELECT(false, false, true, false, (byte)1), 
/* 151 */     DELETE(false, true, false, false, (byte)2), 
/* 152 */     INSERT(false, true, false, false, (byte)4), 
/* 153 */     MERGE(false, true, false, false, (byte)8), 
/* 154 */     UPDATE(false, true, false, false, (byte)16), 
/* 155 */     PLSQL_BLOCK(true, false, false, false, (byte)32), 
/* 156 */     CALL_BLOCK(true, false, false, false, (byte)64), 
/* 157 */     SELECT_FOR_UPDATE(false, false, true, false, (byte)1), 
/* 158 */     ALTER_SESSION(false, false, false, true, (byte)-128), 
/* 159 */     OTHER(false, false, false, true, (byte)-128), 
/* 160 */     UNINITIALIZED(false, false, false, false, (byte)0);
/*     */ 
/*     */     private final boolean dml;
/*     */     private final boolean plsqlOrCall;
/*     */     private final boolean select;
/*     */     private final boolean other;
/*     */     private final byte kind;
/*     */ 
/*     */     private SqlKind(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3, boolean paramBoolean4, byte paramByte) {
/* 173 */       this.dml = paramBoolean2;
/* 174 */       this.plsqlOrCall = paramBoolean1;
/* 175 */       this.select = paramBoolean3;
/* 176 */       this.other = paramBoolean4;
/* 177 */       this.kind = paramByte;
/*     */     }
/*     */ 
/*     */     public static final SqlKind valueOf(byte paramByte) {
/* 181 */       switch (paramByte) {
/*     */       case 2:
/* 183 */         return DELETE;
/*     */       case 4:
/* 185 */         return INSERT;
/*     */       case 8:
/* 187 */         return MERGE;
/*     */       case 16:
/* 189 */         return UPDATE;
/*     */       case -128:
/* 191 */         return OTHER;
/*     */       case 32:
/* 193 */         return PLSQL_BLOCK;
/*     */       case 64:
/* 195 */         return CALL_BLOCK;
/*     */       case 1:
/* 197 */         return SELECT;
/*     */       }
/* 199 */       return UNINITIALIZED;
/*     */     }
/*     */ 
/*     */     public boolean isPlsqlOrCall() {
/* 203 */       return this.plsqlOrCall; } 
/* 204 */     public boolean isDML() { return this.dml; } 
/* 205 */     public boolean isSELECT() { return this.select; } 
/* 206 */     public boolean isOTHER() { return this.other; } 
/* 207 */     public byte getKind() { return this.kind; }
/*     */ 
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.internal.OracleStatement
 * JD-Core Version:    0.6.2
 */