/*      */ package oracle.jdbc.internal;
/*      */ 
/*      */ import java.net.SocketException;
/*      */ import java.security.NoSuchAlgorithmException;
/*      */ import java.security.spec.InvalidKeySpecException;
/*      */ import java.sql.Connection;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.SQLException;
/*      */ import java.util.EnumSet;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Map;
/*      */ import java.util.Properties;
/*      */ import java.util.concurrent.Executor;
/*      */ import javax.transaction.xa.XAResource;
/*      */ import oracle.jdbc.aq.AQMessageProperties;
/*      */ import oracle.jdbc.oracore.OracleTypeADT;
/*      */ import oracle.jdbc.oracore.OracleTypeCLOB;
/*      */ import oracle.jdbc.pool.OracleConnectionCacheCallback;
/*      */ import oracle.jdbc.pool.OraclePooledConnection;
/*      */ import oracle.sql.ARRAY;
/*      */ import oracle.sql.ArrayDescriptor;
/*      */ import oracle.sql.BFILE;
/*      */ import oracle.sql.BLOB;
/*      */ import oracle.sql.BfileDBAccess;
/*      */ import oracle.sql.BlobDBAccess;
/*      */ import oracle.sql.CLOB;
/*      */ import oracle.sql.ClobDBAccess;
/*      */ import oracle.sql.CustomDatum;
/*      */ import oracle.sql.Datum;
/*      */ import oracle.sql.StructDescriptor;
/*      */ import oracle.sql.TIMESTAMPTZ;
/*      */ import oracle.sql.TIMEZONETAB;
/*      */ 
/*      */ public abstract interface OracleConnection extends oracle.jdbc.OracleConnection, ACProxyable
/*      */ {
/*      */   public static final String CONNECTION_PROPERTY_LOGON_CAP = "oracle.jdbc.thinLogonCapability";
/*      */   public static final String CONNECTION_PROPERTY_LOGON_CAP_DEFAULT = "o5";
/*      */   public static final byte CONNECTION_PROPERTY_LOGON_CAP_ACCESSMODE = 3;
/*      */   public static final String CONNECTION_PROPERTY_OCI_DEFAULT_DEFINES = "oracle.jdbc.useOCIDefaultDefines";
/*      */   public static final String CONNECTION_PROPERTY_OCI_DEFAULT_DEFINES_DEFAULT = "false";
/*      */   public static final byte CONNECTION_PROPERTY_OCI_DEFAULT_DEFINES_ACCESSMODE = 3;
/*      */   public static final String CONNECTION_PROPERTY_JMSNOTIFICATION = "oracle.jdbc.jmsNotification";
/*      */   public static final String CONNECTION_PROPERTY_JMSNOTIFICATION_DEFAULT = "false";
/*      */   public static final byte CONNECTION_PROPERTY_JMSNOTIFICATION_ACCESSMODE = 3;
/*      */   public static final String CONNECTION_PROPERTY_NLS_LANG_BACKDOOR = "oracle.jdbc.ociNlsLangBackwardCompatible";
/*      */   public static final String CONNECTION_PROPERTY_NLS_LANG_BACKDOOR_DEFAULT = "false";
/*      */   public static final byte CONNECTION_PROPERTY_NLS_LANG_BACKDOOR_ACCESSMODE = 3;
/*      */   public static final String CONNECTION_PROPERTY_SPAWN_NEW_THREAD_TO_CANCEL = "oracle.jdbc.spawnNewThreadToCancel";
/*      */   public static final String CONNECTION_PROPERTY_SPAWN_NEW_THREAD_TO_CANCEL_DEFAULT = "false";
/*      */   public static final byte CONNECTION_PROPERTY_SPAWN_NEW_THREAD_TO_CANCEL_ACCESSMODE = 3;
/*      */   public static final String CONNECTION_PROPERTY_OVERRIDE_ENABLE_READ_DATA_IN_LOCATOR = "oracle.jdbc.overrideEnableReadDataInLocator";
/*      */   public static final String CONNECTION_PROPERTY_OVERRIDE_ENABLE_READ_DATA_IN_LOCATOR_DEFAULT = "false";
/*      */   public static final byte CONNECTION_PROPERTY_OVERRIDE_ENABLE_READ_DATA_IN_LOCATOR_ACCESSMODE = 3;
/*      */   public static final String CONNECTION_PROPERTY_PERMIT_TIMESTAMP_DATE_MISMATCH = "oracle.jdbc.internal.permitBindDateDefineTimestampMismatch";
/*      */   public static final String CONNECTION_PROPERTY_PERMIT_TIMESTAMP_DATE_MISMATCH_DEFAULT = "false";
/*      */   public static final byte CONNECTION_PROPERTY_PERMIT_TIMESTAMP_DATE_MISMATCH_ACCESSMODE = 3;
/*      */   public static final String CONNECTION_PROPERTY_IGNORE_REPLAY_CTX_FROM_AUTH = "oracle.jdbc.ignoreReplayContextFromAuthentication";
/*      */   public static final String CONNECTION_PROPERTY_IGNORE_REPLAY_CTX_FROM_AUTH_DEFAULT = "false";
/*      */   public static final byte CONNECTION_PROPERTY_IGNORE_REPLAY_CTX_FROM_AUTH_ACCESSMODE = 1;
/*      */   public static final String CONNECTION_PROPERTY_DEFAULT_USE_JAVANETNIO = "oracle.jdbc.javaNetNio";
/*      */   public static final String CONNECTION_PROPERTY_DEFAULT_USE_JAVANETNIO_DEFAULT = "false";
/*      */   public static final byte CONNECTION_PROPERTY_DEFAULT_USE_JAVANETNIO_ACCESSMODE = 3;
/*      */   public static final String CONNECTION_PROPERTY_NS_DIRECT_BUFFER = "oracle.jdbc.nsDirectBuffer";
/*      */   public static final String CONNECTION_PROPERTY_NS_DIRECT_BUFFER_DEFAULT = "false";
/*      */   public static final byte CONNECTION_PROPERTY_NS_DIRECT_BUFFER_ACCESSMODE = 3;
/*      */   public static final String CONNECTION_PROPERTY_PLSQL_VARCHAR_PARAMETER_4K_ONLY = "oracle.jdbc.plsqlVarcharParameter4KOnly";
/*      */   public static final String CONNECTION_PROPERTY_PLSQL_VARCHAR_PARAMETER_4K_ONLY_DEFAULT = "false";
/*      */   public static final byte CONNECTION_PROPERTY_PLSQL_VARCHAR_PARAMETER_4K_ONLY_ACCESSMODE = 3;
/*      */   public static final String CONNECTION_PROPERTY_INSTANCE_NAME = "oracle.jdbc.targetInstanceName";
/*  265 */   public static final String CONNECTION_PROPERTY_INSTANCE_NAME_DEFAULT = null;
/*      */   public static final byte CONNECTION_PROPERTY_INSTANCE_NAME_ACCESSMODE = 3;
/*      */   public static final String CONNECTION_PROPERTY_ENABLE_OCI_FAST_APPLICATION_NOTIFICATION = "oracle.jdbc.enableOCIFastApplicationNotification";
/*      */   public static final String CONNECTION_PROPERTY_ENABLE_OCI_FAST_APPLICATION_NOTIFICATION_DEFAULT = "false";
/*      */   public static final byte CONNECTION_PROPERTY_ENABLE_OCI_FAST_APPLICATION_NOTIFICATION_ACCESSMODE = 3;
/*      */   public static final int CHAR_TO_ASCII = 0;
/*      */   public static final int CHAR_TO_UNICODE = 1;
/*      */   public static final int RAW_TO_ASCII = 2;
/*      */   public static final int RAW_TO_UNICODE = 3;
/*      */   public static final int UNICODE_TO_CHAR = 4;
/*      */   public static final int ASCII_TO_CHAR = 5;
/*      */   public static final int NONE = 6;
/*      */   public static final int JAVACHAR_TO_CHAR = 7;
/*      */   public static final int RAW_TO_JAVACHAR = 8;
/*      */   public static final int CHAR_TO_JAVACHAR = 9;
/*      */   public static final int GLOBAL_TXN = 1;
/*      */   public static final int NO_GLOBAL_TXN = 0;
/*      */   public static final int VARTYPE_MAXLEN_COMPAT_STANDARD = 1;
/*      */   public static final int VARTYPE_MAXLEN_COMPAT_EXTENDED = 2;
/*      */   public static final int VARTYPE_MAXLEN_STANDARD_METADATA = 4000;
/*      */   public static final int VARTYPE_MAXLEN_STANDARD_BIND = 32766;
/*      */   public static final int VARTYPE_MAXLEN_STANDARD_BIND_OUT = 32767;
/*      */   public static final int VARTYPE_MAXLEN_STANDARD_BIND_PLSQL_BUG3936526 = 32512;
/*      */   public static final int NVARTYPE_MAXLEN_STANDARD_METADATA = 4000;
/*      */   public static final int NVARTYPE_MAXLEN_STANDARD_BIND = 32766;
/*      */   public static final int RAWTYPE_MAXLEN_STANDARD_METADATA = 2000;
/*      */   public static final int RAWTYPE_MAXLEN_STANDARD_BIND_SQL = 4000;
/*      */   public static final int RAWTYPE_MAXLEN_STANDARD_BIND_PLSQL = 32766;
/*      */   public static final int VARTYPE_MAXLEN_EXTENDED_METADATA = 32767;
/*      */   public static final int VARTYPE_MAXLEN_EXTENDED_BIND = 32766;
/*      */   public static final int VARTYPE_MAXLEN_EXTENDED_BIND_OUT = 32767;
/*      */   public static final int VARTYPE_MAXLEN_STANDARD = 4000;
/*      */   public static final int RAWTYPE_MAXLEN_STANDARD = 2000;
/*      */   public static final int NVARTYPE_MAXLEN_STANDARD = 4000;
/*      */   public static final int VARTYPE_MAXLEN_EXTENDED = 32767;
/*      */   public static final int RAWTYPE_MAXLEN_EXTENDED = 32767;
/*      */   public static final int NVARTYPE_MAXLEN_EXTENDED = 32766;
/*      */ 
/*      */   public abstract int getVarTypeMaxLenCompat()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract short getStructAttrNCsId()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Map getTypeMap()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Properties getDBAccessProperties()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Properties getOCIHandles()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract String getDatabaseProductVersion()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract String getURL()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract short getVersionNumber()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Map getJavaObjectTypeMap();
/*      */ 
/*      */   public abstract void setJavaObjectTypeMap(Map paramMap);
/*      */ 
/*      */   public abstract byte getInstanceProperty(InstanceProperty paramInstanceProperty)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract BfileDBAccess createBfileDBAccess()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract BlobDBAccess createBlobDBAccess()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract ClobDBAccess createClobDBAccess()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void setDefaultFixedString(boolean paramBoolean);
/*      */ 
/*      */   public abstract boolean getDefaultFixedString();
/*      */ 
/*      */   public abstract oracle.jdbc.OracleConnection getWrapper();
/*      */ 
/*      */   public abstract Class classForNameAndSchema(String paramString1, String paramString2)
/*      */     throws ClassNotFoundException;
/*      */ 
/*      */   public abstract void setFDO(byte[] paramArrayOfByte)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract byte[] getFDO(boolean paramBoolean)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean getBigEndian()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Object getDescriptor(byte[] paramArrayOfByte);
/*      */ 
/*      */   public abstract void putDescriptor(byte[] paramArrayOfByte, Object paramObject)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract OracleConnection getPhysicalConnection();
/*      */ 
/*      */   public abstract void removeDescriptor(String paramString);
/*      */ 
/*      */   public abstract void removeAllDescriptor();
/*      */ 
/*      */   public abstract int numberOfDescriptorCacheEntries();
/*      */ 
/*      */   public abstract Enumeration descriptorCacheKeys();
/*      */ 
/*      */   public abstract long getTdoCState(String paramString1, String paramString2)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract long getTdoCState(String paramString)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract BufferCacheStatistics getByteBufferCacheStatistics();
/*      */ 
/*      */   public abstract BufferCacheStatistics getCharBufferCacheStatistics();
/*      */ 
/*      */   public abstract Datum toDatum(CustomDatum paramCustomDatum)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract short getDbCsId()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract short getJdbcCsId()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract short getNCharSet();
/*      */ 
/*      */   public abstract ResultSet newArrayDataResultSet(Datum[] paramArrayOfDatum, long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract ResultSet newArrayDataResultSet(ARRAY paramARRAY, long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract ResultSet newArrayLocatorResultSet(ArrayDescriptor paramArrayDescriptor, byte[] paramArrayOfByte, long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract ResultSetMetaData newStructMetaData(StructDescriptor paramStructDescriptor)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void getForm(OracleTypeADT paramOracleTypeADT, OracleTypeCLOB paramOracleTypeCLOB, int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int CHARBytesToJavaChars(byte[] paramArrayOfByte, int paramInt, char[] paramArrayOfChar)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int NCHARBytesToJavaChars(byte[] paramArrayOfByte, int paramInt, char[] paramArrayOfChar)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean IsNCharFixedWith();
/*      */ 
/*      */   public abstract short getDriverCharSet();
/*      */ 
/*      */   public abstract int getC2SNlsRatio();
/*      */ 
/*      */   public abstract int getMaxCharSize()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getMaxCharbyteSize();
/*      */ 
/*      */   public abstract int getMaxNCharbyteSize();
/*      */ 
/*      */   public abstract boolean isCharSetMultibyte(short paramShort);
/*      */ 
/*      */   public abstract int javaCharsToCHARBytes(char[] paramArrayOfChar, int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int javaCharsToNCHARBytes(char[] paramArrayOfChar, int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void setStartTime(long paramLong)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract long getStartTime()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean isStatementCacheInitialized();
/*      */ 
/*      */   public abstract void getPropertyForPooledConnection(OraclePooledConnection paramOraclePooledConnection)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void setTypeMap(Map paramMap)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract String getProtocolType();
/*      */ 
/*      */   public abstract Connection getLogicalConnection(OraclePooledConnection paramOraclePooledConnection, boolean paramBoolean)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void setTxnMode(int paramInt);
/*      */ 
/*      */   public abstract int getTxnMode();
/*      */ 
/*      */   public abstract int getHeapAllocSize()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getOCIEnvHeapAllocSize()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void setAbandonedTimeoutEnabled(boolean paramBoolean)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getHeartbeatNoChangeCount()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void closeInternal(boolean paramBoolean)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void cleanupAndClose(boolean paramBoolean)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract OracleConnectionCacheCallback getConnectionCacheCallbackObj()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Object getConnectionCacheCallbackPrivObj()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getConnectionCacheCallbackFlag()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Properties getServerSessionInfo()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract CLOB createClob(byte[] paramArrayOfByte)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract CLOB createClobWithUnpickledBytes(byte[] paramArrayOfByte)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract CLOB createClob(byte[] paramArrayOfByte, short paramShort)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract BLOB createBlob(byte[] paramArrayOfByte)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract BLOB createBlobWithUnpickledBytes(byte[] paramArrayOfByte)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract BFILE createBfile(byte[] paramArrayOfByte)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean isDescriptorSharable(OracleConnection paramOracleConnection)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract OracleStatement refCursorCursorToStatement(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract XAResource getXAResource()
/*      */     throws SQLException;
/*      */ 
/*      */   /** @deprecated */
/*      */   public abstract boolean isV8Compatible()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean getMapDateToTimestamp();
/*      */ 
/*      */   public abstract byte[] createLightweightSession(String paramString, KeywordValueLong[] paramArrayOfKeywordValueLong, int paramInt, KeywordValueLong[][] paramArrayOfKeywordValueLong1, int[] paramArrayOfInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void executeLightweightSessionPiggyback(int paramInt1, byte[] paramArrayOfByte, KeywordValueLong[] paramArrayOfKeywordValueLong, int paramInt2)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void doXSNamespaceOp(XSOperationCode paramXSOperationCode, byte[] paramArrayOfByte, XSNamespace[] paramArrayOfXSNamespace, XSNamespace[][] paramArrayOfXSNamespace1, XSSecureId paramXSSecureId)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void doXSNamespaceOp(XSOperationCode paramXSOperationCode, byte[] paramArrayOfByte, XSNamespace[] paramArrayOfXSNamespace, XSSecureId paramXSSecureId)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract byte[] doXSSessionCreateOp(XSSessionOperationCode paramXSSessionOperationCode, XSSecureId paramXSSecureId, byte[] paramArrayOfByte, XSPrincipal paramXSPrincipal, String paramString, XSNamespace[] paramArrayOfXSNamespace, XSSessionModeFlag paramXSSessionModeFlag, XSKeyval paramXSKeyval)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void doXSSessionDestroyOp(byte[] paramArrayOfByte1, XSSecureId paramXSSecureId, byte[] paramArrayOfByte2)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void doXSSessionAttachOp(int paramInt1, byte[] paramArrayOfByte1, XSSecureId paramXSSecureId, byte[] paramArrayOfByte2, XSPrincipal paramXSPrincipal, String[] paramArrayOfString1, String[] paramArrayOfString2, String[] paramArrayOfString3, XSNamespace[] paramArrayOfXSNamespace1, XSNamespace[] paramArrayOfXSNamespace2, XSNamespace[] paramArrayOfXSNamespace3, TIMESTAMPTZ paramTIMESTAMPTZ1, TIMESTAMPTZ paramTIMESTAMPTZ2, int paramInt2, long paramLong, XSKeyval paramXSKeyval, int[] paramArrayOfInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void doXSSessionDetachOp(int paramInt, byte[] paramArrayOfByte, XSSecureId paramXSSecureId, boolean paramBoolean)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void doXSSessionChangeOp(XSSessionSetOperationCode paramXSSessionSetOperationCode, byte[] paramArrayOfByte, XSSecureId paramXSSecureId, XSSessionParameters paramXSSessionParameters)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract String getDefaultSchemaNameForNamedTypes()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void setUsable(boolean paramBoolean);
/*      */ 
/*      */   public abstract Class getClassForType(String paramString, Map<String, Class> paramMap);
/*      */ 
/*      */   public abstract void addXSEventListener(XSEventListener paramXSEventListener)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void addXSEventListener(XSEventListener paramXSEventListener, Executor paramExecutor)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void removeXSEventListener(XSEventListener paramXSEventListener)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getTimezoneVersionNumber()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void removeAllXSEventListener()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract TIMEZONETAB getTIMEZONETAB()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract String getDatabaseTimeZone()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean getTimestamptzInGmt();
/*      */ 
/*      */   public abstract boolean getUse1900AsYearForTime();
/*      */ 
/*      */   public abstract boolean isDataInLocatorEnabled()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean isLobStreamPosStandardCompliant()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract long getCurrentSCN()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract EnumSet<TransactionState> getTransactionState()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean isConnectionSocketKeepAlive()
/*      */     throws SocketException, SQLException;
/*      */ 
/*      */   public abstract void setReplayOperations(EnumSet<ReplayOperation> paramEnumSet)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void setReplayingMode(boolean paramBoolean)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void beginNonRequestCalls()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void endNonRequestCalls()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void setReplayContext(ReplayContext[] paramArrayOfReplayContext)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract ReplayContext[] getReplayContext()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract ReplayContext getLastReplayContext()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void registerEndReplayCallback(EndReplayCallback paramEndReplayCallback)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getEOC()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract byte[] getDerivedKeyInternal(byte[] paramArrayOfByte, int paramInt)
/*      */     throws NoSuchAlgorithmException, InvalidKeySpecException, SQLException;
/*      */ 
/*      */   public abstract short getExecutingRPCFunctionCode();
/*      */ 
/*      */   public abstract String getExecutingRPCSQL();
/*      */ 
/*      */   public abstract void jmsEnqueue(String paramString, JMSEnqueueOptions paramJMSEnqueueOptions, JMSMessage paramJMSMessage, AQMessageProperties paramAQMessageProperties)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract JMSMessage jmsDequeue(String paramString, JMSDequeueOptions paramJMSDequeueOptions)
/*      */     throws SQLException;
/*      */ 
/*      */   /** @deprecated */
/*      */   public abstract JMSMessage jmsDequeue(String paramString1, JMSDequeueOptions paramJMSDequeueOptions, String paramString2)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Map<String, JMSNotificationRegistration> registerJMSNotification(String[] paramArrayOfString, Map<String, Properties> paramMap)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void unregisterJMSNotification(JMSNotificationRegistration paramJMSNotificationRegistration)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void ackJMSNotification(JMSNotificationRegistration paramJMSNotificationRegistration, byte[] paramArrayOfByte, JMSNotificationRegistration.Directive paramDirective)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getNegotiatedSDU()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void setPDBChangeEventListener(PDBChangeEventListener paramPDBChangeEventListener)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void setPDBChangeEventListener(PDBChangeEventListener paramPDBChangeEventListener, Executor paramExecutor)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void setChecksumMode(ChecksumMode paramChecksumMode)
/*      */     throws SQLException;
/*      */ 
/*      */   public static enum ChecksumMode
/*      */   {
/* 1631 */     NO_CHECKSUM(false, false), 
/* 1632 */     CALCULATE_CHECKSUM_FETCH(true, false), 
/* 1633 */     CALCULATE_CHECKSUM_BINDS(false, true), 
/* 1634 */     CALCULATE_CHECKSUM_ALL(true, true);
/*      */ 
/*      */     private boolean fetchChecksum;
/*      */     private boolean bindChecksum;
/*      */ 
/* 1639 */     private ChecksumMode(boolean paramBoolean1, boolean paramBoolean2) { this.fetchChecksum = paramBoolean1;
/* 1640 */       this.bindChecksum = paramBoolean2; }
/*      */ 
/*      */     public boolean needToCalculateFetchChecksum() {
/* 1643 */       return this.fetchChecksum; } 
/* 1644 */     public boolean needToCalculateBindChecksum() { return this.bindChecksum; }
/*      */ 
/*      */   }
/*      */ 
/*      */   public static abstract interface EndReplayCallback
/*      */   {
/*      */     public abstract void executeCallback()
/*      */       throws SQLException;
/*      */   }
/*      */ 
/*      */   public static enum ReplayOperation
/*      */   {
/* 1350 */     KPDSS_SESSSTATE_APPCONT_ENABLED(1L), 
/* 1351 */     KPDSS_SESSSTATE_STATIC(2L), 
/* 1352 */     KPDSS_SESSSTATE_REQUEST_BEGIN(4L), 
/* 1353 */     KPDSS_SESSSTATE_REQUEST_END(8L), 
/* 1354 */     KPDSS_SESSSTATE_NONREQUEST_CALL(16L);
/*      */ 
/*      */     private final long code;
/*      */ 
/* 1358 */     private ReplayOperation(long paramLong) { this.code = paramLong; }
/*      */ 
/*      */ 
/*      */     public final long getCode()
/*      */     {
/* 1363 */       return this.code;
/*      */     }
/*      */   }
/*      */ 
/*      */   public static abstract interface BufferCacheStatistics
/*      */   {
/*      */     public abstract int getId();
/*      */ 
/*      */     public abstract int[] getBufferSizes();
/*      */ 
/*      */     public abstract int getCacheHits(int paramInt);
/*      */ 
/*      */     public abstract int getCacheMisses(int paramInt);
/*      */ 
/*      */     public abstract int getBuffersCached(int paramInt);
/*      */ 
/*      */     public abstract int getBucketsFull(int paramInt);
/*      */ 
/*      */     public abstract int getReferencesCleared(int paramInt);
/*      */ 
/*      */     public abstract int getTooBigToCache();
/*      */   }
/*      */ 
/*      */   public static enum XSSessionSetOperationCode
/*      */   {
/* 1084 */     SESSION_SET_COOKIE(1), 
/* 1085 */     SESSION_SET_TIMEOUT(2), 
/* 1086 */     SESSION_REAUTH(3), 
/* 1087 */     SESSION_ENABLE_ROLE(4), 
/* 1088 */     SESSION_DISABLE_ROLE(5);
/*      */ 
/*      */     private final int code;
/*      */ 
/* 1092 */     private XSSessionSetOperationCode(int paramInt) { this.code = paramInt; }
/*      */ 
/*      */ 
/*      */     public final int getCode()
/*      */     {
/* 1097 */       return this.code;
/*      */     }
/*      */   }
/*      */ 
/*      */   public static enum XSSessionModeFlag
/*      */   {
/*  978 */     SECURE(0), 
/*  979 */     TRUSTED(1);
/*      */ 
/*      */     private final int code;
/*      */ 
/*  983 */     private XSSessionModeFlag(int paramInt) { this.code = paramInt; }
/*      */ 
/*      */ 
/*      */     public final int getCode()
/*      */     {
/*  988 */       return this.code;
/*      */     }
/*      */   }
/*      */ 
/*      */   public static enum XSSessionOperationCode
/*      */   {
/*  964 */     SESSION_CREATE(1);
/*      */ 
/*      */     private final int code;
/*      */ 
/*  968 */     private XSSessionOperationCode(int paramInt) { this.code = paramInt; }
/*      */ 
/*      */ 
/*      */     public final int getCode()
/*      */     {
/*  973 */       return this.code;
/*      */     }
/*      */   }
/*      */ 
/*      */   public static enum XSOperationCode
/*      */   {
/*  886 */     NAMESPACE_CREATE(1), 
/*  887 */     NAMESPACE_DELETE(2), 
/*  888 */     ATTRIBUTE_CREATE(3), 
/*  889 */     ATTRIBUTE_SET(4), 
/*  890 */     ATTRIBUTE_DELETE(5), 
/*  891 */     ATTRIBUTE_RESET(6), 
/*  892 */     NAMESPACE_GET(7), 
/*  893 */     ATTRIBUTE_GET(8);
/*      */ 
/*      */     private final int code;
/*      */ 
/*  897 */     private XSOperationCode(int paramInt) { this.code = paramInt; }
/*      */ 
/*      */ 
/*      */     public final int getCode()
/*      */     {
/*  902 */       return this.code;
/*      */     }
/*      */   }
/*      */ 
/*      */   public static enum TransactionState
/*      */   {
/*  454 */     TRANSACTION_STARTED, 
/*      */ 
/*  458 */     TRANSACTION_ENDED, 
/*      */ 
/*  462 */     TRANSACTION_READONLY, 
/*      */ 
/*  467 */     TRANSACTION_INTENTION;
/*      */   }
/*      */ 
/*      */   public static enum InstanceProperty
/*      */   {
/*  430 */     ASM_VOLUME_SUPPORTED, 
/*      */ 
/*  443 */     INSTANCE_TYPE;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.internal.OracleConnection
 * JD-Core Version:    0.6.2
 */