/*    */ package oracle.jdbc.internal;
/*    */ 
/*    */ public abstract interface JMSMessageProperties
/*    */ {
/*    */   public abstract String getHeaderProperties();
/*    */ 
/*    */   public abstract void setHeaderProperties(String paramString);
/*    */ 
/*    */   public abstract JMSMessageType getJMSMessageType();
/*    */ 
/*    */   public abstract void setJMSMessageType(JMSMessageType paramJMSMessageType);
/*    */ 
/*    */   public abstract String getUserProperties();
/*    */ 
/*    */   public abstract void setUserProperties(String paramString);
/*    */ 
/*    */   public static enum JMSMessageType
/*    */   {
/* 40 */     TEXT_MESSAGE(0), 
/* 41 */     BYTES_MESSAGE(1), 
/* 42 */     STREAM_MESSAGE(2), 
/* 43 */     MAP_MESSAGE(3), 
/* 44 */     OBJECT_MESSAGE(4), 
/* 45 */     MESSAGE(100);
/*    */ 
/*    */     private final int code;
/*    */ 
/*    */     private JMSMessageType(int paramInt) {
/* 50 */       this.code = paramInt;
/*    */     }
/*    */ 
/*    */     public final int getCode()
/*    */     {
/* 55 */       return this.code;
/*    */     }
/*    */ 
/*    */     public static final JMSMessageType getJMSMessageType(int paramInt)
/*    */     {
/* 60 */       if (paramInt == TEXT_MESSAGE.getCode())
/* 61 */         return TEXT_MESSAGE;
/* 62 */       if (paramInt == BYTES_MESSAGE.getCode())
/* 63 */         return BYTES_MESSAGE;
/* 64 */       if (paramInt == STREAM_MESSAGE.getCode())
/* 65 */         return STREAM_MESSAGE;
/* 66 */       if (paramInt == MAP_MESSAGE.getCode())
/* 67 */         return MAP_MESSAGE;
/* 68 */       if (paramInt == OBJECT_MESSAGE.getCode()) {
/* 69 */         return OBJECT_MESSAGE;
/*    */       }
/* 71 */       return MESSAGE;
/*    */     }
/*    */   }
/*    */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.internal.JMSMessageProperties
 * JD-Core Version:    0.6.2
 */