/*     */ package oracle.jdbc.internal;
/*     */ 
/*     */ public class JMSDequeueOptions
/*     */ {
/*     */   public static final int DEQUEUE_WAIT_FOREVER = 4;
/*     */   private DequeueMode attrDeqMode;
/*     */   private VisibilityOption attrVisibility;
/*     */   private int attrWait;
/*     */   private DeliveryFilter attrDeliveryMode;
/*     */   private String consumerName;
/*     */   private String correlation;
/*     */   private boolean retrieveMessageId;
/*     */   private String condition;
/* 159 */   private byte[] deqMessageId = null;
/*     */ 
/*     */   public JMSDequeueOptions()
/*     */   {
/* 163 */     this.consumerName = null;
/* 164 */     this.correlation = null;
/* 165 */     this.attrDeqMode = DequeueMode.REMOVE;
/* 166 */     this.deqMessageId = null;
/* 167 */     this.attrVisibility = VisibilityOption.IMMEDIATE;
/* 168 */     this.attrWait = 4;
/* 169 */     this.attrDeliveryMode = DeliveryFilter.PERSISTENT;
/*     */ 
/* 174 */     this.retrieveMessageId = false;
/*     */   }
/*     */ 
/*     */   public String getConsumerName() {
/* 178 */     return this.consumerName;
/*     */   }
/*     */ 
/*     */   public void setConsumerName(String paramString) {
/* 182 */     this.consumerName = paramString;
/*     */   }
/*     */ 
/*     */   public String getCorrelation() {
/* 186 */     return this.correlation;
/*     */   }
/*     */ 
/*     */   public void setCorrelation(String paramString) {
/* 190 */     this.correlation = paramString;
/*     */   }
/*     */ 
/*     */   public String getCondition() {
/* 194 */     return this.condition;
/*     */   }
/*     */ 
/*     */   public void setCondition(String paramString) {
/* 198 */     this.condition = paramString;
/*     */   }
/*     */ 
/*     */   public boolean isRetrieveMessageId() {
/* 202 */     return this.retrieveMessageId;
/*     */   }
/*     */ 
/*     */   public void setRetrieveMessageId(boolean paramBoolean) {
/* 206 */     this.retrieveMessageId = paramBoolean;
/*     */   }
/*     */ 
/*     */   public byte[] getDequeueMessageId() {
/* 210 */     return this.deqMessageId;
/*     */   }
/*     */ 
/*     */   public void setDequeueMessageId(byte[] paramArrayOfByte) {
/* 214 */     this.deqMessageId = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   public DeliveryFilter getDeliveryMode() {
/* 218 */     return this.attrDeliveryMode;
/*     */   }
/*     */ 
/*     */   public void setDeliveryMode(DeliveryFilter paramDeliveryFilter) {
/* 222 */     this.attrDeliveryMode = paramDeliveryFilter;
/*     */   }
/*     */ 
/*     */   public DequeueMode getDequeueMode() {
/* 226 */     return this.attrDeqMode;
/*     */   }
/*     */ 
/*     */   public void setDequeueMode(DequeueMode paramDequeueMode) {
/* 230 */     this.attrDeqMode = paramDequeueMode;
/*     */   }
/*     */ 
/*     */   public VisibilityOption getVisibility()
/*     */   {
/* 235 */     return this.attrVisibility;
/*     */   }
/*     */ 
/*     */   public void setVisibility(VisibilityOption paramVisibilityOption) {
/* 239 */     this.attrVisibility = paramVisibilityOption;
/*     */   }
/*     */ 
/*     */   public int getWait() {
/* 243 */     return this.attrWait;
/*     */   }
/*     */ 
/*     */   public void setWait(int paramInt) {
/* 247 */     this.attrWait = paramInt;
/*     */   }
/*     */ 
/*     */   public static enum DeliveryFilter
/*     */   {
/* 118 */     PERSISTENT(0), BUFFERED(128), PERSISTENT_OR_BUFFERED(256);
/*     */ 
/*     */     private final int mode;
/*     */ 
/* 122 */     private DeliveryFilter(int paramInt) { this.mode = paramInt; }
/*     */ 
/*     */ 
/*     */     public final int getCode()
/*     */     {
/* 129 */       return this.mode;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static enum DequeueMode
/*     */   {
/*  83 */     BROWSE(8), 
/*     */ 
/*  89 */     LOCKED(16), 
/*     */ 
/*  95 */     REMOVE(32), 
/*     */ 
/* 100 */     REMOVE_NODATA(64);
/*     */ 
/*     */     private final int mode;
/*     */ 
/*     */     private DequeueMode(int paramInt) {
/* 105 */       this.mode = paramInt;
/*     */     }
/*     */ 
/*     */     public final int getCode()
/*     */     {
/* 112 */       return this.mode;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static enum VisibilityOption
/*     */   {
/*  56 */     ON_COMMIT(1), 
/*     */ 
/*  62 */     IMMEDIATE(2);
/*     */ 
/*     */     private final int mode;
/*     */ 
/*  66 */     private VisibilityOption(int paramInt) { this.mode = paramInt; }
/*     */ 
/*     */ 
/*     */     public final int getCode()
/*     */     {
/*  73 */       return this.mode;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.internal.JMSDequeueOptions
 * JD-Core Version:    0.6.2
 */