/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.XSPrincipal;
/*     */ import oracle.jdbc.internal.XSSessionNamespace;
/*     */ import oracle.sql.TIMESTAMPTZ;
/*     */ 
/*     */ class XSSessionNamespaceI extends XSSessionNamespace
/*     */ {
/*     */   XSPrincipalI kpxssessnsuser;
/*     */   String kpxssessnstenant;
/*     */   byte[] kpxssessnstenantBytes;
/*     */   byte[] kpxssessnssid;
/*     */   byte[] kpxssessnscookie;
/*     */   long kpxssessnsproxy;
/*     */   long kpxssessnsaclids;
/*     */   long kpxssessnscreator;
/*     */   long kpxssessnsupdater;
/*     */   byte[] kpxssessnscrets;
/*     */   byte[] kpxssessnsaccts;
/*     */   byte[] kpxssessnsautts;
/*     */   int kpxssessnstimeout;
/* 277 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   XSSessionNamespaceI()
/*     */   {
/*  75 */     this.kpxssessnsuser = null;
/*  76 */     this.kpxssessnstenant = null;
/*  77 */     this.kpxssessnstenantBytes = null;
/*  78 */     this.kpxssessnssid = null;
/*  79 */     this.kpxssessnscookie = null;
/*  80 */     this.kpxssessnsproxy = 0L;
/*  81 */     this.kpxssessnsaclids = 0L;
/*  82 */     this.kpxssessnscreator = 0L;
/*  83 */     this.kpxssessnsupdater = 0L;
/*  84 */     this.kpxssessnscrets = null;
/*  85 */     this.kpxssessnsaccts = null;
/*  86 */     this.kpxssessnsautts = null;
/*  87 */     this.kpxssessnstimeout = 0;
/*     */   }
/*     */ 
/*     */   public XSPrincipal getPrincipal()
/*     */   {
/*  92 */     return this.kpxssessnsuser;
/*     */   }
/*     */ 
/*     */   public String getTenant() {
/*  96 */     return this.kpxssessnstenant;
/*     */   }
/*     */ 
/*     */   public byte[] getSessionId() {
/* 100 */     return this.kpxssessnssid;
/*     */   }
/*     */ 
/*     */   public byte[] getCookie() {
/* 104 */     return this.kpxssessnscookie;
/*     */   }
/*     */ 
/*     */   public long getProxyId() {
/* 108 */     return this.kpxssessnsproxy;
/*     */   }
/*     */ 
/*     */   public long getACLId() {
/* 112 */     return this.kpxssessnsaclids;
/*     */   }
/*     */ 
/*     */   public long getCreatedBy() {
/* 116 */     return this.kpxssessnscreator;
/*     */   }
/*     */ 
/*     */   public long getUpdatedBy() {
/* 120 */     return this.kpxssessnsupdater;
/*     */   }
/*     */ 
/*     */   public TIMESTAMPTZ getCreateTimestamp() {
/* 124 */     return new TIMESTAMPTZ(this.kpxssessnscrets);
/*     */   }
/*     */ 
/*     */   public TIMESTAMPTZ getAccessTimestamp() {
/* 128 */     return new TIMESTAMPTZ(this.kpxssessnsaccts);
/*     */   }
/*     */ 
/*     */   public TIMESTAMPTZ getAuthTimestamp() {
/* 132 */     return new TIMESTAMPTZ(this.kpxssessnsautts);
/*     */   }
/*     */ 
/*     */   public int getTimeout() {
/* 136 */     return this.kpxssessnstimeout;
/*     */   }
/*     */ 
/*     */   private void setPrincipal(XSPrincipal paramXSPrincipal)
/*     */     throws SQLException
/*     */   {
/* 142 */     this.kpxssessnsuser = ((XSPrincipalI)paramXSPrincipal);
/*     */   }
/*     */ 
/*     */   private void setTenant(String paramString) throws SQLException {
/* 146 */     this.kpxssessnstenant = paramString;
/*     */   }
/*     */ 
/*     */   private void setSessionId(byte[] paramArrayOfByte) throws SQLException {
/* 150 */     this.kpxssessnssid = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   private void setCookie(byte[] paramArrayOfByte) throws SQLException {
/* 154 */     this.kpxssessnscookie = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   private void setProxyId(long paramLong) throws SQLException {
/* 158 */     this.kpxssessnsproxy = paramLong;
/*     */   }
/*     */ 
/*     */   private void setACLId(long paramLong) throws SQLException {
/* 162 */     this.kpxssessnsaclids = paramLong;
/*     */   }
/*     */ 
/*     */   private void setCreatedBy(long paramLong) throws SQLException {
/* 166 */     this.kpxssessnscreator = paramLong;
/*     */   }
/*     */ 
/*     */   private void setUpdatedBy(long paramLong) throws SQLException {
/* 170 */     this.kpxssessnsupdater = paramLong;
/*     */   }
/*     */ 
/*     */   private void setCreateTimestamp(byte[] paramArrayOfByte) throws SQLException {
/* 174 */     this.kpxssessnscrets = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   private void setAccessTimestamp(byte[] paramArrayOfByte) throws SQLException {
/* 178 */     this.kpxssessnsaccts = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   private void setAuthTimestamp(byte[] paramArrayOfByte) throws SQLException {
/* 182 */     this.kpxssessnsautts = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   private void setTimeout(int paramInt) throws SQLException {
/* 186 */     this.kpxssessnstimeout = paramInt;
/*     */   }
/*     */ 
/*     */   static XSSessionNamespaceI unmarshal(T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException, IOException
/*     */   {
/* 192 */     XSPrincipalI localXSPrincipalI = XSPrincipalI.unmarshal(paramT4CMAREngine);
/*     */ 
/* 194 */     int[] arrayOfInt = new int[1];
/* 195 */     String str = null;
/* 196 */     int i = (int)paramT4CMAREngine.unmarshalUB4();
/* 197 */     if (i > 0)
/*     */     {
/* 199 */       arrayOfByte1 = new byte[i];
/* 200 */       paramT4CMAREngine.unmarshalCLR(arrayOfByte1, 0, arrayOfInt);
/* 201 */       str = paramT4CMAREngine.conv.CharBytesToString(arrayOfByte1, arrayOfInt[0]);
/*     */     }
/*     */ 
/* 204 */     byte[] arrayOfByte1 = null;
/* 205 */     int j = (int)paramT4CMAREngine.unmarshalUB4();
/* 206 */     if (j > 0)
/*     */     {
/* 208 */       paramT4CMAREngine.unmarshalUB1();
/* 209 */       arrayOfByte1 = paramT4CMAREngine.unmarshalNBytes(j);
/*     */     }
/*     */ 
/* 212 */     byte[] arrayOfByte2 = null;
/* 213 */     int k = (int)paramT4CMAREngine.unmarshalUB4();
/* 214 */     if (k > 0)
/*     */     {
/* 216 */       paramT4CMAREngine.unmarshalUB1();
/* 217 */       arrayOfByte2 = paramT4CMAREngine.unmarshalNBytes(k);
/*     */     }
/*     */ 
/* 220 */     long l1 = paramT4CMAREngine.unmarshalSB8();
/*     */ 
/* 222 */     long l2 = paramT4CMAREngine.unmarshalSB8();
/*     */ 
/* 224 */     long l3 = paramT4CMAREngine.unmarshalSB8();
/* 225 */     long l4 = paramT4CMAREngine.unmarshalSB8();
/*     */ 
/* 239 */     byte[] arrayOfByte3 = null;
/* 240 */     if (paramT4CMAREngine.unmarshalUB1() == 1)
/*     */     {
/* 242 */       int m = (int)paramT4CMAREngine.unmarshalUB4();
/* 243 */       arrayOfByte3 = paramT4CMAREngine.unmarshalNBytes(m);
/*     */     }
/*     */ 
/* 246 */     byte[] arrayOfByte4 = null;
/* 247 */     if (paramT4CMAREngine.unmarshalUB1() == 1)
/*     */     {
/* 249 */       int n = (int)paramT4CMAREngine.unmarshalUB4();
/* 250 */       arrayOfByte4 = paramT4CMAREngine.unmarshalNBytes(n);
/*     */     }
/* 252 */     byte[] arrayOfByte5 = null;
/* 253 */     if (paramT4CMAREngine.unmarshalUB1() == 1)
/*     */     {
/* 255 */       i1 = (int)paramT4CMAREngine.unmarshalUB4();
/* 256 */       arrayOfByte5 = paramT4CMAREngine.unmarshalNBytes(i1);
/*     */     }
/*     */ 
/* 259 */     int i1 = (int)paramT4CMAREngine.unmarshalUB4();
/* 260 */     XSSessionNamespaceI localXSSessionNamespaceI = new XSSessionNamespaceI();
/* 261 */     localXSSessionNamespaceI.setPrincipal(localXSPrincipalI);
/* 262 */     localXSSessionNamespaceI.setTenant(str);
/* 263 */     localXSSessionNamespaceI.setSessionId(arrayOfByte1);
/* 264 */     localXSSessionNamespaceI.setCookie(arrayOfByte2);
/* 265 */     localXSSessionNamespaceI.setProxyId(l1);
/* 266 */     localXSSessionNamespaceI.setACLId(l2);
/* 267 */     localXSSessionNamespaceI.setCreatedBy(l3);
/* 268 */     localXSSessionNamespaceI.setUpdatedBy(l4);
/* 269 */     localXSSessionNamespaceI.setCreateTimestamp(arrayOfByte3);
/* 270 */     localXSSessionNamespaceI.setAccessTimestamp(arrayOfByte4);
/* 271 */     localXSSessionNamespaceI.setAuthTimestamp(arrayOfByte5);
/* 272 */     localXSSessionNamespaceI.setTimeout(i1);
/* 273 */     return localXSSessionNamespaceI;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.XSSessionNamespaceI
 * JD-Core Version:    0.6.2
 */