/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.XSSecureId;
/*     */ 
/*     */ class XSSecureIdI extends XSSecureId
/*     */ {
/*     */   byte[] kpxssidpmac;
/*     */   byte[] kpxssidpmtid;
/*     */   long kpxssidpnonce;
/*     */ 
/*     */   XSSecureIdI()
/*     */   {
/*  33 */     this.kpxssidpmac = null;
/*  34 */     this.kpxssidpmtid = null;
/*  35 */     this.kpxssidpnonce = 0L;
/*     */   }
/*     */ 
/*     */   public void setMac(byte[] paramArrayOfByte) throws SQLException {
/*  39 */     this.kpxssidpmac = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   public void setMidtierId(byte[] paramArrayOfByte) throws SQLException {
/*  43 */     this.kpxssidpmtid = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   public void setNonce(long paramLong) throws SQLException {
/*  47 */     this.kpxssidpnonce = paramLong;
/*     */   }
/*     */ 
/*     */   public byte[] getMac()
/*     */   {
/*  52 */     return this.kpxssidpmac;
/*     */   }
/*     */ 
/*     */   public byte[] getMidtierId()
/*     */   {
/*  57 */     return this.kpxssidpmtid;
/*     */   }
/*     */ 
/*     */   public long getNonce()
/*     */   {
/*  62 */     return this.kpxssidpnonce;
/*     */   }
/*     */ 
/*     */   void marshal(T4CMAREngine paramT4CMAREngine) throws IOException
/*     */   {
/*  67 */     if (this.kpxssidpmac != null)
/*     */     {
/*  69 */       paramT4CMAREngine.marshalUB4(this.kpxssidpmac.length);
/*  70 */       paramT4CMAREngine.marshalCLR(this.kpxssidpmac, this.kpxssidpmac.length);
/*     */     }
/*     */     else {
/*  73 */       paramT4CMAREngine.marshalUB4(0L);
/*     */     }
/*  75 */     if (this.kpxssidpmtid != null)
/*     */     {
/*  77 */       paramT4CMAREngine.marshalUB4(this.kpxssidpmtid.length);
/*  78 */       paramT4CMAREngine.marshalCLR(this.kpxssidpmtid, this.kpxssidpmtid.length);
/*     */     }
/*     */     else {
/*  81 */       paramT4CMAREngine.marshalUB4(0L);
/*     */     }
/*  83 */     paramT4CMAREngine.marshalUB4(this.kpxssidpnonce);
/*     */   }
/*     */ 
/*     */   static XSSecureIdI unmarshal(T4CMAREngine paramT4CMAREngine) throws SQLException, IOException {
/*  87 */     byte[] arrayOfByte1 = null;
/*  88 */     byte[] arrayOfByte2 = null;
/*  89 */     long l = 0L;
/*     */ 
/*  91 */     int i = (int)paramT4CMAREngine.unmarshalUB4();
/*  92 */     if (i > 0) {
/*  93 */       arrayOfByte1 = paramT4CMAREngine.unmarshalNBytes(i);
/*     */     }
/*  95 */     int j = (int)paramT4CMAREngine.unmarshalUB4();
/*  96 */     if (j > 0) {
/*  97 */       arrayOfByte2 = paramT4CMAREngine.unmarshalNBytes(j);
/*     */     }
/*  99 */     l = paramT4CMAREngine.unmarshalUB4();
/*     */ 
/* 101 */     XSSecureIdI localXSSecureIdI = new XSSecureIdI();
/* 102 */     localXSSecureIdI.setMac(arrayOfByte1);
/* 103 */     localXSSecureIdI.setMidtierId(arrayOfByte2);
/* 104 */     localXSSecureIdI.setNonce(l);
/* 105 */     return localXSSecureIdI;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.XSSecureIdI
 * JD-Core Version:    0.6.2
 */