/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.XSPrincipal;
/*     */ import oracle.jdbc.internal.XSPrincipal.Flag;
/*     */ 
/*     */ class XSPrincipalI extends XSPrincipal
/*     */ {
/*     */   long kpxsprindbid;
/*     */   String kpxsprinname;
/*     */   byte[] kpxsprinnameBytes;
/*     */   byte[] kpxsprinuuid;
/*     */   XSPrincipal.Flag kpxsprinflg;
/*     */ 
/*     */   XSPrincipalI()
/*     */   {
/*  39 */     this.kpxsprindbid = 0L;
/*  40 */     this.kpxsprinname = null;
/*  41 */     this.kpxsprinnameBytes = null;
/*  42 */     this.kpxsprinuuid = null;
/*  43 */     this.kpxsprinflg = XSPrincipal.Flag.KPXS_PRIN_EXT;
/*     */   }
/*     */ 
/*     */   public void setDatabaseId(long paramLong) throws SQLException {
/*  47 */     this.kpxsprindbid = paramLong;
/*     */   }
/*     */ 
/*     */   public void setName(String paramString) throws SQLException {
/*  51 */     this.kpxsprinname = paramString;
/*     */   }
/*     */ 
/*     */   public void setUUID(byte[] paramArrayOfByte) throws SQLException {
/*  55 */     this.kpxsprinuuid = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   public void setFlag(XSPrincipal.Flag paramFlag) throws SQLException {
/*  59 */     this.kpxsprinflg = paramFlag;
/*     */   }
/*     */ 
/*     */   public long getDatabaseId()
/*     */   {
/*  64 */     return this.kpxsprindbid;
/*     */   }
/*     */ 
/*     */   public String getName() {
/*  68 */     return this.kpxsprinname;
/*     */   }
/*     */ 
/*     */   public byte[] getUUID() {
/*  72 */     return this.kpxsprinuuid;
/*     */   }
/*     */ 
/*     */   public XSPrincipal.Flag getFlag() {
/*  76 */     return this.kpxsprinflg;
/*     */   }
/*     */ 
/*     */   void doCharConversion(DBConversion paramDBConversion) throws SQLException
/*     */   {
/*  81 */     if (this.kpxsprinname != null)
/*  82 */       this.kpxsprinnameBytes = paramDBConversion.StringToCharBytes(this.kpxsprinname);
/*     */     else
/*  84 */       this.kpxsprinnameBytes = null;
/*     */   }
/*     */ 
/*     */   void marshal(T4CMAREngine paramT4CMAREngine) throws IOException
/*     */   {
/*  89 */     paramT4CMAREngine.marshalSB8(this.kpxsprindbid);
/*  90 */     if (this.kpxsprinnameBytes != null)
/*     */     {
/*  92 */       paramT4CMAREngine.marshalUB4(this.kpxsprinnameBytes.length);
/*  93 */       paramT4CMAREngine.marshalCLR(this.kpxsprinnameBytes, this.kpxsprinnameBytes.length);
/*     */     }
/*     */     else {
/*  96 */       paramT4CMAREngine.marshalUB4(0L);
/*     */     }
/*  98 */     if (this.kpxsprinuuid != null)
/*     */     {
/* 100 */       paramT4CMAREngine.marshalUB4(this.kpxsprinuuid.length);
/* 101 */       paramT4CMAREngine.marshalCLR(this.kpxsprinuuid, this.kpxsprinuuid.length);
/*     */     }
/*     */     else {
/* 104 */       paramT4CMAREngine.marshalUB4(0L);
/*     */     }
/* 106 */     paramT4CMAREngine.marshalUB4(this.kpxsprinflg.getMode());
/*     */   }
/*     */ 
/*     */   static XSPrincipalI unmarshal(T4CMAREngine paramT4CMAREngine) throws SQLException, IOException {
/* 110 */     int[] arrayOfInt = new int[1];
/*     */ 
/* 112 */     long l1 = paramT4CMAREngine.unmarshalSB8();
/*     */ 
/* 114 */     String str = null;
/* 115 */     int i = (int)paramT4CMAREngine.unmarshalUB4();
/* 116 */     if (i > 0)
/*     */     {
/* 118 */       arrayOfByte = new byte[i];
/* 119 */       paramT4CMAREngine.unmarshalCLR(arrayOfByte, 0, arrayOfInt);
/* 120 */       str = paramT4CMAREngine.conv.CharBytesToString(arrayOfByte, arrayOfInt[0]);
/*     */     }
/*     */ 
/* 123 */     byte[] arrayOfByte = null;
/* 124 */     int j = (int)paramT4CMAREngine.unmarshalUB4();
/* 125 */     if (j > 0)
/*     */     {
/* 127 */       paramT4CMAREngine.unmarshalUB1();
/* 128 */       arrayOfByte = paramT4CMAREngine.unmarshalNBytes(j);
/*     */     }
/*     */ 
/* 131 */     long l2 = paramT4CMAREngine.unmarshalUB4();
/*     */     XSPrincipal.Flag localFlag;
/* 133 */     if (l2 == XSPrincipal.Flag.KPXS_PRIN_EXT.getMode())
/* 134 */       localFlag = XSPrincipal.Flag.KPXS_PRIN_EXT;
/*     */     else {
/* 136 */       localFlag = XSPrincipal.Flag.KPXS_PRIN_USEDBID;
/*     */     }
/* 138 */     XSPrincipalI localXSPrincipalI = new XSPrincipalI();
/* 139 */     localXSPrincipalI.setDatabaseId(l1);
/* 140 */     localXSPrincipalI.setName(str);
/* 141 */     localXSPrincipalI.setUUID(arrayOfByte);
/* 142 */     localXSPrincipalI.setFlag(localFlag);
/* 143 */     return localXSPrincipalI;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.XSPrincipalI
 * JD-Core Version:    0.6.2
 */