/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.XSAttribute;
/*     */ import oracle.jdbc.internal.XSNamespace;
/*     */ import oracle.sql.TIMESTAMPTZ;
/*     */ 
/*     */ class XSNamespaceI extends XSNamespace
/*     */ {
/*     */   String namespaceName;
/*     */   byte[] namespaceNameBytes;
/*     */   String kpxsnshandler;
/*     */   byte[] kpxsnshandlerBytes;
/*     */   XSAttributeI[] attributes;
/*     */   byte[] timestampBytes;
/*     */   long flag;
/*     */   long[] aclList;
/* 292 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   XSNamespaceI()
/*     */   {
/*  81 */     this.namespaceName = null;
/*  82 */     this.namespaceNameBytes = null;
/*  83 */     this.kpxsnshandler = null;
/*  84 */     this.kpxsnshandlerBytes = null;
/*  85 */     this.attributes = null;
/*  86 */     this.timestampBytes = null;
/*  87 */     this.flag = 0L;
/*  88 */     this.aclList = null;
/*     */   }
/*     */ 
/*     */   public void setNamespaceName(String paramString) throws SQLException {
/*  92 */     this.namespaceName = paramString;
/*     */   }
/*     */ 
/*     */   public void setNamespaceHandler(String paramString) throws SQLException {
/*  96 */     this.kpxsnshandler = paramString;
/*     */   }
/*     */ 
/*     */   public void setTimestamp(TIMESTAMPTZ paramTIMESTAMPTZ) throws SQLException
/*     */   {
/* 101 */     this.timestampBytes = paramTIMESTAMPTZ.toBytes();
/*     */   }
/*     */ 
/*     */   private void setTimestamp(byte[] paramArrayOfByte) throws SQLException {
/* 105 */     this.timestampBytes = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   public void setACLIdList(long[] paramArrayOfLong) throws SQLException {
/* 109 */     this.aclList = paramArrayOfLong;
/*     */   }
/*     */ 
/*     */   public void setFlag(long paramLong) throws SQLException
/*     */   {
/* 114 */     this.flag = paramLong;
/*     */   }
/*     */ 
/*     */   public void setAttributes(XSAttribute[] paramArrayOfXSAttribute) throws SQLException
/*     */   {
/* 119 */     if (paramArrayOfXSAttribute != null) {
/* 120 */       XSAttributeI[] arrayOfXSAttributeI = new XSAttributeI[paramArrayOfXSAttribute.length];
/* 121 */       for (int i = 0; i < paramArrayOfXSAttribute.length; i++) {
/* 122 */         arrayOfXSAttributeI[i] = ((XSAttributeI)paramArrayOfXSAttribute[i]);
/*     */       }
/* 124 */       this.attributes = arrayOfXSAttributeI;
/*     */     }
/*     */   }
/*     */ 
/*     */   void doCharConversion(DBConversion paramDBConversion)
/*     */     throws SQLException
/*     */   {
/* 132 */     if (this.namespaceName != null)
/* 133 */       this.namespaceNameBytes = paramDBConversion.StringToCharBytes(this.namespaceName);
/*     */     else {
/* 135 */       this.namespaceNameBytes = null;
/*     */     }
/* 137 */     if (this.kpxsnshandler != null)
/* 138 */       this.kpxsnshandlerBytes = paramDBConversion.StringToCharBytes(this.kpxsnshandler);
/*     */     else {
/* 140 */       this.kpxsnshandlerBytes = null;
/*     */     }
/*     */ 
/* 143 */     if (this.attributes != null)
/* 144 */       for (int i = 0; i < this.attributes.length; i++)
/* 145 */         this.attributes[i].doCharConversion(paramDBConversion);
/*     */   }
/*     */ 
/*     */   public String getNamespaceName()
/*     */   {
/* 152 */     return this.namespaceName;
/*     */   }
/*     */ 
/*     */   public String getNamespaceHandler() {
/* 156 */     return this.kpxsnshandler;
/*     */   }
/*     */ 
/*     */   public TIMESTAMPTZ getTimestamp() {
/* 160 */     return new TIMESTAMPTZ(this.timestampBytes);
/*     */   }
/*     */ 
/*     */   public long getFlag()
/*     */   {
/* 165 */     return this.flag;
/*     */   }
/*     */ 
/*     */   public XSAttribute[] getAttributes()
/*     */   {
/* 170 */     return this.attributes;
/*     */   }
/*     */ 
/*     */   public long[] getACLIdList() {
/* 174 */     return this.aclList;
/*     */   }
/*     */ 
/*     */   void marshal(T4CMAREngine paramT4CMAREngine)
/*     */     throws IOException
/*     */   {
/* 184 */     if (this.namespaceNameBytes != null) {
/* 185 */       paramT4CMAREngine.marshalUB4(this.namespaceNameBytes.length);
/* 186 */       paramT4CMAREngine.marshalCLR(this.namespaceNameBytes, this.namespaceNameBytes.length);
/*     */     }
/*     */     else {
/* 189 */       paramT4CMAREngine.marshalUB4(0L);
/*     */     }
/* 191 */     if (this.kpxsnshandlerBytes != null) {
/* 192 */       paramT4CMAREngine.marshalUB4(this.kpxsnshandlerBytes.length);
/* 193 */       paramT4CMAREngine.marshalCLR(this.kpxsnshandlerBytes, this.kpxsnshandlerBytes.length);
/*     */     }
/*     */     else {
/* 196 */       paramT4CMAREngine.marshalUB4(0L);
/*     */     }
/* 198 */     if (this.timestampBytes != null) {
/* 199 */       paramT4CMAREngine.marshalUB4(this.timestampBytes.length);
/* 200 */       paramT4CMAREngine.marshalCLR(this.timestampBytes, this.timestampBytes.length);
/*     */     }
/*     */     else {
/* 203 */       paramT4CMAREngine.marshalUB4(0L);
/*     */     }
/* 205 */     paramT4CMAREngine.marshalUB4(this.flag);
/*     */     int i;
/* 207 */     if (this.attributes != null) {
/* 208 */       paramT4CMAREngine.marshalUB4(this.attributes.length);
/*     */ 
/* 211 */       paramT4CMAREngine.marshalUB1((short)28);
/* 212 */       for (i = 0; i < this.attributes.length; i++)
/* 213 */         this.attributes[i].marshal(paramT4CMAREngine);
/*     */     }
/*     */     else {
/* 216 */       paramT4CMAREngine.marshalUB4(0L);
/*     */     }
/* 218 */     if (this.aclList != null) {
/* 219 */       paramT4CMAREngine.marshalUB4(this.aclList.length);
/* 220 */       paramT4CMAREngine.marshalUB1((short)8);
/* 221 */       for (i = 0; i < this.aclList.length; i++)
/* 222 */         paramT4CMAREngine.marshalSB8(this.aclList[i]);
/*     */     }
/*     */     else {
/* 225 */       paramT4CMAREngine.marshalUB4(0L);
/*     */     }
/*     */   }
/*     */ 
/*     */   static XSNamespaceI unmarshal(T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException, IOException
/*     */   {
/* 237 */     int[] arrayOfInt = new int[1];
/* 238 */     String str1 = null;
/*     */ 
/* 241 */     int i = (int)paramT4CMAREngine.unmarshalUB4();
/* 242 */     if (i > 0) {
/* 243 */       byte[] arrayOfByte1 = new byte[i];
/* 244 */       paramT4CMAREngine.unmarshalCLR(arrayOfByte1, 0, arrayOfInt);
/* 245 */       str1 = paramT4CMAREngine.conv.CharBytesToString(arrayOfByte1, arrayOfInt[0]);
/*     */     }
/*     */ 
/* 248 */     int j = (int)paramT4CMAREngine.unmarshalUB4();
/* 249 */     String str2 = null;
/* 250 */     if (j > 0) {
/* 251 */       arrayOfByte2 = new byte[i];
/* 252 */       paramT4CMAREngine.unmarshalCLR(arrayOfByte2, 0, arrayOfInt);
/* 253 */       str2 = paramT4CMAREngine.conv.CharBytesToString(arrayOfByte2, arrayOfInt[0]);
/*     */     }
/*     */ 
/* 257 */     byte[] arrayOfByte2 = null;
/* 258 */     if (paramT4CMAREngine.unmarshalUB1() == 1) {
/* 259 */       int k = (int)paramT4CMAREngine.unmarshalUB4();
/* 260 */       arrayOfByte2 = paramT4CMAREngine.unmarshalNBytes(k);
/*     */     }
/*     */ 
/* 263 */     long l = paramT4CMAREngine.unmarshalUB4();
/*     */ 
/* 265 */     XSAttribute[] arrayOfXSAttribute = null;
/* 266 */     int m = (int)paramT4CMAREngine.unmarshalUB4();
/* 267 */     arrayOfXSAttribute = new XSAttribute[m];
/* 268 */     if (m > 0)
/* 269 */       paramT4CMAREngine.unmarshalUB1();
/* 270 */     for (int n = 0; n < m; n++) {
/* 271 */       arrayOfXSAttribute[n] = XSAttributeI.unmarshal(paramT4CMAREngine);
/*     */     }
/* 273 */     n = (int)paramT4CMAREngine.unmarshalUB4();
/* 274 */     long[] arrayOfLong = null;
/* 275 */     if (n > 0) {
/* 276 */       arrayOfLong = new long[n];
/* 277 */       for (int i1 = 0; i1 < n; i1++) {
/* 278 */         arrayOfLong[i1] = paramT4CMAREngine.unmarshalSB8();
/*     */       }
/*     */     }
/* 281 */     XSNamespaceI localXSNamespaceI = new XSNamespaceI();
/* 282 */     localXSNamespaceI.setNamespaceName(str1);
/* 283 */     localXSNamespaceI.setNamespaceHandler(str2);
/* 284 */     localXSNamespaceI.setTimestamp(arrayOfByte2);
/* 285 */     localXSNamespaceI.setFlag(l);
/* 286 */     localXSNamespaceI.setAttributes(arrayOfXSAttribute);
/* 287 */     localXSNamespaceI.setACLIdList(arrayOfLong);
/* 288 */     return localXSNamespaceI;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.XSNamespaceI
 * JD-Core Version:    0.6.2
 */