/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.XSAttribute;
/*     */ 
/*     */ class XSAttributeI extends XSAttribute
/*     */ {
/*     */   String attributeName;
/*     */   byte[] attributeNameBytes;
/*     */   String attributeValue;
/*     */   byte[] attributeValueBytes;
/*     */   String attributeDefaultValue;
/*     */   byte[] attributeDefaultValueBytes;
/*     */   long flag;
/*     */ 
/*     */   XSAttributeI()
/*     */   {
/*  60 */     this.attributeName = null;
/*  61 */     this.attributeValue = null;
/*  62 */     this.attributeDefaultValue = null;
/*  63 */     this.flag = 0L;
/*     */   }
/*     */ 
/*     */   public void setAttributeName(String paramString) throws SQLException {
/*  67 */     this.attributeName = paramString;
/*     */   }
/*     */ 
/*     */   void doCharConversion(DBConversion paramDBConversion) throws SQLException {
/*  71 */     if (this.attributeName != null)
/*  72 */       this.attributeNameBytes = paramDBConversion.StringToCharBytes(this.attributeName);
/*     */     else {
/*  74 */       this.attributeNameBytes = null;
/*     */     }
/*  76 */     if (this.attributeValue != null)
/*  77 */       this.attributeValueBytes = paramDBConversion.StringToCharBytes(this.attributeValue);
/*     */     else {
/*  79 */       this.attributeValueBytes = null;
/*     */     }
/*  81 */     if (this.attributeDefaultValue != null)
/*  82 */       this.attributeDefaultValueBytes = paramDBConversion.StringToCharBytes(this.attributeDefaultValue);
/*     */     else
/*  84 */       this.attributeDefaultValueBytes = null;
/*     */   }
/*     */ 
/*     */   public void setAttributeValue(String paramString) throws SQLException {
/*  88 */     this.attributeValue = paramString;
/*     */   }
/*     */ 
/*     */   public void setAttributeDefaultValue(String paramString) throws SQLException {
/*  92 */     this.attributeDefaultValue = paramString;
/*     */   }
/*     */ 
/*     */   public void setFlag(long paramLong) throws SQLException {
/*  96 */     this.flag = paramLong;
/*     */   }
/*     */ 
/*     */   public String getAttributeName()
/*     */   {
/* 101 */     return this.attributeName;
/*     */   }
/*     */ 
/*     */   public String getAttributeValue()
/*     */   {
/* 106 */     return this.attributeValue;
/*     */   }
/*     */ 
/*     */   public String getAttributeDefaultValue() {
/* 110 */     return this.attributeDefaultValue;
/*     */   }
/*     */ 
/*     */   public long getFlag() {
/* 114 */     return this.flag;
/*     */   }
/*     */ 
/*     */   void marshal(T4CMAREngine paramT4CMAREngine) throws IOException {
/* 118 */     if (this.attributeNameBytes != null)
/*     */     {
/* 120 */       paramT4CMAREngine.marshalUB4(this.attributeNameBytes.length);
/* 121 */       paramT4CMAREngine.marshalCLR(this.attributeNameBytes, this.attributeNameBytes.length);
/*     */     }
/*     */     else {
/* 124 */       paramT4CMAREngine.marshalUB4(0L);
/*     */     }
/* 126 */     if (this.attributeValueBytes != null)
/*     */     {
/* 128 */       paramT4CMAREngine.marshalUB4(this.attributeValueBytes.length);
/* 129 */       paramT4CMAREngine.marshalCLR(this.attributeValueBytes, this.attributeValueBytes.length);
/*     */     }
/*     */     else {
/* 132 */       paramT4CMAREngine.marshalUB4(0L);
/*     */     }
/* 134 */     if (this.attributeDefaultValueBytes != null)
/*     */     {
/* 136 */       paramT4CMAREngine.marshalUB4(this.attributeDefaultValueBytes.length);
/* 137 */       paramT4CMAREngine.marshalCLR(this.attributeDefaultValueBytes, this.attributeDefaultValueBytes.length);
/*     */     }
/*     */     else {
/* 140 */       paramT4CMAREngine.marshalUB4(0L);
/*     */     }
/* 142 */     paramT4CMAREngine.marshalUB4(this.flag);
/*     */   }
/*     */ 
/*     */   static XSAttributeI unmarshal(T4CMAREngine paramT4CMAREngine) throws SQLException, IOException {
/* 146 */     int[] arrayOfInt = new int[1];
/* 147 */     String str1 = null;
/* 148 */     String str2 = null;
/* 149 */     String str3 = null;
/*     */ 
/* 152 */     int i = (int)paramT4CMAREngine.unmarshalUB4();
/* 153 */     if (i > 0)
/*     */     {
/* 155 */       byte[] arrayOfByte1 = new byte[i];
/* 156 */       paramT4CMAREngine.unmarshalCLR(arrayOfByte1, 0, arrayOfInt);
/* 157 */       str1 = paramT4CMAREngine.conv.CharBytesToString(arrayOfByte1, arrayOfInt[0]);
/*     */     }
/* 159 */     int j = (int)paramT4CMAREngine.unmarshalUB4();
/* 160 */     if (j > 0)
/*     */     {
/* 162 */       byte[] arrayOfByte2 = new byte[j];
/* 163 */       paramT4CMAREngine.unmarshalCLR(arrayOfByte2, 0, arrayOfInt);
/* 164 */       str2 = paramT4CMAREngine.conv.CharBytesToString(arrayOfByte2, arrayOfInt[0]);
/*     */     }
/* 166 */     int k = (int)paramT4CMAREngine.unmarshalUB4();
/* 167 */     if (k > 0)
/*     */     {
/* 169 */       localObject = new byte[k];
/* 170 */       paramT4CMAREngine.unmarshalCLR((byte[])localObject, 0, arrayOfInt);
/* 171 */       str3 = paramT4CMAREngine.conv.CharBytesToString((byte[])localObject, arrayOfInt[0]);
/*     */     }
/* 173 */     long l = paramT4CMAREngine.unmarshalUB4();
/* 174 */     Object localObject = new XSAttributeI();
/* 175 */     ((XSAttributeI)localObject).setAttributeName(str1);
/* 176 */     ((XSAttributeI)localObject).setAttributeValue(str2);
/* 177 */     ((XSAttributeI)localObject).setAttributeDefaultValue(str3);
/* 178 */     ((XSAttributeI)localObject).setFlag(l);
/* 179 */     return localObject;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.XSAttributeI
 * JD-Core Version:    0.6.2
 */