/*       */ package oracle.jdbc.driver;
/*       */ 
/*       */ abstract class VarnumBinder extends Binder
/*       */ {
/*       */   static final boolean DEBUG = false;
/*       */   static final boolean SLOW_CONVERSIONS = true;
/* 16534 */   Binder theVarnumCopyingBinder = OraclePreparedStatementReadOnly.theStaticVarnumCopyingBinder;
/*       */   static final int LNXSGNBT = 128;
/*       */   static final byte LNXDIGS = 20;
/*       */   static final byte LNXEXPBS = 64;
/*       */   static final int LNXEXPMX = 127;
/* 16582 */   static final double[] factorTable = { 9.999999999999999E+253D, 1.E+252D, 9.999999999999999E+249D, 1.0E+248D, 1.E+246D, 1.E+244D, 1.E+242D, 1.0E+240D, 1.0E+238D, 1.E+236D, 1.0E+234D, 1.E+232D, 1.E+230D, 9.999999999999999E+227D, 1.0E+226D, 1.0E+224D, 1.0E+222D, 1.0E+220D, 1.E+218D, 1.0E+216D, 1.0E+214D, 9.999999999999999E+211D, 9.999999999999999E+209D, 1.0E+208D, 1.0E+206D, 1.0E+204D, 9.999999999999999E+201D, 1.0E+200D, 1.0E+198D, 1.0E+196D, 9.999999999999999E+193D, 1.0E+192D, 1.E+190D, 1.0E+188D, 1.0E+186D, 1.0E+184D, 1.E+182D, 1.0E+180D, 1.E+178D, 1.0E+176D, 1.E+174D, 1.E+172D, 1.0E+170D, 9.999999999999999E+167D, 9.999999999999999E+165D, 1.0E+164D, 9.999999999999999E+161D, 1.0E+160D, 1.0E+158D, 1.0E+156D, 1.0E+154D, 1.0E+152D, 1.0E+150D, 1.0E+148D, 9.999999999999999E+145D, 1.0E+144D, 1.E+142D, 1.E+140D, 1.0E+138D, 1.E+136D, 9.999999999999999E+133D, 1.0E+132D, 1.E+130D, 1.E+128D, 9.999999999999999E+125D, 1.0E+124D, 1.0E+122D, 1.0E+120D, 1.0E+118D, 1.0E+116D, 1.0E+114D, 9.999999999999999E+111D, 1.0E+110D, 1.0E+108D, 1.E+106D, 1.0E+104D, 1.0E+102D, 1.0E+100D, 1.0E+098D, 1.0E+096D, 1.0E+094D, 1.0E+092D, 1.0E+090D, 1.0E+088D, 1.0E+086D, 1.E+084D, 1.0E+082D, 1.0E+080D, 1.0E+078D, 1.0E+076D, 1.0E+074D, 9.999999999999999E+071D, 1.E+070D, 1.0E+068D, 1.0E+066D, 1.0E+064D, 1.0E+062D, 1.0E+060D, 9.999999999999999E+057D, 1.E+056D, 1.E+054D, 1.0E+052D, 1.E+050D, 1.0E+048D, 1.0E+046D, 1.E+044D, 1.0E+042D, 1.0E+040D, 1.0E+038D, 1.0E+036D, 1.0E+034D, 1.E+032D, 1.0E+030D, 1.0E+028D, 1.0E+026D, 1.0E+024D, 1.0E+022D, 1.0E+020D, 1.0E+018D, 10000000000000000.0D, 100000000000000.0D, 1000000000000.0D, 10000000000.0D, 100000000.0D, 1000000.0D, 10000.0D, 100.0D, 1.0D, 0.01D, 0.0001D, 1.0E-006D, 1.0E-008D, 1.0E-010D, 1.0E-012D, 1.0E-014D, 1.0E-016D, 1.E-018D, 1.0E-020D, 1.0E-022D, 9.999999999999999E-025D, 1.0E-026D, 1.0E-028D, 1.E-030D, 1.E-032D, 9.999999999999999E-035D, 9.999999999999999E-037D, 1.0E-038D, 9.999999999999999E-041D, 1.0E-042D, 1.0E-044D, 1.0E-046D, 1.0E-048D, 1.0E-050D, 1.0E-052D, 1.0E-054D, 1.0E-056D, 1.0E-058D, 1.0E-060D, 1.0E-062D, 1.0E-064D, 1.0E-066D, 1.E-068D, 1.0E-070D, 1.0E-072D, 1.0E-074D, 9.999999999999999E-077D, 1.0E-078D, 1.0E-080D, 1.0E-082D, 1.0E-084D, 1.E-086D, 9.999999999999999E-089D, 1.0E-090D, 1.0E-092D, 1.0E-094D, 9.999999999999999E-097D, 9.999999999999999E-099D, 1.0E-100D, 9.999999999999999E-103D, 9.999999999999999E-105D, 9.999999999999999E-107D, 1.0E-108D, 1.E-110D, 1.0E-112D, 1.E-114D, 1.0E-116D, 1.0E-118D, 1.0E-120D, 1.E-122D, 9.999999999999999E-125D, 1.0E-126D, 1.E-128D, 1.E-130D, 1.0E-132D, 1.0E-134D, 1.0E-136D, 1.E-138D, 1.0E-140D, 1.0E-142D, 1.0E-144D, 1.0E-146D, 9.999999999999999E-149D, 1.0E-150D, 1.E-152D, 1.0E-154D, 1.0E-156D, 1.E-158D, 1.0E-160D, 1.0E-162D, 1.0E-164D, 1.0E-166D, 1.0E-168D, 1.0E-170D, 1.0E-172D, 1.0E-174D, 1.0E-176D, 1.0E-178D, 1.0E-180D, 1.0E-182D, 1.E-184D, 9.999999999999999E-187D, 1.0E-188D, 1.0E-190D, 1.E-192D, 1.0E-194D, 1.0E-196D, 9.999999999999999E-199D, 1.0E-200D, 1.0E-202D, 1.0E-204D, 1.0E-206D, 1.E-208D, 1.0E-210D, 1.0E-212D, 9.999999999999999E-215D, 1.0E-216D, 1.0E-218D, 1.0E-220D, 1.0E-222D, 1.0E-224D, 9.999999999999999E-227D, 1.0E-228D, 1.0E-230D, 1.0E-232D, 1.0E-234D, 1.0E-236D, 1.0E-238D, 1.0E-240D, 1.0E-242D, 9.999999999999999E-245D, 1.0E-246D, 1.0E-248D, 1.E-250D, 9.999999999999999E-253D, 9.999999999999999E-255D };
/*       */   static final int MANTISSA_SIZE = 53;
/*       */   static final int expShift = 52;
/*       */   static final long fractHOB = 4503599627370496L;
/*       */   static final long fractMask = 4503599627370495L;
/*       */   static final int expBias = 1023;
/*       */   static final int maxSmallBinExp = 62;
/*       */   static final int minSmallBinExp = -21;
/*       */   static final long expOne = 4607182418800017408L;
/*       */   static final long highbyte = -72057594037927936L;
/*       */   static final long highbit = -9223372036854775808L;
/*       */   static final long lowbytes = 72057594037927935L;
/* 16631 */   static final int[] small5pow = { 1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125 };
/*       */ 
/* 16643 */   static final long[] long5pow = { 1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L };
/*       */ 
/* 16675 */   static final int[] n5bits = { 0, 3, 5, 7, 10, 12, 14, 17, 19, 21, 24, 26, 28, 31, 33, 35, 38, 40, 42, 45, 47, 49, 52, 54, 56, 59, 61 };
/*       */   static FDBigInt[] b5p;
/* 17678 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*       */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*       */   public static final boolean TRACE = false;
/*       */ 
/*       */   static void init(Binder paramBinder)
/*       */   {
/* 16540 */     paramBinder.type = 6;
/* 16541 */     paramBinder.bytelen = 22;
/*       */   }
/*       */ 
/*       */   VarnumBinder()
/*       */   {
/* 16548 */     init(this);
/*       */   }
/*       */ 
/*       */   Binder copyingBinder()
/*       */   {
/* 16555 */     return this.theVarnumCopyingBinder;
/*       */   }
/*       */ 
/*       */   static int setLongInternal(byte[] paramArrayOfByte, int paramInt, long paramLong)
/*       */   {
/* 16685 */     if (paramLong == 0L)
/*       */     {
/* 16687 */       paramArrayOfByte[paramInt] = -128;
/*       */ 
/* 16689 */       return 1;
/*       */     }
/*       */ 
/* 16692 */     if (paramLong == -9223372036854775808L)
/*       */     {
/* 16694 */       paramArrayOfByte[paramInt] = 53;
/* 16695 */       paramArrayOfByte[(paramInt + 1)] = 92;
/* 16696 */       paramArrayOfByte[(paramInt + 2)] = 79;
/* 16697 */       paramArrayOfByte[(paramInt + 3)] = 68;
/* 16698 */       paramArrayOfByte[(paramInt + 4)] = 29;
/* 16699 */       paramArrayOfByte[(paramInt + 5)] = 98;
/* 16700 */       paramArrayOfByte[(paramInt + 6)] = 33;
/* 16701 */       paramArrayOfByte[(paramInt + 7)] = 47;
/* 16702 */       paramArrayOfByte[(paramInt + 8)] = 24;
/* 16703 */       paramArrayOfByte[(paramInt + 9)] = 43;
/* 16704 */       paramArrayOfByte[(paramInt + 10)] = 93;
/* 16705 */       paramArrayOfByte[(paramInt + 11)] = 102;
/*       */ 
/* 16707 */       return 12;
/*       */     }
/*       */ 
/* 16710 */     int i = 10;
/* 16711 */     int j = 0;
/*       */ 
/* 16713 */     if (paramLong / 1000000000000000000L == 0L)
/*       */     {
/* 16715 */       i--;
/*       */ 
/* 16717 */       if (paramLong / 10000000000000000L == 0L)
/*       */       {
/* 16719 */         i--;
/*       */ 
/* 16721 */         if (paramLong / 100000000000000L == 0L)
/*       */         {
/* 16723 */           i--;
/*       */ 
/* 16725 */           if (paramLong / 1000000000000L == 0L)
/*       */           {
/* 16727 */             i--;
/*       */ 
/* 16729 */             if (paramLong / 10000000000L == 0L)
/*       */             {
/* 16731 */               i--;
/*       */ 
/* 16733 */               if (paramLong / 100000000L == 0L)
/*       */               {
/* 16735 */                 i--;
/*       */ 
/* 16737 */                 if (paramLong / 1000000L == 0L)
/*       */                 {
/* 16739 */                   i--;
/*       */ 
/* 16741 */                   if (paramLong / 10000L == 0L)
/*       */                   {
/* 16743 */                     i--;
/*       */ 
/* 16745 */                     if (paramLong / 100L == 0L)
/*       */                     {
/* 16747 */                       i--;
/*       */                     }
/*       */                   }
/*       */                 }
/*       */               }
/*       */             }
/*       */           }
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 16758 */     int k = paramInt + i;
/*       */     int m;
/* 16761 */     if (paramLong < 0L)
/*       */     {
/* 16763 */       paramLong = -paramLong;
/* 16764 */       paramArrayOfByte[paramInt] = ((byte)(63 - i));
/*       */       while (true)
/*       */       {
/* 16768 */         m = (int)(paramLong % 100L);
/*       */ 
/* 16770 */         if (j == 0)
/*       */         {
/* 16772 */           if (m != 0)
/*       */           {
/* 16774 */             paramArrayOfByte[(k + 1)] = 102;
/* 16775 */             j = k + 2 - paramInt;
/* 16776 */             paramArrayOfByte[k] = ((byte)(101 - m));
/*       */           }
/*       */         }
/*       */         else
/*       */         {
/* 16781 */           paramArrayOfByte[k] = ((byte)(101 - m));
/*       */         }
/*       */ 
/* 16784 */         k--; if (k == paramInt) {
/*       */           break;
/*       */         }
/* 16787 */         paramLong /= 100L;
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/* 16793 */     paramArrayOfByte[paramInt] = ((byte)(192 + i));
/*       */     while (true)
/*       */     {
/* 16797 */       m = (int)(paramLong % 100L);
/*       */ 
/* 16799 */       if (j == 0)
/*       */       {
/* 16801 */         if (m != 0)
/*       */         {
/* 16803 */           j = k + 1 - paramInt;
/* 16804 */           paramArrayOfByte[k] = ((byte)(m + 1));
/*       */         }
/*       */       }
/*       */       else
/*       */       {
/* 16809 */         paramArrayOfByte[k] = ((byte)(m + 1));
/*       */       }
/*       */ 
/* 16812 */       k--; if (k == paramInt) {
/*       */         break;
/*       */       }
/* 16815 */       paramLong /= 100L;
/*       */     }
/*       */ 
/* 16820 */     return j;
/*       */   }
/*       */ 
/*       */   static int countBits(long paramLong)
/*       */   {
/* 16833 */     if (paramLong == 0L) {
/* 16834 */       return 0;
/*       */     }
/* 16836 */     while ((paramLong & 0x0) == 0L)
/*       */     {
/* 16838 */       paramLong <<= 8;
/*       */     }
/*       */ 
/* 16841 */     while (paramLong > 0L)
/*       */     {
/* 16843 */       paramLong <<= 1;
/*       */     }
/*       */ 
/* 16846 */     int i = 0;
/*       */ 
/* 16848 */     while ((paramLong & 0xFFFFFFFF) != 0L)
/*       */     {
/* 16850 */       paramLong <<= 8;
/* 16851 */       i += 8;
/*       */     }
/*       */ 
/* 16854 */     while (paramLong != 0L)
/*       */     {
/* 16856 */       paramLong <<= 1;
/* 16857 */       i++;
/*       */     }
/*       */ 
/* 16860 */     return i;
/*       */   }
/*       */ 
/*       */   boolean roundup(char[] paramArrayOfChar, int paramInt)
/*       */   {
/* 16874 */     int i = paramInt - 1;
/* 16875 */     int j = paramArrayOfChar[i];
/*       */ 
/* 16877 */     if (j == 57)
/*       */     {
/* 16879 */       while ((j == 57) && (i > 0))
/*       */       {
/* 16881 */         paramArrayOfChar[i] = '0';
/* 16882 */         j = paramArrayOfChar[(--i)];
/*       */       }
/*       */ 
/* 16885 */       if (j == 57)
/*       */       {
/* 16889 */         paramArrayOfChar[0] = '1';
/*       */ 
/* 16891 */         return true;
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/* 16897 */     paramArrayOfChar[i] = ((char)(j + 1));
/*       */ 
/* 16899 */     return false;
/*       */   }
/*       */ 
/*       */   static FDBigInt big5pow(int paramInt)
/*       */   {
/* 16908 */     if (paramInt < 0) {
/* 16909 */       throw new RuntimeException("Assertion botch: negative power of 5");
/*       */     }
/* 16911 */     if (b5p == null)
/*       */     {
/* 16913 */       b5p = new FDBigInt[paramInt + 1];
/*       */     }
/* 16915 */     else if (b5p.length <= paramInt)
/*       */     {
/* 16917 */       FDBigInt[] arrayOfFDBigInt = new FDBigInt[paramInt + 1];
/*       */ 
/* 16919 */       System.arraycopy(b5p, 0, arrayOfFDBigInt, 0, b5p.length);
/*       */ 
/* 16921 */       b5p = arrayOfFDBigInt;
/*       */     }
/*       */ 
/* 16924 */     if (b5p[paramInt] != null)
/* 16925 */       return b5p[paramInt];
/* 16926 */     if (paramInt < small5pow.length)
/* 16927 */       return b5p[paramInt] =  = new FDBigInt(small5pow[paramInt]);
/* 16928 */     if (paramInt < long5pow.length) {
/* 16929 */       return b5p[paramInt] =  = new FDBigInt(long5pow[paramInt]);
/*       */     }
/*       */ 
/* 16941 */     int i = paramInt >> 1;
/* 16942 */     int j = paramInt - i;
/*       */ 
/* 16944 */     FDBigInt localFDBigInt1 = b5p[i];
/*       */ 
/* 16946 */     if (localFDBigInt1 == null) {
/* 16947 */       localFDBigInt1 = big5pow(i);
/*       */     }
/* 16949 */     if (j < small5pow.length)
/*       */     {
/* 16951 */       return b5p[paramInt] =  = localFDBigInt1.mult(small5pow[j]);
/*       */     }
/*       */ 
/* 16955 */     FDBigInt localFDBigInt2 = b5p[j];
/*       */ 
/* 16957 */     if (localFDBigInt2 == null) {
/* 16958 */       localFDBigInt2 = big5pow(j);
/*       */     }
/* 16960 */     return b5p[paramInt] =  = localFDBigInt1.mult(localFDBigInt2);
/*       */   }
/*       */ 
/*       */   static FDBigInt multPow52(FDBigInt paramFDBigInt, int paramInt1, int paramInt2)
/*       */   {
/* 16969 */     if (paramInt1 != 0)
/*       */     {
/* 16971 */       if (paramInt1 < small5pow.length)
/*       */       {
/* 16973 */         paramFDBigInt = paramFDBigInt.mult(small5pow[paramInt1]);
/*       */       }
/*       */       else
/*       */       {
/* 16977 */         paramFDBigInt = paramFDBigInt.mult(big5pow(paramInt1));
/*       */       }
/*       */     }
/*       */ 
/* 16981 */     if (paramInt2 != 0)
/*       */     {
/* 16983 */       paramFDBigInt.lshiftMe(paramInt2);
/*       */     }
/*       */ 
/* 16986 */     return paramFDBigInt;
/*       */   }
/*       */ 
/*       */   static FDBigInt constructPow52(int paramInt1, int paramInt2)
/*       */   {
/* 16996 */     FDBigInt localFDBigInt = new FDBigInt(big5pow(paramInt1));
/*       */ 
/* 16998 */     if (paramInt2 != 0)
/*       */     {
/* 17000 */       localFDBigInt.lshiftMe(paramInt2);
/*       */     }
/*       */ 
/* 17003 */     return localFDBigInt;
/*       */   }
/*       */ 
/*       */   int dtoa(byte[] paramArrayOfByte, int paramInt1, double paramDouble, boolean paramBoolean1, boolean paramBoolean2, char[] paramArrayOfChar, int paramInt2, long paramLong, int paramInt3)
/*       */   {
/* 17011 */     int i = 2147483647;
/* 17012 */     int j = -1;
/* 17013 */     int k = countBits(paramLong);
/*       */ 
/* 17015 */     int m = k - paramInt2 - 1;
/*       */ 
/* 17018 */     int i1 = 0;
/*       */ 
/* 17024 */     if (m < 0)
/* 17025 */       m = 0;
/*       */     int i11;
/*       */     int i8;
/*       */     int i9;
/*       */     int i10;
/* 17027 */     if ((paramInt2 <= 62) && (paramInt2 >= -21))
/*       */     {
/* 17033 */       if ((m < long5pow.length) && (k + n5bits[m] < 64))
/*       */       {
/* 17054 */         if (m == 0)
/*       */         {
/*       */           long l1;
/* 17056 */           if (paramInt2 > paramInt3)
/*       */           {
/* 17058 */             l1 = 1L << paramInt2 - paramInt3 - 1;
/*       */           }
/*       */           else
/*       */           {
/* 17062 */             l1 = 0L;
/*       */           }
/*       */ 
/* 17065 */           if (paramInt2 >= 52)
/*       */           {
/* 17067 */             paramLong <<= paramInt2 - 52;
/*       */           }
/*       */           else
/*       */           {
/* 17071 */             paramLong >>>= 52 - paramInt2;
/*       */           }
/*       */ 
/* 17075 */           i = 0;
/*       */ 
/* 17077 */           long l2 = paramLong;
/* 17078 */           long l3 = l1;
/*       */ 
/* 17088 */           for (i11 = 0; l3 >= 10L; i11++) {
/* 17089 */             l3 /= 10L;
/*       */           }
/* 17091 */           if (i11 != 0)
/*       */           {
/* 17093 */             long l4 = long5pow[i11] << i11;
/* 17094 */             long l5 = l2 % l4;
/*       */ 
/* 17096 */             l2 /= l4;
/* 17097 */             i += i11;
/*       */ 
/* 17099 */             if (l5 >= l4 >> 1)
/*       */             {
/* 17103 */               l2 += 1L;
/*       */             }
/*       */           }
/*       */ 
/* 17107 */           if (l2 <= 2147483647L)
/*       */           {
/* 17112 */             int i12 = (int)l2;
/*       */ 
/* 17114 */             i8 = 10;
/* 17115 */             i9 = i8 - 1;
/* 17116 */             i10 = i12 % 10;
/* 17117 */             i12 /= 10;
/*       */ 
/* 17119 */             while (i10 == 0)
/*       */             {
/* 17121 */               i++;
/* 17122 */               i10 = i12 % 10;
/* 17123 */               i12 /= 10;
/*       */             }
/*       */ 
/* 17126 */             while (i12 != 0)
/*       */             {
/* 17128 */               paramArrayOfChar[(i9--)] = ((char)(i10 + 48));
/* 17129 */               i++;
/* 17130 */               i10 = i12 % 10;
/* 17131 */               i12 /= 10;
/*       */             }
/*       */ 
/* 17134 */             paramArrayOfChar[i9] = ((char)(i10 + 48));
/*       */           }
/*       */           else
/*       */           {
/* 17141 */             i8 = 20;
/* 17142 */             i9 = i8 - 1;
/* 17143 */             i10 = (int)(l2 % 10L);
/* 17144 */             l2 /= 10L;
/*       */ 
/* 17146 */             while (i10 == 0)
/*       */             {
/* 17148 */               i++;
/* 17149 */               i10 = (int)(l2 % 10L);
/* 17150 */               l2 /= 10L;
/*       */             }
/*       */ 
/* 17153 */             while (l2 != 0L)
/*       */             {
/* 17155 */               paramArrayOfChar[(i9--)] = ((char)(i10 + 48));
/* 17156 */               i++;
/* 17157 */               i10 = (int)(l2 % 10L);
/* 17158 */               l2 /= 10L;
/*       */             }
/*       */ 
/* 17161 */             paramArrayOfChar[i9] = ((char)(i10 + 48));
/*       */           }
/*       */ 
/* 17164 */           i8 -= i9;
/*       */ 
/* 17166 */           if (i9 != 0) {
/* 17167 */             System.arraycopy(paramArrayOfChar, i9, paramArrayOfChar, 0, i8);
/*       */           }
/* 17169 */           i += 1;
/* 17170 */           j = i8;
/*       */ 
/* 17173 */           i1 = 1;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 17178 */     if (i1 == 0)
/*       */     {
/* 17213 */       double d = Double.longBitsToDouble(0x0 | paramLong & 0xFFFFFFFF);
/*       */ 
/* 17215 */       int n = (int)Math.floor((d - 1.5D) * 0.289529654D + 0.176091259D + paramInt2 * 0.301029995663981D);
/*       */ 
/* 17225 */       i5 = Math.max(0, -n);
/* 17226 */       i4 = i5 + m + paramInt2;
/*       */ 
/* 17228 */       int i7 = Math.max(0, n);
/* 17229 */       i6 = i7 + m;
/*       */ 
/* 17231 */       i9 = i5;
/* 17232 */       i8 = i4 - paramInt3;
/*       */ 
/* 17242 */       paramLong >>>= 53 - k;
/* 17243 */       i4 -= k - 1;
/*       */ 
/* 17245 */       int i13 = Math.min(i4, i6);
/*       */ 
/* 17247 */       i4 -= i13;
/* 17248 */       i6 -= i13;
/* 17249 */       i8 -= i13;
/*       */ 
/* 17257 */       if (k == 1) {
/* 17258 */         i8--;
/*       */       }
/* 17260 */       if (i8 < 0)
/*       */       {
/* 17266 */         i4 -= i8;
/* 17267 */         i6 -= i8;
/* 17268 */         i8 = 0;
/*       */       }
/*       */ 
/* 17279 */       int i14 = 0;
/*       */ 
/* 17299 */       i10 = k + i4 + (i5 < n5bits.length ? n5bits[i5] : i5 * 3);
/* 17300 */       i11 = i6 + 1 + (i7 + 1 < n5bits.length ? n5bits[(i7 + 1)] : (i7 + 1) * 3);
/*       */       int i19;
/*       */       int i17;
/*       */       int i15;
/*       */       int i16;
/*       */       long l6;
/* 17304 */       if ((i10 < 64) && (i11 < 64))
/*       */       {
/* 17306 */         if ((i10 < 32) && (i11 < 32))
/*       */         {
/* 17310 */           int i18 = (int)paramLong * small5pow[i5] << i4;
/* 17311 */           i19 = small5pow[i7] << i6;
/* 17312 */           int i20 = small5pow[i9] << i8;
/* 17313 */           int i21 = i19 * 10;
/*       */ 
/* 17320 */           i14 = 0;
/* 17321 */           i17 = i18 / i19;
/* 17322 */           i18 = 10 * (i18 % i19);
/* 17323 */           i20 *= 10;
/* 17324 */           i15 = i18 < i20 ? 1 : 0;
/* 17325 */           i16 = i18 + i20 > i21 ? 1 : 0;
/*       */ 
/* 17327 */           if ((i17 == 0) && (i16 == 0))
/*       */           {
/* 17331 */             n--;
/*       */           }
/*       */           else
/*       */           {
/* 17335 */             paramArrayOfChar[(i14++)] = ((char)(48 + i17));
/*       */           }
/*       */ 
/* 17344 */           if ((n <= -3) || (n >= 8))
/*       */           {
/* 17346 */             i16 = i15 = 0;
/*       */           }
/*       */ 
/* 17349 */           while ((i15 == 0) && (i16 == 0))
/*       */           {
/* 17351 */             i17 = i18 / i19;
/* 17352 */             i18 = 10 * (i18 % i19);
/* 17353 */             i20 *= 10;
/*       */ 
/* 17355 */             if (i20 > 0L)
/*       */             {
/* 17357 */               i15 = i18 < i20 ? 1 : 0;
/* 17358 */               i16 = i18 + i20 > i21 ? 1 : 0;
/*       */             }
/*       */             else
/*       */             {
/* 17368 */               i15 = 1;
/* 17369 */               i16 = 1;
/*       */             }
/*       */ 
/* 17372 */             paramArrayOfChar[(i14++)] = ((char)(48 + i17));
/*       */           }
/*       */ 
/* 17375 */           l6 = (i18 << 1) - i21;
/*       */         }
/*       */         else
/*       */         {
/* 17381 */           long l7 = paramLong * long5pow[i5] << i4;
/* 17382 */           long l8 = long5pow[i7] << i6;
/* 17383 */           long l9 = long5pow[i9] << i8;
/* 17384 */           long l10 = l8 * 10L;
/*       */ 
/* 17391 */           i14 = 0;
/* 17392 */           i17 = (int)(l7 / l8);
/* 17393 */           l7 = 10L * (l7 % l8);
/* 17394 */           l9 *= 10L;
/* 17395 */           i15 = l7 < l9 ? 1 : 0;
/* 17396 */           i16 = l7 + l9 > l10 ? 1 : 0;
/*       */ 
/* 17398 */           if ((i17 == 0) && (i16 == 0))
/*       */           {
/* 17402 */             n--;
/*       */           }
/*       */           else
/*       */           {
/* 17406 */             paramArrayOfChar[(i14++)] = ((char)(48 + i17));
/*       */           }
/*       */ 
/* 17415 */           if ((n <= -3) || (n >= 8))
/*       */           {
/* 17417 */             i16 = i15 = 0;
/*       */           }
/*       */ 
/* 17420 */           while ((i15 == 0) && (i16 == 0))
/*       */           {
/* 17422 */             i17 = (int)(l7 / l8);
/* 17423 */             l7 = 10L * (l7 % l8);
/* 17424 */             l9 *= 10L;
/*       */ 
/* 17426 */             if (l9 > 0L)
/*       */             {
/* 17428 */               i15 = l7 < l9 ? 1 : 0;
/* 17429 */               i16 = l7 + l9 > l10 ? 1 : 0;
/*       */             }
/*       */             else
/*       */             {
/* 17439 */               i15 = 1;
/* 17440 */               i16 = 1;
/*       */             }
/*       */ 
/* 17443 */             paramArrayOfChar[(i14++)] = ((char)(48 + i17));
/*       */           }
/*       */ 
/* 17446 */           l6 = (l7 << 1) - l10;
/*       */         }
/*       */ 
/*       */       }
/*       */       else
/*       */       {
/* 17458 */         FDBigInt localFDBigInt2 = multPow52(new FDBigInt(paramLong), i5, i4);
/* 17459 */         FDBigInt localFDBigInt1 = constructPow52(i7, i6);
/* 17460 */         FDBigInt localFDBigInt3 = constructPow52(i9, i8);
/*       */ 
/* 17464 */         localFDBigInt2.lshiftMe(i19 = localFDBigInt1.normalizeMe());
/* 17465 */         localFDBigInt3.lshiftMe(i19);
/*       */ 
/* 17467 */         FDBigInt localFDBigInt4 = localFDBigInt1.mult(10);
/*       */ 
/* 17474 */         i14 = 0;
/* 17475 */         i17 = localFDBigInt2.quoRemIteration(localFDBigInt1);
/* 17476 */         localFDBigInt3 = localFDBigInt3.mult(10);
/* 17477 */         i15 = localFDBigInt2.cmp(localFDBigInt3) < 0 ? 1 : 0;
/* 17478 */         i16 = localFDBigInt2.add(localFDBigInt3).cmp(localFDBigInt4) > 0 ? 1 : 0;
/*       */ 
/* 17480 */         if ((i17 == 0) && (i16 == 0))
/*       */         {
/* 17484 */           n--;
/*       */         }
/*       */         else
/*       */         {
/* 17488 */           paramArrayOfChar[(i14++)] = ((char)(48 + i17));
/*       */         }
/*       */ 
/* 17497 */         if ((n <= -3) || (n >= 8))
/*       */         {
/* 17499 */           i16 = i15 = 0;
/*       */         }
/*       */ 
/* 17502 */         while ((i15 == 0) && (i16 == 0))
/*       */         {
/* 17504 */           i17 = localFDBigInt2.quoRemIteration(localFDBigInt1);
/* 17505 */           localFDBigInt3 = localFDBigInt3.mult(10);
/* 17506 */           i15 = localFDBigInt2.cmp(localFDBigInt3) < 0 ? 1 : 0;
/* 17507 */           i16 = localFDBigInt2.add(localFDBigInt3).cmp(localFDBigInt4) > 0 ? 1 : 0;
/* 17508 */           paramArrayOfChar[(i14++)] = ((char)(48 + i17));
/*       */         }
/*       */ 
/* 17511 */         if ((i16 != 0) && (i15 != 0))
/*       */         {
/* 17513 */           localFDBigInt2.lshiftMe(1);
/*       */ 
/* 17515 */           l6 = localFDBigInt2.cmp(localFDBigInt4);
/*       */         }
/*       */         else {
/* 17518 */           l6 = 0L;
/*       */         }
/*       */       }
/* 17521 */       i = n + 1;
/* 17522 */       j = i14;
/*       */ 
/* 17527 */       if (i16 != 0)
/*       */       {
/* 17529 */         if (i15 != 0)
/*       */         {
/* 17531 */           if (l6 == 0L)
/*       */           {
/* 17536 */             if ((paramArrayOfChar[(j - 1)] & 0x1) != 0)
/*       */             {
/* 17538 */               if (roundup(paramArrayOfChar, j))
/* 17539 */                 i++;
/*       */             }
/*       */           }
/* 17542 */           else if (l6 > 0L)
/*       */           {
/* 17544 */             if (roundup(paramArrayOfChar, j)) {
/* 17545 */               i++;
/*       */             }
/*       */           }
/*       */ 
/*       */         }
/* 17550 */         else if (roundup(paramArrayOfChar, j)) {
/* 17551 */           i++;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 17556 */     while ((j - i > 0) && (paramArrayOfChar[(j - 1)] == '0')) j--;
/*       */ 
/* 17558 */     int i2 = i % 2 != 0 ? 1 : 0;
/*       */     int i3;
/* 17561 */     if (i2 != 0)
/*       */     {
/* 17563 */       if (j % 2 == 0) {
/* 17564 */         paramArrayOfChar[(j++)] = '0';
/*       */       }
/* 17566 */       i3 = (i - 1) / 2;
/*       */     }
/*       */     else
/*       */     {
/* 17570 */       if (j % 2 == 1) {
/* 17571 */         paramArrayOfChar[(j++)] = '0';
/*       */       }
/* 17573 */       i3 = (i - 2) / 2;
/*       */     }
/*       */ 
/* 17576 */     int i4 = 117 - i3;
/*       */ 
/* 17624 */     int i5 = 0;
/* 17625 */     int i6 = 1;
/*       */ 
/* 17627 */     if (paramBoolean1)
/*       */     {
/* 17632 */       paramArrayOfByte[paramInt1] = ((byte)(62 - i3));
/*       */ 
/* 17634 */       if (i2 != 0)
/*       */       {
/* 17636 */         paramArrayOfByte[(paramInt1 + i6)] = ((byte)(101 - (paramArrayOfChar[(i5++)] - '0')));
/* 17637 */         i6++;
/*       */       }
/*       */ 
/* 17640 */       while (i5 < j)
/*       */       {
/* 17642 */         paramArrayOfByte[(paramInt1 + i6)] = ((byte)(101 - ((paramArrayOfChar[i5] - '0') * 10 + (paramArrayOfChar[(i5 + 1)] - '0'))));
/*       */ 
/* 17645 */         i5 += 2;
/* 17646 */         i6++;
/*       */       }
/*       */ 
/* 17649 */       paramArrayOfByte[(paramInt1 + i6++)] = 102;
/*       */     }
/*       */     else
/*       */     {
/* 17655 */       paramArrayOfByte[paramInt1] = ((byte)(192 + (i3 + 1)));
/*       */ 
/* 17657 */       if (i2 != 0)
/*       */       {
/* 17659 */         paramArrayOfByte[(paramInt1 + i6)] = ((byte)(paramArrayOfChar[(i5++)] - '0' + 1));
/* 17660 */         i6++;
/*       */       }
/*       */ 
/* 17663 */       while (i5 < j)
/*       */       {
/* 17665 */         paramArrayOfByte[(paramInt1 + i6)] = ((byte)((paramArrayOfChar[i5] - '0') * 10 + (paramArrayOfChar[(i5 + 1)] - '0') + 1));
/*       */ 
/* 17668 */         i5 += 2;
/* 17669 */         i6++;
/*       */       }
/*       */     }
/*       */ 
/* 17673 */     return i6;
/*       */   }
/*       */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.VarnumBinder
 * JD-Core Version:    0.6.2
 */